/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.OptionId;
import com.intellij.application.options.OptionsApplicabilityFilter;
import com.intellij.application.options.editor.ErrorHighlightingPanel;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.codeInsight.documentation.QuickDocOnMouseOverManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorOptionsPanel {
    private JPanel myBehaviourPanel;
    private JCheckBox myCbHighlightBraces;
    private static final String STRIP_CHANGED = ApplicationBundle.message((String)"combobox.strip.modified.lines", (Object[])new Object[0]);
    private static final String STRIP_ALL = ApplicationBundle.message((String)"combobox.strip.all", (Object[])new Object[0]);
    private static final String STRIP_NONE = ApplicationBundle.message((String)"combobox.strip.none", (Object[])new Object[0]);
    private JComboBox myStripTrailingSpacesCombo;
    private JCheckBox myCbVirtualSpace;
    private JCheckBox myCbCaretInsideTabs;
    private JTextField myRecentFilesLimitField;
    private JTextField myCommandsHistoryLimitField;
    private JCheckBox myCbHighlightScope;
    private JTextField myClipboardContentLimitTextField;
    private JCheckBox myCbSmoothScrolling;
    private JCheckBox myCbVirtualPageAtBottom;
    private JCheckBox myCbEnableDnD;
    private JCheckBox myCbEnableWheelFontChange;
    private JCheckBox myCbHonorCamelHumpsWhenSelectingByClicking;
    private JPanel myHighlightSettingsPanel;
    private JRadioButton myRbPreferScrolling;
    private JRadioButton myRbPreferMovingCaret;
    private JCheckBox myCbRenameLocalVariablesInplace;
    private JCheckBox myCbHighlightIdentifierUnderCaret;
    private JCheckBox myCbEnsureBlankLineBeforeCheckBox;
    private JCheckBox myShowReformatCodeDialogCheckBox;
    private JCheckBox myShowOptimizeImportsDialogCheckBox;
    private JCheckBox myCbUseSoftWrapsAtEditor;
    private JCheckBox myCbUseSoftWrapsAtConsole;
    private JCheckBox myCbUseCustomSoftWrapIndent;
    private JTextField myCustomSoftWrapIndent;
    private JCheckBox myCbShowAllSoftWraps;
    private JCheckBox myPreselectCheckBox;
    private JBCheckBox myCbShowQuickDocOnMouseMove;
    private JBLabel myQuickDocDelayLabel;
    private JTextField myQuickDocDelayTextField;
    private JComboBox myRichCopyColorSchemeComboBox;
    private JCheckBox myShowInlineDialogForCheckBox;
    private static final String ACTIVE_COLOR_SCHEME = ApplicationBundle.message((String)"combobox.richcopy.color.scheme.active", (Object[])new Object[0]);
    private final ErrorHighlightingPanel myErrorHighlightingPanel;
    private final MyConfigurable myConfigurable;

    public EditorOptionsPanel() {
        this.$$$setupUI$$$();
        this.myErrorHighlightingPanel = new ErrorHighlightingPanel();
        if (SystemInfo.isMac) {
            this.myCbEnableWheelFontChange.setText(ApplicationBundle.message((String)"checkbox.enable.ctrl.mousewheel.changes.font.size.macos", (Object[])new Object[0]));
        }
        this.myStripTrailingSpacesCombo.addItem(STRIP_CHANGED);
        this.myStripTrailingSpacesCombo.addItem(STRIP_ALL);
        this.myStripTrailingSpacesCombo.addItem(STRIP_NONE);
        this.myHighlightSettingsPanel.setLayout(new BorderLayout());
        this.myHighlightSettingsPanel.add((Component)this.myErrorHighlightingPanel.getPanel(), "Center");
        this.myCbRenameLocalVariablesInplace.setVisible(OptionsApplicabilityFilter.isApplicable(OptionId.RENAME_IN_PLACE));
        this.myRichCopyColorSchemeComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value, int index, boolean selected, boolean hasFocus) {
                String textToUse = "__ACTIVE_GLOBAL_SCHEME__".equals(value) ? ACTIVE_COLOR_SCHEME : value;
                this.setText(textToUse);
            }
        });
        this.myConfigurable = new MyConfigurable();
        this.initQuickDocProcessing();
        this.initSoftWrapsSettingsProcessing();
    }

    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        this.myCbSmoothScrolling.setSelected(editorSettings.isSmoothScrolling());
        this.myCbHighlightBraces.setSelected(codeInsightSettings.HIGHLIGHT_BRACES);
        this.myCbHighlightScope.setSelected(codeInsightSettings.HIGHLIGHT_SCOPE);
        this.myCbHighlightIdentifierUnderCaret.setSelected(codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET);
        this.myCbUseSoftWrapsAtEditor.setSelected(editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR));
        this.myCbUseSoftWrapsAtConsole.setSelected(editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        this.myCbUseCustomSoftWrapIndent.setSelected(editorSettings.isUseCustomSoftWrapIndent());
        this.myCustomSoftWrapIndent.setText(Integer.toString(editorSettings.getCustomSoftWrapIndent()));
        this.myCbShowAllSoftWraps.setSelected(editorSettings.isAllSoftWrapsShown());
        this.updateSoftWrapSettingsRepresentation();
        this.myCbVirtualSpace.setSelected(editorSettings.isVirtualSpace());
        this.myCbCaretInsideTabs.setSelected(editorSettings.isCaretInsideTabs());
        this.myCbVirtualPageAtBottom.setSelected(editorSettings.isAdditionalPageAtBottom());
        this.myClipboardContentLimitTextField.setText(Integer.toString(uiSettings.MAX_CLIPBOARD_CONTENTS));
        String stripTrailingSpaces = editorSettings.getStripTrailingSpaces();
        if ("None".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_NONE);
        } else if ("Changed".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_CHANGED);
        } else if ("Whole".equals(stripTrailingSpaces)) {
            this.myStripTrailingSpacesCombo.setSelectedItem(STRIP_ALL);
        }
        this.myCbEnsureBlankLineBeforeCheckBox.setSelected(editorSettings.isEnsureNewLineAtEOF());
        this.myCbShowQuickDocOnMouseMove.setSelected(editorSettings.isShowQuickDocOnMouseOverElement());
        this.myQuickDocDelayTextField.setText(Long.toString(editorSettings.getQuickDocOnMouseOverElementDelayMillis()));
        this.myQuickDocDelayTextField.setEnabled(editorSettings.isShowQuickDocOnMouseOverElement());
        this.myQuickDocDelayLabel.setEnabled(editorSettings.isShowQuickDocOnMouseOverElement());
        this.myCbEnableDnD.setSelected(editorSettings.isDndEnabled());
        this.myCbEnableWheelFontChange.setSelected(editorSettings.isWheelFontChangeEnabled());
        this.myCbHonorCamelHumpsWhenSelectingByClicking.setSelected(editorSettings.isMouseClickSelectionHonorsCamelWords());
        this.myRbPreferMovingCaret.setSelected(editorSettings.isRefrainFromScrolling());
        this.myRbPreferScrolling.setSelected(!editorSettings.isRefrainFromScrolling());
        this.myRecentFilesLimitField.setText(Integer.toString(uiSettings.RECENT_FILES_LIMIT));
        this.myCommandsHistoryLimitField.setText(Integer.toString(uiSettings.CONSOLE_COMMAND_HISTORY_LIMIT));
        this.myCbRenameLocalVariablesInplace.setSelected(editorSettings.isVariableInplaceRenameEnabled());
        this.myPreselectCheckBox.setSelected(editorSettings.isPreselectRename());
        this.myShowInlineDialogForCheckBox.setSelected(editorSettings.isShowInlineLocalDialog());
        this.myShowReformatCodeDialogCheckBox.setSelected(editorSettings.getOptions().SHOW_REFORMAT_DIALOG);
        this.myShowOptimizeImportsDialogCheckBox.setSelected(editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG);
        this.myErrorHighlightingPanel.reset();
        RichCopySettings settings = RichCopySettings.getInstance();
        this.myRichCopyColorSchemeComboBox.removeAllItems();
        EditorColorsScheme[] schemes = EditorColorsManager.getInstance().getAllSchemes();
        this.myRichCopyColorSchemeComboBox.addItem("__ACTIVE_GLOBAL_SCHEME__");
        for (EditorColorsScheme scheme : schemes) {
            this.myRichCopyColorSchemeComboBox.addItem(scheme.getName());
        }
        String toSelect = settings.getSchemeName();
        if (!StringUtil.isEmpty((String)toSelect)) {
            this.myRichCopyColorSchemeComboBox.setSelectedItem(toSelect);
        }
    }

    public void apply() throws ConfigurationException {
        Long quickDocDelay;
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        editorSettings.setSmoothScrolling(this.myCbSmoothScrolling.isSelected());
        codeInsightSettings.HIGHLIGHT_BRACES = this.myCbHighlightBraces.isSelected();
        codeInsightSettings.HIGHLIGHT_SCOPE = this.myCbHighlightScope.isSelected();
        codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET = this.myCbHighlightIdentifierUnderCaret.isSelected();
        EditorOptionsPanel.clearAllIdentifierHighlighters();
        editorSettings.setUseSoftWraps(this.myCbUseSoftWrapsAtEditor.isSelected(), SoftWrapAppliancePlaces.MAIN_EDITOR);
        editorSettings.setUseSoftWraps(this.myCbUseSoftWrapsAtConsole.isSelected(), SoftWrapAppliancePlaces.CONSOLE);
        editorSettings.setUseCustomSoftWrapIndent(this.myCbUseCustomSoftWrapIndent.isSelected());
        editorSettings.setCustomSoftWrapIndent(this.getCustomSoftWrapIndent());
        editorSettings.setAllSoftwrapsShown(this.myCbShowAllSoftWraps.isSelected());
        editorSettings.setVirtualSpace(this.myCbVirtualSpace.isSelected());
        editorSettings.setCaretInsideTabs(this.myCbCaretInsideTabs.isSelected());
        editorSettings.setAdditionalPageAtBottom(this.myCbVirtualPageAtBottom.isSelected());
        boolean uiSettingsChanged = false;
        int maxClipboardContents = this.getMaxClipboardContents();
        if (uiSettings.MAX_CLIPBOARD_CONTENTS != maxClipboardContents) {
            uiSettings.MAX_CLIPBOARD_CONTENTS = maxClipboardContents;
            uiSettingsChanged = true;
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
        if (STRIP_NONE.equals(this.myStripTrailingSpacesCombo.getSelectedItem())) {
            editorSettings.setStripTrailingSpaces("None");
        } else if (STRIP_CHANGED.equals(this.myStripTrailingSpacesCombo.getSelectedItem())) {
            editorSettings.setStripTrailingSpaces("Changed");
        } else {
            editorSettings.setStripTrailingSpaces("Whole");
        }
        editorSettings.setEnsureNewLineAtEOF(this.myCbEnsureBlankLineBeforeCheckBox.isSelected());
        if (this.myCbShowQuickDocOnMouseMove.isSelected() ^ editorSettings.isShowQuickDocOnMouseOverElement()) {
            boolean enabled = this.myCbShowQuickDocOnMouseMove.isSelected();
            editorSettings.setShowQuickDocOnMouseOverElement(enabled);
            ((QuickDocOnMouseOverManager)ServiceManager.getService(QuickDocOnMouseOverManager.class)).setEnabled(enabled);
        }
        if ((quickDocDelay = this.getQuickDocDelayFromGui()) != null) {
            editorSettings.setQuickDocOnMouseOverElementDelayMillis(quickDocDelay);
        }
        editorSettings.setDndEnabled(this.myCbEnableDnD.isSelected());
        editorSettings.setWheelFontChangeEnabled(this.myCbEnableWheelFontChange.isSelected());
        editorSettings.setMouseClickSelectionHonorsCamelWords(this.myCbHonorCamelHumpsWhenSelectingByClicking.isSelected());
        editorSettings.setRefrainFromScrolling(this.myRbPreferMovingCaret.isSelected());
        editorSettings.setVariableInplaceRenameEnabled(this.myCbRenameLocalVariablesInplace.isSelected());
        editorSettings.setPreselectRename(this.myPreselectCheckBox.isSelected());
        editorSettings.setShowInlineLocalDialog(this.myShowInlineDialogForCheckBox.isSelected());
        editorSettings.getOptions().SHOW_REFORMAT_DIALOG = this.myShowReformatCodeDialogCheckBox.isSelected();
        editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG = this.myShowOptimizeImportsDialogCheckBox.isSelected();
        EditorOptionsPanel.reinitAllEditors();
        String temp = this.myRecentFilesLimitField.getText();
        if (temp.trim().length() > 0) {
            try {
                int newRecentFilesLimit = Integer.parseInt(temp);
                if (newRecentFilesLimit > 0 && uiSettings.RECENT_FILES_LIMIT != newRecentFilesLimit) {
                    uiSettings.RECENT_FILES_LIMIT = newRecentFilesLimit;
                    uiSettingsChanged = true;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (uiSettingsChanged) {
            uiSettings.fireUISettingsChanged();
        }
        uiSettings.CONSOLE_COMMAND_HISTORY_LIMIT = StringUtil.parseInt((String)this.myCommandsHistoryLimitField.getText(), (int)uiSettings.CONSOLE_COMMAND_HISTORY_LIMIT);
        this.myErrorHighlightingPanel.apply();
        RichCopySettings settings = RichCopySettings.getInstance();
        Object item = this.myRichCopyColorSchemeComboBox.getSelectedItem();
        if (item instanceof String) {
            settings.setSchemeName(item.toString());
        }
        EditorOptionsPanel.restartDaemons();
    }

    @Nullable
    private Long getQuickDocDelayFromGui() {
        String quickDocDelayAsText = this.myQuickDocDelayTextField.getText();
        if (StringUtil.isEmptyOrSpaces((String)quickDocDelayAsText)) {
            return null;
        }
        try {
            long delay = Long.parseLong(quickDocDelayAsText);
            return delay > 0L ? Long.valueOf(delay) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static void restartDaemons() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).settingsChanged();
        }
    }

    private static void clearAllIdentifierHighlighters() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                IdentifierHighlighterPass.clearMyHighlights(document, project);
            }
        }
    }

    public static void reinitAllEditors() {
        Editor[] editors;
        for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
            ((EditorEx)editor).reinitSettings();
        }
    }

    public void disposeUIResources() {
        this.myErrorHighlightingPanel.disposeUIResources();
    }

    private int getMaxClipboardContents() {
        int maxClipboardContents = -1;
        try {
            maxClipboardContents = Integer.parseInt(this.myClipboardContentLimitTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (maxClipboardContents <= 0) {
            maxClipboardContents = 1;
        }
        return maxClipboardContents;
    }

    public boolean isModified() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        UISettings uiSettings = UISettings.getInstance();
        boolean isModified = EditorOptionsPanel.isModified(this.myCbSmoothScrolling, editorSettings.isSmoothScrolling());
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightBraces, codeInsightSettings.HIGHLIGHT_BRACES);
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightScope, codeInsightSettings.HIGHLIGHT_SCOPE);
        isModified |= EditorOptionsPanel.isModified(this.myCbHighlightIdentifierUnderCaret, codeInsightSettings.HIGHLIGHT_IDENTIFIER_UNDER_CARET);
        isModified |= EditorOptionsPanel.isModified(this.myCbUseSoftWrapsAtEditor, editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.MAIN_EDITOR));
        isModified |= EditorOptionsPanel.isModified(this.myCbUseSoftWrapsAtConsole, editorSettings.isUseSoftWraps(SoftWrapAppliancePlaces.CONSOLE));
        isModified |= EditorOptionsPanel.isModified(this.myCbUseCustomSoftWrapIndent, editorSettings.isUseCustomSoftWrapIndent());
        isModified |= editorSettings.getCustomSoftWrapIndent() != this.getCustomSoftWrapIndent();
        isModified |= EditorOptionsPanel.isModified(this.myCbShowAllSoftWraps, editorSettings.isAllSoftWrapsShown());
        isModified |= EditorOptionsPanel.isModified(this.myCbVirtualSpace, editorSettings.isVirtualSpace());
        isModified |= EditorOptionsPanel.isModified(this.myCbCaretInsideTabs, editorSettings.isCaretInsideTabs());
        isModified |= EditorOptionsPanel.isModified(this.myCbVirtualPageAtBottom, editorSettings.isAdditionalPageAtBottom());
        isModified |= this.getMaxClipboardContents() != uiSettings.MAX_CLIPBOARD_CONTENTS;
        isModified |= !this.getStripTrailingSpacesValue().equals(editorSettings.getStripTrailingSpaces());
        isModified |= EditorOptionsPanel.isModified(this.myCbEnsureBlankLineBeforeCheckBox, editorSettings.isEnsureNewLineAtEOF());
        isModified |= EditorOptionsPanel.isModified((JToggleButton)this.myCbShowQuickDocOnMouseMove, editorSettings.isShowQuickDocOnMouseOverElement());
        Long quickDocDelay = this.getQuickDocDelayFromGui();
        if (quickDocDelay != null && !quickDocDelay.equals(editorSettings.getQuickDocOnMouseOverElementDelayMillis())) {
            return true;
        }
        isModified |= EditorOptionsPanel.isModified(this.myCbEnableDnD, editorSettings.isDndEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myCbEnableWheelFontChange, editorSettings.isWheelFontChangeEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myCbHonorCamelHumpsWhenSelectingByClicking, editorSettings.isMouseClickSelectionHonorsCamelWords());
        isModified |= this.myRbPreferMovingCaret.isSelected() != editorSettings.isRefrainFromScrolling();
        isModified |= EditorOptionsPanel.isModified(this.myRecentFilesLimitField, UISettings.getInstance().RECENT_FILES_LIMIT);
        isModified |= EditorOptionsPanel.isModified(this.myCommandsHistoryLimitField, UISettings.getInstance().CONSOLE_COMMAND_HISTORY_LIMIT);
        isModified |= EditorOptionsPanel.isModified(this.myCbRenameLocalVariablesInplace, editorSettings.isVariableInplaceRenameEnabled());
        isModified |= EditorOptionsPanel.isModified(this.myPreselectCheckBox, editorSettings.isPreselectRename());
        isModified |= EditorOptionsPanel.isModified(this.myShowInlineDialogForCheckBox, editorSettings.isShowInlineLocalDialog());
        isModified |= EditorOptionsPanel.isModified(this.myShowReformatCodeDialogCheckBox, editorSettings.getOptions().SHOW_REFORMAT_DIALOG);
        isModified |= EditorOptionsPanel.isModified(this.myShowOptimizeImportsDialogCheckBox, editorSettings.getOptions().SHOW_OPIMIZE_IMPORTS_DIALOG);
        isModified |= this.myErrorHighlightingPanel.isModified();
        RichCopySettings settings = RichCopySettings.getInstance();
        return isModified |= !Comparing.equal((Object)settings.getSchemeName(), (Object)this.myRichCopyColorSchemeComboBox.getSelectedItem());
    }

    private static boolean isModified(JToggleButton checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    private static boolean isModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private String getStripTrailingSpacesValue() {
        Object selectedItem = this.myStripTrailingSpacesCombo.getSelectedItem();
        if (STRIP_NONE.equals(selectedItem)) {
            return "None";
        }
        if (STRIP_CHANGED.equals(selectedItem)) {
            return "Changed";
        }
        return "Whole";
    }

    private int getCustomSoftWrapIndent() {
        String indentAsString = this.myCustomSoftWrapIndent.getText();
        int defaultIndent = 0;
        if (indentAsString == null) {
            return defaultIndent;
        }
        try {
            int indent = Integer.parseInt(indentAsString.trim());
            return indent >= 0 ? indent : defaultIndent;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultIndent;
        }
    }

    private void initQuickDocProcessing() {
        this.myCbShowQuickDocOnMouseMove.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EditorOptionsPanel.this.myQuickDocDelayTextField.setEnabled(EditorOptionsPanel.this.myCbShowQuickDocOnMouseMove.isSelected());
                EditorOptionsPanel.this.myQuickDocDelayLabel.setEnabled(EditorOptionsPanel.this.myCbShowQuickDocOnMouseMove.isSelected());
            }
        });
    }

    private void initSoftWrapsSettingsProcessing() {
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EditorOptionsPanel.this.updateSoftWrapSettingsRepresentation();
            }
        };
        this.myCbUseSoftWrapsAtEditor.addItemListener(listener);
        this.myCbUseSoftWrapsAtConsole.addItemListener(listener);
        this.myCbUseCustomSoftWrapIndent.addItemListener(listener);
    }

    private void updateSoftWrapSettingsRepresentation() {
        this.myCbUseCustomSoftWrapIndent.setEnabled(this.myCbUseSoftWrapsAtEditor.isSelected() || this.myCbUseSoftWrapsAtConsole.isSelected());
        this.myCustomSoftWrapIndent.setEnabled(this.myCbUseCustomSoftWrapIndent.isEnabled() && this.myCbUseCustomSoftWrapIndent.isSelected());
    }

    public JComponent getComponent() {
        return this.myBehaviourPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        JBLabel jBLabel;
        JTextField jTextField;
        JBCheckBox jBCheckBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox6;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JCheckBox jCheckBox7;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JTextField jTextField5;
        JCheckBox jCheckBox12;
        JCheckBox jCheckBox13;
        JCheckBox jCheckBox14;
        JCheckBox jCheckBox15;
        JCheckBox jCheckBox16;
        JCheckBox jCheckBox17;
        JCheckBox jCheckBox18;
        JCheckBox jCheckBox19;
        JCheckBox jCheckBox20;
        JPanel jPanel2;
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.myBehaviourPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab(ResourceBundle.getBundle("messages/ApplicationBundle").getString("tab.editor.settings.behavior"), null, jPanel2, null);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.advanced.mouse.usages"), (int)0, (int)0, null, null));
        this.myCbHonorCamelHumpsWhenSelectingByClicking = jCheckBox20 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox20, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.honor.camelhumps.words.settings.on.double.click"));
        jPanel4.add((Component)jCheckBox20, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbEnableDnD = jCheckBox19 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox19, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.drag.n.drop.functionality.in.editor"));
        jPanel4.add((Component)jCheckBox19, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbEnableWheelFontChange = jCheckBox18 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox18, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.enable.ctrl.mousewheel.changes.font.size"));
        jPanel4.add((Component)jCheckBox18, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.virtual.space"), (int)0, (int)0, null, null));
        this.myCbVirtualPageAtBottom = jCheckBox17 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox17, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.virtual.space.at.file.bottom"));
        jPanel5.add((Component)jCheckBox17, new GridConstraints(3, 0, 1, 1, 8, 2, 7, 3, null, null, null));
        this.myCbCaretInsideTabs = jCheckBox16 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox16, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.allow.placement.of.caret.inside.tabs"));
        jPanel5.add((Component)jCheckBox16, new GridConstraints(2, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        this.myCbVirtualSpace = jCheckBox15 = new JCheckBox();
        jCheckBox15.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox15, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.allow.placement.of.caret.after.end.of.line"));
        jPanel5.add((Component)jCheckBox15, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCbUseSoftWrapsAtEditor = jCheckBox14 = new JCheckBox();
        jCheckBox14.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox14, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.soft.wraps.at.editor"));
        jPanel6.add((Component)jCheckBox14, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myCbUseCustomSoftWrapIndent = jCheckBox13 = new JCheckBox();
        ((Component)jCheckBox13).setEnabled(false);
        this.$$$loadButtonText$$$(jCheckBox13, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.custom.soft.wraps.indent"));
        jPanel7.add((Component)jCheckBox13, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCbUseSoftWrapsAtConsole = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.soft.wraps.at.console"));
        jPanel7.add((Component)jCheckBox12, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomSoftWrapIndent = jTextField5 = new JTextField();
        ((Component)jTextField5).setEnabled(false);
        jPanel7.add((Component)jTextField5, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(35, -1), null));
        this.myCbShowAllSoftWraps = jCheckBox11 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.all.softwraps"));
        jPanel6.add((Component)jCheckBox11, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel8, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.brace.highlighting"), (int)0, (int)0, null, null));
        this.myCbHighlightScope = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.highlight.current.scope"));
        jPanel8.add((Component)jCheckBox10, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbHighlightBraces = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.highlight.matched.brace"));
        jPanel8.add((Component)jCheckBox9, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbHighlightIdentifierUnderCaret = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Highlight usages of element at caret");
        jPanel8.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel9.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Scrolling", (int)0, (int)0, null, null));
        this.myRbPreferScrolling = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Prefer scrolling editor canvas to keep caret line centered");
        jPanel9.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRbPreferMovingCaret = jRadioButton = new JRadioButton();
        jRadioButton.setText("Prefer moving caret line to minimize editor scrolling");
        jPanel9.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCbSmoothScrolling = jCheckBox7 = new JCheckBox();
        jCheckBox7.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.smooth.scrolling"));
        jPanel9.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel10, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel10.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.limits"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.maximum.number.of.contents.to.keep.in.clipboard"));
        jPanel10.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClipboardContentLimitTextField = jTextField4 = new JTextField();
        jTextField4.setText("5");
        jPanel10.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 0, 4, 0, null, new Dimension(50, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.recent.files.limit"));
        jPanel10.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.console.history.limit"));
        jPanel10.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecentFilesLimitField = jTextField3 = new JTextField();
        jTextField3.setText("10");
        jPanel10.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myCommandsHistoryLimitField = jTextField2 = new JTextField();
        jTextField2.setText("20");
        jPanel10.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel11.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel11, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel11.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Other", (int)0, (int)0, null, null));
        this.myCbEnsureBlankLineBeforeCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Ensure line feed at file end on Save");
        jPanel11.add((Component)jCheckBox6, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.strip.trailing.spaces.on.save"));
        jPanel11.add((Component)jLabel4, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myStripTrailingSpacesCombo = jComboBox2 = new JComboBox();
        jPanel11.add(jComboBox2, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myCbShowQuickDocOnMouseMove = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show quick doc on mouse move");
        jPanel11.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuickDocDelayTextField = jTextField = new JTextField();
        jTextField.setText("500");
        jPanel11.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myQuickDocDelayLabel = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(11);
        jBLabel.setText("Delay (ms):");
        jPanel11.add((Component)jBLabel, new GridConstraints(2, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel11.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myHighlightSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel12, new GridConstraints(3, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel12.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel13.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Formatting", (int)0, (int)0, null, null));
        this.myShowOptimizeImportsDialogCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Show \"Optimize Imports\" dialog");
        jPanel13.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowReformatCodeDialogCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Show \"Reformat Code\" dialog ");
        jPanel13.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel12.add((Component)jPanel14, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel14.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Refactorings", (int)0, (int)0, null, null));
        this.myCbRenameLocalVariablesInplace = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.rename.local.variables.inplace"));
        jPanel14.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreselectCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.rename.local.variables.preselect"));
        jPanel14.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowInlineDialogForCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Show inline dialog for local variables");
        jPanel14.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel12.add((Component)jPanel15, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel15.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("group.richcopy"), (int)0, (int)0, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("combobox.richcopy.color.scheme"));
        jPanel15.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRichCopyColorSchemeComboBox = jComboBox = new JComboBox();
        jPanel15.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    public class MyConfigurable
    implements SearchableConfigurable {
        @NotNull
        public String getId() {
            if ("Editor.Behavior" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/editor/EditorOptionsPanel$MyConfigurable", "getId"));
            }
            return "Editor.Behavior";
        }

        public Runnable enableSearch(String option) {
            return null;
        }

        public String getDisplayName() {
            return ApplicationBundle.message((String)"tab.editor.settings.behavior", (Object[])new Object[0]);
        }

        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return EditorOptionsPanel.this.myBehaviourPanel;
        }

        public boolean isModified() {
            return EditorOptionsPanel.this.isModified();
        }

        public void apply() throws ConfigurationException {
            EditorOptionsPanel.this.apply();
        }

        public void reset() {
            EditorOptionsPanel.this.reset();
        }

        public void disposeUIResources() {
            EditorOptionsPanel.this.disposeUIResources();
        }
    }
}

