/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.Stack;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpectedTypesProvider {
    private static final ExpectedTypeInfo VOID_EXPECTED = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.VOID, 1, (PsiType)PsiType.VOID, TailType.SEMICOLON);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.ExpectedTypesProvider");
    private static final int MAX_COUNT = 50;
    private static final ExpectedClassProvider ourGlobalScopeClassProvider = new ExpectedClassProvider(){

        @Override
        @NotNull
        public PsiField[] findDeclaredFields(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredFields"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredFields"));
            }
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            PsiField[] psiFieldArray = cache.getFieldsByName(name, scope);
            if (psiFieldArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredFields"));
            }
            return psiFieldArray;
        }

        @Override
        @NotNull
        public PsiMethod[] findDeclaredMethods(@NotNull PsiManager manager, @NotNull String name) {
            if (manager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredMethods"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredMethods"));
            }
            PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)manager.getProject());
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)manager.getProject());
            PsiMethod[] psiMethodArray = cache.getMethodsByNameIfNotMoreThan(name, scope, 50);
            if (psiMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$1", "findDeclaredMethods"));
            }
            return psiMethodArray;
        }
    };
    private static final PsiType[] PRIMITIVE_TYPES = new PsiType[]{PsiType.BYTE, PsiType.CHAR, PsiType.SHORT, PsiType.INT, PsiType.LONG, PsiType.FLOAT, PsiType.DOUBLE};

    private ExpectedTypesProvider() {
    }

    public static ExpectedTypesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/ExpectedTypesProvider", "getInstance"));
        }
        return (ExpectedTypesProvider)ServiceManager.getService((Project)project, ExpectedTypesProvider.class);
    }

    @NotNull
    public static ExpectedTypeInfo createInfo(@NotNull PsiType type, @ExpectedTypeInfo.Type int kind, PsiType defaultType, @NotNull TailType tailType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfo"));
        }
        if (tailType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailType", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfo"));
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = ExpectedTypesProvider.createInfoImpl(type, kind, defaultType, tailType);
        if (expectedTypeInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfo"));
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, PsiType defaultType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = ExpectedTypesProvider.createInfoImpl(type, 1, defaultType, TailType.NONE);
        if (expectedTypeInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, @ExpectedTypeInfo.Type int kind, PsiType defaultType, @NotNull TailType tailType) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        if (tailType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailType", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = new ExpectedTypeInfoImpl(type, kind, defaultType, tailType, null, ExpectedTypeInfoImpl.NULL);
        if (expectedTypeInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    private static ExpectedTypeInfoImpl createInfoImpl(@NotNull PsiType type, int kind, PsiType defaultType, @NotNull TailType tailType, PsiMethod calledMethod, NullableComputable<String> expectedName) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        if (tailType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tailType", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        ExpectedTypeInfoImpl expectedTypeInfoImpl = new ExpectedTypeInfoImpl(type, kind, defaultType, tailType, calledMethod, expectedName);
        if (expectedTypeInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "createInfoImpl"));
        }
        return expectedTypeInfoImpl;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, false, false);
        if (expectedTypeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getExpectedTypes"));
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, boolean voidable, boolean usedAfter) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, ourGlobalScopeClassProvider, voidable, usedAfter);
        if (expectedTypeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getExpectedTypes"));
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean usedAfter) {
        ExpectedTypeInfo[] expectedTypeInfoArray = ExpectedTypesProvider.getExpectedTypes(expr, forCompletion, classProvider, false, usedAfter);
        if (expectedTypeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getExpectedTypes"));
        }
        return expectedTypeInfoArray;
    }

    @NotNull
    public static ExpectedTypeInfo[] getExpectedTypes(@Nullable PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
        if (expr == null) {
            if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getExpectedTypes"));
            }
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        PsiElement parent = expr.getParent();
        MyParentVisitor visitor = new MyParentVisitor(expr, forCompletion, classProvider, voidable, usedAfter);
        if (parent != null) {
            parent.accept((PsiElementVisitor)visitor);
        }
        ExpectedTypeInfo[] expectedTypeInfoArray = visitor.getResult();
        if (expectedTypeInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getExpectedTypes"));
        }
        return expectedTypeInfoArray;
    }

    public static PsiType[] processExpectedTypes(@NotNull ExpectedTypeInfo[] infos, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/ExpectedTypesProvider", "processExpectedTypes"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInsight/ExpectedTypesProvider", "processExpectedTypes"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/ExpectedTypesProvider", "processExpectedTypes"));
        }
        LinkedHashSet<PsiType> set = new LinkedHashSet<PsiType>();
        for (ExpectedTypeInfo info : infos) {
            ExpectedTypeInfoImpl infoImpl = (ExpectedTypeInfoImpl)info;
            if (infoImpl.getDefaultType() instanceof PsiClassType) {
                PsiClassType.ClassResolveResult result = ((PsiClassType)infoImpl.getDefaultType()).resolveGenerics();
                PsiClass aClass = (PsiClass)result.getElement();
                if (aClass instanceof PsiAnonymousClass) {
                    ExpectedTypesProvider.processType((PsiType)((PsiAnonymousClass)aClass).getBaseClassType(), visitor, set);
                    ((PsiAnonymousClass)aClass).getBaseClassType().accept(visitor);
                } else {
                    ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
                }
            } else {
                ExpectedTypesProvider.processType(infoImpl.getDefaultType(), visitor, set);
            }
            if (infoImpl.getKind() == 2) {
                ExpectedTypesProvider.processAllSuperTypes(infoImpl.getType(), visitor, project, set);
                continue;
            }
            if (infoImpl.getKind() != 1 || !(infoImpl.getType() instanceof PsiPrimitiveType)) continue;
            ExpectedTypesProvider.processPrimitiveTypeAndSubtypes((PsiPrimitiveType)infoImpl.getType(), visitor, set);
        }
        return set.toArray(PsiType.createArray((int)set.size()));
    }

    private static void processType(@NotNull PsiType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<PsiType> typeSet) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "processType"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInsight/ExpectedTypesProvider", "processType"));
        }
        if (typeSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSet", "com/intellij/codeInsight/ExpectedTypesProvider", "processType"));
        }
        PsiType accepted = (PsiType)type.accept(visitor);
        if (accepted != null) {
            typeSet.add(accepted);
        }
    }

    public static void processPrimitiveTypeAndSubtypes(@NotNull PsiPrimitiveType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Set<PsiType> set) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "processPrimitiveTypeAndSubtypes"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInsight/ExpectedTypesProvider", "processPrimitiveTypeAndSubtypes"));
        }
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/codeInsight/ExpectedTypesProvider", "processPrimitiveTypeAndSubtypes"));
        }
        if (type.equals((Object)PsiType.BOOLEAN) || type.equals((Object)PsiType.VOID) || type.equals((Object)PsiType.NULL)) {
            return;
        }
        int i = 0;
        while (true) {
            PsiType primitive = PRIMITIVE_TYPES[i];
            ExpectedTypesProvider.processType(primitive, visitor, set);
            if (primitive.equals(type)) {
                return;
            }
            ++i;
        }
    }

    public static void processAllSuperTypes(@NotNull PsiType type, @NotNull PsiTypeVisitor<PsiType> visitor, @NotNull Project project, @NotNull Set<PsiType> set) {
        block10: {
            PsiType[] superTypes;
            block9: {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/ExpectedTypesProvider", "processAllSuperTypes"));
                }
                if (visitor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInsight/ExpectedTypesProvider", "processAllSuperTypes"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/ExpectedTypesProvider", "processAllSuperTypes"));
                }
                if (set == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/codeInsight/ExpectedTypesProvider", "processAllSuperTypes"));
                }
                if (!(type instanceof PsiPrimitiveType)) break block9;
                if (type.equals(PsiType.BOOLEAN) || type.equals(PsiType.VOID) || type.equals(PsiType.NULL)) {
                    return;
                }
                Stack stack = new Stack();
                int i = PRIMITIVE_TYPES.length - 1;
                while (!PRIMITIVE_TYPES[i].equals(type)) {
                    stack.push((Object)PRIMITIVE_TYPES[i]);
                    --i;
                }
                while (!stack.empty()) {
                    ExpectedTypesProvider.processType((PsiType)stack.pop(), visitor, set);
                }
                break block10;
            }
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope resolveScope = type.getResolveScope();
            if (resolveScope == null) {
                resolveScope = GlobalSearchScope.allScope((Project)project);
            }
            PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)resolveScope);
            ExpectedTypesProvider.processType((PsiType)objectType, visitor, set);
            if (!(type instanceof PsiClassType)) break block10;
            for (PsiType superType : superTypes = type.getSuperTypes()) {
                ExpectedTypesProvider.processType(superType, visitor, set);
                ExpectedTypesProvider.processAllSuperTypes(superType, visitor, project, set);
            }
        }
    }

    @NotNull
    public static TailType getFinalCallParameterTailType(@NotNull PsiElement call, @Nullable PsiType returnType, @NotNull PsiMethod method) {
        boolean statementContext;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/ExpectedTypesProvider", "getFinalCallParameterTailType"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider", "getFinalCallParameterTailType"));
        }
        if (method.isConstructor() && call instanceof PsiMethodCallExpression && ((PsiMethodCallExpression)call).getMethodExpression() instanceof PsiSuperExpression) {
            TailType tailType = TailTypes.CALL_RPARENTH_SEMICOLON;
            if (tailType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getFinalCallParameterTailType"));
            }
            return tailType;
        }
        boolean chainable = !PsiType.VOID.equals((Object)returnType) && returnType != null || method.isConstructor() && call instanceof PsiNewExpression;
        PsiElement parent = call.getParent();
        boolean bl = statementContext = parent instanceof PsiExpressionStatement || parent instanceof PsiVariable || parent instanceof PsiCodeBlock;
        if (parent instanceof PsiThrowStatement || statementContext && !chainable) {
            TailType tailType = TailTypes.CALL_RPARENTH_SEMICOLON;
            if (tailType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getFinalCallParameterTailType"));
            }
            return tailType;
        }
        TailType tailType = TailTypes.CALL_RPARENTH;
        if (tailType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider", "getFinalCallParameterTailType"));
        }
        return tailType;
    }

    public static interface ExpectedClassProvider {
        public PsiField[] findDeclaredFields(PsiManager var1, String var2);

        public PsiMethod[] findDeclaredMethods(PsiManager var1, String var2);
    }

    private static class MyParentVisitor
    extends JavaElementVisitor {
        private PsiExpression myExpr;
        private final boolean myForCompletion;
        private final boolean myUsedAfter;
        private final ExpectedClassProvider myClassProvider;
        private final boolean myVoidable;
        final List<ExpectedTypeInfo> myResult = ContainerUtil.newArrayList();
        @NonNls
        private static final String LENGTH_SYNTHETIC_ARRAY_FIELD = "length";

        private MyParentVisitor(PsiExpression expr, boolean forCompletion, ExpectedClassProvider classProvider, boolean voidable, boolean usedAfter) {
            this.myExpr = expr;
            this.myForCompletion = forCompletion;
            this.myClassProvider = classProvider;
            this.myVoidable = voidable;
            this.myUsedAfter = usedAfter;
        }

        @NotNull
        public ExpectedTypeInfo[] getResult() {
            ExpectedTypeInfo[] expectedTypeInfoArray = this.myResult.toArray(new ExpectedTypeInfo[this.myResult.size()]);
            if (expectedTypeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getResult"));
            }
            return expectedTypeInfoArray;
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
            PsiElement parent = expression.getParent();
            if (parent != null) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                parent.accept((PsiElementVisitor)visitor);
                for (final ExpectedTypeInfo info : visitor.myResult) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailTypes.RPARENTH, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                        @Nullable
                        public String compute() {
                            return ((ExpectedTypeInfoImpl)info).getExpectedName();
                        }
                    })));
                }
            }
        }

        public void visitAnnotationMethod(@NotNull PsiAnnotationMethod method) {
            PsiType type;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitAnnotationMethod"));
            }
            if (this.myExpr == method.getDefaultValue() && (type = method.getReturnType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.SEMICOLON));
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitReferenceExpression"));
            }
            if (this.myForCompletion) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expression, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                expression.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                return;
            }
            String referenceName = expression.getReferenceName();
            if (referenceName != null) {
                PsiElement parent = expression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    Collections.addAll(this.myResult, this.findClassesWithDeclaredMethod((PsiMethodCallExpression)parent, false));
                } else if (parent instanceof PsiReferenceExpression || parent instanceof PsiVariable || parent instanceof PsiExpression) {
                    if (LENGTH_SYNTHETIC_ARRAY_FIELD.equals(referenceName)) {
                        this.myResult.addAll(this.anyArrayType());
                    } else {
                        Collections.addAll(this.myResult, this.findClassesWithDeclaredField(expression));
                    }
                }
            }
        }

        public void visitExpressionStatement(PsiExpressionStatement statement) {
            if (this.myVoidable) {
                this.myResult.add(VOID_EXPECTED);
            }
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitMethodCallExpression"));
            }
            this.myExpr = (PsiExpression)this.myExpr.getParent();
            expression.getParent().accept((PsiElementVisitor)this);
        }

        public void visitAnnotationArrayInitializer(@NotNull PsiArrayInitializerMemberValue initializer) {
            if (initializer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitAnnotationArrayInitializer"));
            }
            PsiElement parent = initializer.getParent();
            while (parent instanceof PsiArrayInitializerMemberValue) {
                parent = parent.getParent();
            }
            PsiType type = parent instanceof PsiNameValuePair ? MyParentVisitor.getAnnotationMethodType((PsiNameValuePair)parent) : ((PsiAnnotationMethod)parent).getReturnType();
            if (type instanceof PsiArrayType) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(((PsiArrayType)type).getComponentType(), type));
            }
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitNameValuePair"));
            }
            PsiType type = MyParentVisitor.getAnnotationMethodType(pair);
            if (type == null) {
                return;
            }
            this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, type));
            if (type instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)type).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        @Nullable
        private static PsiType getAnnotationMethodType(@NotNull PsiNameValuePair pair) {
            PsiElement method;
            if (pair == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getAnnotationMethodType"));
            }
            PsiReference reference = pair.getReference();
            if (reference != null && (method = reference.resolve()) instanceof PsiMethod) {
                return ((PsiMethod)method).getReturnType();
            }
            return null;
        }

        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            super.visitLambdaExpression(lambdaExpression);
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            PsiMethod scopeMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
            if (scopeMethod != null) {
                this.visitMethodReturnType(scopeMethod, LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType), LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)lambdaExpression));
            }
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            boolean tailTypeSemicolon;
            PsiType type;
            PsiMethod method;
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class);
            if (lambdaExpression != null) {
                PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                type = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                tailTypeSemicolon = LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)lambdaExpression);
            } else {
                method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class);
                type = method != null ? method.getReturnType() : null;
                tailTypeSemicolon = true;
            }
            if (method != null) {
                this.visitMethodReturnType(method, type, tailTypeSemicolon);
            }
        }

        private void visitMethodReturnType(final PsiMethod scopeMethod, PsiType type, boolean tailTypeSemicolon) {
            if (type != null) {
                NullableComputable<String> expectedName = PropertyUtil.isSimplePropertyAccessor((PsiMethod)scopeMethod) ? new NullableComputable<String>(){

                    public String compute() {
                        return PropertyUtil.getPropertyName((PsiMethod)scopeMethod);
                    }
                } : ExpectedTypeInfoImpl.NULL;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, tailTypeSemicolon ? TailType.SEMICOLON : TailType.NONE, null, (NullableComputable<String>)((NullableComputable)expectedName)));
            }
        }

        public void visitIfStatement(PsiIfStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.IF_RPARENTH));
        }

        public void visitWhileStatement(PsiWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitDoWhileStatement(PsiDoWhileStatement statement) {
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailTypes.WHILE_RPARENTH));
        }

        public void visitForStatement(@NotNull PsiForStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitForStatement"));
            }
            if (this.myExpr.equals(statement.getCondition())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitAssertStatement(@NotNull PsiAssertStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitAssertStatement"));
            }
            if (statement.getAssertDescription() == this.myExpr) {
                PsiClassType stringType = PsiType.getJavaLangString((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope());
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)stringType, 0, (PsiType)stringType, TailType.SEMICOLON));
            } else {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.SEMICOLON));
            }
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitForeachStatement"));
            }
            if (this.myExpr.equals(statement.getIteratedValue())) {
                PsiType type = statement.getIterationParameter().getType();
                PsiArrayType arrayType = type.createArrayType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, (PsiType)arrayType));
                PsiManager manager = statement.getManager();
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
                PsiClass iterableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Iterable", statement.getResolveScope());
                if (iterableClass != null && iterableClass.getTypeParameters().length == 1) {
                    HashMap map = new HashMap();
                    map.put(iterableClass.getTypeParameters()[0], PsiWildcardType.createExtends((PsiManager)manager, (PsiType)type));
                    PsiClassType iterableType = factory.createType(iterableClass, factory.createSubstitutor((Map)map));
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)iterableType, (PsiType)iterableType));
                }
            }
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitSwitchStatement"));
            }
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)statement)) {
                return;
            }
            PsiManager manager = statement.getManager();
            PsiClassType enumType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Enum", statement.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)enumType, (PsiType)enumType));
        }

        public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
            PsiType type;
            PsiExpression expression;
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitSwitchLabelStatement"));
            }
            PsiSwitchStatement switchStatement = statement.getEnclosingSwitchStatement();
            if (switchStatement != null && (expression = switchStatement.getExpression()) != null && (type = expression.getType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, TailType.CASE_COLON));
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitSynchronizedStatement"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)statement.getProject()).getElementFactory();
            PsiClassType objectType = factory.createTypeByFQClassName("java.lang.Object", this.myExpr.getResolveScope());
            this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)objectType));
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitVariable"));
            }
            PsiType type = variable.getType();
            this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, variable instanceof PsiResourceVariable ? TailType.NONE : TailType.SEMICOLON, null, (NullableComputable<String>)MyParentVisitor.getPropertyName(variable)));
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitAssignmentExpression"));
            }
            if (this.myExpr.equals(assignment.getRExpression())) {
                PsiExpression lExpr = assignment.getLExpression();
                PsiType type = lExpr.getType();
                if (type != null) {
                    PsiElement refElement;
                    TailType tailType = MyParentVisitor.getAssignmentRValueTailType(assignment);
                    NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
                    if (lExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)lExpr).resolve()) instanceof PsiVariable) {
                        expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
                    }
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, 1, type, tailType, null, (NullableComputable<String>)expectedName));
                }
            } else {
                PsiType type;
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    assignment.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiExpression rExpr = assignment.getRExpression();
                if (rExpr != null && (type = rExpr.getType()) != null && type != PsiType.NULL) {
                    PsiClass resolved;
                    if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) instanceof PsiAnonymousClass) {
                        type = ((PsiAnonymousClass)resolved).getBaseClassType();
                    }
                    int kind = assignment.getOperationTokenType() != JavaTokenType.EQ ? 0 : 2;
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, kind, type, TailType.NONE));
                }
            }
        }

        private static TailType getAssignmentRValueTailType(@NotNull PsiAssignmentExpression assignment) {
            if (assignment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getAssignmentRValueTailType"));
            }
            if (assignment.getParent() instanceof PsiExpressionStatement) {
                if (!(assignment.getParent().getParent() instanceof PsiForStatement)) {
                    return TailType.SEMICOLON;
                }
                PsiForStatement forStatement = (PsiForStatement)assignment.getParent().getParent();
                if (!assignment.getParent().equals(forStatement.getUpdate())) {
                    return TailType.SEMICOLON;
                }
            }
            return TailType.NONE;
        }

        public void visitExpressionList(@NotNull PsiExpressionList list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitExpressionList"));
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            if (list.getParent() instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)list.getParent();
                CandidateInfo[] candidates = helper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false, true);
                Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, list, this.myExpr, this.myForCompletion));
            } else if (list.getParent() instanceof PsiEnumConstant) {
                this.getExpectedArgumentsTypesForEnumConstant((PsiEnumConstant)list.getParent(), list);
            } else if (list.getParent() instanceof PsiNewExpression) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent(), list);
            } else if (list.getParent() instanceof PsiAnonymousClass) {
                this.getExpectedArgumentsTypesForNewExpression((PsiNewExpression)list.getParent().getParent(), list);
            }
        }

        private void getExpectedArgumentsTypesForEnumConstant(@NotNull PsiEnumConstant enumConstant, @NotNull PsiExpressionList list) {
            if (enumConstant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumConstant", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentsTypesForEnumConstant"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentsTypesForEnumConstant"));
            }
            PsiClass aClass = enumConstant.getContainingClass();
            if (aClass != null) {
                LOG.assertTrue(aClass.isEnum());
                this.getExpectedTypesForConstructorCall(aClass, list, PsiSubstitutor.EMPTY);
            }
        }

        private void getExpectedArgumentsTypesForNewExpression(@NotNull PsiNewExpression newExpr, @NotNull PsiExpressionList list) {
            if (newExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentsTypesForNewExpression"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentsTypesForNewExpression"));
            }
            PsiType newType = newExpr.getType();
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)newType);
                PsiClass newClass = (PsiClass)resolveResult.getElement();
                if (newClass instanceof PsiAnonymousClass) {
                    PsiAnonymousClass anonymous = (PsiAnonymousClass)newClass;
                    if ((newClass = anonymous.getBaseClassType().resolve()) == null) {
                        return;
                    }
                    substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)newClass, (PsiClass)anonymous, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                } else if (newClass != null) {
                    substitutor = resolveResult.getSubstitutor();
                } else {
                    return;
                }
                this.getExpectedTypesForConstructorCall(newClass, list, substitutor);
            }
        }

        private void getExpectedTypesForConstructorCall(@NotNull PsiClass referencedClass, @NotNull PsiExpressionList argumentList, PsiSubstitutor substitutor) {
            if (referencedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedClass", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedTypesForConstructorCall"));
            }
            if (argumentList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedTypesForConstructorCall"));
            }
            ArrayList<MethodCandidateInfo> array = new ArrayList<MethodCandidateInfo>();
            for (PsiMethod constructor : referencedClass.getConstructors()) {
                array.add(new MethodCandidateInfo((PsiElement)constructor, substitutor, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null));
            }
            CandidateInfo[] candidates = array.toArray(new CandidateInfo[array.size()]);
            Collections.addAll(this.myResult, this.getExpectedArgumentTypesForMethodCall(candidates, argumentList, this.myExpr, this.myForCompletion));
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitPolyadicExpression"));
            }
            PsiExpression[] operands = expr.getOperands();
            int index = Arrays.asList(operands).indexOf(this.myExpr);
            assert (index >= 0);
            if (this.myForCompletion && index == 0) {
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                expr.getParent().accept((PsiElementVisitor)visitor);
                this.myResult.addAll(visitor.myResult);
                if (!(expr.getParent() instanceof PsiExpressionList)) {
                    for (int i = 0; i < this.myResult.size(); ++i) {
                        final ExpectedTypeInfo info = this.myResult.get(i);
                        this.myResult.set(i, ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.NONE, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                            @Nullable
                            public String compute() {
                                return ((ExpectedTypeInfoImpl)info).getExpectedName();
                            }
                        })));
                    }
                }
                return;
            }
            PsiExpression anotherExpr = index > 0 ? operands[0] : (1 < operands.length ? operands[1] : null);
            PsiType anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            IElementType i = expr.getOperationTokenType();
            if (i == JavaTokenType.MINUS || i == JavaTokenType.ASTERISK || i == JavaTokenType.DIV || i == JavaTokenType.PERC || i == JavaTokenType.LT || i == JavaTokenType.GT || i == JavaTokenType.LE || i == JavaTokenType.GE) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (i == JavaTokenType.PLUS) {
                if (anotherType == null || anotherType.equalsToText("java.lang.String")) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)expr.getManager(), (GlobalSearchScope)expr.getResolveScope());
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)objectType, (PsiType)(anotherType != null ? anotherType : objectType)));
                } else if (PsiType.DOUBLE.isAssignableFrom(anotherType)) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, anotherType));
                }
            } else if (i == JavaTokenType.EQEQ || i == JavaTokenType.NE) {
                ContainerUtil.addIfNotNull(this.myResult, (Object)MyParentVisitor.getEqualsType(anotherExpr));
            } else if (i == JavaTokenType.LTLT || i == JavaTokenType.GTGT || i == JavaTokenType.GTGTGT) {
                if (anotherType != null) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 3, (PsiType)PsiType.SHORT, TailType.NONE));
                }
            } else if (i == JavaTokenType.OROR || i == JavaTokenType.ANDAND) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if ((i == JavaTokenType.OR || i == JavaTokenType.XOR || i == JavaTokenType.AND) && anotherType != null) {
                ExpectedTypeInfoImpl info = PsiType.BOOLEAN.equals((Object)anotherType) ? ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, anotherType);
                this.myResult.add(info);
            }
        }

        @Nullable
        private static ExpectedTypeInfo getEqualsType(@Nullable PsiExpression anotherExpr) {
            ExpectedTypeInfoImpl info;
            PsiElement refElement;
            PsiType anotherType;
            PsiType psiType = anotherType = anotherExpr != null ? anotherExpr.getType() : null;
            if (anotherType == null) {
                return null;
            }
            NullableComputable<String> expectedName = ExpectedTypeInfoImpl.NULL;
            if (anotherExpr instanceof PsiReferenceExpression && (refElement = ((PsiReferenceExpression)anotherExpr).resolve()) instanceof PsiVariable) {
                expectedName = MyParentVisitor.getPropertyName((PsiVariable)refElement);
            }
            if (anotherType instanceof PsiPrimitiveType) {
                if (PsiType.BOOLEAN.equals((Object)anotherType)) {
                    info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else if (PsiType.NULL.equals((Object)anotherType)) {
                    PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)anotherExpr.getManager(), (GlobalSearchScope)anotherExpr.getResolveScope());
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)objectType, 1, (PsiType)objectType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                } else {
                    info = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
                }
            } else {
                info = ExpectedTypesProvider.createInfoImpl(anotherType, 0, anotherType, TailType.NONE, null, (NullableComputable<String>)expectedName);
            }
            return info;
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expr) {
            TailType tailType;
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitPrefixExpression"));
            }
            IElementType i = expr.getOperationTokenType();
            PsiType type = expr.getType();
            TailType tailType2 = tailType = expr.getParent() instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)expr.getParent()).getRExpression() == expr ? MyParentVisitor.getAssignmentRValueTailType((PsiAssignmentExpression)expr.getParent()) : TailType.NONE;
            if (i == JavaTokenType.PLUSPLUS || i == JavaTokenType.MINUSMINUS || i == JavaTokenType.TILDE) {
                ExpectedTypeInfoImpl info = this.myUsedAfter && type != null ? ExpectedTypesProvider.createInfoImpl(type, 0, type, tailType) : (type != null ? ExpectedTypesProvider.createInfoImpl(type, 2, (PsiType)PsiType.INT, tailType) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, 1, (PsiType)PsiType.INT, tailType));
                this.myResult.add(info);
            } else if (i == JavaTokenType.PLUS || i == JavaTokenType.MINUS) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE, 1, (PsiType)PsiType.INT, tailType));
            } else if (i == JavaTokenType.EXCL) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, tailType));
            }
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitPostfixExpression"));
            }
            if (this.myForCompletion) {
                return;
            }
            PsiType type = expr.getType();
            ExpectedTypeInfoImpl info = this.myUsedAfter && type != null ? ExpectedTypesProvider.createInfoImpl(type, 0, type, TailType.NONE) : (type != null ? ExpectedTypesProvider.createInfoImpl(type, 2, (PsiType)PsiType.INT, TailType.NONE) : ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.LONG, (PsiType)PsiType.INT));
            this.myResult.add(info);
        }

        public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expr) {
            PsiType type;
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitArrayInitializerExpression"));
            }
            PsiElement pParent = expr.getParent();
            PsiType arrayType = null;
            if (pParent instanceof PsiVariable) {
                arrayType = ((PsiVariable)pParent).getType();
            } else if (pParent instanceof PsiNewExpression) {
                arrayType = ((PsiNewExpression)pParent).getType();
            } else if (pParent instanceof PsiArrayInitializerExpression && (type = ((PsiArrayInitializerExpression)pParent).getType()) instanceof PsiArrayType) {
                arrayType = ((PsiArrayType)type).getComponentType();
            }
            if (arrayType instanceof PsiArrayType) {
                PsiType componentType = ((PsiArrayType)arrayType).getComponentType();
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(componentType, componentType));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiExpression[] arrayDimensions;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitNewExpression"));
            }
            for (PsiExpression dimension : arrayDimensions = expression.getArrayDimensions()) {
                if (!this.myExpr.equals(dimension)) continue;
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
                return;
            }
        }

        public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitArrayAccessExpression"));
            }
            if (this.myExpr.equals(expr.getIndexExpression())) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.INT, (PsiType)PsiType.INT));
            } else if (this.myExpr.equals(expr.getArrayExpression())) {
                if (this.myForCompletion) {
                    this.myExpr = (PsiExpression)this.myExpr.getParent();
                    expr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                PsiElement parent = expr.getParent();
                MyParentVisitor visitor = new MyParentVisitor((PsiExpression)expr, this.myForCompletion, this.myClassProvider, this.myVoidable, this.myUsedAfter);
                this.myExpr = (PsiExpression)this.myExpr.getParent();
                parent.accept((PsiElementVisitor)visitor);
                ExpectedTypeInfo[] componentTypeInfo = visitor.getResult();
                if (componentTypeInfo.length == 0) {
                    this.myResult.addAll(this.anyArrayType());
                } else {
                    for (int i = 0; i < componentTypeInfo.length; ++i) {
                        ExpectedTypeInfo compInfo = componentTypeInfo[i];
                        PsiArrayType expectedArrayType = compInfo.getType().createArrayType();
                        this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)expectedArrayType, (PsiType)expectedArrayType));
                    }
                }
            }
        }

        public void visitConditionalExpression(@NotNull PsiConditionalExpression expr) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitConditionalExpression"));
            }
            if (this.myExpr.equals(expr.getCondition())) {
                if (this.myForCompletion) {
                    this.myExpr = expr;
                    this.myExpr.getParent().accept((PsiElementVisitor)this);
                    return;
                }
                this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.BOOLEAN, 0, (PsiType)PsiType.BOOLEAN, TailType.NONE));
            } else if (this.myExpr.equals(expr.getThenExpression())) {
                ExpectedTypeInfo[] types = ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion);
                for (int i = 0; i < types.length; ++i) {
                    final ExpectedTypeInfo info = types[i];
                    types[i] = ExpectedTypesProvider.createInfoImpl(info.getType(), info.getKind(), info.getDefaultType(), TailType.COND_EXPR_COLON, info.getCalledMethod(), (NullableComputable<String>)((NullableComputable)new NullableComputable<String>(){

                        @Nullable
                        public String compute() {
                            return ((ExpectedTypeInfoImpl)info).getExpectedName();
                        }
                    }));
                }
                Collections.addAll(this.myResult, types);
            } else {
                if (!this.myExpr.equals(expr.getElseExpression())) {
                    LOG.error(Arrays.asList(expr.getChildren()) + "; " + this.myExpr);
                }
                Collections.addAll(this.myResult, ExpectedTypesProvider.getExpectedTypes((PsiExpression)expr, this.myForCompletion));
            }
        }

        public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitThrowStatement"));
            }
            if (statement.getException() == this.myExpr) {
                PsiManager manager = statement.getManager();
                PsiClassType throwableType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Throwable", this.myExpr.getResolveScope());
                PsiMember container = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiClass.class});
                PsiType[] throwsTypes = PsiType.EMPTY_ARRAY;
                if (container instanceof PsiMethod) {
                    throwsTypes = ((PsiMethod)container).getThrowsList().getReferencedTypes();
                }
                if (throwsTypes.length == 0) {
                    PsiClassType exceptionType = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Exception", this.myExpr.getResolveScope());
                    throwsTypes = new PsiClassType[]{exceptionType};
                }
                for (int i = 0; i < throwsTypes.length; ++i) {
                    this.myResult.add(ExpectedTypesProvider.createInfoImpl((PsiType)(this.myExpr instanceof PsiTypeCastExpression && this.myForCompletion ? throwsTypes[i] : throwableType), 1, throwsTypes[i], TailType.SEMICOLON));
                }
            }
        }

        public void visitCodeFragment(@NotNull JavaCodeFragment codeFragment) {
            PsiType type;
            if (codeFragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "visitCodeFragment"));
            }
            if (codeFragment instanceof PsiExpressionCodeFragment && (type = ((PsiExpressionCodeFragment)codeFragment).getExpectedType()) != null) {
                this.myResult.add(ExpectedTypesProvider.createInfoImpl(type, type));
            }
        }

        @NotNull
        private ExpectedTypeInfo[] getExpectedArgumentTypesForMethodCall(@NotNull CandidateInfo[] allCandidates, @NotNull PsiExpressionList argumentList, @NotNull PsiExpression argument, boolean forCompletion) {
            PsiSubstitutor substitutor;
            PsiMethod method;
            PsiExpression[] leftArgs;
            if (allCandidates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allCandidates", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentTypesForMethodCall"));
            }
            if (argumentList == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentTypesForMethodCall"));
            }
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentTypesForMethodCall"));
            }
            if (allCandidates.length == 0) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentTypesForMethodCall"));
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)this.myExpr.getProject()).getResolveHelper();
            ArrayList<CandidateInfo> methodCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo candidate : allCandidates) {
                PsiElement element = candidate.getElement();
                if (!(element instanceof PsiMethod) || !helper.isAccessible((PsiMember)element, (PsiElement)argumentList, null)) continue;
                methodCandidates.add(candidate);
            }
            Object[] args = (PsiExpression[])argumentList.getExpressions().clone();
            int index = ArrayUtil.indexOf((Object[])args, (Object)argument);
            LOG.assertTrue(index >= 0);
            if (index <= args.length - 1) {
                leftArgs = new PsiExpression[index];
                System.arraycopy(args, 0, leftArgs, 0, index);
                if (forCompletion) {
                    args[index] = null;
                }
            } else {
                leftArgs = null;
            }
            CompletionParameterTypeInferencePolicy policy = forCompletion ? CompletionParameterTypeInferencePolicy.INSTANCE : DefaultParameterTypeInferencePolicy.INSTANCE;
            LinkedHashSet<ExpectedTypeInfo> array = new LinkedHashSet<ExpectedTypeInfo>();
            for (CandidateInfo candidateInfo : methodCandidates) {
                method = (PsiMethod)candidateInfo.getElement();
                if (candidateInfo instanceof MethodCandidateInfo) {
                    MethodCandidateInfo info = (MethodCandidateInfo)candidateInfo;
                    substitutor = info.inferTypeArguments((ParameterTypeInferencePolicy)policy, (PsiExpression[])args, true);
                    if (!info.isStaticsScopeCorrect() && method != null && !method.hasModifierProperty("static")) {
                        continue;
                    }
                } else {
                    substitutor = candidateInfo.getSubstitutor();
                }
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, (PsiExpression[])args, index, method, substitutor, array);
                if (leftArgs == null || !(candidateInfo instanceof MethodCandidateInfo)) continue;
                substitutor = ((MethodCandidateInfo)candidateInfo).inferTypeArguments((ParameterTypeInferencePolicy)policy, leftArgs, true);
                MyParentVisitor.inferMethodCallArgumentTypes(argument, forCompletion, leftArgs, index, method, substitutor, array);
            }
            if (forCompletion && array.isEmpty()) {
                for (CandidateInfo candidate : methodCandidates) {
                    method = (PsiMethod)candidate.getElement();
                    substitutor = candidate.getSubstitutor();
                    PsiParameter[] params = method.getParameterList().getParameters();
                    if (params.length <= index) continue;
                    PsiParameter param = params[index];
                    PsiType paramType = MyParentVisitor.getParameterType(param, substitutor);
                    TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, params);
                    ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(paramType, 1, paramType, tailType, method, (NullableComputable<String>)MyParentVisitor.getPropertyName((PsiVariable)param));
                    array.add(info);
                }
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = array.toArray(new ExpectedTypeInfo[array.size()]);
            if (expectedTypeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getExpectedArgumentTypesForMethodCall"));
            }
            return expectedTypeInfoArray;
        }

        @NotNull
        private static TailType getMethodArgumentTailType(@NotNull PsiExpression argument, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiParameter[] params) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
            }
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
            }
            if (params == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
            }
            if (index >= params.length || index == params.length - 2 && params[index + 1].isVarArgs()) {
                TailType tailType = TailType.NONE;
                if (tailType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
                }
                return tailType;
            }
            if (index == params.length - 1) {
                PsiElement call = argument.getParent().getParent();
                if (call instanceof SyntheticElement) {
                    TailType tailType = TailType.NONE;
                    if (tailType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
                    }
                    return tailType;
                }
                PsiType returnType = method.getReturnType();
                if (returnType != null) {
                    returnType = substitutor.substitute(returnType);
                }
                TailType tailType = ExpectedTypesProvider.getFinalCallParameterTailType(call, returnType, method);
                if (tailType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
                }
                return tailType;
            }
            TailType tailType = TailType.COMMA;
            if (tailType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getMethodArgumentTailType"));
            }
            return tailType;
        }

        private static void inferMethodCallArgumentTypes(@NotNull PsiExpression argument, boolean forCompletion, @NotNull PsiExpression[] args, int index, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull Set<ExpectedTypeInfo> array) {
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "inferMethodCallArgumentTypes"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "inferMethodCallArgumentTypes"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "inferMethodCallArgumentTypes"));
            }
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "inferMethodCallArgumentTypes"));
            }
            if (array == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "inferMethodCallArgumentTypes"));
            }
            LOG.assertTrue(substitutor.isValid());
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (!forCompletion && parameters.length != args.length) {
                return;
            }
            if (parameters.length <= index && !method.isVarArgs()) {
                return;
            }
            for (int j = 0; j < index; ++j) {
                PsiType paramType = MyParentVisitor.getParameterType(parameters[Math.min(parameters.length - 1, j)], substitutor);
                PsiType argType = args[j].getType();
                if (argType == null || paramType.isAssignableFrom(argType)) continue;
                return;
            }
            PsiParameter parameter = parameters[Math.min(parameters.length - 1, index)];
            PsiType parameterType = MyParentVisitor.getParameterType(parameter, substitutor);
            TailType tailType = MyParentVisitor.getMethodArgumentTailType(argument, index, method, substitutor, parameters);
            PsiType defaultType = MyParentVisitor.getDefaultType(method, substitutor, parameterType, argument, args, index);
            NullableComputable<String> propertyName = MyParentVisitor.getPropertyName((PsiVariable)parameter);
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl(parameterType, 1, defaultType, tailType, method, (NullableComputable<String>)propertyName);
            array.add(info);
            if (index == parameters.length - 1 && parameter.isVarArgs()) {
                PsiArrayType arrayType = parameterType.createArrayType();
                ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)arrayType, 1, (PsiType)arrayType, tailType, method, (NullableComputable<String>)propertyName);
                array.add(info1);
            }
        }

        @Nullable
        private static PsiType getTypeParameterValue(@NotNull PsiClass rootClass, @NotNull PsiClass derivedClass, PsiSubstitutor substitutor, int index) {
            PsiType type;
            PsiSubstitutor psiSubstitutor;
            if (rootClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootClass", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getTypeParameterValue"));
            }
            if (derivedClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "derivedClass", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getTypeParameterValue"));
            }
            PsiTypeParameter[] typeParameters = rootClass.getTypeParameters();
            if (typeParameters.length > index && (psiSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)rootClass, (PsiClass)derivedClass, (PsiSubstitutor)substitutor)) != null && (type = psiSubstitutor.substitute(typeParameters[index])) != null) {
                return type;
            }
            return null;
        }

        @Nullable
        protected static PsiType checkMethod(@NotNull PsiMethod method, final @NotNull @NonNls String className, final @NotNull NullableFunction<PsiClass, PsiType> function) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "checkMethod"));
            }
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "checkMethod"));
            }
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "checkMethod"));
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            if (className.equals(containingClass.getQualifiedName())) {
                return (PsiType)function.fun((Object)containingClass);
            }
            final PsiType[] type = new PsiType[]{null};
            DeepestSuperMethodsSearch.search((PsiMethod)method).forEach((Processor)new Processor<PsiMethod>(){

                public boolean process(@NotNull PsiMethod psiMethod) {
                    if (psiMethod == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor$5", "process"));
                    }
                    PsiClass rootClass = psiMethod.getContainingClass();
                    assert (rootClass != null);
                    if (className.equals(rootClass.getQualifiedName())) {
                        type[0] = (PsiType)function.fun((Object)rootClass);
                        return false;
                    }
                    return true;
                }
            });
            return type[0];
        }

        @Nullable
        private static PsiType getDefaultType(@NotNull PsiMethod method, final PsiSubstitutor substitutor, @NotNull PsiType parameterType, final @NotNull PsiExpression argument, @NotNull PsiExpression[] args, int index) {
            PsiType typeArg;
            PsiType type;
            PsiType type2;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getDefaultType"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getDefaultType"));
            }
            if (argument == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getDefaultType"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getDefaultType"));
            }
            final PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return parameterType;
            }
            final String name = method.getName();
            if (("contains".equals(name) || "remove".equals(name)) && (type2 = MyParentVisitor.checkMethod(method, "java.util.Collection", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(@NotNull PsiClass psiClass) {
                    if (psiClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor$6", "fun"));
                    }
                    return MyParentVisitor.getTypeParameterValue(psiClass, containingClass, substitutor, 0);
                }
            })) != null) {
                return type2;
            }
            if (("containsKey".equals(name) || "remove".equals(name) || "get".equals(name) || "containsValue".equals(name)) && (type2 = MyParentVisitor.checkMethod(method, "java.util.Map", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(@NotNull PsiClass psiClass) {
                    if (psiClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor$7", "fun"));
                    }
                    return MyParentVisitor.getTypeParameterValue(psiClass, containingClass, substitutor, name.equals("containsValue") ? 1 : 0);
                }
            })) != null) {
                return type2;
            }
            final PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)containingClass.getProject());
            if ("equals".equals(name) && (type = MyParentVisitor.checkMethod(method, "java.lang.Object", new NullableFunction<PsiClass, PsiType>(){

                public PsiType fun(PsiClass psiClass) {
                    PsiElement parent = argument.getParent().getParent();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression expression = (PsiMethodCallExpression)parent;
                        PsiExpression qualifierExpression = expression.getMethodExpression().getQualifierExpression();
                        if (qualifierExpression != null) {
                            return qualifierExpression.getType();
                        }
                        PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)parent, PsiClass.class, (boolean)true);
                        if (aClass != null) {
                            return factory.createType(aClass);
                        }
                    }
                    return null;
                }
            })) != null) {
                return type;
            }
            int argCount = Math.max(index + 1, args.length);
            if (("assertEquals".equals(name) || "assertSame".equals(name) && method.getParameterList().getParametersCount() == argCount) && (argCount == 2 || argCount == 3 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.String"))) {
                ExpectedTypeInfo info;
                int other;
                int n = other = index == argCount - 1 ? index - 1 : index + 1;
                if (args.length > other && (info = MyParentVisitor.getEqualsType(args[other])) != null && parameterType.isAssignableFrom(info.getDefaultType())) {
                    return info.getDefaultType();
                }
            }
            if (("Logger".equals(containingClass.getName()) || "Log".equals(containingClass.getName())) && parameterType instanceof PsiClassType && (typeArg = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.lang.Class", (int)0, (boolean)true)) != null && TypeConversionUtil.erasure((PsiType)typeArg).equalsToText("java.lang.Object")) {
                PsiClass placeClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)argument, (Class[])new Class[]{PsiClass.class});
                PsiClass classClass = ((PsiClassType)parameterType).resolve();
                if (placeClass != null && classClass != null) {
                    return factory.createType(classClass, (PsiType)factory.createType(placeClass));
                }
            }
            return parameterType;
        }

        private static PsiType getParameterType(@NotNull PsiParameter parameter, @NotNull PsiSubstitutor substitutor) {
            PsiType parameterType;
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getParameterType"));
            }
            if (substitutor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getParameterType"));
            }
            PsiType type = parameter.getType();
            LOG.assertTrue(type.isValid());
            if (parameter.isVarArgs()) {
                if (type instanceof PsiArrayType) {
                    type = ((PsiArrayType)type).getComponentType();
                } else {
                    LOG.error("Vararg parameter with non-array type. Class=" + parameter.getClass() + "; type=" + parameter.getType());
                }
            }
            if ((parameterType = substitutor.substitute(type)) instanceof PsiCapturedWildcardType) {
                parameterType = ((PsiCapturedWildcardType)parameterType).getWildcard();
            }
            if (parameterType instanceof PsiWildcardType) {
                PsiType bound = ((PsiWildcardType)parameterType).getBound();
                return bound != null ? bound : PsiType.getJavaLangObject((PsiManager)parameter.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)parameter.getProject()));
            }
            return parameterType;
        }

        @Nullable
        private static NullableComputable<String> getPropertyName(final @NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "getPropertyName"));
            }
            return new NullableComputable<String>(){

                public String compute() {
                    String name = variable.getName();
                    if (name == null) {
                        return null;
                    }
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
                    VariableKind variableKind = codeStyleManager.getVariableKind(variable);
                    return codeStyleManager.variableNameToPropertyName(name, variableKind);
                }
            };
        }

        @NotNull
        private List<ExpectedTypeInfo> anyArrayType() {
            PsiArrayType objType = PsiType.getJavaLangObject((PsiManager)this.myExpr.getManager(), (GlobalSearchScope)this.myExpr.getResolveScope()).createArrayType();
            ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)objType, (PsiType)objType);
            ExpectedTypeInfoImpl info1 = ExpectedTypesProvider.createInfoImpl((PsiType)PsiType.DOUBLE.createArrayType(), (PsiType)PsiType.INT.createArrayType());
            PsiArrayType booleanType = PsiType.BOOLEAN.createArrayType();
            ExpectedTypeInfoImpl info2 = ExpectedTypesProvider.createInfoImpl((PsiType)booleanType, 0, (PsiType)booleanType, TailType.NONE);
            List<ExpectedTypeInfo> list = Arrays.asList(info, info1, info2);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "anyArrayType"));
            }
            return list;
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredMethod(@NotNull PsiMethodCallExpression methodCallExpr, boolean forCompletion) {
            if (methodCallExpr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpr", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "findClassesWithDeclaredMethod"));
            }
            PsiReferenceExpression reference = methodCallExpr.getMethodExpression();
            if (reference.getQualifierExpression() instanceof PsiClassObjectAccessExpression) {
                if (ExpectedTypeInfo.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "findClassesWithDeclaredMethod"));
                }
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            PsiManager manager = methodCallExpr.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
            PsiMethod[] methods = this.myClassProvider.findDeclaredMethods(reference.getManager(), reference.getReferenceName());
            THashSet types = new THashSet();
            for (PsiMethod method : methods) {
                PsiClassType type;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)method, (PsiElement)reference, aClass)) continue;
                PsiSubstitutor substitutor = ExpectedTypeUtil.inferSubstitutor(method, methodCallExpr, forCompletion);
                PsiClassType psiClassType = type = substitutor == null ? facade.getElementFactory().createType(aClass) : facade.getElementFactory().createType(aClass, substitutor);
                if (method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private")) {
                    types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 0, (PsiType)type, TailType.DOT));
                    continue;
                }
                if (method.findSuperMethods().length != 0) continue;
                types.add(ExpectedTypesProvider.createInfoImpl((PsiType)type, 1, (PsiType)type, TailType.DOT));
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = types.toArray(new ExpectedTypeInfo[types.size()]);
            if (expectedTypeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "findClassesWithDeclaredMethod"));
            }
            return expectedTypeInfoArray;
        }

        @NotNull
        private ExpectedTypeInfo[] findClassesWithDeclaredField(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "findClassesWithDeclaredField"));
            }
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)expression.getProject());
            PsiField[] fields = this.myClassProvider.findDeclaredFields(expression.getManager(), expression.getReferenceName());
            ArrayList<ExpectedTypeInfoImpl> types = new ArrayList<ExpectedTypeInfoImpl>();
            for (PsiField field : fields) {
                PsiClass aClass = field.getContainingClass();
                if (aClass == null || !facade.getResolveHelper().isAccessible((PsiMember)field, (PsiElement)expression, aClass)) continue;
                PsiClassType type = facade.getElementFactory().createType(aClass);
                int kind = field.hasModifierProperty("static") || field.hasModifierProperty("final") || field.hasModifierProperty("private") ? 0 : 1;
                ExpectedTypeInfoImpl info = ExpectedTypesProvider.createInfoImpl((PsiType)type, kind, (PsiType)type, TailType.DOT);
                types.add(info);
            }
            ExpectedTypeInfo[] expectedTypeInfoArray = types.toArray(new ExpectedTypeInfo[types.size()]);
            if (expectedTypeInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/ExpectedTypesProvider$MyParentVisitor", "findClassesWithDeclaredField"));
            }
            return expectedTypeInfoArray;
        }
    }
}

