/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotationsLineMarkerProvider
implements LineMarkerProvider {
    private static final Function<PsiElement, String> ourTooltipProvider = new Function<PsiElement, String>(){

        public String fun(PsiElement nameIdentifier) {
            return XmlStringUtil.wrapInHtml((CharSequence)JavaDocInfoGenerator.generateSignature(nameIdentifier.getParent()));
        }
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (!(element instanceof PsiModifierListOwner) || !(element instanceof PsiNameIdentifierOwner)) {
            return null;
        }
        if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
            return null;
        }
        PsiElement nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
        if (nameIdentifier == null || nameIdentifier.getParent() != element) {
            return null;
        }
        if (!ExternalAnnotationsLineMarkerProvider.shouldShowSignature((PsiModifierListOwner)element)) {
            return null;
        }
        return new LineMarkerInfo(nameIdentifier, nameIdentifier.getTextRange().getStartOffset(), AllIcons.Gutter.ExtAnnotation, 4, ourTooltipProvider, (GutterIconNavigationHandler)MyIconGutterHandler.INSTANCE, GutterIconRenderer.Alignment.LEFT);
    }

    private static boolean shouldShowSignature(PsiModifierListOwner owner) {
        if (ExternalAnnotationsLineMarkerProvider.hasNonCodeAnnotations(owner)) {
            return true;
        }
        if (owner instanceof PsiMethod) {
            for (PsiParameter parameter : ((PsiMethod)owner).getParameterList().getParameters()) {
                if (!ExternalAnnotationsLineMarkerProvider.hasNonCodeAnnotations((PsiModifierListOwner)parameter)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasNonCodeAnnotations(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "hasNonCodeAnnotations"));
        }
        Project project = element.getProject();
        PsiAnnotation[] externalAnnotations = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotations(element);
        if (externalAnnotations != null) {
            for (PsiAnnotation annotation : externalAnnotations) {
                if (!ExternalAnnotationsLineMarkerProvider.isVisibleAnnotation(annotation)) continue;
                return true;
            }
        }
        for (PsiAnnotation annotation : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(element)) {
            if (!ExternalAnnotationsLineMarkerProvider.isVisibleAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVisibleAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "isVisibleAnnotation"));
        }
        PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
        if (ref == null) {
            return true;
        }
        PsiElement target = ref.resolve();
        return !(target instanceof PsiClass) || JavaDocInfoGenerator.isDocumentedAnnotationType(target);
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/ExternalAnnotationsLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    private static class MyIconGutterHandler
    implements GutterIconNavigationHandler<PsiElement> {
        static final MyIconGutterHandler INSTANCE = new MyIconGutterHandler();

        private MyIconGutterHandler() {
        }

        public void navigate(MouseEvent e, PsiElement nameIdentifier) {
            PsiElement listOwner = nameIdentifier.getParent();
            PsiFile containingFile = listOwner.getContainingFile();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)listOwner);
            if (virtualFile != null && containingFile != null) {
                Project project = listOwner.getProject();
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile, listOwner.getTextOffset());
                final Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
                if (editor != null) {
                    final DefaultActionGroup group = new DefaultActionGroup();
                    for (IntentionAction action : IntentionManager.getInstance().getAvailableIntentionActions()) {
                        if (!action.isAvailable(project, editor, containingFile)) continue;
                        group.add((AnAction)new ApplyIntentionAction(action, action.getText(), editor, containingFile));
                    }
                    if (group.getChildrenCount() > 0) {
                        editor.getScrollingModel().runActionOnScrollingFinished(new Runnable(){

                            @Override
                            public void run() {
                                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, SimpleDataContext.getProjectContext(null), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showInBestPositionFor(editor);
                            }
                        });
                    }
                }
            }
        }
    }
}

