/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMirrorElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetElementUtil
extends TargetElementUtilBase {
    public static final int NEW_AS_CONSTRUCTOR = 4;
    public static final int THIS_ACCEPTED = 16;
    public static final int SUPER_ACCEPTED = 32;

    @Override
    public int getAllAccepted() {
        return super.getAllAccepted() | 4 | 0x10 | 0x20;
    }

    @Override
    public int getDefinitionSearchFlags() {
        return super.getDefinitionSearchFlags() | 0x10 | 0x20;
    }

    @Override
    public int getReferenceSearchFlags() {
        return super.getReferenceSearchFlags() | 4;
    }

    @Override
    @Nullable
    public PsiElement findTargetElement(@NotNull Editor editor, int flags, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/TargetElementUtil", "findTargetElement"));
        }
        PsiElement element = super.findTargetElement(editor, flags, offset);
        if (element instanceof PsiKeyword) {
            if (element.getParent() instanceof PsiThisExpression) {
                if ((flags & 0x10) == 0) {
                    return null;
                }
                PsiType type = ((PsiThisExpression)element.getParent()).getType();
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type).resolve();
            }
            if (element.getParent() instanceof PsiSuperExpression) {
                if ((flags & 0x20) == 0) {
                    return null;
                }
                PsiType type = ((PsiSuperExpression)element.getParent()).getType();
                if (!(type instanceof PsiClassType)) {
                    return null;
                }
                return ((PsiClassType)type).resolve();
            }
        }
        return element;
    }

    @Override
    protected boolean isAcceptableReferencedElement(PsiElement element, PsiElement referenceOrReferencedElement) {
        return super.isAcceptableReferencedElement(element, referenceOrReferencedElement) && !TargetElementUtil.isEnumConstantReference(element, referenceOrReferencedElement);
    }

    private static boolean isEnumConstantReference(PsiElement element, PsiElement referenceOrReferencedElement) {
        return element != null && element.getParent() instanceof PsiEnumConstant && referenceOrReferencedElement instanceof PsiMethod && ((PsiMethod)referenceOrReferencedElement).isConstructor();
    }

    @Override
    @Nullable
    protected PsiElement getReferenceOrReferencedElement(PsiFile file, Editor editor, int flags, int offset) {
        PsiElement refElement = super.getReferenceOrReferencedElement(file, editor, flags, offset);
        PsiReference ref = null;
        if (refElement == null && (ref = TargetElementUtilBase.findReference(editor, offset)) instanceof PsiJavaReference) {
            refElement = ((PsiJavaReference)ref).advancedResolve(true).getElement();
        }
        if (refElement != null) {
            PsiFile containingFile;
            if ((flags & 4) != 0) {
                if (ref == null) {
                    ref = TargetElementUtilBase.findReference(editor, offset);
                }
                if (ref != null) {
                    PsiElement parent = ref.getElement().getParent();
                    if (parent instanceof PsiAnonymousClass) {
                        parent = parent.getParent();
                    }
                    if (parent instanceof PsiNewExpression) {
                        PsiMethod constructor = ((PsiNewExpression)parent).resolveConstructor();
                        if (constructor != null) {
                            refElement = constructor;
                        } else if (refElement instanceof PsiClass && ((PsiClass)refElement).getConstructors().length > 0) {
                            return null;
                        }
                    }
                }
            }
            if (refElement instanceof PsiMirrorElement) {
                return ((PsiMirrorElement)refElement).getPrototype();
            }
            if (refElement instanceof PsiClass && (containingFile = refElement.getContainingFile()) != null && containingFile.getVirtualFile() == null) {
                String qualifiedName = ((PsiClass)refElement).getQualifiedName();
                if (qualifiedName == null) {
                    return null;
                }
                return JavaPsiFacade.getInstance((Project)refElement.getProject()).findClass(qualifiedName, refElement.getResolveScope());
            }
        }
        return refElement;
    }

    @Override
    @Nullable
    protected PsiElement getNamedElement(PsiElement element) {
        PsiElement parent = element.getParent();
        if (element instanceof PsiIdentifier) {
            if (parent instanceof PsiClass && element.equals(((PsiClass)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiVariable && element.equals(((PsiVariable)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiMethod && element.equals(((PsiMethod)parent).getNameIdentifier())) {
                return parent;
            }
            if (parent instanceof PsiLabeledStatement && element.equals(((PsiLabeledStatement)parent).getLabelIdentifier())) {
                return parent;
            }
        } else {
            parent = PsiTreeUtil.getParentOfType((PsiElement)element, PsiNamedElement.class, (boolean)false);
            if (!(parent == null || parent.getTextOffset() != element.getTextRange().getStartOffset() || parent instanceof XmlAttribute || parent instanceof PsiFile && InjectedLanguageManager.getInstance((Project)parent.getProject()).isInjectedFragment((PsiFile)parent))) {
                return parent;
            }
        }
        return null;
    }

    @Nullable
    public static PsiReferenceExpression findReferenceExpression(Editor editor) {
        PsiReference ref = TargetElementUtil.findReference(editor);
        return ref instanceof PsiReferenceExpression ? (PsiReferenceExpression)ref : null;
    }

    @Override
    public PsiElement adjustReference(@NotNull PsiReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/TargetElementUtil", "adjustReference"));
        }
        PsiElement parent = ref.getElement().getParent();
        if (parent instanceof PsiMethodCallExpression) {
            return parent;
        }
        return super.adjustReference(ref);
    }

    @Override
    @Nullable
    public PsiElement adjustElement(Editor editor, int flags, PsiElement element, PsiElement contextElement) {
        if (element != null) {
            if (element instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)element).getBaseClassType().resolve();
            }
            return element;
        }
        if (contextElement == null) {
            return null;
        }
        PsiElement parent = contextElement.getParent();
        if (parent instanceof XmlText || parent instanceof XmlAttributeValue) {
            return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, parent.getParent().getTextRange().getStartOffset() + 1);
        }
        if (parent instanceof XmlTag || parent instanceof XmlAttribute) {
            return TargetElementUtilBase.getInstance().findTargetElement(editor, flags, parent.getTextRange().getStartOffset() + 1);
        }
        return null;
    }

    @Override
    public Collection<PsiElement> getTargetCandidates(PsiReference reference) {
        PsiElement parent = reference.getElement().getParent();
        if (parent instanceof PsiCallExpression) {
            PsiElement referee;
            PsiExpression qualifier;
            PsiCallExpression callExpr = (PsiCallExpression)parent;
            boolean allowStatics = false;
            Object object = callExpr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpr).getMethodExpression().getQualifierExpression() : (qualifier = callExpr instanceof PsiNewExpression ? ((PsiNewExpression)callExpr).getQualifier() : null);
            if (qualifier == null) {
                allowStatics = true;
            } else if (qualifier instanceof PsiJavaCodeReferenceElement && (referee = ((PsiJavaCodeReferenceElement)qualifier).advancedResolve(true).getElement()) instanceof PsiClass) {
                allowStatics = true;
            }
            PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)parent.getProject()).getResolveHelper();
            PsiElement[] candidates = PsiUtil.mapElements((ResolveResult[])helper.getReferencedMethodCandidates(callExpr, false));
            LinkedHashSet<PsiElement> methods = new LinkedHashSet<PsiElement>();
            for (PsiElement candidate1 : candidates) {
                PsiMethod candidate = (PsiMethod)candidate1;
                if (candidate.hasModifierProperty("static") && !allowStatics) continue;
                List<PsiMethod> supers = Arrays.asList(candidate.findSuperMethods());
                if (supers.isEmpty()) {
                    methods.add((PsiElement)candidate);
                    continue;
                }
                methods.addAll(supers);
            }
            return methods;
        }
        return super.getTargetCandidates(reference);
    }

    @Override
    public PsiElement getGotoDeclarationTarget(PsiElement element, PsiElement navElement) {
        PsiElement navClass;
        PsiClass aClass;
        PsiMethod method;
        if (navElement == element && element instanceof PsiCompiledElement && element instanceof PsiMethod && (method = (PsiMethod)element).isConstructor() && method.getParameterList().getParametersCount() == 0 && (aClass = method.getContainingClass()) != (navClass = aClass.getNavigationElement())) {
            return navClass;
        }
        return super.getGotoDeclarationTarget(element, navElement);
    }

    @Override
    public boolean includeSelfInGotoImplementation(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/TargetElementUtil", "includeSelfInGotoImplementation"));
        }
        if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("abstract")) {
            return false;
        }
        return super.includeSelfInGotoImplementation(element);
    }

    @Override
    public boolean acceptImplementationForReference(PsiReference reference, PsiElement element) {
        if (reference instanceof PsiReferenceExpression && element instanceof PsiMember) {
            return TargetElementUtil.getMemberClass(reference, element) != null;
        }
        return super.acceptImplementationForReference(reference, element);
    }

    private static PsiClass[] getMemberClass(final PsiReference reference, final PsiElement element) {
        return (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

            public PsiClass[] compute() {
                PsiClass psiClass;
                PsiClass containingClass = ((PsiMember)element).getContainingClass();
                PsiExpression expression = ((PsiReferenceExpression)reference).getQualifierExpression();
                if (expression != null) {
                    psiClass = PsiUtil.resolveClassInType((PsiType)expression.getType());
                } else if (element instanceof PsiClass) {
                    psiClass = (PsiClass)element;
                    PsiElement resolve = reference.resolve();
                    if (resolve instanceof PsiClass) {
                        containingClass = (PsiClass)resolve;
                    }
                } else {
                    psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiReferenceExpression)reference), PsiClass.class);
                }
                if (containingClass == null && psiClass == null) {
                    return PsiClass.EMPTY_ARRAY;
                }
                if (containingClass != null) {
                    PsiElementFindProcessor<PsiClass> processor1 = new PsiElementFindProcessor<PsiClass>(containingClass);
                    while (psiClass != null) {
                        if (!(processor1.process(psiClass) && ClassInheritorsSearch.search((PsiClass)containingClass).forEach(new PsiElementFindProcessor<PsiClass>(psiClass)) && ClassInheritorsSearch.search((PsiClass)psiClass).forEach(processor1))) {
                            return new PsiClass[]{psiClass};
                        }
                        psiClass = psiClass.getContainingClass();
                    }
                }
                return null;
            }
        });
    }

    @Override
    public SearchScope getSearchScope(Editor editor, PsiElement element) {
        PsiClass[] memberClass;
        PsiReferenceExpression referenceExpression;
        PsiReferenceExpression psiReferenceExpression = referenceExpression = editor != null ? TargetElementUtil.findReferenceExpression(editor) : null;
        if (referenceExpression != null && element instanceof PsiMethod && (memberClass = TargetElementUtil.getMemberClass((PsiReference)referenceExpression, element)) != null && memberClass.length == 1) {
            return (SearchScope)CachedValuesManager.getCachedValue((PsiElement)referenceExpression, (CachedValueProvider)new CachedValueProvider<SearchScope>(){

                @Nullable
                public CachedValueProvider.Result<SearchScope> compute() {
                    ArrayList classesToSearch = new ArrayList();
                    classesToSearch.addAll(ClassInheritorsSearch.search((PsiClass)memberClass[0], (boolean)true).findAll());
                    HashSet supers = new HashSet();
                    for (PsiClass psiClass : classesToSearch) {
                        supers.addAll(InheritanceUtil.getSuperClasses((PsiClass)psiClass));
                    }
                    classesToSearch.addAll(supers);
                    return new CachedValueProvider.Result((Object)new LocalSearchScope(PsiUtilCore.toPsiElementArray(classesToSearch)), new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
                }
            });
        }
        return super.getSearchScope(editor, element);
    }

    private static class PsiElementFindProcessor<T extends PsiClass>
    implements Processor<T> {
        private final T myElement;

        public PsiElementFindProcessor(T t) {
            this.myElement = t;
        }

        public boolean process(T t) {
            if (InheritanceUtil.isInheritorOrSelf(t, this.myElement, (boolean)true)) {
                return false;
            }
            return !this.myElement.getManager().areElementsEquivalent(this.myElement, t);
        }
    }
}

