/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatChangedTextUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.actions.FormatChangedTextUtil");

    private FormatChangedTextUtil() {
    }

    public static boolean hasChanges(@NotNull PsiFile file) {
        Change change;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (change = ChangeListManager.getInstance((Project)project).getChange(virtualFile)) != null && change.getType() == Change.Type.NEW) {
            return true;
        }
        LineStatusTrackerManagerI manager = LineStatusTrackerManager.getInstance(project);
        if (manager == null) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return false;
        }
        LineStatusTracker lineStatusTracker = manager.getLineStatusTracker(document);
        if (lineStatusTracker == null) {
            return false;
        }
        List<Range> ranges = lineStatusTracker.getRanges();
        if (ranges == null || ranges.isEmpty()) {
            return false;
        }
        for (Range range : ranges) {
            if (range.getType() == 3) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull PsiDirectory directory) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        return FormatChangedTextUtil.hasChanges(directory.getVirtualFile(), directory.getProject());
    }

    public static boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file);
        for (Change change : changes) {
            if (change.getType() != Change.Type.NEW && change.getType() != Change.Type.MODIFICATION) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull VirtualFile[] files, @NotNull Project project) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        for (VirtualFile file : files) {
            if (!FormatChangedTextUtil.hasChanges(file, project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasChanges(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile root : rootManager.getSourceRoots()) {
            if (!FormatChangedTextUtil.hasChanges(root, module.getProject())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanges(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "hasChanges"));
        }
        ModifiableModuleModel moduleModel = (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(Result<ModifiableModuleModel> result) throws Throwable {
                result.setResult((Object)ModuleManager.getInstance((Project)project).getModifiableModel());
            }
        }.execute().getResultObject();
        try {
            for (Module module : moduleModel.getModules()) {
                if (!FormatChangedTextUtil.hasChanges(module)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            moduleModel.dispose();
        }
    }

    @NotNull
    public static Collection<TextRange> getChanges(@NotNull PsiFile file) {
        Change change;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
        }
        Set<TextRange> defaultResult = Collections.singleton(file.getTextRange());
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (change = ChangeListManager.getInstance((Project)file.getProject()).getChange(virtualFile)) != null && change.getType() == Change.Type.NEW) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        LineStatusTrackerManagerI manager = LineStatusTrackerManager.getInstance(file.getProject());
        if (manager == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        LineStatusTracker lineStatusTracker = manager.getLineStatusTracker(document);
        if (lineStatusTracker == null) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        List<Range> ranges = lineStatusTracker.getRanges();
        if (ranges == null || ranges.isEmpty()) {
            Set<TextRange> set = defaultResult;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
            }
            return set;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        for (Range range : ranges) {
            RangeHighlighter highlighter;
            if (range.getType() == 3 || (highlighter = range.getHighlighter()) == null) continue;
            result.add(new TextRange(highlighter.getStartOffset(), highlighter.getEndOffset()));
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChanges"));
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<PsiDirectory> dirs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        ArrayList changes = ContainerUtil.newArrayList();
        for (PsiDirectory dir : dirs) {
            changes.addAll(changeListManager.getChangesIn(dir.getVirtualFile()));
        }
        List<PsiFile> list = FormatChangedTextUtil.getChangedFiles(project, changes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFilesFromDirs"));
        }
        return list;
    }

    @NotNull
    public static List<PsiFile> getChangedFiles(@NotNull Project project, @NotNull Collection<Change> changes) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        ArrayList files = ContainerUtil.newArrayList();
        for (Change change : changes) {
            PsiFile file;
            VirtualFile vFile = change.getVirtualFile();
            if (vFile == null || (file = PsiManager.getInstance((Project)project).findFile(vFile)) == null) continue;
            files.add(file);
        }
        ArrayList arrayList = files;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedFiles"));
        }
        return arrayList;
    }

    @NotNull
    public static List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file) throws FilesTooBigForDiffException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file.getVirtualFile());
        if (change == null) {
            List list = ContainerUtilRt.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
            }
            return list;
        }
        if (change.getType() == Change.Type.NEW) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TextRange[]{file.getTextRange()});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
            }
            return arrayList;
        }
        String contentFromVcs = FormatChangedTextUtil.getRevisionedContentFrom(change);
        List<TextRange> list = contentFromVcs != null ? FormatChangedTextUtil.calculateChangedTextRanges(project, file, contentFromVcs) : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        return list;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getRevisionedContentFrom"));
        }
        ContentRevision revision = change.getBeforeRevision();
        if (revision == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<TextRange> calculateChangedTextRanges(@NotNull Project project, @NotNull PsiFile file, @NotNull String contentFromVcs) throws FilesTooBigForDiffException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        if (contentFromVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentFromVcs", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        Document documentFromVcs = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(contentFromVcs, true, false);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedTextRanges"));
            }
            return list;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document);
        List<Range> changedRanges = tracker != null ? tracker.getRanges() : new RangesBuilder(document, documentFromVcs).getRanges();
        List<TextRange> list = FormatChangedTextUtil.getChangedTextRanges(document, changedRanges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "calculateChangedTextRanges"));
        }
        return list;
    }

    @NotNull
    private static List<TextRange> getChangedTextRanges(@NotNull Document document, @NotNull List<Range> changedRanges) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        if (changedRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedRanges", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            ranges.add(new TextRange(lineStartOffset, lineEndOffset));
        }
        ArrayList arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/FormatChangedTextUtil", "getChangedTextRanges"));
        }
        return arrayList;
    }
}

