/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.TargetElementUtilBase;
import com.intellij.codeInsight.completion.AsyncCompletion;
import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.codeInsight.completion.CompletionConfidenceEP;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionThreading;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.DefaultCompletionContributor;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.SyncCompletion;
import com.intellij.codeInsight.completion.WeighingDelegate;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.editorActions.CompletionAutoPopupHandler;
import com.intellij.codeInsight.hint.EditorHintListener;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupAdapter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionProgressIndicator
extends ProgressIndicatorBase
implements CompletionProcess,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.CompletionProgressIndicator");
    private final Editor myEditor;
    private final CompletionParameters myParameters;
    private final CodeCompletionHandlerBase myHandler;
    private final LookupImpl myLookup;
    private final MergingUpdateQueue myQueue;
    private final Update myUpdate = new Update("update"){

        public void run() {
            CompletionProgressIndicator.this.updateLookup();
            CompletionProgressIndicator.this.myQueue.setMergingTimeSpan(300);
        }
    };
    private final Semaphore myFreezeSemaphore;
    private final OffsetMap myOffsetMap;
    private final List<Pair<Integer, ElementPattern<String>>> myRestartingPrefixConditions = ContainerUtil.createLockFreeCopyOnWriteList();
    private final LookupAdapter myLookupListener = new LookupAdapter(){

        @Override
        public void itemSelected(LookupEvent event) {
            CompletionProgressIndicator.this.finishCompletionProcess(false);
            LookupElement item = event.getItem();
            if (item == null) {
                return;
            }
            CompletionProgressIndicator.this.setMergeCommand();
            CompletionProgressIndicator.this.myHandler.lookupItemSelected(CompletionProgressIndicator.this, item, event.getCompletionChar(), CompletionProgressIndicator.this.myLookup.getItems());
        }

        @Override
        public void lookupCanceled(LookupEvent event) {
            CompletionProgressIndicator.this.finishCompletionProcess(true);
        }
    };
    private volatile int myCount;
    private volatile boolean myHasPsiElements;
    private boolean myLookupUpdated;
    private final ConcurrentHashMap<LookupElement, CompletionSorterImpl> myItemSorters = new ConcurrentHashMap(ContainerUtil.identityStrategy());
    private final PropertyChangeListener myLookupManagerListener;
    private final Queue<Runnable> myAdvertiserChanges = new ConcurrentLinkedQueue<Runnable>();
    private final int myStartCaret;

    public CompletionProgressIndicator(Editor editor, CompletionParameters parameters, CodeCompletionHandlerBase handler, Semaphore freezeSemaphore, OffsetMap offsetMap, boolean hasModifiers, LookupImpl lookup) {
        this.myEditor = editor;
        this.myParameters = parameters;
        this.myHandler = handler;
        this.myFreezeSemaphore = freezeSemaphore;
        this.myOffsetMap = offsetMap;
        this.myLookup = lookup;
        this.myStartCaret = this.myEditor.getCaretModel().getOffset();
        this.myAdvertiserChanges.offer(new Runnable(){

            @Override
            public void run() {
                CompletionProgressIndicator.this.myLookup.getAdvertiser().clearAdvertisements();
            }
        });
        this.myLookup.setArranger(new CompletionLookupArranger(parameters, this));
        this.myLookup.addLookupListener(this.myLookupListener);
        this.myLookup.setCalculating(true);
        this.myLookupManagerListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    LOG.error("An attempt to change the lookup during completion, phase = " + CompletionServiceImpl.getCompletionPhase());
                }
            }
        };
        LookupManager.getInstance(this.getProject()).addPropertyChangeListener(this.myLookupManagerListener);
        this.myQueue = new MergingUpdateQueue("completion lookup progress", 100, true, this.myEditor.getContentComponent());
        this.myQueue.setPassThrough(false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.register((Disposable)this, (Disposable)offsetMap);
        if (hasModifiers && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.trackModifiers();
        }
    }

    public OffsetMap getOffsetMap() {
        return this.myOffsetMap;
    }

    public int getSelectionEndOffset() {
        return this.getOffsetMap().getOffset(CompletionInitializationContext.SELECTION_END_OFFSET);
    }

    void duringCompletion(CompletionInitializationContext initContext) {
        if (this.isAutopopupCompletion()) {
            if (CompletionProgressIndicator.shouldPreselectFirstSuggestion(this.myParameters)) {
                if (!CodeInsightSettings.getInstance().SELECT_AUTOPOPUP_SUGGESTIONS_BY_CHARS) {
                    String dotShortcut;
                    this.myLookup.setFocusDegree(LookupImpl.FocusDegree.SEMI_FOCUSED);
                    if (FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.finishByCtrlDot", this.getProject()) && StringUtil.isNotEmpty((String)(dotShortcut = CompletionContributor.getActionShortcut((String)"EditorChooseLookupItemDot")))) {
                        this.addAdvertisement("Press " + dotShortcut + " to choose the selected (or first) suggestion and insert a dot afterwards", null);
                    }
                } else {
                    this.myLookup.setFocusDegree(LookupImpl.FocusDegree.FOCUSED);
                }
            }
            if (!this.myEditor.isOneLineMode() && FeatureUsageTracker.getInstance().isToBeAdvertisedInLookup("editing.completion.cancelByControlArrows", this.getProject())) {
                String downShortcut = CompletionContributor.getActionShortcut((String)"EditorLookupDown");
                String upShortcut = CompletionContributor.getActionShortcut((String)"EditorLookupUp");
                if (StringUtil.isNotEmpty((String)downShortcut) && StringUtil.isNotEmpty((String)upShortcut)) {
                    this.addAdvertisement(downShortcut + " and " + upShortcut + " will move caret down and up in the editor", null);
                }
            }
        } else if (DumbService.isDumb((Project)this.getProject())) {
            this.addAdvertisement("The results might be incomplete while indexing is in progress", MessageType.WARNING.getPopupBackground());
        }
        ProgressManager.checkCanceled();
        if (!initContext.getOffsetMap().wasModified(CompletionInitializationContext.IDENTIFIER_END_OFFSET)) {
            try {
                int selectionEndOffset = initContext.getSelectionEndOffset();
                PsiReference reference = TargetElementUtilBase.findReference(this.myEditor, selectionEndOffset);
                if (reference != null) {
                    initContext.setReplacementOffset(CompletionProgressIndicator.findReplacementOffset(selectionEndOffset, reference));
                }
            }
            catch (IndexNotReadyException ignored) {
                // empty catch block
            }
        }
        for (CompletionContributor contributor : CompletionContributor.forLanguage((Language)initContext.getPositionLanguage())) {
            ProgressManager.checkCanceled();
            if (DumbService.getInstance((Project)initContext.getProject()).isDumb() && !DumbService.isDumbAware((Object)contributor)) continue;
            contributor.duringCompletion(initContext);
        }
    }

    @NotNull
    CompletionSorterImpl getSorter(LookupElement element) {
        CompletionSorterImpl completionSorterImpl = (CompletionSorterImpl)((Object)this.myItemSorters.get((Object)element));
        if (completionSorterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionProgressIndicator", "getSorter"));
        }
        return completionSorterImpl;
    }

    public void dispose() {
    }

    private static int findReplacementOffset(int selectionEndOffset, PsiReference reference) {
        List ranges = ReferenceRange.getAbsoluteRanges((PsiReference)reference);
        for (TextRange range : ranges) {
            if (!range.contains(selectionEndOffset)) continue;
            return range.getEndOffset();
        }
        return selectionEndOffset;
    }

    void scheduleAdvertising() {
        if (this.myLookup.isAvailableToUser()) {
            return;
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)this.myParameters)) {
            if (!this.myLookup.isCalculating() && !this.myLookup.isVisible()) {
                return;
            }
            String s = contributor.advertise(this.myParameters);
            if (s == null) continue;
            this.addAdvertisement(s, null);
        }
    }

    private boolean isOutdated() {
        return CompletionServiceImpl.getCompletionPhase().indicator != this;
    }

    private void trackModifiers() {
        assert (!this.isAutopopupCompletion());
        JComponent contentComponent = this.myEditor.getContentComponent();
        contentComponent.addKeyListener(new ModifierTracker(contentComponent));
    }

    public void setMergeCommand() {
        CommandProcessor.getInstance().setCurrentCommandGroupId((Object)this.getCompletionCommandName());
    }

    private String getCompletionCommandName() {
        return "Completion" + this.hashCode();
    }

    public boolean showLookup() {
        return this.updateLookup();
    }

    public CompletionParameters getParameters() {
        return this.myParameters;
    }

    public CodeCompletionHandlerBase getHandler() {
        return this.myHandler;
    }

    public LookupImpl getLookup() {
        return this.myLookup;
    }

    private boolean updateLookup() {
        Runnable action;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isOutdated() || !this.shouldShowLookup()) {
            return false;
        }
        while ((action = this.myAdvertiserChanges.poll()) != null) {
            action.run();
        }
        if (!this.myLookupUpdated) {
            if (this.myLookup.getAdvertisements().isEmpty() && !this.isAutopopupCompletion() && !DumbService.isDumb((Project)this.getProject())) {
                DefaultCompletionContributor.addDefaultAdvertisements(this.myParameters, this.myLookup, this.myHasPsiElements);
            }
            this.myLookup.getAdvertiser().showRandomText();
        }
        boolean justShown = false;
        if (!this.myLookup.isShown()) {
            if (this.hideAutopopupIfMeaningless()) {
                return false;
            }
            if (Registry.is((String)"dump.threads.on.empty.lookup") && this.myLookup.isCalculating() && this.myLookup.getItems().isEmpty()) {
                PerformanceWatcher.getInstance().dumpThreads(true);
            }
            if (!this.myLookup.showLookup()) {
                return false;
            }
            justShown = true;
        }
        this.myLookupUpdated = true;
        this.myLookup.refreshUi(true, justShown);
        this.hideAutopopupIfMeaningless();
        if (justShown) {
            this.myLookup.ensureSelectionVisible(true);
        }
        return true;
    }

    private boolean shouldShowLookup() {
        if (this.isAutopopupCompletion()) {
            if (this.myCount == 0) {
                return false;
            }
            if (this.myLookup.isCalculating() && Registry.is((String)"ide.completion.delay.autopopup.until.completed")) {
                return false;
            }
        }
        return true;
    }

    final boolean isInsideIdentifier() {
        return this.getIdentifierEndOffset() != this.getSelectionEndOffset();
    }

    public int getIdentifierEndOffset() {
        return this.myOffsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
    }

    public synchronized void addItem(CompletionResult item) {
        if (!this.isRunning()) {
            return;
        }
        ProgressManager.checkCanceled();
        boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        if (!unitTestMode) {
            LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        }
        LOG.assertTrue(this.myParameters.getPosition().isValid());
        LookupElement lookupElement = item.getLookupElement();
        if (!this.myHasPsiElements && lookupElement.getPsiElement() != null) {
            this.myHasPsiElements = true;
        }
        this.myItemSorters.put((Object)lookupElement, (Object)((CompletionSorterImpl)item.getSorter()));
        if (!this.myLookup.addItem(lookupElement, item.getPrefixMatcher())) {
            return;
        }
        ++this.myCount;
        if (this.myCount == 1) {
            new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)this).addRequest(new Runnable(){

                @Override
                public void run() {
                    CompletionProgressIndicator.this.myFreezeSemaphore.up();
                }
            }, 300);
        }
        this.myQueue.queue(this.myUpdate);
    }

    public void closeAndFinish(boolean hideLookup) {
        if (!this.myLookup.isLookupDisposed()) {
            LookupEx lookup = LookupManager.getActiveLookup(this.myEditor);
            LOG.assertTrue(lookup == this.myLookup, (Object)("lookup changed: " + lookup + "; " + this));
        }
        this.myLookup.removeLookupListener(this.myLookupListener);
        this.finishCompletionProcess(true);
        CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        if (hideLookup) {
            LookupManager.getInstance(this.getProject()).hideActiveLookup();
        }
    }

    private void finishCompletionProcess(boolean disposeOffsetMap) {
        this.cancel();
        ApplicationManager.getApplication().assertIsDispatchThread();
        Disposer.dispose((Disposable)this.myQueue);
        LookupManager.getInstance(this.getProject()).removePropertyChangeListener(this.myLookupManagerListener);
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        LOG.assertTrue(currentCompletion == this, (Object)(currentCompletion + "!=" + this));
        CompletionServiceImpl.assertPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.Synchronous.class, CompletionPhase.CommittingDocuments.class);
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            LOG.assertTrue(((CompletionPhase.CommittingDocuments)oldPhase).isRestartingCompletion(), (Object)oldPhase);
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        if (disposeOffsetMap) {
            this.disposeIndicator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposeIndicator() {
        AccessToken token = WriteAction.start();
        try {
            Disposer.dispose((Disposable)this);
        }
        finally {
            token.finish();
        }
    }

    public static void cleanupForNextTest() {
        CompletionProgressIndicator currentCompletion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (currentCompletion != null) {
            currentCompletion.finishCompletionProcess(true);
            CompletionServiceImpl.assertPhase(CompletionPhase.NoCompletion.getClass());
        } else {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
        }
        CompletionLookupArranger.cancelLastCompletionStatisticsUpdate();
    }

    @Override
    public void stop() {
        super.stop();
        this.myQueue.cancelAllUpdates();
        this.myFreezeSemaphore.up();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
                if (!(phase instanceof CompletionPhase.BgCalculation) || phase.indicator != CompletionProgressIndicator.this) {
                    return;
                }
                LOG.assertTrue(!CompletionProgressIndicator.this.getProject().isDisposed(), (Object)"project disposed");
                if (CompletionProgressIndicator.this.myEditor.isDisposed()) {
                    LookupManager.getInstance(CompletionProgressIndicator.this.getProject()).hideActiveLookup();
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                    return;
                }
                if (CompletionProgressIndicator.this.myEditor instanceof EditorWindow) {
                    LOG.assertTrue(((EditorWindow)CompletionProgressIndicator.this.myEditor).getInjectedFile().isValid(), (Object)"injected file !valid");
                    LOG.assertTrue(((DocumentWindow)CompletionProgressIndicator.this.myEditor.getDocument()).isValid(), (Object)"docWindow !valid");
                }
                PsiFile file = CompletionProgressIndicator.this.myLookup.getPsiFile();
                LOG.assertTrue(file == null || file.isValid(), (Object)"file !valid");
                CompletionProgressIndicator.this.myLookup.setCalculating(false);
                if (CompletionProgressIndicator.this.myCount == 0) {
                    LookupManager.getInstance(CompletionProgressIndicator.this.getProject()).hideActiveLookup();
                    if (!CompletionProgressIndicator.this.isAutopopupCompletion()) {
                        CompletionProgressIndicator current = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
                        LOG.assertTrue(current == null, (Object)(current + "!=" + CompletionProgressIndicator.this));
                        CompletionProgressIndicator.this.handleEmptyLookup(!((CompletionPhase.BgCalculation)phase).modifiersChanged);
                    }
                } else {
                    CompletionServiceImpl.setCompletionPhase(new CompletionPhase.ItemsCalculated(CompletionProgressIndicator.this));
                    CompletionProgressIndicator.this.updateLookup();
                }
            }
        }, this.myQueue.getModalityState());
    }

    private boolean hideAutopopupIfMeaningless() {
        if (!this.myLookup.isLookupDisposed() && this.isAutopopupCompletion() && !this.myLookup.isSelectionTouched() && !this.myLookup.isCalculating()) {
            this.myLookup.refreshUi(true, false);
            List<LookupElement> items = this.myLookup.getItems();
            for (LookupElement item : items) {
                if (!this.myLookup.itemPattern(item).equals(item.getLookupString())) {
                    return false;
                }
                if (!item.isValid() || !item.isWorthShowingInAutoPopup()) continue;
                return false;
            }
            this.myLookup.hideLookup(false);
            LOG.assertTrue(CompletionServiceImpl.getCompletionService().getCurrentCompletion() == null);
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return true;
        }
        return false;
    }

    public boolean fillInCommonPrefix(final boolean explicit) {
        if (this.isInsideIdentifier()) {
            return false;
        }
        Boolean aBoolean = (Boolean)new WriteCommandAction<Boolean>(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CompletionProgressIndicator$7", "run"));
                }
                if (!explicit) {
                    CompletionProgressIndicator.this.setMergeCommand();
                }
                try {
                    result.setResult((Object)CompletionProgressIndicator.this.myLookup.fillInCommonPrefix(explicit));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }.execute().getResultObject();
        return aBoolean;
    }

    public void restorePrefix(final @NotNull Runnable customRestore) {
        if (customRestore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customRestore", "com/intellij/codeInsight/completion/CompletionProgressIndicator", "restorePrefix"));
        }
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/completion/CompletionProgressIndicator$8", "run"));
                }
                CompletionProgressIndicator.this.setMergeCommand();
                customRestore.run();
            }
        }.execute();
    }

    public int nextInvocationCount(int invocation, boolean reused) {
        return reused ? Math.max(this.getParameters().getInvocationCount() + 1, 2) : invocation;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public boolean isRepeatedInvocation(CompletionType completionType, Editor editor) {
        if (completionType != this.myParameters.getCompletionType() || editor != this.myEditor) {
            return false;
        }
        return !this.isAutopopupCompletion() || this.myLookup.mayBeNoticed();
    }

    public boolean isAutopopupCompletion() {
        return this.myHandler.autopopup;
    }

    @NotNull
    public Project getProject() {
        Project project = (Project)ObjectUtils.assertNotNull((Object)this.myEditor.getProject());
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/CompletionProgressIndicator", "getProject"));
        }
        return project;
    }

    public void addWatchedPrefix(int startOffset, ElementPattern<String> restartCondition) {
        this.myRestartingPrefixConditions.add((Pair<Integer, ElementPattern<String>>)Pair.create((Object)startOffset, restartCondition));
    }

    public void prefixUpdated() {
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        if (caretOffset < this.myStartCaret) {
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        for (Pair<Integer, ElementPattern<String>> pair : this.myRestartingPrefixConditions) {
            String newPrefix;
            int start = (Integer)pair.first;
            if (caretOffset < start || start < 0 || !((ElementPattern)pair.second).accepts((Object)(newPrefix = ((Object)text.subSequence(start, caretOffset)).toString()))) continue;
            this.scheduleRestart();
            this.myRestartingPrefixConditions.clear();
            return;
        }
        this.hideAutopopupIfMeaningless();
    }

    public void scheduleRestart() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.cancel();
        CompletionProgressIndicator current = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
        if (this != current) {
            LOG.error(current + "!=" + this);
        }
        this.hideAutopopupIfMeaningless();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        if (oldPhase instanceof CompletionPhase.CommittingDocuments) {
            ((CompletionPhase.CommittingDocuments)oldPhase).replaced = true;
        }
        final CompletionPhase.CommittingDocuments phase = new CompletionPhase.CommittingDocuments(this, this.myEditor);
        CompletionServiceImpl.setCompletionPhase(phase);
        phase.ignoreCurrentDocumentChange();
        final Project project = this.getProject();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CompletionAutoPopupHandler.runLaterWithCommitted(project, CompletionProgressIndicator.this.myEditor.getDocument(), new Runnable(){

                    @Override
                    public void run() {
                        if (phase.checkExpired()) {
                            return;
                        }
                        CompletionAutoPopupHandler.invokeCompletion(CompletionProgressIndicator.this.myParameters.getCompletionType(), CompletionProgressIndicator.this.isAutopopupCompletion(), project, CompletionProgressIndicator.this.myEditor, CompletionProgressIndicator.this.myParameters.getInvocationCount(), true);
                    }
                });
            }
        }, project.getDisposed());
    }

    @Override
    public String toString() {
        return "CompletionProgressIndicator[count=" + this.myCount + ",phase=" + CompletionServiceImpl.getCompletionPhase() + "]@" + System.identityHashCode(this);
    }

    protected void handleEmptyLookup(boolean awaitSecondInvocation) {
        LOG.assertTrue(!this.isAutopopupCompletion());
        if (ApplicationManager.getApplication().isUnitTestMode() || !this.myHandler.invokedExplicitly) {
            CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            return;
        }
        for (CompletionContributor contributor : CompletionContributor.forParameters((CompletionParameters)this.getParameters())) {
            String text = contributor.handleEmptyLookup(this.getParameters(), this.getEditor());
            if (!StringUtil.isNotEmpty((String)text)) continue;
            LightweightHint hint = CompletionProgressIndicator.showErrorHint(this.getProject(), this.getEditor(), text);
            CompletionServiceImpl.setCompletionPhase(awaitSecondInvocation ? new CompletionPhase.NoSuggestionsHint(hint, this) : CompletionPhase.NoCompletion);
            return;
        }
        CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
    }

    private static LightweightHint showErrorHint(Project project, Editor editor, String text) {
        final LightweightHint[] result = new LightweightHint[]{null};
        EditorHintListener listener = new EditorHintListener(){

            @Override
            public void hintShown(Project project, LightweightHint hint, int flags) {
                result[0] = hint;
            }
        };
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(EditorHintListener.TOPIC, (Object)listener);
        assert (text != null);
        HintManager.getInstance().showErrorHint(editor, text, (short)2);
        connection.disconnect();
        return result[0];
    }

    private static boolean shouldPreselectFirstSuggestion(CompletionParameters parameters) {
        if (!Registry.is((String)"ide.completion.autopopup.choose.by.enter")) {
            return false;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        switch (CodeInsightSettings.getInstance().AUTOPOPUP_FOCUS_POLICY) {
            case 3: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)parameters.getPosition().getContainingFile(), (int)parameters.getOffset());
        for (CompletionConfidence confidence : CompletionConfidenceEP.forLanguage((Language)language)) {
            ThreeState result = confidence.shouldFocusLookup(parameters);
            if (result == ThreeState.UNSURE) continue;
            LOG.debug(confidence + " has returned shouldFocusLookup=" + result);
            return result == ThreeState.YES;
        }
        return false;
    }

    void startCompletion(final CompletionInitializationContext initContext) {
        boolean sync = ApplicationManager.getApplication().isUnitTestMode() && !CompletionAutoPopupHandler.ourTestingAutopopup;
        CompletionThreading strategy = sync ? new SyncCompletion() : new AsyncCompletion();
        strategy.startThread(ProgressWrapper.wrap(this), new Runnable(){

            @Override
            public void run() {
                CompletionProgressIndicator.this.scheduleAdvertising();
            }
        });
        final WeighingDelegate weigher = strategy.delegateWeighing(this);
        class CalculateItems
        implements Runnable {
            CalculateItems() {
            }

            @Override
            public void run() {
                try {
                    CompletionProgressIndicator.this.calculateItems(initContext, weigher);
                }
                catch (ProcessCanceledException ignore) {
                    CompletionProgressIndicator.this.cancel();
                }
                catch (Throwable t) {
                    CompletionProgressIndicator.this.cancel();
                    LOG.error(t);
                }
            }
        }
        strategy.startThread(this, new CalculateItems());
    }

    private LookupElement[] calculateItems(CompletionInitializationContext initContext, WeighingDelegate weigher) {
        this.duringCompletion(initContext);
        ProgressManager.checkCanceled();
        LookupElement[] result = CompletionService.getCompletionService().performCompletion(this.myParameters, (Consumer)weigher);
        ProgressManager.checkCanceled();
        weigher.waitFor();
        ProgressManager.checkCanceled();
        return result;
    }

    public void addAdvertisement(final @NotNull String text, final @Nullable Color bgColor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/completion/CompletionProgressIndicator", "addAdvertisement"));
        }
        this.myAdvertiserChanges.offer(new Runnable(){

            @Override
            public void run() {
                CompletionProgressIndicator.this.myLookup.addAdvertisement(text, bgColor);
            }
        });
        this.myQueue.queue(this.myUpdate);
    }

    private static class ModifierTracker
    extends KeyAdapter {
        private final JComponent myContentComponent;

        public ModifierTracker(JComponent contentComponent) {
            this.myContentComponent = contentComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processModifier(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processModifier(e);
        }

        private void processModifier(KeyEvent e) {
            int code = e.getKeyCode();
            if (code == 17 || code == 157 || code == 18 || code == 16) {
                this.myContentComponent.removeKeyListener(this);
                CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
                if (phase instanceof CompletionPhase.BgCalculation) {
                    ((CompletionPhase.BgCalculation)phase).modifiersChanged = true;
                } else if (phase instanceof CompletionPhase.InsertedSingleItem) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        }
    }
}

