/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToThrowsFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToThrowsFix");
    private final PsiElement myWrongElement;

    public AddExceptionToThrowsFix(@NotNull PsiElement wrongElement) {
        if (wrongElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrongElement", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "<init>"));
        }
        this.myWrongElement = wrongElement;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        List<PsiClassType> exceptions;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiElement targetElement = null;
        PsiMethod targetMethod = null;
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiLambdaExpression.class);
        if (lambdaExpression != null) {
            targetMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)lambdaExpression);
            targetElement = lambdaExpression.getBody();
        }
        if (targetElement == null && targetMethod == null) {
            targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiMethod.class);
            targetElement = targetMethod;
        }
        if ((exceptions = AddExceptionToThrowsFix.getUnhandledExceptions(this.myWrongElement, targetElement, targetMethod)) == null || targetMethod == null) {
            return;
        }
        THashSet unhandledExceptions = new THashSet(exceptions);
        AddExceptionToThrowsFix.addExceptionsToThrowsList(project, targetMethod, (Set<PsiClassType>)unhandledExceptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void addExceptionsToThrowsList(final @NotNull Project project, final @NotNull PsiMethod targetMethod, final @NotNull Set<PsiClassType> unhandledExceptions) {
        boolean processSuperMethods;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "addExceptionsToThrowsList"));
        }
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "addExceptionsToThrowsList"));
        }
        if (unhandledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledExceptions", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "addExceptionsToThrowsList"));
        }
        final PsiMethod[] superMethods = AddExceptionToThrowsFix.getSuperMethods(targetMethod);
        boolean hasSuperMethodsWithoutExceptions = AddExceptionToThrowsFix.hasSuperMethodsWithoutExceptions(superMethods, unhandledExceptions);
        if (hasSuperMethodsWithoutExceptions && superMethods.length > 0) {
            int result = Messages.showYesNoCancelDialog((String)QuickFixBundle.message("add.exception.to.throws.inherited.method.warning.text", targetMethod.getName()), (String)QuickFixBundle.message("method.is.inherited.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                processSuperMethods = true;
            } else {
                if (result != 1) return;
                processSuperMethods = false;
            }
        } else {
            processSuperMethods = false;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (!FileModificationService.getInstance().prepareFileForWrite(targetMethod.getContainingFile())) {
                    return;
                }
                if (processSuperMethods) {
                    for (PsiMethod superMethod : superMethods) {
                        if (FileModificationService.getInstance().prepareFileForWrite(superMethod.getContainingFile())) continue;
                        return;
                    }
                }
                try {
                    AddExceptionToThrowsFix.processMethod(project, targetMethod, unhandledExceptions);
                    if (processSuperMethods) {
                        for (PsiMethod superMethod : superMethods) {
                            AddExceptionToThrowsFix.processMethod(project, superMethod, unhandledExceptions);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    private static PsiMethod[] getSuperMethods(@NotNull PsiMethod targetMethod) {
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "getSuperMethods"));
        }
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        AddExceptionToThrowsFix.collectSuperMethods(targetMethod, result);
        return result.toArray(new PsiMethod[result.size()]);
    }

    private static void collectSuperMethods(@NotNull PsiMethod method, @NotNull List<PsiMethod> result) {
        PsiMethod[] superMethods;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "collectSuperMethods"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "collectSuperMethods"));
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            result.add(superMethod);
            AddExceptionToThrowsFix.collectSuperMethods(superMethod, result);
        }
    }

    private static boolean hasSuperMethodsWithoutExceptions(@NotNull PsiMethod[] superMethods, @NotNull Set<PsiClassType> unhandledExceptions) {
        if (superMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethods", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "hasSuperMethodsWithoutExceptions"));
        }
        if (unhandledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledExceptions", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "hasSuperMethodsWithoutExceptions"));
        }
        for (PsiMethod superMethod : superMethods) {
            PsiClassType[] referencedTypes = superMethod.getThrowsList().getReferencedTypes();
            HashSet<PsiClassType> exceptions = new HashSet<PsiClassType>(unhandledExceptions);
            for (PsiClassType referencedType : referencedTypes) {
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    exceptions.remove(exception);
                }
            }
            if (exceptions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void processMethod(@NotNull Project project, @NotNull PsiMethod targetMethod, @NotNull Set<PsiClassType> unhandledExceptions) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "processMethod"));
        }
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "processMethod"));
        }
        if (unhandledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledExceptions", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "processMethod"));
        }
        for (PsiClassType unhandledException : unhandledExceptions) {
            PsiClass exceptionClass = unhandledException.resolve();
            if (exceptionClass == null) continue;
            PsiUtil.addException((PsiMethod)targetMethod, (PsiClass)exceptionClass);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)targetMethod.getThrowsList());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "isAvailable"));
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        if (this.myWrongElement == null || !this.myWrongElement.isValid()) {
            return false;
        }
        PsiElement targetElement = null;
        PsiMethod targetMethod = null;
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiLambdaExpression.class);
        if (lambdaExpression != null) {
            targetMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)lambdaExpression);
            targetElement = lambdaExpression.getBody();
        }
        if (targetElement == null && targetMethod == null) {
            targetMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myWrongElement, PsiMethod.class);
            targetElement = targetMethod;
        }
        if (targetElement == null || targetMethod == null || !targetMethod.getThrowsList().isPhysical()) {
            return false;
        }
        List<PsiClassType> unhandled = AddExceptionToThrowsFix.getUnhandledExceptions(this.myWrongElement, targetElement, targetMethod);
        if (unhandled == null || unhandled.isEmpty()) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.exception.to.throws.text", unhandled.size()));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.exception.to.throws.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "getFamilyName"));
        }
        return string;
    }

    @Nullable
    private static List<PsiClassType> getUnhandledExceptions(@Nullable PsiElement element, PsiElement topElement, PsiMethod targetMethod) {
        if (element == null || element == topElement) {
            return null;
        }
        List<PsiClassType> unhandledExceptions = ExceptionUtil.getUnhandledExceptions(element);
        if (!AddExceptionToThrowsFix.filterInProjectExceptions(targetMethod, unhandledExceptions).isEmpty()) {
            return unhandledExceptions;
        }
        return AddExceptionToThrowsFix.getUnhandledExceptions(element.getParent(), topElement, targetMethod);
    }

    @NotNull
    private static Set<PsiClassType> filterInProjectExceptions(@Nullable PsiMethod targetMethod, @NotNull List<PsiClassType> unhandledExceptions) {
        if (unhandledExceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unhandledExceptions", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "filterInProjectExceptions"));
        }
        if (targetMethod == null) {
            Set<PsiClassType> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "filterInProjectExceptions"));
            }
            return set;
        }
        HashSet<PsiClassType> result = new HashSet<PsiClassType>();
        if (targetMethod.getManager().isInProject((PsiElement)targetMethod)) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = targetMethod.findSuperMethods()) {
                Set<PsiClassType> classTypes = AddExceptionToThrowsFix.filterInProjectExceptions(superMethod, unhandledExceptions);
                result.addAll(classTypes);
            }
            if (superMethods.length == 0) {
                result.addAll(unhandledExceptions);
            }
        } else {
            PsiClassType[] referencedTypes;
            for (PsiClassType referencedType : referencedTypes = targetMethod.getThrowsList().getReferencedTypes()) {
                PsiClass psiClass = referencedType.resolve();
                if (psiClass == null) continue;
                for (PsiClassType exception : unhandledExceptions) {
                    if (!referencedType.isAssignableFrom((PsiType)exception)) continue;
                    result.add(exception);
                }
            }
        }
        HashSet<PsiClassType> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToThrowsFix", "filterInProjectExceptions"));
        }
        return hashSet;
    }
}

