/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.BaseExtResourceAction;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.MapExternalResourceDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ManuallySetupExtResourceAction
extends BaseExtResourceAction {
    @Override
    protected String getQuickFixKeyId() {
        return "manually.setup.external.resource";
    }

    @Override
    protected void doInvoke(@NotNull PsiFile file, int offset, @NotNull String uri, Editor editor) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/ManuallySetupExtResourceAction", "doInvoke"));
        }
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/codeInsight/daemon/impl/quickfix/ManuallySetupExtResourceAction", "doInvoke"));
        }
        final MapExternalResourceDialog dialog = new MapExternalResourceDialog(uri, file.getProject(), file, null);
        dialog.show();
        if (dialog.isOK()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    String location = dialog.getResourceLocation();
                    ExternalResourceManager.getInstance().addResource(dialog.getUri(), location);
                }
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

