/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateDelegateHandler
implements LanguageCodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateDelegateHandler");
    private boolean myToCopyJavaDoc = false;

    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        return OverrideImplementUtil.getContextClass(editor.getProject(), editor, file, false) != null && GenerateDelegateHandler.isApplicable(file, editor);
    }

    public void invoke(@NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateDelegateHandler", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final PsiElementClassMember target = GenerateDelegateHandler.chooseTarget(file, editor, project);
        if (target == null) {
            return;
        }
        final PsiMethodMember[] candidates = this.chooseMethods(target, file, editor, project);
        if (candidates == null || candidates.length == 0) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    int offset = editor.getCaretModel().getOffset();
                    ArrayList<PsiGenerationInfo> prototypes = new ArrayList<PsiGenerationInfo>(candidates.length);
                    for (PsiMethodMember candidate : candidates) {
                        prototypes.add(GenerateDelegateHandler.this.generateDelegatePrototype(candidate, target.getElement()));
                    }
                    List results = GenerateMembersUtil.insertMembersAtOffset(file, offset, prototypes);
                    if (!results.isEmpty()) {
                        PsiMethod firstMethod = (PsiMethod)((PsiGenerationInfo)results.get(0)).getPsiMember();
                        PsiCodeBlock block = firstMethod.getBody();
                        assert (block != null);
                        PsiElement first = block.getFirstBodyElement();
                        assert (first != null);
                        editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private PsiGenerationInfo<PsiMethod> generateDelegatePrototype(PsiMethodMember methodCandidate, PsiElement target) throws IncorrectOperationException {
        PsiMethod method = GenerateMembersUtil.substituteGenericMethod((PsiMethod)methodCandidate.getElement(), methodCandidate.getSubstitutor());
        this.clearMethod(method);
        GenerateDelegateHandler.clearModifiers(method);
        StringBuffer call = new StringBuffer();
        PsiModifierList modifierList = null;
        if (method.getReturnType() != PsiType.VOID) {
            call.append("return ");
        }
        boolean isMethodStatic = ((PsiMethod)methodCandidate.getElement()).hasModifierProperty("static");
        if (target instanceof PsiField) {
            PsiField field = (PsiField)target;
            modifierList = field.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName());
            } else {
                PsiParameter[] parameters;
                String name = field.getName();
                for (PsiParameter psiParameter : parameters = method.getParameterList().getParameters()) {
                    if (!name.equals(psiParameter.getName())) continue;
                    call.append("this.");
                    break;
                }
                call.append(name);
            }
            call.append(".");
        } else if (target instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)target;
            modifierList = m.getModifierList();
            if (isMethodStatic) {
                call.append(methodCandidate.getContainingClass().getQualifiedName()).append(".");
            } else {
                call.append(m.getName());
                call.append("().");
            }
        }
        call.append(method.getName());
        call.append("(");
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int j = 0; j < parameters.length; ++j) {
            PsiParameter parameter = parameters[j];
            if (j > 0) {
                call.append(",");
            }
            call.append(parameter.getName());
        }
        call.append(");");
        PsiManager psiManager = method.getManager();
        PsiStatement stmt = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText(call.toString(), (PsiElement)method);
        stmt = (PsiStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)stmt);
        method.getBody().add((PsiElement)stmt);
        for (PsiParameter psiParameter : ((PsiMethod)methodCandidate.getElement()).getModifierList().getAnnotations()) {
            if (SuppressWarnings.class.getName().equals(psiParameter.getQualifiedName())) continue;
            method.getModifierList().add(psiParameter.copy());
        }
        if (isMethodStatic || modifierList != null && modifierList.hasModifierProperty("static")) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        PsiClass targetClass = ((PsiMember)target).getContainingClass();
        LOG.assertTrue(targetClass != null);
        PsiMethod overridden = targetClass.findMethodBySignature(method, true);
        if (overridden != null && overridden.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(method, targetClass, overridden);
        }
        return new PsiGenerationInfo<PsiMethod>(method);
    }

    private void clearMethod(PsiMethod method) throws IncorrectOperationException {
        PsiDocComment docComment;
        LOG.assertTrue(!method.isPhysical());
        PsiCodeBlock codeBlock = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory().createCodeBlock();
        if (method.getBody() != null) {
            method.getBody().replace((PsiElement)codeBlock);
        } else {
            method.add((PsiElement)codeBlock);
        }
        if (!this.myToCopyJavaDoc && (docComment = method.getDocComment()) != null) {
            docComment.delete();
        }
    }

    private static void clearModifiers(PsiMethod method) throws IncorrectOperationException {
        PsiElement[] children;
        for (PsiElement child : children = method.getModifierList().getChildren()) {
            if (!(child instanceof PsiKeyword)) continue;
            child.delete();
        }
    }

    @Nullable
    private PsiMethodMember[] chooseMethods(PsiElementClassMember targetMember, PsiFile file, Editor editor, Project project) {
        PsiMethodMember[] result;
        PsiMethod[] allMethods;
        PsiClassType.ClassResolveResult resolveResult = null;
        Object target = targetMember.getElement();
        if (target instanceof PsiField) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiField)target).getType()));
        } else if (target instanceof PsiMethod) {
            resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)targetMember.getSubstitutor().substitute(((PsiMethod)target).getReturnType()));
        }
        if (resolveResult == null || resolveResult.getElement() == null) {
            return null;
        }
        PsiClass targetClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiMethodMember> methodInstances = new ArrayList<PsiMethodMember>();
        if (targetClass instanceof PsiTypeParameter) {
            LinkedHashSet<PsiMethod> meths = new LinkedHashSet<PsiMethod>();
            for (PsiClass superClass : targetClass.getSupers()) {
                meths.addAll(Arrays.asList(superClass.getAllMethods()));
            }
            allMethods = meths.toArray(new PsiMethod[meths.size()]);
        } else {
            allMethods = targetClass.getAllMethods();
        }
        HashSet signatures = new HashSet();
        HashSet existingSignatures = new HashSet(aClass.getVisibleSignatures());
        HashSet selection = new HashSet();
        HashMap superSubstitutors = new HashMap();
        PsiClass containingClass = targetMember.getContainingClass();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)target.getProject());
        for (PsiMethod method : allMethods) {
            PsiSubstitutor methodSubstitutor;
            MethodSignature signature;
            PsiMethod overridden;
            PsiClass superClass = method.getContainingClass();
            if ("java.lang.Object".equals(superClass.getQualifiedName()) || method.isConstructor() || method.hasModifierProperty("final") && (overridden = containingClass.findMethodBySignature(method, true)) != null && overridden.getContainingClass() != containingClass) continue;
            PsiSubstitutor superSubstitutor = (PsiSubstitutor)superSubstitutors.get(superClass);
            if (superSubstitutor == null) {
                superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)targetClass, (PsiSubstitutor)substitutor);
                superSubstitutors.put(superClass, superSubstitutor);
            }
            if (signatures.contains(signature = method.getSignature(methodSubstitutor = OverrideImplementExploreUtil.correctSubstitutor(method, superSubstitutor)))) continue;
            signatures.add(signature);
            if (!facade.getResolveHelper().isAccessible((PsiMember)method, target, aClass)) continue;
            PsiMethodMember methodMember = new PsiMethodMember(method, methodSubstitutor);
            methodInstances.add(methodMember);
            if (existingSignatures.contains(signature)) continue;
            selection.add(methodMember);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser((ClassMember[])methodInstances.toArray(new PsiMethodMember[methodInstances.size()]), false, true, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(true);
            if (!selection.isEmpty()) {
                chooser.selectElements(selection.toArray(new ClassMember[selection.size()]));
            }
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            this.myToCopyJavaDoc = chooser.isCopyJavadoc();
            List<PsiMethodMember> list = chooser.getSelectedElements();
            result = list.toArray(new PsiMethodMember[list.size()]);
        } else {
            PsiMethodMember[] psiMethodMemberArray;
            if (methodInstances.isEmpty()) {
                psiMethodMemberArray = new PsiMethodMember[]{};
            } else {
                PsiMethodMember[] psiMethodMemberArray2 = new PsiMethodMember[1];
                psiMethodMemberArray = psiMethodMemberArray2;
                psiMethodMemberArray2[0] = (PsiMethodMember)methodInstances.get(0);
            }
            result = psiMethodMemberArray;
        }
        return result;
    }

    public void setToCopyJavaDoc(boolean toCopyJavaDoc) {
        this.myToCopyJavaDoc = toCopyJavaDoc;
    }

    public static boolean isApplicable(PsiFile file, Editor editor) {
        PsiElementClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        return targetElements != null && targetElements.length > 0;
    }

    @Nullable
    private static PsiElementClassMember chooseTarget(PsiFile file, Editor editor, Project project) {
        ClassMember[] targetElements = GenerateDelegateHandler.getTargetElements(file, editor);
        if (targetElements == null || targetElements.length == 0) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            MemberChooser chooser = new MemberChooser(targetElements, false, false, project);
            chooser.setTitle(CodeInsightBundle.message((String)"generate.delegate.target.chooser.title", (Object[])new Object[0]));
            chooser.setCopyJavadocVisible(false);
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
            List selectedElements = chooser.getSelectedElements();
            if (selectedElements != null && selectedElements.size() > 0) {
                return (PsiElementClassMember)selectedElements.get(0);
            }
        } else {
            return targetElements[0];
        }
        return null;
    }

    @Nullable
    private static PsiElementClassMember[] getTargetElements(PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (aClass == null) {
            return null;
        }
        ArrayList<PsiElementClassMember> result = new ArrayList<PsiElementClassMember>();
        while (aClass != null) {
            GenerateDelegateHandler.collectTargetsInClass(element, aClass, result);
            if (aClass.hasModifierProperty("static")) break;
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }
        return result.toArray(new PsiElementClassMember[result.size()]);
    }

    private static void collectTargetsInClass(PsiElement element, final PsiClass aClass, List<PsiElementClassMember> result) {
        PsiMethod[] methods;
        PsiClass containingClass;
        PsiField[] fields = aClass.getAllFields();
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        for (PsiField field : fields) {
            PsiType type = field.getType();
            if (!helper.isAccessible((PsiMember)field, (PsiElement)aClass, aClass) || !(type instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)field, (PsiElement)element, (boolean)false) || (containingClass = field.getContainingClass()) == null) continue;
            result.add(new PsiFieldMember(field, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        for (PsiMethod method : methods = aClass.getAllMethods()) {
            PsiType returnType;
            containingClass = method.getContainingClass();
            if (containingClass == null || "java.lang.Object".equals(containingClass.getQualifiedName()) || (returnType = method.getReturnType()) == null || !PropertyUtil.isSimplePropertyGetter((PsiMethod)method) || !helper.isAccessible((PsiMember)method, (PsiElement)aClass, aClass) || !(returnType instanceof PsiClassType) || PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)element, (boolean)false)) continue;
            result.add(new PsiMethodMember(method, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)));
        }
        if (aClass instanceof PsiAnonymousClass) {
            PsiClass scope;
            VariablesProcessor proc = new VariablesProcessor(false){

                @Override
                protected boolean check(PsiVariable var, ResolveState state) {
                    return var.hasModifierProperty("final") && var instanceof PsiLocalVariable || var instanceof PsiParameter;
                }
            };
            for (scope = aClass; !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
            }
            if (scope != null) {
                PsiScopesUtil.treeWalkUp(proc, (PsiElement)aClass, (PsiElement)scope);
                for (int i = 0; i < proc.size(); ++i) {
                    PsiVariable psiVariable = proc.getResult(i);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
                    PsiType type = psiVariable.getType();
                    result.add(new PsiFieldMember(elementFactory.createField(psiVariable.getName(), type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type)){

                        @Override
                        protected PsiClass getContainingClass() {
                            return aClass;
                        }
                    });
                }
            }
        }
    }
}

