/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.LiveTemplateBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetLexer;
import com.intellij.codeInsight.template.emmet.EmmetParser;
import com.intellij.codeInsight.template.emmet.filters.SingleLineEmmetFilter;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.FilterNode;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.TemplateNode;
import com.intellij.codeInsight.template.emmet.nodes.TextNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZenCodingTemplate
extends CustomLiveTemplateBase {
    public static final char MARKER = '\u0000';
    private static final String EMMET_RECENT_WRAP_ABBREVIATIONS_KEY = "emmet.recent.wrap.abbreviations";
    private static final String EMMET_LAST_WRAP_ABBREVIATIONS_KEY = "emmet.last.wrap.abbreviations";
    private static final Logger LOG = Logger.getInstance(ZenCodingTemplate.class);

    @Nullable
    public static ZenCodingGenerator findApplicableDefaultGenerator(@NotNull PsiElement context, boolean wrapping) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "findApplicableDefaultGenerator"));
        }
        for (ZenCodingGenerator generator : ZenCodingGenerator.getInstances()) {
            if (!generator.isMyContext(context, wrapping) || !generator.isAppliedByDefault(context)) continue;
            return generator;
        }
        return null;
    }

    @Nullable
    public static ZenCodingNode parse(@NotNull String text, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator, @Nullable String surroundedText) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "parse"));
        }
        List<ZenCodingToken> tokens = new EmmetLexer().lex(text);
        if (tokens == null) {
            return null;
        }
        if (!ZenCodingTemplate.validate(tokens, generator)) {
            return null;
        }
        EmmetParser parser = generator.createParser(tokens, callback, generator, surroundedText != null);
        ZenCodingNode node = parser.parse();
        if (parser.getIndex() != tokens.size() || node instanceof TextNode) {
            return null;
        }
        return node;
    }

    private static boolean validate(@NotNull List<ZenCodingToken> tokens, @NotNull ZenCodingGenerator generator) {
        if (tokens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokens", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validate"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validate"));
        }
        for (ZenCodingToken token : tokens) {
            if (!(token instanceof TextToken) || generator instanceof XmlZenCodingGenerator) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTemplateKey(@NotNull String key, CustomTemplateCallback callback, @NotNull ZenCodingGenerator generator) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "checkTemplateKey"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "checkTemplateKey"));
        }
        return ZenCodingTemplate.parse(key, callback, generator, null) != null;
    }

    @Override
    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), false);
        assert (defaultGenerator != null);
        try {
            ZenCodingTemplate.expand(key, callback, defaultGenerator, Collections.emptyList(), true, Registry.intValue((String)"emmet.segments.limit"));
        }
        catch (EmmetException e) {
            CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)"Emmet error", (String)"");
        }
    }

    @Nullable
    private static ZenCodingGenerator findApplicableGenerator(ZenCodingNode node, PsiElement context, boolean wrapping) {
        ZenCodingGenerator defaultGenerator = null;
        List<ZenCodingGenerator> generators = ZenCodingGenerator.getInstances();
        for (ZenCodingGenerator generator : generators) {
            if (defaultGenerator != null || !generator.isMyContext(context, wrapping) || !generator.isAppliedByDefault(context)) continue;
            defaultGenerator = generator;
        }
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String suffix = filterNode.getFilter();
            for (ZenCodingGenerator generator : generators) {
                if (!generator.isMyContext(context, wrapping) || suffix == null || !suffix.equals(generator.getSuffix())) continue;
                return generator;
            }
            node = filterNode.getNode();
        }
        return defaultGenerator;
    }

    private static List<ZenCodingFilter> getFilters(ZenCodingNode node, PsiElement context) {
        ArrayList<ZenCodingFilter> result = new ArrayList<ZenCodingFilter>();
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            String filterSuffix = filterNode.getFilter();
            boolean filterFound = false;
            for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
                if (!filter.isMyContext(context) || !filter.getSuffix().equals(filterSuffix)) continue;
                filterFound = true;
                result.add(filter);
            }
            assert (filterFound);
            node = filterNode.getNode();
        }
        for (ZenCodingFilter filter : ZenCodingFilter.getInstances()) {
            if (!filter.isMyContext(context) || !filter.isAppliedByDefault(context)) continue;
            result.add(filter);
        }
        Collections.reverse(result);
        return result;
    }

    public static void expand(@NotNull String key, @NotNull CustomTemplateCallback callback, @NotNull ZenCodingGenerator defaultGenerator, @NotNull Collection<? extends ZenCodingFilter> extraFilters, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (defaultGenerator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultGenerator", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        if (extraFilters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraFilters", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "expand"));
        }
        ZenCodingNode node = ZenCodingTemplate.parse(key, callback, defaultGenerator, null);
        if (node == null) {
            return;
        }
        if (node instanceof TemplateNode && key.equals(((TemplateNode)node).getTemplateToken().getKey()) && callback.findApplicableTemplates(key).size() > 1) {
            Map<TemplateImpl, String> template2Argument;
            TemplateManagerImpl templateManager = (TemplateManagerImpl)callback.getTemplateManager();
            Runnable runnable = templateManager.startNonCustomTemplates(template2Argument = templateManager.findMatchingTemplates(callback.getFile(), callback.getEditor(), null, TemplateSettings.getInstance()), callback.getEditor(), null);
            if (runnable != null) {
                runnable.run();
            }
            return;
        }
        PsiElement context = callback.getContext();
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableGenerator(node, context, false);
        List<ZenCodingFilter> filters = ZenCodingTemplate.getFilters(node, context);
        filters.addAll(extraFilters);
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        callback.deleteTemplateKey(key);
        ZenCodingTemplate.expand(node, generator, filters, null, callback, expandPrimitiveAbbreviations, segmentsLimit);
    }

    private static void expand(ZenCodingNode node, ZenCodingGenerator generator, List<ZenCodingFilter> filters, String surroundedText, CustomTemplateCallback callback, boolean expandPrimitiveAbbreviations, int segmentsLimit) throws EmmetException {
        ZenCodingTemplate.checkTemplateOutputLength(node, callback);
        if (surroundedText != null) {
            surroundedText = surroundedText.trim();
        }
        GenerationNode fakeParentNode = new GenerationNode(TemplateToken.EMPTY_TEMPLATE_TOKEN, -1, 1, surroundedText, true, null);
        node.expand(-1, 1, surroundedText, callback, true, fakeParentNode);
        if (!expandPrimitiveAbbreviations && ZenCodingTemplate.isPrimitiveNode(node)) {
            return;
        }
        List<GenerationNode> genNodes = fakeParentNode.getChildren();
        LiveTemplateBuilder builder = new LiveTemplateBuilder(segmentsLimit);
        int end = -1;
        int genNodesSize = genNodes.size();
        for (int i = 0; i < genNodesSize; ++i) {
            GenerationNode genNode = genNodes.get(i);
            TemplateImpl template = genNode.generate(callback, generator, filters, true, segmentsLimit);
            int e = builder.insertTemplate(builder.length(), template, null);
            if (i < genNodesSize - 1 && genNode.isInsertNewLineBetweenNodes()) {
                builder.insertText(e, "\n", false);
                ++e;
            }
            if (end != -1 || end >= builder.length()) continue;
            end = e;
        }
        for (ZenCodingFilter filter : filters) {
            if (!(filter instanceof SingleLineEmmetFilter)) continue;
            builder.setIsToReformat(false);
            break;
        }
        callback.startTemplate(builder.buildTemplate(), null, new TemplateEditingAdapter(){
            private TextRange myEndVarRange;
            private Editor myEditor;

            @Override
            public void beforeTemplateFinished(TemplateState state, Template template) {
                int variableNumber = state.getCurrentVariableNumber();
                if (variableNumber >= 0 && template instanceof TemplateImpl) {
                    TemplateImpl t = (TemplateImpl)template;
                    while (variableNumber < t.getVariableCount()) {
                        String varName = t.getVariableNameAt(variableNumber);
                        if (LiveTemplateBuilder.isEndVariable(varName)) {
                            this.myEndVarRange = state.getVariableRange(varName);
                            this.myEditor = state.getEditor();
                            break;
                        }
                        ++variableNumber;
                    }
                }
            }

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                int offset;
                if (brokenOff && this.myEndVarRange != null && this.myEditor != null && (offset = this.myEndVarRange.getStartOffset()) >= 0 && offset != this.myEditor.getCaretModel().getOffset()) {
                    this.myEditor.getCaretModel().moveToOffset(offset);
                    this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
            }
        });
    }

    private static void checkTemplateOutputLength(ZenCodingNode node, CustomTemplateCallback callback) throws EmmetException {
        int predictedOutputLength = node.getApproximateOutputLength(callback);
        if (predictedOutputLength > 15360) {
            throw new EmmetException();
        }
    }

    private static boolean isPrimitiveNode(@NotNull ZenCodingNode node) {
        List<Couple<String>> attributes;
        Couple singleAttribute;
        TemplateToken token;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "isPrimitiveNode"));
        }
        return node instanceof TemplateNode && (token = ((TemplateNode)node).getTemplateToken()) != null && ((singleAttribute = (Couple)ContainerUtil.getFirstItem(attributes = token.getAttribute2Value())) == null || "class".equalsIgnoreCase((String)singleAttribute.first) && StringUtil.isEmpty((String)((String)singleAttribute.second)));
    }

    @Override
    public void wrap(@NotNull String selection, final @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "wrap"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "wrap"));
        }
        final TextFieldWithStoredHistory field = new TextFieldWithStoredHistory(EMMET_RECENT_WRAP_ABBREVIATIONS_KEY);
        Dimension fieldPreferredSize = field.getPreferredSize();
        field.setPreferredSize(new Dimension(Math.max(220, fieldPreferredSize.width), fieldPreferredSize.height));
        field.setHistorySize(10);
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final BalloonImpl balloon = (BalloonImpl)popupFactory.createDialogBalloonBuilder((JComponent)field, XmlBundle.message((String)"emmet.title", (Object[])new Object[0])).setCloseButtonEnabled(false).setBlockClicksThroughBalloon(true).setAnimationCycle(0).setHideOnKeyOutside(true).createBalloon();
        field.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ZenCodingTemplate.validateTemplateKey((TextFieldWithHistory)field, balloon, field.getText(), callback);
            }
        });
        field.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$3", "keyPressed"));
                }
                if (!field.isPopupVisible()) {
                    switch (e.getKeyCode()) {
                        case 10: {
                            String abbreviation = field.getText();
                            if (!ZenCodingTemplate.validateTemplateKey((TextFieldWithHistory)field, balloon, abbreviation, callback)) break;
                            ZenCodingTemplate.doWrap(abbreviation, callback);
                            PropertiesComponent.getInstance().setValue(ZenCodingTemplate.EMMET_LAST_WRAP_ABBREVIATIONS_KEY, abbreviation);
                            field.addCurrentTextToHistory();
                            balloon.hide(true);
                            break;
                        }
                        case 27: {
                            balloon.hide(false);
                        }
                    }
                }
            }
        });
        IdeEventQueue.getInstance().addDispatcher(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(AWTEvent e) {
                if (e instanceof MouseEvent && e.getID() == 501 && !balloon.isInsideBalloon((MouseEvent)e) && !PopupUtil.isComboPopupKeyEvent((ComponentEvent)((ComponentEvent)e), (JComboBox)field)) {
                    balloon.hide();
                }
                return false;
            }
        }, (Disposable)balloon);
        balloon.addListener((JBPopupListener)new JBPopupListener.Adapter(){

            public void beforeShown(LightweightWindowEvent event) {
                field.setText(PropertiesComponent.getInstance().getValue(ZenCodingTemplate.EMMET_LAST_WRAP_ABBREVIATIONS_KEY, ""));
            }
        });
        balloon.show(popupFactory.guessBestPopupLocation(callback.getEditor()), Balloon.Position.below);
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)callback.getProject());
        focusManager.doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                focusManager.requestFocus((Component)field, true);
                field.selectText();
            }
        });
    }

    private static boolean validateTemplateKey(@NotNull TextFieldWithHistory field, @Nullable Balloon balloon, @NotNull String abbreviation, @NotNull CustomTemplateCallback callback) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validateTemplateKey"));
        }
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validateTemplateKey"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "validateTemplateKey"));
        }
        boolean correct = ZenCodingTemplate.checkTemplateKey(abbreviation, callback);
        field.getTextEditor().setBackground(correct ? LightColors.SLIGHTLY_GREEN : LightColors.RED);
        if (balloon != null && !balloon.isDisposed()) {
            balloon.revalidate();
        }
        return correct;
    }

    static boolean checkTemplateKey(String inputString, CustomTemplateCallback callback) {
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), true);
        if (generator == null) {
            int offset = callback.getEditor().getCaretModel().getOffset();
            LOG.error("Emmet is disabled for context for file " + callback.getFileType().getName() + " in offset: " + offset, new Attachment[]{AttachmentFactory.createAttachment(callback.getEditor().getDocument())});
            return false;
        }
        return ZenCodingTemplate.checkTemplateKey(inputString, callback, generator);
    }

    @Override
    public boolean isApplicable(PsiFile file, int offset, boolean wrapping) {
        if (file == null) {
            return false;
        }
        PsiElement element = CustomTemplateCallback.getContext(file, offset);
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(element, wrapping);
        return applicableGenerator != null && applicableGenerator.isEnabled();
    }

    @Override
    public boolean hasCompletionItem(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "hasCompletionItem"));
        }
        PsiElement element = CustomTemplateCallback.getContext(file, offset);
        ZenCodingGenerator applicableGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(element, false);
        return applicableGenerator != null && applicableGenerator.isEnabled() && applicableGenerator.hasCompletionItem();
    }

    public static void doWrap(final @NotNull String abbreviation, final @NotNull CustomTemplateCallback callback) {
        if (abbreviation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abbreviation", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "doWrap"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "doWrap"));
        }
        final ZenCodingGenerator defaultGenerator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), true);
        assert (defaultGenerator != null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(callback.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        callback.getEditor().getCaretModel().runForEachCaret(new CaretAction(){

                            public void perform(Caret caret) {
                                String selectedText = callback.getEditor().getSelectionModel().getSelectedText();
                                if (selectedText != null) {
                                    String selection = selectedText.trim();
                                    ZenCodingNode node = ZenCodingTemplate.parse(abbreviation, callback, defaultGenerator, selection);
                                    assert (node != null);
                                    PsiElement context = callback.getContext();
                                    ZenCodingGenerator generator = ZenCodingTemplate.findApplicableGenerator(node, context, true);
                                    List filters = ZenCodingTemplate.getFilters(node, context);
                                    EditorModificationUtil.deleteSelectedText((Editor)callback.getEditor());
                                    PsiDocumentManager.getInstance((Project)callback.getProject()).commitAllDocuments();
                                    try {
                                        ZenCodingTemplate.expand(node, generator, filters, selection, callback, true, Registry.intValue((String)"emmet.segments.limit"));
                                    }
                                    catch (EmmetException e) {
                                        CommonRefactoringUtil.showErrorHint((Project)callback.getProject(), (Editor)callback.getEditor(), (String)e.getMessage(), (String)"Emmet error", (String)"");
                                    }
                                }
                            }
                        });
                    }
                }, CodeInsightBundle.message((String)"insert.code.template.command", (Object[])new Object[0]), null);
            }
        });
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = XmlBundle.message((String)"emmet.title", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "getTitle"));
        }
        return string;
    }

    @Override
    public char getShortcut() {
        return (char)EmmetOptions.getInstance().getEmmetExpandShortcut();
    }

    @Override
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate", "computeTemplateKey"));
        }
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(callback.getContext(), false);
        if (generator == null) {
            return null;
        }
        return generator.computeTemplateKey(callback);
    }

    @Override
    public boolean supportsWrapping() {
        return true;
    }

    @Override
    public void addCompletions(CompletionParameters parameters, CompletionResultSet result) {
        if (!parameters.isAutoPopup()) {
            return;
        }
        PsiFile file = parameters.getPosition().getContainingFile();
        int offset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(CustomTemplateCallback.getContext(file, offset), false);
        if (generator != null && generator.hasCompletionItem()) {
            final Ref generatedTemplate = new Ref();
            CustomTemplateCallback callback = new CustomTemplateCallback(editor, file){

                @Override
                public void deleteTemplateKey(@NotNull String key) {
                    if (key == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$8", "deleteTemplateKey"));
                    }
                }

                @Override
                public void startTemplate(@NotNull Template template, Map<String, String> predefinedValues, TemplateEditingListener listener) {
                    if (template == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/template/emmet/ZenCodingTemplate$8", "startTemplate"));
                    }
                    if (template instanceof TemplateImpl && !((TemplateImpl)template).isDeactivated()) {
                        generatedTemplate.set((Object)((TemplateImpl)template));
                    }
                }
            };
            final String templatePrefix = this.computeTemplateKeyWithoutContextChecking(callback);
            if (templatePrefix != null) {
                List<TemplateImpl> regularTemplates = TemplateManagerImpl.listApplicableTemplates(file, offset, false);
                boolean regularTemplateWithSamePrefixExists = !ContainerUtil.filter(regularTemplates, (Condition)new Condition<TemplateImpl>(){

                    public boolean value(TemplateImpl template) {
                        return templatePrefix.equals(template.getKey());
                    }
                }).isEmpty();
                CompletionResultSet resultSet = result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(templatePrefix));
                resultSet.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().startsWith(templatePrefix));
                if (!regularTemplateWithSamePrefixExists) {
                    LinkedList extraFilters = ContainerUtil.newLinkedList((Object[])new SingleLineEmmetFilter[]{new SingleLineEmmetFilter()});
                    try {
                        ZenCodingTemplate.expand(templatePrefix, callback, generator, extraFilters, false, 0);
                    }
                    catch (EmmetException e) {
                        generatedTemplate.set(null);
                    }
                    if (!generatedTemplate.isNull()) {
                        TemplateImpl template = (TemplateImpl)generatedTemplate.get();
                        template.setKey(templatePrefix);
                        template.setDescription(template.getTemplateText());
                        resultSet.addElement((LookupElement)new CustomLiveTemplateLookupElement(this, template.getKey(), template.getKey(), template.getDescription(), !LiveTemplateCompletionContributor.shouldShowAllTemplates(), true));
                    }
                }
            } else if (result.getPrefixMatcher().getPrefix().isEmpty()) {
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            }
        }
    }
}

