/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + LambdaCanBeMethodReferenceInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Lambda can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Lambda can be replaced with method reference";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2MethodRef" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getShortName"));
        }
        return "Convert2MethodRef";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (PsiUtil.getLanguageLevel((PsiElement)expression).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiCallExpression callExpression;
                    PsiElement body = expression.getBody();
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (functionalInterfaceType != null && (callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body, expression.getParameterList().getParameters(), functionalInterfaceType)) != null) {
                        holder.registerProblem((PsiElement)callExpression, "Can be replaced with method reference", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithMethodRefFix()});
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    protected static PsiCallExpression canBeMethodReferenceProblem(@Nullable PsiElement body, final PsiParameter[] parameters, PsiType functionalInterfaceType) {
        PsiCallExpression methodCall = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock(body);
        if (methodCall instanceof PsiNewExpression && ((PsiNewExpression)methodCall).getAnonymousClass() != null) {
            return null;
        }
        if (methodCall != null) {
            PsiParameter[] psiParameters;
            PsiMethod interfaceMethod;
            PsiExpression[] dimensions;
            PsiExpressionList argumentList = methodCall.getArgumentList();
            if (argumentList != null) {
                int offset;
                PsiClass containingClass;
                boolean isConstructor;
                PsiExpression[] expressions = argumentList.getExpressions();
                PsiMethod psiMethod = methodCall.resolveMethod();
                if (psiMethod == null) {
                    isConstructor = true;
                    if (!(methodCall instanceof PsiNewExpression)) {
                        return null;
                    }
                    PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)methodCall).getClassOrAnonymousClassReference();
                    if (classReference == null) {
                        return null;
                    }
                    containingClass = (PsiClass)classReference.resolve();
                } else {
                    containingClass = psiMethod.getContainingClass();
                    isConstructor = psiMethod.isConstructor();
                }
                boolean isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)functionalInterfaceType, (PsiClass)containingClass, (PsiMethod)psiMethod);
                if (psiMethod != null && !isConstructor) {
                    PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.ensureNonAmbiguousMethod(parameters, psiMethod, isReceiverType);
                    if (nonAmbiguousMethod == null) {
                        return null;
                    }
                    psiMethod = nonAmbiguousMethod;
                    containingClass = nonAmbiguousMethod.getContainingClass();
                }
                if (containingClass == null) {
                    return null;
                }
                boolean staticOrValidConstructorRef = isConstructor ? containingClass.getContainingClass() == null || containingClass.hasModifierProperty("static") : psiMethod.hasModifierProperty("static");
                int n = offset = isReceiverType && !staticOrValidConstructorRef ? 1 : 0;
                if (parameters.length != expressions.length + offset) {
                    return null;
                }
                for (int i = 0; i < expressions.length; ++i) {
                    PsiExpression psiExpression = expressions[i];
                    if (!(psiExpression instanceof PsiReferenceExpression)) {
                        return null;
                    }
                    PsiElement resolve = ((PsiReferenceExpression)psiExpression).resolve();
                    if (resolve == null) {
                        return null;
                    }
                    if (parameters[i + offset] == resolve) continue;
                    return null;
                }
                Object qualifierExpression = methodCall instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)methodCall).getMethodExpression().getQualifierExpression() : (methodCall instanceof PsiNewExpression ? ((PsiNewExpression)methodCall).getQualifier() : null);
                if (offset > 0) {
                    if (!(qualifierExpression instanceof PsiReferenceExpression) || ((PsiReferenceExpression)qualifierExpression).resolve() != parameters[0]) {
                        return null;
                    }
                } else if (qualifierExpression != null) {
                    final Ref usedInQualifier = new Ref((Object)false);
                    qualifierExpression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReferenceExpression(PsiReferenceExpression expression) {
                            PsiElement resolve = expression.resolve();
                            if (resolve instanceof PsiParameter && ArrayUtilRt.find((Object[])parameters, (Object)resolve) > -1) {
                                usedInQualifier.set((Object)true);
                                return;
                            }
                            super.visitReferenceExpression(expression);
                        }

                        public void visitNewExpression(PsiNewExpression expression) {
                            usedInQualifier.set((Object)true);
                            super.visitNewExpression(expression);
                        }

                        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                            usedInQualifier.set((Object)true);
                            super.visitMethodCallExpression(expression);
                        }
                    });
                    if (((Boolean)usedInQualifier.get()).booleanValue()) {
                        return null;
                    }
                } else if (containingClass != PsiTreeUtil.getParentOfType((PsiElement)body, PsiClass.class) && containingClass.getName() == null) {
                    return null;
                }
                return methodCall;
            }
            if (methodCall instanceof PsiNewExpression && (dimensions = ((PsiNewExpression)methodCall).getArrayDimensions()).length > 0 && (interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType)) != null && (psiParameters = interfaceMethod.getParameterList().getParameters()).length == 1 && PsiType.INT.equals((Object)psiParameters[0].getType())) {
                return methodCall;
            }
        }
        return null;
    }

    public static PsiCallExpression extractMethodCallFromBlock(PsiElement body) {
        PsiCallExpression methodCall = null;
        if (body instanceof PsiCallExpression) {
            methodCall = (PsiCallExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                PsiExpression expr;
                if (statements[0] instanceof PsiReturnStatement) {
                    PsiExpression returnValue = ((PsiReturnStatement)statements[0]).getReturnValue();
                    if (returnValue instanceof PsiCallExpression) {
                        methodCall = (PsiCallExpression)returnValue;
                    }
                } else if (statements[0] instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiCallExpression) {
                    methodCall = (PsiCallExpression)expr;
                }
            }
        } else {
            PsiExpression expression;
            if (body instanceof PsiBlockStatement) {
                return LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock((PsiElement)((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)body).getExpression()) instanceof PsiCallExpression) {
                methodCall = (PsiCallExpression)expression;
            }
        }
        return methodCall;
    }

    @Nullable
    private static PsiMethod ensureNonAmbiguousMethod(PsiParameter[] parameters, @NotNull PsiMethod psiMethod, boolean isReceiverType) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "ensureNonAmbiguousMethod"));
        }
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        for (PsiMethod method : psiMethods) {
            PsiParameter[] candidateParams = method.getParameterList().getParameters();
            if (candidateParams.length == parameters.length && isReceiverType) {
                PsiMethod[] deepestSuperMethods;
                if (TypeConversionUtil.areTypesConvertible((PsiType)candidateParams[0].getType(), (PsiType)parameters[0].getType()) && (deepestSuperMethods = psiMethod.findDeepestSuperMethods()).length > 0) {
                    for (PsiMethod superMethod : deepestSuperMethods) {
                        PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.ensureNonAmbiguousMethod(parameters, superMethod, true);
                        if (validSuperMethod == null) continue;
                        return validSuperMethod;
                    }
                }
                return null;
            }
            if (isReceiverType || candidateParams.length + 1 != parameters.length || !method.hasModifierProperty("static")) continue;
            return null;
        }
        return psiMethod;
    }

    @Nullable
    protected static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiParameter[] parameters) {
        String methodRefText = null;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiMethod psiMethod = methodCall.resolveMethod();
            if (psiMethod == null) {
                return null;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            LOG.assertTrue(containingClass != null);
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            String methodReferenceName = methodExpression.getReferenceName();
            if (qualifierExpression != null) {
                boolean isReceiverType = PsiMethodReferenceUtil.isReceiverType((PsiType)functionalInterfaceType, (PsiClass)containingClass, (PsiMethod)psiMethod);
                String qualifier = isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters, psiMethod, containingClass, qualifierExpression) : qualifierExpression.getText();
                methodRefText = qualifier + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodReferenceName;
            } else {
                methodRefText = psiMethod.hasModifierProperty("static") ? LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass) : (containingClass != PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) ? containingClass.getName() + ".this" : "this");
                methodRefText = methodRefText + "::" + methodReferenceName;
            }
        } else if (element instanceof PsiNewExpression) {
            PsiType deepComponentType;
            PsiMethod constructor = ((PsiNewExpression)element).resolveConstructor();
            PsiClass containingClass = null;
            if (constructor != null) {
                containingClass = constructor.getContainingClass();
                LOG.assertTrue(containingClass != null);
            } else {
                JavaResolveResult resolve;
                PsiElement resolveElement;
                PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)element).getClassOrAnonymousClassReference();
                if (classReference != null && (resolveElement = (resolve = classReference.advancedResolve(false)).getElement()) instanceof PsiClass) {
                    containingClass = (PsiClass)resolveElement;
                }
            }
            PsiType newExprType = ((PsiNewExpression)element).getType();
            if (containingClass != null) {
                methodRefText = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
            } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
                methodRefText = deepComponentType.getCanonicalText();
            }
            if (methodRefText != null) {
                if (newExprType != null) {
                    int dim = newExprType.getArrayDimensions();
                    while (dim-- > 0) {
                        methodRefText = methodRefText + "[]";
                    }
                }
                methodRefText = methodRefText + "::new";
            }
        }
        return methodRefText;
    }

    private static String composeReceiverQualifierText(PsiParameter[] parameters, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression) {
        PsiElement resolve;
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "composeReceiverQualifierText"));
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.ensureNonAmbiguousMethod(parameters, psiMethod, true);
        LOG.assertTrue(nonAmbiguousMethod != null);
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (!containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (nonAmbiguousContainingClass.isPhysical() && qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiParameter && ArrayUtil.find((Object[])parameters, (Object)resolve) > -1 && ((PsiParameter)resolve).getTypeElement() == null) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        PsiType qualifierExpressionType = qualifierExpression.getType();
        return qualifierExpressionType != null ? qualifierExpressionType.getCanonicalText() : LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        String containingClassName = containingClass.getName();
        return containingClassName != null ? containingClassName : "";
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace lambda with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getName"));
            }
            return "Replace lambda with method reference";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
                return;
            }
            String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(element, functionalInterfaceType, lambdaExpression.getParameterList().getParameters());
            if (methodRefText != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, (PsiElement)lambdaExpression);
                PsiElement replace = lambdaExpression.replace((PsiElement)psiExpression);
                if (((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType() == null) {
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", replace);
                    cast.getCastType().replace((PsiElement)factory.createTypeElement(functionalInterfaceType));
                    cast.getOperand().replace(replace);
                    replace = replace.replace((PsiElement)cast);
                }
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replace);
            }
        }
    }
}

