/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PossibleHeapPollutionVarargsInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + PossibleHeapPollutionVarargsInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Possible heap pollution from parameterized vararg type" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getDisplayName"));
        }
        return "Possible heap pollution from parameterized vararg type";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("SafeVarargsDetector" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getShortName"));
        }
        return "SafeVarargsDetector";
    }

    @NotNull
    public String getID() {
        if ("unchecked" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "getID"));
        }
        return "unchecked";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "buildVisitor"));
        }
        HeapPollutionVisitor heapPollutionVisitor = new HeapPollutionVisitor(){

            @Override
            protected void registerProblem(PsiMethod method, PsiIdentifier nameIdentifier) {
                Object quickFix;
                if (method.hasModifierProperty("final") || method.hasModifierProperty("static") || method.isConstructor()) {
                    quickFix = new AnnotateAsSafeVarargsQuickFix();
                } else {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    boolean canBeFinal = !method.hasModifierProperty("abstract") && !containingClass.isInterface() && OverridingMethodsSearch.search((PsiMethod)method).findFirst() == null;
                    quickFix = canBeFinal ? new MakeFinalAndAnnotateQuickFix() : null;
                }
                holder.registerProblem((PsiElement)nameIdentifier, "Possible heap pollution from parameterized vararg type #loc", new LocalQuickFix[]{quickFix});
            }
        };
        if (heapPollutionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection", "buildVisitor"));
        }
        return heapPollutionVisitor;
    }

    public static abstract class HeapPollutionVisitor
    extends JavaElementVisitor {
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!PsiUtil.getLanguageLevel((PsiElement)method).isAtLeast(LanguageLevel.JDK_1_7)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.SafeVarargs", (boolean)false)) {
                return;
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiParameter psiParameter = method.getParameterList().getParameters()[method.getParameterList().getParametersCount() - 1];
            PsiType componentType = ((PsiEllipsisType)psiParameter.getType()).getComponentType();
            if (JavaGenericsUtil.isReifiableType(componentType)) {
                return;
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter)) {
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiExpression) || PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)element))) continue;
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerProblem(method, nameIdentifier);
            }
        }

        protected abstract void registerProblem(PsiMethod var1, PsiIdentifier var2);
    }

    private static class MakeFinalAndAnnotateQuickFix
    implements LocalQuickFix {
        private MakeFinalAndAnnotateQuickFix() {
        }

        @NotNull
        public String getName() {
            if ("Make final and annotate as @SafeVarargs" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "getName"));
            }
            return "Make final and annotate as @SafeVarargs";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$MakeFinalAndAnnotateQuickFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier) {
                PsiMethod psiMethod = (PsiMethod)psiElement.getParent();
                psiMethod.getModifierList().setModifierProperty("final", true);
                new AddAnnotationPsiFix("java.lang.SafeVarargs", (PsiModifierListOwner)psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }

    private static class AnnotateAsSafeVarargsQuickFix
    implements LocalQuickFix {
        private AnnotateAsSafeVarargsQuickFix() {
        }

        @NotNull
        public String getName() {
            if ("Annotate as @SafeVarargs" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "getName"));
            }
            return "Annotate as @SafeVarargs";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiMethod psiMethod;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement instanceof PsiIdentifier && (psiMethod = (PsiMethod)psiElement.getParent()) != null) {
                new AddAnnotationPsiFix("java.lang.SafeVarargs", (PsiModifierListOwner)psiMethod, PsiNameValuePair.EMPTY_ARRAY, new String[0]).applyFix(project, descriptor);
            }
        }
    }
}

