/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantLambdaCodeBlockInspection
extends BaseJavaBatchLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance((String)("#" + RedundantLambdaCodeBlockInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Statement lambda can be replaced with expression lambda" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getDisplayName"));
        }
        return "Statement lambda can be replaced with expression lambda";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("CodeBlock2Expr" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "getShortName"));
        }
        return "CodeBlock2Expr";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitLambdaExpression(PsiLambdaExpression expression) {
                PsiExpression psiExpression;
                super.visitLambdaExpression(expression);
                PsiElement body = expression.getBody();
                if (body instanceof PsiCodeBlock && (psiExpression = RedundantLambdaCodeBlockInspection.getExpression((PsiCodeBlock)body)) != null) {
                    PsiElement parent;
                    CandidateInfo[] candidates;
                    PsiElement gParent;
                    PsiElement parent2;
                    if (!expression.isVoidCompatible() && LambdaUtil.isExpressionStatementExpression((PsiElement)psiExpression) && (parent2 = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiExpressionList && (gParent = parent2.getParent()) instanceof PsiCallExpression && (candidates = PsiResolveHelper.SERVICE.getInstance((Project)gParent.getProject()).getReferencedMethodCandidates((PsiCallExpression)gParent, false)).length > 1) {
                        ArrayList<CandidateInfo> info = new ArrayList<CandidateInfo>(Arrays.asList(candidates));
                        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)parent2);
                        JavaMethodsConflictResolver conflictResolver = new JavaMethodsConflictResolver((PsiExpressionList)parent2, level);
                        int applicability = conflictResolver.checkApplicability(info);
                        conflictResolver.checkSpecifics(info, applicability, level);
                        if (info.size() > 1) {
                            return;
                        }
                    }
                    PsiElement errorElement = (parent = psiExpression.getParent()) instanceof PsiReturnStatement ? parent.getFirstChild() : body.getFirstChild();
                    holder.registerProblem(errorElement, "Statement lambda can be replaced with expression lambda", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new ReplaceWithExprFix()});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiExpression getExpression(PsiCodeBlock body) {
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 1) {
            if (statements[0] instanceof PsiBlockStatement) {
                return RedundantLambdaCodeBlockInspection.getExpression(((PsiBlockStatement)statements[0]).getCodeBlock());
            }
            if (statements[0] instanceof PsiReturnStatement || statements[0] instanceof PsiExpressionStatement) {
                if (statements[0] instanceof PsiReturnStatement) {
                    PsiReturnStatement returnStatement = (PsiReturnStatement)statements[0];
                    return returnStatement.getReturnValue();
                }
                return ((PsiExpressionStatement)statements[0]).getExpression();
            }
        }
        return null;
    }

    private static class ReplaceWithExprFix
    implements LocalQuickFix,
    HighPriorityAction {
        private ReplaceWithExprFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with expression lambda" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "getName"));
            }
            return "Replace with expression lambda";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression;
            PsiElement body;
            PsiLambdaExpression lambdaExpression;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/RedundantLambdaCodeBlockInspection$ReplaceWithExprFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null && (lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLambdaExpression.class)) != null && (body = lambdaExpression.getBody()) != null && (expression = RedundantLambdaCodeBlockInspection.getExpression((PsiCodeBlock)body)) != null) {
                body.replace((PsiElement)expression);
            }
        }
    }
}

