/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaStaticGroup
extends XValueGroup
implements NodeDescriptorProvider {
    private final StaticDescriptorImpl myStaticDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;

    public JavaStaticGroup(StaticDescriptorImpl staticDescriptor, EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        super(staticDescriptor.getName());
        this.myStaticDescriptor = staticDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return this.myStaticDescriptor;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/engine/JavaStaticGroup", "computeChildren"));
        }
        this.myEvaluationContext.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public void contextAction() throws Exception {
                XValueChildrenList children = new XValueChildrenList();
                ReferenceType refType = JavaStaticGroup.this.myStaticDescriptor.getType();
                List<Field> fields = refType.allFields();
                ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                for (Field field : fields) {
                    if (!field.isStatic()) continue;
                    boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
                    if (!classRenderer.SHOW_SYNTHETICS && isSynthetic) continue;
                    FieldDescriptorImpl fieldDescriptor = JavaStaticGroup.this.myNodeManager.getFieldDescriptor(JavaStaticGroup.this.myStaticDescriptor, null, field);
                    children.add((XNamedValue)JavaValue.create(fieldDescriptor, JavaStaticGroup.this.myEvaluationContext, JavaStaticGroup.this.myNodeManager));
                }
                node.addChildren(children, true);
            }
        });
    }
}

