/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        List<Location> list;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        try {
            int line = position.getLine() + 1;
            list = type.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "locationsOfLine"));
        }
        return list;
    }

    public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequest"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "createPrepareRequest"));
        }
        final Ref waitPrepareFor = new Ref(null);
        final Ref waitRequestor = new Ref(null);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = JVMNameUtil.getClassAt(position);
                if (psiClass == null) {
                    return;
                }
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                    PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (parent == null) {
                        return;
                    }
                    String parentQName = JVMNameUtil.getNonAnonymousClassName(parent);
                    if (parentQName == null) {
                        return;
                    }
                    waitPrepareFor.set((Object)(parentQName + "*"));
                    waitRequestor.set((Object)new ClassPrepareRequestor(){

                        public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                            CompoundPositionManager positionManager = ((DebugProcessImpl)debuggerProcess).getPositionManager();
                            List<ReferenceType> positionClasses = positionManager.getAllClasses(position);
                            if (positionClasses.contains(referenceType)) {
                                requestor.processClassPrepare(debuggerProcess, referenceType);
                            }
                        }
                    });
                } else {
                    waitPrepareFor.set((Object)JVMNameUtil.getNonAnonymousClassName(psiClass));
                    waitRequestor.set((Object)requestor);
                }
            }
        });
        if (waitPrepareFor.get() == null) {
            return null;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest((ClassPrepareRequestor)waitRequestor.get(), (String)waitPrepareFor.get());
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        int lineNumber;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        PsiFile psiFile = this.getPsiFileByLocation(this.getDebugProcess().getProject(), location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        if (location == null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
        }
        try {
            lineNumber = location.lineNumber() - 1;
        }
        catch (InternalError e) {
            lineNumber = -1;
        }
        if (psiFile instanceof PsiCompiledElement || lineNumber < 0) {
            String methodSignature = location.method().signature();
            if (methodSignature == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            String methodName = location.method().name();
            if (methodName == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            if (location.declaringType() == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            MethodFinder finder = new MethodFinder(location.declaringType().name(), methodSignature);
            psiFile.accept((PsiElementVisitor)finder);
            PsiMethod compiledMethod = finder.getCompiledMethod();
            if (compiledMethod == null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
            return SourcePosition.createFromElement((PsiElement)compiledMethod);
        }
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
    }

    @Nullable
    private PsiFile getPsiFileByLocation(Project project, Location location) {
        int dollar;
        GlobalSearchScope searchScope;
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            return null;
        }
        String originalQName = refType.name();
        PsiClass psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project, (GlobalSearchScope)(searchScope = this.myDebugProcess.getSearchScope()));
        if (psiClass == null && (dollar = originalQName.indexOf(36)) > 0) {
            String qName = originalQName.substring(0, dollar);
            psiClass = DebuggerUtils.findClass((String)qName, (Project)project, (GlobalSearchScope)searchScope);
        }
        if (psiClass != null) {
            PsiElement element = psiClass.getNavigationElement();
            return element.getContainingFile();
        }
        try {
            PsiFile[] files;
            for (PsiFile file : files = FilenameIndex.getFilesByName(project, refType.sourceName(), GlobalSearchScope.allScope((Project)project))) {
                if (!(file instanceof PsiJavaFile)) continue;
                for (PsiClass cls : ((PsiJavaFile)file).getClasses()) {
                    if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)cls.getQualifiedName())) continue;
                    return file;
                }
            }
        }
        catch (AbsentInformationException ignore) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(final @NotNull SourcePosition position) throws NoDataException {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
        }
        final Ref baseClassNameRef = new Ref(null);
        final Ref classAtPositionRef = new Ref(null);
        final Ref isLocalOrAnonymous = new Ref((Object)Boolean.FALSE);
        final Ref requiredDepth = new Ref((Object)0);
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = JVMNameUtil.getClassAt(position);
                if (psiClass != null) {
                    classAtPositionRef.set((Object)psiClass);
                    if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                        isLocalOrAnonymous.set((Object)Boolean.TRUE);
                        PsiClass topLevelClass = JVMNameUtil.getTopLevelParentClass(psiClass);
                        if (topLevelClass != null) {
                            String parentClassName = JVMNameUtil.getNonAnonymousClassName(topLevelClass);
                            if (parentClassName != null) {
                                requiredDepth.set((Object)PositionManagerImpl.getNestingDepth(psiClass));
                                baseClassNameRef.set((Object)parentClassName);
                            } else {
                                LOG.error("The name of a parent of a local (anonymous) class is null");
                            }
                        } else {
                            LOG.error("Local or anonymous class has no non-local parent");
                        }
                    } else {
                        String className = JVMNameUtil.getNonAnonymousClassName(psiClass);
                        if (className != null) {
                            baseClassNameRef.set((Object)className);
                        }
                    }
                }
            }
        });
        String className = (String)baseClassNameRef.get();
        if (className == null) {
            List<ReferenceType> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
            }
            return list;
        }
        if (!((Boolean)isLocalOrAnonymous.get()).booleanValue()) {
            List<ReferenceType> list = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
            }
            return list;
        }
        List<ReferenceType> outers = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(outers.size());
        for (ReferenceType outer : outers) {
            ReferenceType nested = this.findNested(outer, 0, (PsiClass)classAtPositionRef.get(), (Integer)requiredDepth.get(), position);
            if (nested == null) continue;
            result.add(nested);
        }
        ArrayList<ReferenceType> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/PositionManagerImpl", "getAllClasses"));
        }
        return arrayList;
    }

    private static int getNestingDepth(PsiClass aClass) {
        int depth = 0;
        PsiClass enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)aClass);
        while (enclosing != null) {
            ++depth;
            enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)enclosing);
        }
        return depth;
    }

    private static PsiClass getEnclosingClass(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement previous = null;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (PsiClass.class.isInstance(element) && !(previous instanceof PsiExpressionList)) {
                return (PsiClass)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            previous = element;
        }
        return null;
    }

    @Nullable
    private ReferenceType findNested(final ReferenceType fromClass, int currentDepth, final PsiClass classToFind, int requiredDepth, final SourcePosition position) {
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            try {
                if (currentDepth < requiredDepth) {
                    List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
                    for (ReferenceType nested : nestedTypes) {
                        ReferenceType found = this.findNested(nested, currentDepth + 1, classToFind, requiredDepth, position);
                        if (found == null) continue;
                        return found;
                    }
                    return null;
                }
                boolean canGetSynthetic = vmProxy.canGetSyntheticAttribute();
                int rangeBegin = Integer.MAX_VALUE;
                int rangeEnd = Integer.MIN_VALUE;
                for (Location location : fromClass.allLineLocations()) {
                    Method method;
                    int lnumber = location.lineNumber();
                    if (lnumber <= 1 || (method = location.method()) == null || canGetSynthetic && method.isSynthetic() || method.isBridge()) continue;
                    int locationLine = lnumber - 1;
                    rangeBegin = Math.min(rangeBegin, locationLine);
                    rangeEnd = Math.max(rangeEnd, locationLine);
                }
                final int positionLine = position.getLine();
                if (positionLine >= rangeBegin && positionLine <= rangeEnd) {
                    final int finalRangeBegin = rangeBegin;
                    final int finalRangeEnd = rangeEnd;
                    return (ReferenceType)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<ReferenceType>(){

                        public ReferenceType compute() {
                            if (!classToFind.isValid()) {
                                return null;
                            }
                            int line = Math.min(finalRangeBegin + 1, finalRangeEnd);
                            SourcePosition candidatePosition = positionLine == line ? position : SourcePosition.createFromLine((PsiFile)position.getFile(), (int)line);
                            return classToFind.equals(JVMNameUtil.getClassAt(candidatePosition)) ? fromClass : null;
                        }
                    });
                }
            }
            catch (AbsentInformationException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        public MethodFinder(String className, String methodSignature) {
            this.myClassName = className;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            List<ReferenceType> allClasses = PositionManagerImpl.this.myDebugProcess.getPositionManager().getAllClasses(SourcePosition.createFromElement((PsiElement)aClass));
            for (ReferenceType referenceType : allClasses) {
                if (!referenceType.name().equals(this.myClassName)) continue;
                this.myCompiledClass = aClass;
            }
            aClass.acceptChildren((PsiElementVisitor)this);
        }

        public void visitMethod(PsiMethod method) {
            try {
                String methodName = method.isConstructor() ? "<init>" : method.getName();
                PsiClass containingClass = method.getContainingClass();
                if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(methodName) && JVMNameUtil.getJVMSignature(method).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                    this.myCompiledMethod = method;
                }
            }
            catch (EvaluateException e) {
                LOG.debug((Throwable)e);
            }
        }

        public PsiClass getCompiledClass() {
            return this.myCompiledClass;
        }

        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }
    }
}

