/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RequestManagerImpl
extends DebugProcessAdapterImpl
implements RequestManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.RequestManagerImpl");
    private static final Key CLASS_NAME = Key.create((String)"ClassName");
    private static final Key<Requestor> REQUESTOR = Key.create((String)"Requestor");
    private final DebugProcessImpl myDebugProcess;
    private final Map<Requestor, String> myRequestWarnings = new HashMap();
    private final Map<Requestor, Set<EventRequest>> myRequestorToBelongedRequests = new HashMap();
    private EventRequestManager myEventRequestManager;
    @Nullable
    private ThreadReference myFilterThread;

    public RequestManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
        this.myDebugProcess.addDebugProcessListener(this);
    }

    public EventRequestManager getVMRequestManager() {
        return this.myEventRequestManager;
    }

    @Nullable
    public ThreadReference getFilterThread() {
        return this.myFilterThread;
    }

    public void setFilterThread(@Nullable ThreadReference filterThread) {
        this.myFilterThread = filterThread;
    }

    public Set<EventRequest> findRequests(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set<EventRequest> requestSet = this.myRequestorToBelongedRequests.get(requestor);
        if (requestSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(requestSet);
    }

    @Nullable
    public Requestor findRequestor(EventRequest request) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return request != null ? (Requestor)request.getProperty(REQUESTOR) : null;
    }

    private static void addClassFilter(EventRequest request, String pattern) {
        if (request instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)request).addClassFilter(pattern);
        } else if (request instanceof ExceptionRequest) {
            ((ExceptionRequest)request).addClassFilter(pattern);
        } else if (request instanceof MethodEntryRequest) {
            ((MethodEntryRequest)request).addClassFilter(pattern);
        } else if (request instanceof MethodExitRequest) {
            ((MethodExitRequest)request).addClassFilter(pattern);
        } else if (request instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)request).addClassFilter(pattern);
        } else if (request instanceof WatchpointRequest) {
            ((WatchpointRequest)request).addClassFilter(pattern);
        }
    }

    private static void addClassExclusionFilter(EventRequest request, String pattern) {
        if (request instanceof AccessWatchpointRequest) {
            ((AccessWatchpointRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof ExceptionRequest) {
            ((ExceptionRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof MethodEntryRequest) {
            ((MethodEntryRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof MethodExitRequest) {
            ((MethodExitRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof ModificationWatchpointRequest) {
            ((ModificationWatchpointRequest)request).addClassExclusionFilter(pattern);
        } else if (request instanceof WatchpointRequest) {
            ((WatchpointRequest)request).addClassExclusionFilter(pattern);
        }
    }

    private void addLocatableRequest(FilteredRequestor requestor, EventRequest request) {
        if ("SuspendAll".equals(requestor.getSuspendPolicy())) {
            request.setSuspendPolicy(2);
        } else {
            request.setSuspendPolicy(1);
        }
        if (requestor.isCountFilterEnabled() && requestor.getCountFilter() > 0) {
            request.addCountFilter(requestor.getCountFilter());
        }
        if (requestor.isClassFiltersEnabled() && !(request instanceof BreakpointRequest)) {
            ClassFilter[] classFilters = requestor.getClassFilters();
            if (DebuggerUtilsEx.getEnabledNumber(classFilters) == 1) {
                for (final ClassFilter filter : classFilters) {
                    if (!filter.isEnabled()) continue;
                    JVMName jvmClassName = (JVMName)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JVMName>(){

                        public JVMName compute() {
                            PsiClass psiClass = DebuggerUtils.findClass((String)filter.getPattern(), (Project)RequestManagerImpl.this.myDebugProcess.getProject(), (GlobalSearchScope)RequestManagerImpl.this.myDebugProcess.getSearchScope());
                            if (psiClass == null) {
                                return null;
                            }
                            return JVMNameUtil.getJVMQualifiedName(psiClass);
                        }
                    });
                    String pattern = filter.getPattern();
                    try {
                        if (jvmClassName != null) {
                            pattern = jvmClassName.getName(this.myDebugProcess);
                        }
                    }
                    catch (EvaluateException ignored) {
                        // empty catch block
                    }
                    RequestManagerImpl.addClassFilter(request, pattern);
                    break;
                }
            }
            for (final ClassFilter filter : requestor.getClassExclusionFilters()) {
                if (!filter.isEnabled()) continue;
                RequestManagerImpl.addClassExclusionFilter(request, filter.getPattern());
            }
        }
        this.registerRequestInternal(requestor, request);
    }

    public void registerRequestInternal(Requestor requestor, EventRequest request) {
        this.registerRequest(requestor, request);
        request.putProperty(REQUESTOR, requestor);
    }

    private void registerRequest(Requestor requestor, EventRequest request) {
        Set<EventRequest> reqSet = this.myRequestorToBelongedRequests.get(requestor);
        if (reqSet == null) {
            reqSet = new HashSet<EventRequest>();
            this.myRequestorToBelongedRequests.put(requestor, reqSet);
        }
        reqSet.add(request);
    }

    public ClassPrepareRequest createClassPrepareRequest(ClassPrepareRequestor requestor, String pattern) {
        ClassPrepareRequest classPrepareRequest = this.myEventRequestManager.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(1);
        classPrepareRequest.addClassFilter(pattern);
        classPrepareRequest.putProperty(CLASS_NAME, pattern);
        this.registerRequestInternal((Requestor)requestor, classPrepareRequest);
        return classPrepareRequest;
    }

    public ExceptionRequest createExceptionRequest(FilteredRequestor requestor, ReferenceType referenceType, boolean notifyCaught, boolean notifyUnCaught) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ExceptionRequest req = this.myEventRequestManager.createExceptionRequest(referenceType, notifyCaught, notifyUnCaught);
        this.addLocatableRequest(requestor, req);
        return req;
    }

    public MethodEntryRequest createMethodEntryRequest(FilteredRequestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodEntryRequest req = this.myEventRequestManager.createMethodEntryRequest();
        this.addLocatableRequest(requestor, req);
        return req;
    }

    public MethodExitRequest createMethodExitRequest(FilteredRequestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodExitRequest req = this.myEventRequestManager.createMethodExitRequest();
        this.addLocatableRequest(requestor, req);
        return req;
    }

    public BreakpointRequest createBreakpointRequest(FilteredRequestor requestor, Location location) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        BreakpointRequest req = this.myEventRequestManager.createBreakpointRequest(location);
        this.addLocatableRequest(requestor, req);
        this.myRequestWarnings.remove(requestor);
        return req;
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(FilteredRequestor requestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        AccessWatchpointRequest req = this.myEventRequestManager.createAccessWatchpointRequest(field);
        this.addLocatableRequest(requestor, req);
        return req;
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(FilteredRequestor requestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ModificationWatchpointRequest req = this.myEventRequestManager.createModificationWatchpointRequest(field);
        this.addLocatableRequest(requestor, req);
        return req;
    }

    public void deleteRequest(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.myDebugProcess.isAttached()) {
            return;
        }
        Set<EventRequest> requests = this.myRequestorToBelongedRequests.remove(requestor);
        if (requests == null) {
            return;
        }
        for (EventRequest request : requests) {
            try {
                Set<EventRequest> allTargetRequestorRequests;
                Requestor targetRequestor = (Requestor)request.getProperty(REQUESTOR);
                if (targetRequestor != requestor && (allTargetRequestorRequests = this.myRequestorToBelongedRequests.get(targetRequestor)) != null) {
                    allTargetRequestorRequests.remove(request);
                    if (allTargetRequestorRequests.size() == 0) {
                        this.myRequestorToBelongedRequests.remove(targetRequestor);
                    }
                }
                this.myEventRequestManager.deleteEventRequest(request);
            }
            catch (InvalidRequestStateException ignored) {
            }
            catch (InternalException e) {
                if (e.errorCode() == 41) continue;
                LOG.info((Throwable)e);
            }
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor, SourcePosition classPosition) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassPrepareRequest prepareRequest = this.myDebugProcess.getPositionManager().createPrepareRequest(requestor, classPosition);
        if (prepareRequest == null) {
            this.setInvalid((Requestor)requestor, DebuggerBundle.message((String)"status.invalid.breakpoint.out.of.class", (Object[])new Object[0]));
            return;
        }
        this.registerRequest((Requestor)requestor, prepareRequest);
        prepareRequest.enable();
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor requestor, String classOrPatternToBeLoaded) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ClassPrepareRequest classPrepareRequest = this.createClassPrepareRequest(requestor, classOrPatternToBeLoaded);
        this.registerRequest((Requestor)requestor, classPrepareRequest);
        classPrepareRequest.enable();
        if (LOG.isDebugEnabled()) {
            LOG.debug("classOrPatternToBeLoaded = " + classOrPatternToBeLoaded);
        }
    }

    public void enableRequest(EventRequest request) {
        block8: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            LOG.assertTrue(this.findRequestor(request) != null);
            try {
                ThreadReference filterThread = this.myFilterThread;
                if (filterThread != null) {
                    if (request instanceof BreakpointRequest) {
                        ((BreakpointRequest)request).addThreadFilter(filterThread);
                    } else if (request instanceof MethodEntryRequest) {
                        ((MethodEntryRequest)request).addThreadFilter(filterThread);
                    } else if (request instanceof MethodExitRequest) {
                        ((MethodExitRequest)request).addThreadFilter(filterThread);
                    }
                }
                request.enable();
            }
            catch (InternalException e) {
                if (e.errorCode() == 41) break block8;
                LOG.error((Throwable)e);
            }
        }
    }

    public void setInvalid(Requestor requestor, String message) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isVerified(requestor)) {
            this.myRequestWarnings.put(requestor, message);
        }
    }

    @Nullable
    public String getWarning(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.myRequestWarnings.get(requestor);
    }

    public boolean isVerified(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        for (EventRequest request : this.findRequests(requestor)) {
            if (request instanceof ClassPrepareRequest) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processDetached(DebugProcessImpl process, boolean closedByUser) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myEventRequestManager = null;
        this.myRequestWarnings.clear();
        this.myRequestorToBelongedRequests.clear();
    }

    @Override
    public void processAttached(DebugProcessImpl process) {
        this.myEventRequestManager = this.myDebugProcess.getVirtualMachineProxy().eventRequestManager();
    }

    public void processClassPrepared(ClassPrepareEvent event) {
        if (!this.myDebugProcess.isAttached()) {
            return;
        }
        ReferenceType refType = event.referenceType();
        if (refType instanceof ClassType || refType instanceof InterfaceType) {
            ClassPrepareRequestor requestor;
            if (LOG.isDebugEnabled()) {
                LOG.debug("signature = " + refType.signature());
            }
            if ((requestor = (ClassPrepareRequestor)event.request().getProperty(REQUESTOR)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("requestor found " + refType.signature());
                }
                requestor.processClassPrepare((DebugProcess)this.myDebugProcess, refType);
            }
        }
    }

    private static void invoke(Project project, final AllProcessesCommand command) {
        for (DebuggerSession debuggerSession : DebuggerManagerEx.getInstanceEx(project).getSessions()) {
            final DebugProcessImpl process = debuggerSession.getProcess();
            if (process == null) continue;
            process.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    command.action(process);
                }
            });
        }
    }

    public static void createRequests(final Breakpoint breakpoint) {
        RequestManagerImpl.invoke(breakpoint.getProject(), new AllProcessesCommand(){

            @Override
            public void action(DebugProcessImpl process) {
                breakpoint.createRequest(process);
            }
        });
    }

    public static void updateRequests(final Breakpoint breakpoint) {
        RequestManagerImpl.invoke(breakpoint.getProject(), new AllProcessesCommand(){

            @Override
            public void action(DebugProcessImpl process) {
                process.getRequestsManager().myRequestWarnings.remove(breakpoint);
                process.getRequestsManager().deleteRequest(breakpoint);
                breakpoint.createRequest(process);
            }
        });
    }

    public static void deleteRequests(final Breakpoint breakpoint) {
        RequestManagerImpl.invoke(breakpoint.getProject(), new AllProcessesCommand(){

            @Override
            public void action(DebugProcessImpl process) {
                process.getRequestsManager().myRequestWarnings.remove(breakpoint);
                process.getRequestsManager().deleteRequest(breakpoint);
            }
        });
    }

    public void clearWarnings() {
        this.myRequestWarnings.clear();
    }

    private static interface AllProcessesCommand {
        public void action(DebugProcessImpl var1);
    }
}

