/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TipManager
implements Disposable,
PopupMenuListener {
    private volatile boolean myIsDisposed = false;
    private boolean myPopupShown;
    private MyAwtPreprocessor myHideCanceller;
    private MouseEvent myLastMouseEvent;
    boolean myInsideComponent;
    private JComponent myCurrentTooltip;
    private Popup myTipPopup;
    private final TipFactory myTipFactory;
    private final JComponent myComponent;
    private MouseListener myMouseListener = new MyMouseListener();
    private MouseMotionListener myMouseMotionListener = new MyMouseMotionListener();
    private FrameStateListener myFrameStateListener = new MyFrameStateListener();
    private final Alarm myShowAlarm = new Alarm();
    private final Alarm myHideAlarm = new Alarm();
    private IdeGlassPane myGP;

    private boolean isOverTip(MouseEvent e) {
        if (this.myCurrentTooltip != null) {
            if (!this.myCurrentTooltip.isShowing()) {
                this.hideTooltip(true);
                return false;
            }
            Component eventOriginator = e.getComponent();
            if (eventOriginator == null) {
                return false;
            }
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, eventOriginator);
            Rectangle bounds = this.myCurrentTooltip.getBounds();
            Point tooltipLocationOnScreen = this.myCurrentTooltip.getLocationOnScreen();
            bounds.setLocation(tooltipLocationOnScreen.x, tooltipLocationOnScreen.y);
            return bounds.contains(point);
        }
        return false;
    }

    public JPopupMenu registerPopup(JPopupMenu menu) {
        menu.addPopupMenuListener(this);
        return menu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.myPopupShown = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.onPopupClosed(e);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.onPopupClosed(e);
    }

    private void onPopupClosed(PopupMenuEvent e) {
        this.myPopupShown = false;
        if (e.getSource() instanceof JPopupMenu) {
            ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        }
    }

    private boolean isInsideComponent(MouseEvent e) {
        Rectangle compBounds = this.myComponent.getVisibleRect();
        Point compPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myComponent);
        return compBounds.contains(compPoint);
    }

    private void tryTooltip(final InputEvent e, final boolean auto) {
        this.myShowAlarm.cancelAllRequests();
        this.myHideAlarm.cancelAllRequests();
        this.myShowAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (!TipManager.this.myIsDisposed && !TipManager.this.myPopupShown) {
                    TipManager.this.showTooltip(e, auto);
                }
            }
        }, auto ? XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay() : 10);
    }

    private void showTooltip(InputEvent e, boolean auto) {
        if (auto && !Registry.is((String)"debugger.valueTooltipAutoShow")) {
            return;
        }
        MouseEvent sourceEvent = null;
        JComponent newTip = null;
        if (e instanceof MouseEvent) {
            sourceEvent = (MouseEvent)e;
        } else if (e instanceof KeyEvent) {
            sourceEvent = this.myTipFactory.createTooltipEvent(this.myLastMouseEvent);
        }
        MouseEvent convertedEvent = null;
        if (sourceEvent != null) {
            convertedEvent = SwingUtilities.convertMouseEvent(sourceEvent.getComponent(), sourceEvent, this.myComponent);
            newTip = this.myTipFactory.createToolTip(convertedEvent);
        }
        if (newTip == null || auto && !this.myTipFactory.isFocusOwner()) {
            this.hideTooltip(false);
            return;
        }
        if (newTip == this.myCurrentTooltip) {
            if (!auto) {
                this.hideTooltip(true);
                return;
            }
            return;
        }
        this.hideTooltip(true);
        if (this.myComponent.isShowing()) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point location = convertedEvent.getPoint();
            Component sourceComponent = convertedEvent.getComponent();
            if (sourceComponent != null) {
                SwingUtilities.convertPointToScreen(location, sourceComponent);
            }
            this.myTipPopup = popupFactory.getPopup(this.myComponent, newTip, location.x, location.y);
            this.myInsideComponent = false;
            this.myTipPopup.show();
            this.myCurrentTooltip = newTip;
        }
    }

    public void hideTooltip() {
        this.hideTooltip(true);
    }

    public void hideTooltip(boolean now) {
        if (this.myTipPopup == null) {
            return;
        }
        if (now) {
            this.myHideAlarm.cancelAllRequests();
            this.myTipPopup.hide();
            this.myTipPopup = null;
            this.myCurrentTooltip = null;
        } else {
            this.myHideAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    if (TipManager.this.myInsideComponent) {
                        TipManager.this.hideTooltip(true);
                    }
                }
            }, 100);
        }
    }

    public TipManager(JComponent component, TipFactory factory) {
        this.myTipFactory = factory;
        this.myComponent = component;
        new UiNotifyConnector.Once((Component)component, new Activatable(){

            public void showNotify() {
                TipManager.this.installListeners();
            }

            public void hideNotify() {
            }
        });
        final HideTooltipAction hide = new HideTooltipAction();
        hide.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(27, 0)), this.myComponent);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                hide.unregisterCustomShortcutSet(TipManager.this.myComponent);
            }
        });
    }

    private void installListeners() {
        if (this.myIsDisposed) {
            return;
        }
        this.myGP = IdeGlassPaneUtil.find((Component)this.myComponent);
        assert (this.myGP != null);
        this.myGP.addMousePreprocessor(this.myMouseListener, (Disposable)this);
        this.myGP.addMouseMotionPreprocessor(this.myMouseMotionListener, (Disposable)this);
        this.myHideCanceller = new MyAwtPreprocessor();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myHideCanceller, 56L);
        FrameStateManager.getInstance().addListener(this.myFrameStateListener);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.hideTooltip(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myHideCanceller);
        this.myIsDisposed = true;
        this.myShowAlarm.cancelAllRequests();
        this.myMouseListener = null;
        this.myMouseMotionListener = null;
        FrameStateManager.getInstance().removeListener(this.myFrameStateListener);
        this.myFrameStateListener = null;
    }

    private class MyAwtPreprocessor
    implements AWTEventListener {
        private MyAwtPreprocessor() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 503) {
                this.preventFromHideIfInsideTooltip(event);
            } else if (event.getID() == 501 || event.getID() == 502) {
                this.hideTooltipIfCloseClick((MouseEvent)event);
            } else if (event instanceof KeyEvent) {
                this.tryToShowTooltipIfRequested((KeyEvent)event);
            }
        }

        private void hideTooltipIfCloseClick(MouseEvent me) {
            if (TipManager.this.myCurrentTooltip == null) {
                return;
            }
            if (this.isInsideTooltip(me) && UIUtil.isCloseClick((MouseEvent)me)) {
                TipManager.this.hideTooltip(true);
            }
        }

        private void tryToShowTooltipIfRequested(KeyEvent event) {
            if (KeymapUtil.isTooltipRequest((KeyEvent)event)) {
                TipManager.this.tryTooltip(event, false);
            } else if (event.getID() == 401) {
                TipManager.this.myLastMouseEvent = null;
            }
        }

        private void preventFromHideIfInsideTooltip(AWTEvent event) {
            MouseEvent me;
            if (TipManager.this.myCurrentTooltip == null) {
                return;
            }
            if (event.getID() == 503 && this.isInsideTooltip(me = (MouseEvent)event)) {
                TipManager.this.myHideAlarm.cancelAllRequests();
            }
        }

        private boolean isInsideTooltip(MouseEvent me) {
            return TipManager.this.myCurrentTooltip == me.getComponent() || SwingUtilities.isDescendingFrom(me.getComponent(), TipManager.this.myCurrentTooltip);
        }
    }

    private class HideTooltipAction
    extends AnAction {
        private HideTooltipAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            TipManager.this.hideTooltip(true);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(TipManager.this.myTipPopup != null);
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter
    implements Weighted {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TipManager.this.myLastMouseEvent = e;
            if (!TipManager.this.myComponent.isShowing()) {
                return;
            }
            TipManager.this.myInsideComponent = true;
            if (TipManager.this.myCurrentTooltip == null) {
                if (TipManager.this.isInsideComponent(e)) {
                    TipManager.this.tryTooltip(e, true);
                }
            } else if (!TipManager.this.isOverTip(e)) {
                TipManager.this.tryTooltip(e, true);
            }
        }

        public double getWeight() {
            return 0.0;
        }
    }

    private class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private MyFrameStateListener() {
        }

        public void onFrameDeactivated() {
            TipManager.this.hideTooltip(true);
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements Weighted {
        private MyMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TipManager.this.myInsideComponent = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (TipManager.this.myInsideComponent) {
                TipManager.this.hideTooltip(true);
            }
        }

        public double getWeight() {
            return 0.0;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TipManager.this.myInsideComponent = true;
        }
    }

    public static interface TipFactory {
        public JComponent createToolTip(MouseEvent var1);

        public MouseEvent createTooltipEvent(MouseEvent var1);

        public boolean isFocusOwner();
    }
}

