/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.CommitLoader;
import com.intellij.dvcs.push.OutgoingResult;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSpec;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.RepositoryNodeListener;
import com.intellij.dvcs.push.VcsError;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.SingleRepositoryNode;
import com.intellij.dvcs.push.ui.TextWithLinkNode;
import com.intellij.dvcs.push.ui.VcsLinkListener;
import com.intellij.dvcs.push.ui.VcsLinkedText;
import com.intellij.dvcs.push.ui.VcsPushDialog;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushController
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final List<? extends Repository> myPreselectedRepositories;
    @NotNull
    private final List<PushSupport<?, ?, ?>> myPushSupports;
    @NotNull
    private final PushLog myPushLog;
    @NotNull
    private final VcsPushDialog myDialog;
    private boolean mySingleRepoProject;
    private static final int DEFAULT_CHILDREN_PRESENTATION_NUMBER = 20;
    private final ExecutorService myExecutorService;
    private final Map<RepositoryNode, MyRepoModel> myView2Model;

    public PushController(@NotNull Project project, @NotNull VcsPushDialog dialog, @NotNull List<? extends Repository> preselectedRepositories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        if (preselectedRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedRepositories", "com/intellij/dvcs/push/PushController", "<init>"));
        }
        this.myExecutorService = Executors.newSingleThreadExecutor();
        this.myView2Model = new TreeMap<RepositoryNode, MyRepoModel>();
        this.myProject = project;
        this.myPreselectedRepositories = preselectedRepositories;
        this.myPushSupports = PushController.getAffectedSupports(this.myProject);
        this.mySingleRepoProject = PushController.isSingleRepoProject(this.myPushSupports);
        CheckedTreeNode rootNode = new CheckedTreeNode(null);
        this.createTreeModel(rootNode);
        this.myPushLog = new PushLog(this.myProject, rootNode);
        this.myPushLog.getTree().addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean isEditMode = (Boolean)evt.getNewValue();
                PushController.this.myDialog.enableOkActions(isEditMode == false && PushController.this.isPushAllowed());
            }
        });
        this.myDialog = dialog;
        this.startLoadingCommits();
        Disposer.register((Disposable)dialog.getDisposable(), (Disposable)this);
    }

    private static boolean isSingleRepoProject(@NotNull List<PushSupport<?, ?, ?>> pushSupports) {
        if (pushSupports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupports", "com/intellij/dvcs/push/PushController", "isSingleRepoProject"));
        }
        int repos = 0;
        for (PushSupport<?, ?, ?> support : pushSupports) {
            repos += support.getRepositoryManager().getRepositories().size();
        }
        return repos == 1;
    }

    @NotNull
    private static List<PushSupport<?, ?, ?>> getAffectedSupports(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "getAffectedSupports"));
        }
        List list = ContainerUtil.filter((Object[])Extensions.getExtensions((ExtensionPointName)PushSupport.PUSH_SUPPORT_EP, (AreaInstance)project), (Condition)new Condition<PushSupport>(){

            public boolean value(PushSupport support) {
                return !support.getRepositoryManager().getRepositories().isEmpty();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getAffectedSupports"));
        }
        return list;
    }

    public boolean isForcePushEnabled() {
        return ContainerUtil.exists(this.myView2Model.values(), (Condition)new Condition<MyRepoModel>(){

            public boolean value(MyRepoModel model) {
                return model.getSupport().isForcePushEnabled();
            }
        });
    }

    public boolean isForcePushAllowed() {
        return ContainerUtil.and(this.myView2Model.values(), (Condition)new Condition<MyRepoModel>(){

            public boolean value(MyRepoModel model) {
                return !model.isSelected() || model.getTarget() != null && model.getSupport().isForcePushAllowed(model.getRepository(), model.getTarget());
            }
        });
    }

    private void startLoadingCommits() {
        LinkedHashMap priorityLoading = ContainerUtil.newLinkedHashMap();
        LinkedHashMap others = ContainerUtil.newLinkedHashMap();
        for (Map.Entry<RepositoryNode, MyRepoModel> entry : this.myView2Model.entrySet()) {
            MyRepoModel model = entry.getValue();
            if (this.myPreselectedRepositories.contains(model.getRepository())) {
                priorityLoading.put(entry.getKey(), model);
                continue;
            }
            if (!model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) continue;
            others.put(entry.getKey(), model);
        }
        this.loadCommitsFromMap(priorityLoading);
        this.loadCommitsFromMap(others);
    }

    private void loadCommitsFromMap(@NotNull Map<RepositoryNode, MyRepoModel> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/dvcs/push/PushController", "loadCommitsFromMap"));
        }
        for (Map.Entry<RepositoryNode, MyRepoModel> entry : items.entrySet()) {
            RepositoryNode node = entry.getKey();
            this.loadCommits(entry.getValue(), node, true);
        }
    }

    private void createTreeModel(@NotNull CheckedTreeNode rootNode) {
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createTreeModel"));
        }
        for (PushSupport<?, ?, ?> support : this.myPushSupports) {
            this.createNodesForVcs(support, rootNode);
        }
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createNodesForVcs(@NotNull PushSupport<R, S, T> pushSupport, @NotNull CheckedTreeNode rootNode) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "createNodesForVcs"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createNodesForVcs"));
        }
        for (Repository repository : pushSupport.getRepositoryManager().getRepositories()) {
            this.createRepoNode(pushSupport, repository, rootNode);
        }
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void createRepoNode(@NotNull PushSupport<R, S, T> support, @NotNull R repository, final @NotNull CheckedTreeNode rootNode) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        if (rootNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootNode", "com/intellij/dvcs/push/PushController", "createRepoNode"));
        }
        PushTarget target = support.getDefaultTarget(repository);
        String repoName = this.getDisplayedRepoName(repository);
        PushSource source = support.getSource(repository);
        final MyRepoModel<R, PushSource, PushTarget> model = new MyRepoModel<R, PushSource, PushTarget>(repository, support, this.mySingleRepoProject, source, target, 20);
        if (target == null) {
            model.setError(VcsError.createEmptyTargetError((String)repoName));
        }
        PushTargetPanel pushTargetPanel = support.createTargetPanel(repository, target);
        RepositoryWithBranchPanel repoPanel = new RepositoryWithBranchPanel(this.myProject, repoName, source.getPresentation(), pushTargetPanel);
        final RepositoryNode repoNode = this.mySingleRepoProject ? new SingleRepositoryNode(repoPanel) : new RepositoryNode(repoPanel, target != null);
        this.myView2Model.put(repoNode, model);
        repoPanel.addRepoNodeListener(new RepositoryNodeListener<T>(){

            @Override
            public void onTargetChanged(T newTarget) {
                model.setSelected(true);
                repoNode.setChecked(true);
                model.setTarget(newTarget);
                model.clearErrors();
                PushController.this.loadCommits(model, repoNode, false);
            }

            @Override
            public void onSelectionChanged(boolean isSelected) {
                model.setSelected(isSelected);
                rootNode.setChecked(isSelected);
                PushController.this.myDialog.enableOkActions(PushController.this.isPushAllowed());
                if (isSelected && !model.hasCommitInfo() && !model.getSupport().shouldRequestIncomingChangesForNotCheckedRepositories()) {
                    PushController.this.loadCommits(model, repoNode, false);
                }
            }
        });
        rootNode.add((MutableTreeNode)((Object)repoNode));
    }

    @NotNull
    private String getDisplayedRepoName(@NotNull Repository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        String name = DvcsUtil.getShortRepositoryName(repository);
        int slash = name.lastIndexOf(File.separatorChar);
        if (slash < 0) {
            String string = name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
            }
            return string;
        }
        String candidate = name.substring(slash + 1);
        if (!this.getOtherReposLastNames(repository).contains(candidate)) {
            String string = candidate;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getDisplayedRepoName"));
        }
        return string;
    }

    @NotNull
    private Set<String> getOtherReposLastNames(@NotNull Repository except) {
        if (except == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "except", "com/intellij/dvcs/push/PushController", "getOtherReposLastNames"));
        }
        HashSet repos = ContainerUtil.newHashSet();
        for (PushSupport<?, ?, ?> support : this.myPushSupports) {
            for (Repository repo : support.getRepositoryManager().getRepositories()) {
                if (repo.equals(except)) continue;
                repos.add(repo.getRoot().getName());
            }
        }
        HashSet hashSet = repos;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getOtherReposLastNames"));
        }
        return hashSet;
    }

    public boolean isPushAllowed() {
        JTree tree = this.myPushLog.getTree();
        return !tree.isEditing() && ContainerUtil.exists(this.myPushSupports, (Condition)new Condition<PushSupport<?, ?, ?>>(){

            public boolean value(PushSupport<?, ?, ?> support) {
                return PushController.this.isPushAllowed(support);
            }
        });
    }

    private boolean isPushAllowed(@NotNull PushSupport<?, ?, ?> pushSupport) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "isPushAllowed"));
        }
        Collection<RepositoryNode> nodes = this.getNodesForSupport(pushSupport);
        if (pushSupport.getRepositoryManager().isSyncEnabled()) {
            return PushController.hasCheckedNode(nodes) && PushController.allNodesAreLoaded(nodes);
        }
        return PushController.hasCheckedNode(nodes);
    }

    private static boolean allNodesAreLoaded(@NotNull Collection<RepositoryNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "allNodesAreLoaded"));
        }
        return !ContainerUtil.exists(nodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(@NotNull RepositoryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController$7", "value"));
                }
                return node.isLoading();
            }
        });
    }

    private static boolean hasCheckedNode(@NotNull Collection<RepositoryNode> nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dvcs/push/PushController", "hasCheckedNode"));
        }
        return ContainerUtil.exists(nodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(@NotNull RepositoryNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController$8", "value"));
                }
                return node.isChecked();
            }
        });
    }

    @NotNull
    private Collection<RepositoryNode> getNodesForSupport(final PushSupport<?, ?, ?> support) {
        List list = ContainerUtil.mapNotNull(this.myView2Model.entrySet(), (Function)new Function<Map.Entry<RepositoryNode, MyRepoModel>, RepositoryNode>(){

            public RepositoryNode fun(Map.Entry<RepositoryNode, MyRepoModel> entry) {
                return entry.getValue().getSupport().equals(support) ? entry.getKey() : null;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getNodesForSupport"));
        }
        return list;
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void loadCommits(final @NotNull MyRepoModel<R, S, T> model, @NotNull RepositoryNode node, boolean initial) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/PushController", "loadCommits"));
        }
        node.cancelLoading();
        T target = model.getTarget();
        if (target == null) {
            node.stopLoading();
            return;
        }
        node.setEnabled(true);
        PushSupport<R, S, T> support = model.getSupport();
        AtomicReference result = new AtomicReference();
        Runnable task = new Runnable((PushSupport)support, initial, result, node, (PushTarget)target){
            final /* synthetic */ PushSupport val$support;
            final /* synthetic */ boolean val$initial;
            final /* synthetic */ AtomicReference val$result;
            final /* synthetic */ RepositoryNode val$node;
            final /* synthetic */ PushTarget val$target;
            {
                this.val$support = pushSupport;
                this.val$initial = bl;
                this.val$result = atomicReference;
                this.val$node = repositoryNode;
                this.val$target = pushTarget;
            }

            @Override
            public void run() {
                Object repository = model.getRepository();
                OutgoingResult outgoing = this.val$support.getOutgoingCommitsProvider().getOutgoingCommits(repository, new PushSpec(model.getSource(), model.getTarget()), this.val$initial);
                this.val$result.compareAndSet(null, outgoing);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((Repository)repository){
                    final /* synthetic */ Repository val$repository;
                    {
                        this.val$repository = repository;
                    }

                    @Override
                    public void run() {
                        boolean shouldBeSelected;
                        OutgoingResult outgoing = (OutgoingResult)val$result.get();
                        List errors = outgoing.getErrors();
                        if (!errors.isEmpty()) {
                            shouldBeSelected = false;
                            PushController.this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)val$node), ContainerUtil.map((Collection)errors, (Function)new Function<VcsError, DefaultMutableTreeNode>(){

                                public DefaultMutableTreeNode fun(final VcsError error) {
                                    VcsLinkedText errorLinkText = new VcsLinkedText(error.getText(), new VcsLinkListener(){

                                        @Override
                                        public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode) {
                                            if (sourceNode == null) {
                                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$10$1$1$1", "hyperlinkActivated"));
                                            }
                                            error.handleError(new CommitLoader(){

                                                public void reloadCommits() {
                                                    PushController.this.loadCommits(model, val$node, false);
                                                }
                                            });
                                        }
                                    });
                                    return new TextWithLinkNode(errorLinkText);
                                }
                            }));
                        } else {
                            List commits = outgoing.getCommits();
                            shouldBeSelected = PushController.this.shouldSelectInitially(val$target, this.val$repository, model.getSupport().getRepositoryManager(), !commits.isEmpty());
                            model.setLoadedCommits(commits);
                            PushController.this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)val$node), PushController.this.getPresentationForCommits(PushController.this.myProject, model.getLoadedCommits(), model.getNumberOfShownCommits()));
                            if (!commits.isEmpty()) {
                                PushController.this.myPushLog.selectIfNothingSelected((TreeNode)((Object)val$node));
                            }
                        }
                        val$node.stopLoading();
                        if (shouldBeSelected) {
                            val$node.setChecked(true);
                            model.setSelected(true);
                        }
                        PushController.this.myDialog.enableOkActions(PushController.this.isPushAllowed());
                    }
                });
            }
        };
        node.startLoading(this.myPushLog.getTree(), this.myExecutorService.submit(task, result));
    }

    private boolean shouldSelectInitially(@NotNull PushTarget target, @NotNull Repository repository, @NotNull RepositoryManager repositoryManager, boolean hasCommits) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/dvcs/push/PushController", "shouldSelectInitially"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController", "shouldSelectInitially"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "com/intellij/dvcs/push/PushController", "shouldSelectInitially"));
        }
        boolean shouldBeSelected = this.mySingleRepoProject ? true : (repositoryManager.isSyncEnabled() ? hasCommits || target.hasSomethingToPush() : (hasCommits || target.hasSomethingToPush()) && this.myPreselectedRepositories.contains(repository));
        return shouldBeSelected;
    }

    public PushLog getPushPanelLog() {
        return this.myPushLog;
    }

    public void push(final boolean force) {
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, "Pushing...", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/PushController$11", "run"));
                }
                for (PushSupport support : PushController.this.myPushSupports) {
                    PushController.this.doPush(support, force);
                }
            }
        };
        task.queue();
    }

    private <R extends Repository, S extends PushSource, T extends PushTarget> void doPush(@NotNull PushSupport<R, S, T> support, boolean force) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/dvcs/push/PushController", "doPush"));
        }
        VcsPushOptionValue options = this.myDialog.getAdditionalOptionValue(support);
        Pusher pusher = support.getPusher();
        pusher.push(this.collectPushSpecsForVcs(support), options, force);
    }

    @NotNull
    private <R extends Repository, S extends PushSource, T extends PushTarget> Map<R, PushSpec<S, T>> collectPushSpecsForVcs(@NotNull PushSupport<R, S, T> pushSupport) {
        if (pushSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pushSupport", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        HashMap pushSpecs = ContainerUtil.newHashMap();
        Collection<MyRepoModel> repositoriesInformation = this.getSelectedRepoNode();
        for (MyRepoModel repoModel : repositoriesInformation) {
            Object target;
            if (!pushSupport.equals(repoModel.getSupport()) || (target = repoModel.getTarget()) == null) continue;
            pushSpecs.put(repoModel.getRepository(), new PushSpec(repoModel.getSource(), target));
        }
        HashMap hashMap = pushSpecs;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "collectPushSpecsForVcs"));
        }
        return hashMap;
    }

    public Collection<MyRepoModel> getSelectedRepoNode() {
        if (this.mySingleRepoProject) {
            return this.myView2Model.values();
        }
        return ContainerUtil.filter(this.myView2Model.values(), (Condition)new Condition<MyRepoModel>(){

            public boolean value(MyRepoModel model) {
                return model.isSelected();
            }
        });
    }

    public void dispose() {
        this.myExecutorService.shutdownNow();
    }

    private void addMoreCommits(RepositoryNode repositoryNode) {
        MyRepoModel repoModel = this.myView2Model.get(repositoryNode);
        repoModel.increaseShownCommits();
        this.myPushLog.setChildren((DefaultMutableTreeNode)((Object)repositoryNode), this.getPresentationForCommits(this.myProject, repoModel.getLoadedCommits(), repoModel.getNumberOfShownCommits()));
    }

    @NotNull
    public List<DefaultMutableTreeNode> getPresentationForCommits(final @NotNull Project project, @NotNull List<? extends VcsFullCommitDetails> commits, int commitsNum) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        Function<VcsFullCommitDetails, DefaultMutableTreeNode> commitToNode = new Function<VcsFullCommitDetails, DefaultMutableTreeNode>(){

            public DefaultMutableTreeNode fun(VcsFullCommitDetails commit) {
                return new CommitNode(project, commit);
            }
        };
        ArrayList<DefaultMutableTreeNode> childrenToShown = new ArrayList<DefaultMutableTreeNode>();
        for (int i = 0; i < commits.size(); ++i) {
            if (i >= commitsNum) {
                VcsLinkedText moreCommitsLink = new VcsLinkedText("<a href='loadMore'>...</a>", new VcsLinkListener(){

                    @Override
                    public void hyperlinkActivated(@NotNull DefaultMutableTreeNode sourceNode) {
                        if (sourceNode == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceNode", "com/intellij/dvcs/push/PushController$14", "hyperlinkActivated"));
                        }
                        PushController.this.addMoreCommits((RepositoryNode)((Object)sourceNode));
                    }
                });
                childrenToShown.add(new TextWithLinkNode(moreCommitsLink));
                break;
            }
            childrenToShown.add((DefaultMutableTreeNode)commitToNode.fun((Object)commits.get(i)));
        }
        ArrayList<DefaultMutableTreeNode> arrayList = childrenToShown;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "getPresentationForCommits"));
        }
        return arrayList;
    }

    @NotNull
    public Map<PushSupport, VcsPushOptionsPanel> createAdditionalPanels() {
        LinkedHashMap result = ContainerUtil.newLinkedHashMap();
        for (PushSupport<?, ?, ?> support : this.myPushSupports) {
            ContainerUtil.putIfNotNull(support, (Object)support.createOptionsPanel(), (Map)result);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController", "createAdditionalPanels"));
        }
        return linkedHashMap;
    }

    private static class MyRepoModel<Repo extends Repository, S extends PushSource, T extends PushTarget> {
        @NotNull
        final Repo myRepository;
        @NotNull
        private PushSupport<Repo, S, T> mySupport;
        @NotNull
        private final S mySource;
        @Nullable
        private T myTarget;
        @Nullable
        VcsError myTargetError;
        int myNumberOfShownCommits;
        @NotNull
        List<? extends VcsFullCommitDetails> myLoadedCommits;
        boolean myIsSelected;

        public MyRepoModel(@NotNull Repo repository, @NotNull PushSupport<Repo, S, T> supportForRepo, boolean isSelected, @NotNull S source, @Nullable T target, int num) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (supportForRepo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supportForRepo", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/dvcs/push/PushController$MyRepoModel", "<init>"));
            }
            this.myLoadedCommits = Collections.emptyList();
            this.myRepository = repository;
            this.mySupport = supportForRepo;
            this.myIsSelected = isSelected;
            this.mySource = source;
            this.myTarget = target;
            this.myNumberOfShownCommits = num;
        }

        @NotNull
        public Repo getRepository() {
            Repo Repo = this.myRepository;
            if (Repo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getRepository"));
            }
            return Repo;
        }

        @NotNull
        public PushSupport<Repo, S, T> getSupport() {
            PushSupport<Repo, S, T> pushSupport = this.mySupport;
            if (pushSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSupport"));
            }
            return pushSupport;
        }

        @NotNull
        public S getSource() {
            S s = this.mySource;
            if (s == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getSource"));
            }
            return s;
        }

        @Nullable
        public T getTarget() {
            return this.myTarget;
        }

        public void setTarget(@Nullable T target) {
            this.myTarget = target;
        }

        public boolean isSelected() {
            return this.myIsSelected;
        }

        public AbstractVcs<?> getVcs() {
            return this.myRepository.getVcs();
        }

        @Nullable
        public VcsError getError() {
            return this.myTargetError;
        }

        public void setError(@Nullable VcsError error) {
            this.myTargetError = error;
        }

        public void clearErrors() {
            this.myTargetError = null;
        }

        public boolean hasError() {
            return this.myTargetError != null;
        }

        public void setSelected(boolean isSelected) {
            this.myIsSelected = isSelected;
        }

        public int getNumberOfShownCommits() {
            return this.myNumberOfShownCommits;
        }

        public void increaseShownCommits() {
            this.myNumberOfShownCommits *= 2;
        }

        @NotNull
        public List<? extends VcsFullCommitDetails> getLoadedCommits() {
            List<? extends VcsFullCommitDetails> list = this.myLoadedCommits;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/PushController$MyRepoModel", "getLoadedCommits"));
            }
            return list;
        }

        public void setLoadedCommits(@NotNull List<? extends VcsFullCommitDetails> loadedCommits) {
            if (loadedCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loadedCommits", "com/intellij/dvcs/push/PushController$MyRepoModel", "setLoadedCommits"));
            }
            this.myLoadedCommits = loadedCommits;
        }

        public boolean hasCommitInfo() {
            return this.myTargetError != null || !this.myLoadedCommits.isEmpty();
        }
    }
}

