/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestTreeViewAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public class ViewAssertEqualsDiffAction
extends AnAction
implements TestTreeViewAction {
    @NonNls
    public static final String ACTION_ID = "openAssertEqualsDiff";

    public void actionPerformed(AnActionEvent e) {
        AbstractTestProxy.AssertEqualsDiffViewerProvider diffViewerProvider;
        AbstractTestProxy testProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(e.getDataContext());
        if (testProxy != null && (diffViewerProvider = testProxy.getDiffViewerProvider()) != null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
            if (diffViewerProvider instanceof AbstractTestProxy.AssertEqualsMultiDiffViewProvider) {
                TestFrameworkRunningModel runningModel = (TestFrameworkRunningModel)TestTreeView.MODEL_DATA_KEY.getData(e.getDataContext());
                List<AbstractTestProxy.AssertEqualsMultiDiffViewProvider> providers = ViewAssertEqualsDiffAction.collectAvailableProviders(runningModel);
                MyAssertEqualsDiffChain diffChain = providers.size() > 1 ? new MyAssertEqualsDiffChain(providers, (AbstractTestProxy.AssertEqualsMultiDiffViewProvider)diffViewerProvider) : null;
                ((AbstractTestProxy.AssertEqualsMultiDiffViewProvider)diffViewerProvider).openMultiDiff(project, diffChain);
            } else {
                diffViewerProvider.openDiff(project);
            }
        }
    }

    private static List<AbstractTestProxy.AssertEqualsMultiDiffViewProvider> collectAvailableProviders(TestFrameworkRunningModel model) {
        ArrayList<AbstractTestProxy.AssertEqualsMultiDiffViewProvider> providers = new ArrayList<AbstractTestProxy.AssertEqualsMultiDiffViewProvider>();
        if (model != null) {
            AbstractTestProxy root = model.getRoot();
            List<? extends AbstractTestProxy> allTests = root.getAllTests();
            for (AbstractTestProxy abstractTestProxy : allTests) {
                AbstractTestProxy.AssertEqualsDiffViewerProvider provider = abstractTestProxy.getDiffViewerProvider();
                if (!(provider instanceof AbstractTestProxy.AssertEqualsMultiDiffViewProvider)) continue;
                providers.add((AbstractTestProxy.AssertEqualsMultiDiffViewProvider)provider);
            }
        }
        return providers;
    }

    public void update(AnActionEvent e) {
        AbstractTestProxy test;
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        boolean enabled = CommonDataKeys.PROJECT.getData(dataContext) == null ? false : ((test = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null ? test.getDiffViewerProvider() != null : false);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static class MyAssertEqualsDiffChain
    implements AbstractTestProxy.AssertEqualsDiffChain {
        private final List<AbstractTestProxy.AssertEqualsMultiDiffViewProvider> myProviders;
        private AbstractTestProxy.AssertEqualsMultiDiffViewProvider myProvider;

        public MyAssertEqualsDiffChain(List<AbstractTestProxy.AssertEqualsMultiDiffViewProvider> providers, AbstractTestProxy.AssertEqualsMultiDiffViewProvider provider) {
            this.myProviders = providers;
            this.myProvider = provider;
        }

        @Override
        public AbstractTestProxy.AssertEqualsMultiDiffViewProvider getPrevious() {
            int prevIdx = (this.myProviders.size() + this.myProviders.indexOf(this.myProvider) - 1) % this.myProviders.size();
            return this.myProviders.get(prevIdx);
        }

        @Override
        public AbstractTestProxy.AssertEqualsMultiDiffViewProvider getCurrent() {
            return this.myProvider;
        }

        @Override
        public AbstractTestProxy.AssertEqualsMultiDiffViewProvider getNext() {
            int nextIdx = (this.myProviders.indexOf(this.myProvider) + 1) % this.myProviders.size();
            return this.myProviders.get(nextIdx);
        }

        @Override
        public void setCurrent(AbstractTestProxy.AssertEqualsMultiDiffViewProvider provider) {
            this.myProvider = provider;
        }
    }
}

