/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsManagerMain;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginManagerConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NonNls
    private static final String POSTPONE = "&Postpone";
    public static final String ID = "preferences.pluginManager";
    public static final String DISPLAY_NAME = IdeBundle.message((String)"title.plugins", (Object[])new Object[0]);
    public boolean EXPANDED = false;
    public String FIND = "";
    public boolean TREE_VIEW = false;
    private PluginManagerMain myPluginManagerMain;
    protected final PluginManagerUISettings myUISettings;
    protected boolean myAvailable;

    public PluginManagerConfigurable(PluginManagerUISettings UISettings2) {
        this.myUISettings = UISettings2;
    }

    public PluginManagerConfigurable(PluginManagerUISettings UISettings2, boolean available) {
        this.myUISettings = UISettings2;
        this.myAvailable = available;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPluginManagerMain.getPluginTable();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public void reset() {
        this.myPluginManagerMain.reset();
        this.myPluginManagerMain.pluginsModel.sort();
        this.getSplitterProportions().restoreSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
    }

    public String getHelpTopic() {
        return ID;
    }

    public void disposeUIResources() {
        if (this.myPluginManagerMain != null) {
            this.getSplitterProportions().saveSplitterProportions((Component)this.myPluginManagerMain.getMainPanel());
            if (this.myAvailable) {
                List<RowSorter.SortKey> sortKeys;
                RowSorter rowSorter = this.myPluginManagerMain.pluginTable.getRowSorter();
                if (rowSorter != null && (sortKeys = rowSorter.getSortKeys()).size() > 0) {
                    RowSorter.SortKey sortKey = sortKeys.get(0);
                    this.myUISettings.AVAILABLE_SORT_MODE = sortKey.getColumn();
                    this.myUISettings.AVAILABLE_SORT_COLUMN_ORDER = sortKey.getSortOrder().ordinal();
                }
                this.myUISettings.AVAILABLE_SORT_BY_STATUS = this.myPluginManagerMain.pluginsModel.isSortByStatus();
            } else {
                this.myUISettings.INSTALLED_SORT_BY_STATUS = this.myPluginManagerMain.pluginsModel.isSortByStatus();
            }
            Disposer.dispose((Disposable)this.myPluginManagerMain);
            this.myPluginManagerMain = null;
        }
    }

    private SplitterProportionsData getSplitterProportions() {
        return this.myAvailable ? this.myUISettings.getAvailableSplitterProportionsData() : this.myUISettings.getSplitterProportionsData();
    }

    public JComponent createComponent() {
        return this.getOrCreatePanel().getMainPanel();
    }

    protected PluginManagerMain createPanel() {
        return new InstalledPluginsManagerMain(this.myUISettings);
    }

    public void apply() throws ConfigurationException {
        String applyMessage = this.myPluginManagerMain.apply();
        if (applyMessage != null) {
            throw new ConfigurationException(applyMessage);
        }
        if (this.myPluginManagerMain.isRequireShutdown()) {
            int response;
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            int n = response = app.isRestartCapable() ? PluginManagerConfigurable.showRestartIDEADialog() : PluginManagerConfigurable.showShutDownIDEADialog();
            if (response == 0) {
                app.restart(true);
            } else {
                this.myPluginManagerMain.ignoreChanges();
            }
        }
    }

    public PluginManagerMain getOrCreatePanel() {
        if (this.myPluginManagerMain == null) {
            this.myPluginManagerMain = this.createPanel();
        }
        return this.myPluginManagerMain;
    }

    @Messages.YesNoResult
    public static int showShutDownIDEADialog() {
        return PluginManagerConfigurable.showShutDownIDEADialog(IdeBundle.message((String)"title.plugins.changed", (Object[])new Object[0]));
    }

    @Messages.YesNoResult
    private static int showShutDownIDEADialog(String title) {
        String message = IdeBundle.message((String)"message.idea.shutdown.required", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        return Messages.showYesNoDialog((String)message, (String)title, (String)"Shut Down", (String)POSTPONE, (Icon)Messages.getQuestionIcon());
    }

    @Messages.YesNoResult
    public static int showRestartIDEADialog() {
        return PluginManagerConfigurable.showRestartIDEADialog(IdeBundle.message((String)"title.plugins.changed", (Object[])new Object[0]));
    }

    @Messages.YesNoResult
    private static int showRestartIDEADialog(String title) {
        String message = IdeBundle.message((String)"message.idea.restart.required", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()});
        return Messages.showYesNoDialog((String)message, (String)title, (String)"Restart", (String)POSTPONE, (Icon)Messages.getQuestionIcon());
    }

    public static void shutdownOrRestartApp(String title) {
        int response;
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        int n = response = app.isRestartCapable() ? PluginManagerConfigurable.showRestartIDEADialog(title) : PluginManagerConfigurable.showShutDownIDEADialog(title);
        if (response == 0) {
            app.restart(true);
        }
    }

    public boolean isModified() {
        return this.myPluginManagerMain != null && this.myPluginManagerMain.isModified();
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginManagerConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(final String option) {
        return new Runnable(){

            @Override
            public void run() {
                if (PluginManagerConfigurable.this.myPluginManagerMain == null) {
                    return;
                }
                PluginManagerConfigurable.this.myPluginManagerMain.filter(option);
            }
        };
    }

    public void select(IdeaPluginDescriptor ... descriptors) {
        this.myPluginManagerMain.select(descriptors);
    }
}

