/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.ide.scratch.ScratchWidget;
import com.intellij.ide.scratch.ScratchpadFileSystem;
import com.intellij.ide.scratch.ScratchpadManager;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import org.jetbrains.annotations.NotNull;

public class ScratchpadManagerImpl
extends ScratchpadManager
implements Disposable {
    private final Project myProject;
    private Integer myIndex;
    private Language myLatestLanguage;

    public ScratchpadManagerImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchpadManagerImpl", "<init>"));
        }
        this.myIndex = 0;
        this.myProject = project;
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar == null) {
            return;
        }
        if (statusBar.getWidget("Scratch") != null) {
            return;
        }
        ScratchWidget widget = new ScratchWidget(this.myProject);
        statusBar.addWidget((StatusBarWidget)widget, "before Encoding", (Disposable)this.myProject);
        statusBar.updateWidget("Scratch");
        project.getMessageBus().connect((Disposable)project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)widget);
    }

    @Override
    @NotNull
    public VirtualFile createScratchFile(final @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/ide/scratch/ScratchpadManagerImpl", "createScratchFile"));
        }
        this.myLatestLanguage = language;
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                String name = ScratchpadManagerImpl.this.generateFileName();
                return ScratchpadFileSystem.getScratchFileSystem().addFile(name, language, ScratchpadManagerImpl.calculatePrefix(ScratchpadManagerImpl.this.myProject));
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "createScratchFile"));
        }
        return virtualFile;
    }

    @NotNull
    private static String calculatePrefix(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/scratch/ScratchpadManagerImpl", "calculatePrefix"));
        }
        String string = project.getLocationHash();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "calculatePrefix"));
        }
        return string;
    }

    @Override
    public Language getLatestLanguage() {
        return this.myLatestLanguage;
    }

    @NotNull
    private String generateFileName() {
        Integer n = this.myIndex;
        Integer n2 = this.myIndex = Integer.valueOf(this.myIndex + 1);
        int updated = n;
        String index = updated == 0 ? "" : "." + updated;
        String string = "scratch" + index;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/ScratchpadManagerImpl", "generateFileName"));
        }
        return string;
    }

    public void dispose() {
        ScratchpadFileSystem.getScratchFileSystem().removeByPrefix(ScratchpadManagerImpl.calculatePrefix(this.myProject));
    }
}

