/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSettingsStep
extends ModuleWizardStep {
    protected final JdkComboBox myJdkComboBox;
    protected final WizardContext myWizardContext;
    protected final ProjectSdksModel myModel;
    private final ModuleBuilder myModuleBuilder;
    private final JPanel myJdkPanel;

    public SdkSettingsStep(SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> sdkFilter) {
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/ide/util/projectWizard/SdkSettingsStep", "<init>"));
        }
        if (sdkFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkFilter", "com/intellij/ide/util/projectWizard/SdkSettingsStep", "<init>"));
        }
        this(settingsStep.getContext(), moduleBuilder, sdkFilter);
        if (!this.isEmpty()) {
            settingsStep.addSettingsField(this.getSdkFieldLabel(settingsStep.getContext().getProject()), (JComponent)this.myJdkPanel);
        }
    }

    public SdkSettingsStep(WizardContext context, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> sdkFilter) {
        Sdk jdk;
        String value;
        if (moduleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleBuilder", "com/intellij/ide/util/projectWizard/SdkSettingsStep", "<init>"));
        }
        if (sdkFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkFilter", "com/intellij/ide/util/projectWizard/SdkSettingsStep", "<init>"));
        }
        this.myModuleBuilder = moduleBuilder;
        this.myWizardContext = context;
        this.myModel = new ProjectSdksModel();
        Project project = this.myWizardContext.getProject();
        this.myModel.reset(project);
        this.myJdkComboBox = new JdkComboBox(this.myModel, sdkFilter);
        this.myJdkPanel = new JPanel(new BorderLayout(4, 0));
        final PropertiesComponent component = project == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project);
        ModuleType moduleType = moduleBuilder.getModuleType();
        final String selectedJdkProperty = "jdk.selected." + (moduleType == null ? "" : moduleType.getId());
        this.myJdkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk jdk = SdkSettingsStep.this.myJdkComboBox.getSelectedJdk();
                if (jdk != null) {
                    component.setValue(selectedJdkProperty, jdk.getName());
                }
                SdkSettingsStep.this.OnSdkSelected(jdk);
            }
        });
        if (project != null) {
            Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (sdk != null && moduleBuilder.isSuitableSdkType(sdk.getSdkType())) {
                return;
            }
        } else {
            Project defaultProject = ProjectManager.getInstance().getDefaultProject();
            Sdk sdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
            if (sdk != null && sdkFilter.value((Object)sdk.getSdkType())) {
                this.myJdkComboBox.setSelectedJdk(sdk);
            }
        }
        if ((value = component.getValue(selectedJdkProperty)) != null && (jdk = ProjectJdkTable.getInstance().findJdk(value)) != null) {
            this.myJdkComboBox.setSelectedJdk(jdk);
        }
        JButton button = new JButton("Ne\u001bw...");
        this.myJdkComboBox.setSetupButton(button, project, this.myModel, project == null ? new JdkComboBox.NoneJdkComboBoxItem() : new JdkComboBox.ProjectJdkComboBoxItem(), null, false);
        this.myJdkPanel.add((Component)((Object)this.myJdkComboBox));
        this.myJdkPanel.add((Component)this.myJdkComboBox.getSetUpButton(), "East");
    }

    protected void OnSdkSelected(Sdk sdk) {
    }

    public boolean isEmpty() {
        return this.myJdkPanel.getComponentCount() == 0;
    }

    @NotNull
    protected String getSdkFieldLabel(@Nullable Project project) {
        String string = (project == null ? "Project" : "Module") + " \u001bSDK:";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/projectWizard/SdkSettingsStep", "getSdkFieldLabel"));
        }
        return string;
    }

    public JdkComboBox getJdkComboBox() {
        return this.myJdkComboBox;
    }

    public JComponent getComponent() {
        return this.myJdkPanel;
    }

    public void updateDataModel() {
        Project project = this.myWizardContext.getProject();
        if (project == null) {
            Sdk jdk = this.myJdkComboBox.getSelectedJdk();
            this.myWizardContext.setProjectJdk(jdk);
        } else {
            Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (sdk == null || !this.myModuleBuilder.isSuitableSdkType(sdk.getSdkType())) {
                this.myModuleBuilder.setModuleJdk(this.myJdkComboBox.getSelectedJdk());
            }
        }
    }

    public boolean validate() throws ConfigurationException {
        block3: {
            if (this.myJdkComboBox.getSelectedJdk() == null && Messages.showDialog((String)this.getNoSdkMessage(), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            try {
                this.myModel.apply(null, true);
            }
            catch (ConfigurationException e) {
                if (Messages.showDialog((String)(e.getMessage() + "/nDo you want to proceed?"), (String)e.getTitle(), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0) break block3;
                return false;
            }
        }
        return true;
    }

    protected String getNoSdkMessage() {
        return IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]);
    }
}

