/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLexer;
import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        MyHighlighter myHighlighter = new MyHighlighter();
        if (myHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/JsonSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return myHighlighter;
    }

    private static class MyHighlighter
    extends SyntaxHighlighterBase {
        private static final Map<IElementType, TextAttributesKey> ourAttributes = new HashMap<IElementType, TextAttributesKey>();

        private MyHighlighter() {
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            LayeredLexer layeredLexer = new LayeredLexer((Lexer)new JsonLexer());
            layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\"', JsonElementTypes.DOUBLE_QUOTED_STRING, false, "/", false, false), new IElementType[]{JsonElementTypes.DOUBLE_QUOTED_STRING}, IElementType.EMPTY_ARRAY);
            layeredLexer.registerSelfStoppingLayer((Lexer)new StringLiteralLexer('\'', JsonElementTypes.SINGLE_QUOTED_STRING, false, "/", false, false), new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING}, IElementType.EMPTY_ARRAY);
            LayeredLexer layeredLexer2 = layeredLexer;
            if (layeredLexer2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/JsonSyntaxHighlighterFactory$MyHighlighter", "getHighlightingLexer"));
            }
            return layeredLexer2;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType type) {
            TextAttributesKey[] textAttributesKeyArray = MyHighlighter.pack((TextAttributesKey)ourAttributes.get(type));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/JsonSyntaxHighlighterFactory$MyHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }

        static {
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES, (IElementType[])new IElementType[]{JsonElementTypes.L_CURLY, JsonElementTypes.R_CURLY});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS, (IElementType[])new IElementType[]{JsonElementTypes.L_BRACKET, JsonElementTypes.R_BRACKET});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA, (IElementType[])new IElementType[]{JsonElementTypes.COMMA});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON, (IElementType[])new IElementType[]{JsonElementTypes.COLON});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING, (IElementType[])new IElementType[]{JsonElementTypes.DOUBLE_QUOTED_STRING});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING, (IElementType[])new IElementType[]{JsonElementTypes.SINGLE_QUOTED_STRING});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER, (IElementType[])new IElementType[]{JsonElementTypes.NUMBER});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD, (IElementType[])new IElementType[]{JsonElementTypes.TRUE, JsonElementTypes.FALSE, JsonElementTypes.NULL});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.LINE_COMMENT});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.BLOCK_COMMENT, (IElementType[])new IElementType[]{JsonElementTypes.BLOCK_COMMENT});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)HighlighterColors.TEXT, (IElementType[])new IElementType[]{JsonElementTypes.INDENTIFIER});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)HighlighterColors.BAD_CHARACTER, (IElementType[])new IElementType[]{TokenType.BAD_CHARACTER});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN});
            MyHighlighter.fillMap(ourAttributes, (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE, (IElementType[])new IElementType[]{StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});
        }
    }
}

