/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralAnnotator
implements Annotator {
    private static final Pattern VALID_ESCAPE = Pattern.compile("\\\\([\"\\\\/bfnrt]|u[0-9a-fA-F]{4})");
    private static boolean debug = ApplicationManager.getApplication().isUnitTestMode();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/codeinsight/JsonStringLiteralAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/json/codeinsight/JsonStringLiteralAnnotator", "annotate"));
        }
        if (element instanceof JsonStringLiteral) {
            String text;
            int length;
            JsonStringLiteral stringLiteral = (JsonStringLiteral)element;
            int elementOffset = element.getTextOffset();
            if (JsonPsiUtil.isPropertyKey(element)) {
                holder.createInfoAnnotation(element, debug ? "instance field" : null).setTextAttributes(DefaultLanguageHighlighterColors.INSTANCE_FIELD);
            }
            if ((length = (text = element.getText()).length()) <= 1 || text.charAt(0) != text.charAt(length - 1) || JsonStringLiteralAnnotator.quoteEscaped(text, length - 1)) {
                holder.createErrorAnnotation(element.getTextRange(), JsonBundle.message("msg.missing.closing.quote", new Object[0]));
            }
            List<Pair<TextRange, String>> fragments = stringLiteral.getTextFragments();
            for (Pair<TextRange, String> fragment : fragments) {
                String fragmentText = (String)fragment.getSecond();
                if (!fragmentText.startsWith("\\") || fragmentText.length() <= 1 || VALID_ESCAPE.matcher(fragmentText).matches()) continue;
                TextRange fragmentRange = (TextRange)fragment.getFirst();
                if (fragmentText.startsWith("\\u")) {
                    holder.createErrorAnnotation(fragmentRange.shiftRight(elementOffset), JsonBundle.message("msg.illegal.unicode.escape.sequence", new Object[0]));
                    continue;
                }
                holder.createErrorAnnotation(fragmentRange.shiftRight(elementOffset), JsonBundle.message("msg.illegal.escape.sequence", new Object[0]));
            }
        }
    }

    private static boolean quoteEscaped(String text, int quotePos) {
        int count = 0;
        for (int i = quotePos - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            ++count;
        }
        return count % 2 != 0;
    }
}

