/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralManipulator
extends AbstractElementManipulator<JsonStringLiteral> {
    public JsonStringLiteral handleContentChange(@NotNull JsonStringLiteral element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonStringLiteralManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/json/psi/JsonStringLiteralManipulator", "handleContentChange"));
        }
        assert (new TextRange(0, element.getTextLength()).contains(range));
        String originalContent = element.getText();
        TextRange withoutQuotes = this.getRangeInElement(element);
        JsonElementGenerator generator = new JsonElementGenerator(element.getProject());
        String replacement = originalContent.substring(withoutQuotes.getStartOffset(), range.getStartOffset()) + newContent + originalContent.substring(range.getEndOffset(), withoutQuotes.getEndOffset());
        return (JsonStringLiteral)element.replace(generator.createStringLiteral(replacement));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JsonStringLiteral element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/psi/JsonStringLiteralManipulator", "getRangeInElement"));
        }
        String content = element.getText();
        int startOffset = content.startsWith("'") || content.startsWith("\"") ? 1 : 0;
        int endOffset = content.length() > 0 && (content.endsWith("'") || content.endsWith("\"")) ? -1 : 0;
        TextRange textRange = new TextRange(startOffset, content.length() + endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/psi/JsonStringLiteralManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

