/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import sun.swing.SwingUtilities2;

public class ActionButtonWithText
extends ActionButton {
    private static final int ICON_TEXT_SPACE = 2;

    public ActionButtonWithText(AnAction action, Presentation presentation, String place, Dimension minimumSize) {
        super(action, presentation, place, minimumSize);
        this.setFont(UIUtil.getLabelFont());
        this.setForeground(UIUtil.getLabelForeground());
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(super.getPreferredSize());
        String text = this.getText();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        preferredSize.width += this.iconTextSpace();
        preferredSize.width += fontMetrics.stringWidth(text);
        return preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        Icon icon = this.getIcon();
        FontMetrics fm = SwingUtilities2.getFontMetrics(this, g, this.getFont());
        Rectangle viewRect = new Rectangle(this.getSize());
        Insets i = this.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        String text = SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), icon, 0, this.horizontalTextAlignment(), 0, 11, viewRect, iconRect, textRect, this.iconTextSpace());
        ActionButtonLook look = ActionButtonLook.IDEA_LOOK;
        look.paintBackground(g, this);
        look.paintIconAt(g, this, icon, iconRect.x, iconRect.y);
        look.paintBorder(g, this);
        UIUtil.applyRenderingHints((Graphics)g);
        g.setColor(this.isButtonEnabled() ? this.getForeground() : UIUtil.getInactiveTextColor());
        SwingUtilities2.drawStringUnderlineCharAt(this, g, text, this.getMnemonicCharIndex(text), textRect.x, textRect.y + fm.getAscent());
    }

    protected int horizontalTextAlignment() {
        return 0;
    }

    protected int iconTextSpace() {
        return this.getIcon() instanceof EmptyIcon || this.getIcon() == null ? 0 : 2;
    }

    private int getMnemonicCharIndex(String text) {
        int mnemonicIndex = this.myPresentation.getDisplayedMnemonicIndex();
        if (mnemonicIndex != -1) {
            return mnemonicIndex;
        }
        ShortcutSet shortcutSet = this.myAction.getShortcutSet();
        Shortcut[] shortcuts = shortcutSet.getShortcuts();
        for (int i = 0; i < shortcuts.length; ++i) {
            KeyStroke keyStroke;
            int modifiers;
            KeyboardShortcut keyboardShortcut;
            Shortcut shortcut = shortcuts[i];
            if (!(shortcut instanceof KeyboardShortcut) || (keyboardShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null || ((modifiers = (keyStroke = keyboardShortcut.getFirstKeyStroke()).getModifiers()) & 8) == 0) continue;
            return keyStroke.getKeyChar() != '\uffff' ? text.indexOf(keyStroke.getKeyChar()) : text.indexOf(KeyEvent.getKeyText(keyStroke.getKeyCode()));
        }
        return -1;
    }

    private String getText() {
        String text = this.myPresentation.getText();
        return text != null ? text : "";
    }
}

