/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.DirectoryStorageData;
import com.intellij.openapi.components.impl.stores.StorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.tracker.VirtualFileTracker;
import com.intellij.util.containers.SmartHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryBasedStorage
implements StateStorage,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.DirectoryBasedStorage");
    private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;
    private final File myDir;
    private final StateSplitter mySplitter;
    private final FileTypeManager myFileTypeManager;
    private DirectoryStorageData myStorageData;

    public DirectoryBasedStorage(@Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @NotNull String dir, @NotNull StateSplitter splitter, @NotNull Disposable parentDisposable, final @Nullable StateStorage.Listener listener) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "<init>"));
        }
        this.myStorageData = null;
        this.myPathMacroSubstitutor = pathMacroSubstitutor;
        this.myDir = new File(dir);
        this.mySplitter = splitter;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        VirtualFileTracker virtualFileTracker = (VirtualFileTracker)ServiceManager.getService(VirtualFileTracker.class);
        if (virtualFileTracker != null && listener != null) {
            String path = this.myDir.getAbsolutePath();
            String fileUrl = "file://" + path.replace(File.separatorChar, '/');
            virtualFileTracker.addTracker(fileUrl, (VirtualFileListener)new VirtualFileAdapter(){

                public void contentsChanged(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "contentsChanged"));
                    }
                    if (!StringUtilRt.endsWithIgnoreCase((CharSequence)event.getFile().getNameSequence(), (CharSequence)".xml")) {
                        return;
                    }
                    assert (listener != null);
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileDeleted(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileDeleted"));
                    }
                    if (!StringUtilRt.endsWithIgnoreCase((CharSequence)event.getFile().getNameSequence(), (CharSequence)".xml")) {
                        return;
                    }
                    assert (listener != null);
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }

                public void fileCreated(@NotNull VirtualFileEvent event) {
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$1", "fileCreated"));
                    }
                    if (!StringUtilRt.endsWithIgnoreCase((CharSequence)event.getFile().getNameSequence(), (CharSequence)".xml")) {
                        return;
                    }
                    assert (listener != null);
                    listener.storageFileChanged(event, (StateStorage)DirectoryBasedStorage.this);
                }
            }, false, (Disposable)this);
        }
        this.myFileTypeManager = FileTypeManager.getInstance();
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Collection<Pair<VirtualFile, StateStorage>> changedFiles, @NotNull Set<String> result) {
        if (changedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFiles", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "analyzeExternalChangesAndUpdateIfNeed"));
        }
        boolean containsSelf = false;
        for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
            if (pair.second != this || !StringUtilRt.endsWithIgnoreCase((CharSequence)((VirtualFile)pair.first).getNameSequence(), (CharSequence)".xml")) continue;
            containsSelf = true;
            break;
        }
        if (!containsSelf) {
            return;
        }
        this.myStorageData = this.loadState();
        result.addAll(this.myStorageData.getComponentNames());
    }

    @Nullable
    public <T> T getState(Object component, @NotNull String componentName, @NotNull Class<T> stateClass, @Nullable T mergeInto) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "getState"));
        }
        if (this.myStorageData == null) {
            this.myStorageData = this.loadState();
        }
        if (!this.myStorageData.containsComponent(componentName)) {
            return DefaultStateSerializer.deserializeState(new Element("component"), stateClass, mergeInto);
        }
        return this.myStorageData.getMergedState(componentName, stateClass, this.mySplitter, mergeInto);
    }

    private DirectoryStorageData loadState() {
        DirectoryStorageData storageData = new DirectoryStorageData();
        storageData.loadFrom(LocalFileSystem.getInstance().findFileByIoFile(this.myDir), this.myPathMacroSubstitutor);
        return storageData;
    }

    public boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "hasState"));
        }
        if (!this.myDir.exists()) {
            return false;
        }
        if (reloadData) {
            this.myStorageData = null;
        }
        return true;
    }

    @NotNull
    public StateStorage.ExternalizationSession startExternalization() {
        if (this.myStorageData == null) {
            try {
                this.myStorageData = this.loadState();
            }
            catch (StateStorageException e) {
                LOG.error((Throwable)e);
            }
        }
        MyExternalizationSession myExternalizationSession = new MyExternalizationSession(this.myStorageData.clone());
        if (myExternalizationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startExternalization"));
        }
        return myExternalizationSession;
    }

    @Nullable
    public StateStorage.SaveSession startSave(@NotNull StateStorage.ExternalizationSession externalizationSession) {
        if (externalizationSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizationSession", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage", "startSave"));
        }
        return new MySaveSession(((MyExternalizationSession)externalizationSession).myStorageData, this.myPathMacroSubstitutor);
    }

    public void dispose() {
    }

    private class MyExternalizationSession
    implements StateStorage.ExternalizationSession {
        private final DirectoryStorageData myStorageData;

        private MyExternalizationSession(DirectoryStorageData storageData) {
            this.myStorageData = storageData;
        }

        public void setState(@NotNull Object component, @NotNull String componentName, @NotNull Object state, Storage storageSpec) {
            Element element;
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            if (componentName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MyExternalizationSession", "setState"));
            }
            try {
                element = DefaultStateSerializer.serializeState(state, storageSpec);
            }
            catch (WriteExternalException e) {
                throw new StateStorageException((Throwable)e);
            }
            catch (Throwable e) {
                LOG.info("Unable to serialize component state!", e);
                return;
            }
            if (element != null) {
                for (Pair pair : DirectoryBasedStorage.this.mySplitter.splitState(element)) {
                    Element e = (Element)pair.first;
                    String name = (String)pair.second;
                    Element statePart = new Element("component");
                    statePart.setAttribute("name", componentName);
                    statePart.addContent(e.detach());
                    this.myStorageData.put(componentName, new File(DirectoryBasedStorage.this.myDir, name), statePart, false);
                }
            }
        }
    }

    private class MySaveSession
    implements StateStorage.SaveSession {
        private final DirectoryStorageData myStorageData;
        private final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

        private MySaveSession(@Nullable DirectoryStorageData storageData, TrackingPathMacroSubstitutor pathMacroSubstitutor) {
            if (storageData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/DirectoryBasedStorage$MySaveSession", "<init>"));
            }
            this.myStorageData = storageData;
            this.myPathMacroSubstitutor = pathMacroSubstitutor;
        }

        public void save() throws StateStorageException {
            SmartHashSet currentNames = new SmartHashSet();
            File[] children = DirectoryBasedStorage.this.myDir.listFiles();
            if (children != null) {
                for (File child : children) {
                    String fileName = child.getName();
                    if (DirectoryBasedStorage.this.myFileTypeManager.isFileIgnored(fileName) || !StringUtil.endsWithIgnoreCase((String)fileName, (String)".xml")) continue;
                    currentNames.add(fileName);
                }
            }
            this.myStorageData.process(new DirectoryStorageData.StorageDataProcessor((Set)currentNames){
                final /* synthetic */ Set val$currentNames;
                {
                    this.val$currentNames = set;
                }

                @Override
                public void process(String componentName, File file, Element element) {
                    this.val$currentNames.remove(file.getName());
                    if (MySaveSession.this.myPathMacroSubstitutor != null) {
                        MySaveSession.this.myPathMacroSubstitutor.collapsePaths(element);
                    }
                    if (file.lastModified() <= MySaveSession.this.myStorageData.getLastTimeStamp()) {
                        StorageUtil.save(file, (Parent)element, MySaveSession.this, false, LocalFileSystem.getInstance().findFileByIoFile(file));
                        MySaveSession.this.myStorageData.updateLastTimestamp(file);
                    }
                }
            });
            if (DirectoryBasedStorage.this.myDir.exists() && !currentNames.isEmpty()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable((Set)currentNames){
                    final /* synthetic */ Set val$currentNames;
                    {
                        this.val$currentNames = set;
                    }

                    @Override
                    public void run() {
                        if (DirectoryBasedStorage.this.myDir.exists()) {
                            for (String name : this.val$currentNames) {
                                File child = new File(DirectoryBasedStorage.this.myDir, name);
                                if (child.lastModified() > MySaveSession.this.myStorageData.getLastTimeStamp()) {
                                    return;
                                }
                                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(child);
                                if (virtualFile == null) continue;
                                try {
                                    LOG.debug("Removing configuration file: " + virtualFile.getPresentableUrl());
                                    virtualFile.delete((Object)MySaveSession.this);
                                }
                                catch (IOException e) {
                                    LOG.error((Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
            this.myStorageData.clear();
        }
    }
}

