/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ImportSpec {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean forceWhenUptodate;
    private boolean whenAutoImportEnabled;

    public ImportSpec(@NotNull Project project, @NotNull ProjectSystemId id) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/importing/ImportSpec", "<init>"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/importing/ImportSpec", "<init>"));
        }
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.MODAL_SYNC;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpec", "getProject"));
        }
        return project;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpec", "getExternalSystemId"));
        }
        return projectSystemId;
    }

    @NotNull
    public ProgressExecutionMode getProgressExecutionMode() {
        ProgressExecutionMode progressExecutionMode = this.myProgressExecutionMode;
        if (progressExecutionMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/importing/ImportSpec", "getProgressExecutionMode"));
        }
        return progressExecutionMode;
    }

    public void setProgressExecutionMode(@NotNull ProgressExecutionMode progressExecutionMode) {
        if (progressExecutionMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressExecutionMode", "com/intellij/openapi/externalSystem/importing/ImportSpec", "setProgressExecutionMode"));
        }
        this.myProgressExecutionMode = progressExecutionMode;
    }

    public boolean isForceWhenUptodate() {
        return this.forceWhenUptodate;
    }

    public void setForceWhenUptodate(boolean forceWhenUptodate) {
        this.forceWhenUptodate = forceWhenUptodate;
    }

    public boolean isWhenAutoImportEnabled() {
        return this.whenAutoImportEnabled;
    }

    public void setWhenAutoImportEnabled(boolean whenAutoImportEnabled) {
        this.whenAutoImportEnabled = whenAutoImportEnabled;
    }
}

