/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.SimpleContent;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.DiffPanelImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import com.intellij.util.messages.MessageBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements VirtualFileListener,
ProjectManagerListener,
SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private final Set<Document> myUnsavedDocuments;
    private final Map<VirtualFile, Document> myDocuments;
    private final MessageBus myBus;
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper;
    private boolean myOnClose;
    private PairProcessor<VirtualFile, Document> askReloadFromDisk;

    public FileDocumentManagerImpl(@NotNull VirtualFileManager virtualFileManager, @NotNull ProjectManager projectManager) {
        if (virtualFileManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFileManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        if (projectManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectManager", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "<init>"));
        }
        this.myUnsavedDocuments = new ConcurrentHashSet();
        this.myDocuments = new ConcurrentWeakValueHashMap();
        this.myTrailingSpacesStripper = new TrailingSpacesStripper();
        this.myOnClose = false;
        this.askReloadFromDisk = new PairProcessor<VirtualFile, Document>(){

            public boolean process(final VirtualFile file, final Document document) {
                String message = UIBundle.message((String)"file.cache.conflict.message.text", (Object[])new Object[]{file.getPresentableUrl()});
                final DialogBuilder builder = new DialogBuilder();
                builder.setCenterPanel((JComponent)new JLabel(message, Messages.getQuestionIcon(), 0));
                builder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.load.fs.changes.button", (Object[])new Object[0]));
                builder.addCancelAction().setText(UIBundle.message((String)"file.cache.conflict.keep.memory.changes.button", (Object[])new Object[0]));
                builder.addAction((Action)new AbstractAction(UIBundle.message((String)"file.cache.conflict.show.difference.button", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String title = UIBundle.message((String)"file.cache.conflict.for.file.dialog.title", (Object[])new Object[]{file.getPresentableUrl()});
                        ProjectEx project = (ProjectEx)ProjectLocator.getInstance().guessProjectForFile(file);
                        SimpleDiffRequest request = new SimpleDiffRequest((Project)project, title);
                        FileType fileType = file.getFileType();
                        String fsContent = ((Object)LoadTextUtil.loadText(file)).toString();
                        request.setContents((DiffContent)new SimpleContent(fsContent, fileType), (DiffContent)new DocumentContent((Project)project, document, fileType));
                        request.setContentTitles(UIBundle.message((String)"file.cache.conflict.diff.content.file.system.content", (Object[])new Object[0]), UIBundle.message((String)"file.cache.conflict.diff.content.memory.content", (Object[])new Object[0]));
                        DialogBuilder diffBuilder = new DialogBuilder((Project)project);
                        DiffPanelImpl diffPanel = (DiffPanelImpl)DiffManager.getInstance().createDiffPanel(diffBuilder.getWindow(), (Project)project, (Disposable)diffBuilder, null);
                        diffPanel.getOptions().setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.DONT_SHOW);
                        diffBuilder.setCenterPanel(diffPanel.getComponent());
                        diffBuilder.setDimensionServiceKey("FileDocumentManager.FileCacheConflict");
                        diffPanel.setDiffRequest((DiffRequest)request);
                        diffBuilder.addOkAction().setText(UIBundle.message((String)"file.cache.conflict.save.changes.button", (Object[])new Object[0]));
                        diffBuilder.addCancelAction();
                        diffBuilder.setTitle(title);
                        if (diffBuilder.show() == 0) {
                            builder.getDialogWrapper().close(1);
                        }
                    }
                });
                builder.setTitle(UIBundle.message((String)"file.cache.conflict.dialog.title", (Object[])new Object[0]));
                builder.setButtonsAlignment(0);
                builder.setHelpId("reference.dialogs.fileCacheConflict");
                return builder.show() == 0;
            }
        };
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this);
        projectManager.addProjectManagerListener((ProjectManagerListener)this);
        this.myBus = ApplicationManager.getApplication().getMessageBus();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            @Nullable
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                FileDocumentManagerImpl.this.multiCast(method, args);
                return null;
            }
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler);
    }

    private void multiCast(@NotNull Method method, Object[] args) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "multiCast"));
        }
        try {
            method.invoke(this.myBus.syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        for (FileDocumentManagerListener listener : FileDocumentManagerImpl.getListeners()) {
            try {
                method.invoke((Object)listener, args);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        try {
            method.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getDocument"));
        }
        DocumentEx document = (DocumentEx)this.getCachedDocument(file);
        if (document == null) {
            if (!file.isValid() || file.isDirectory() || SingleRootFileViewProvider.isTooLargeForContentLoading(file) || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
                return null;
            }
            CharSequence text = LoadTextUtil.loadText(file);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text, file);
                document.setModificationStamp(file.getModificationStamp());
                FileType fileType = file.getFileType();
                document.setReadOnly(!file.isWritable() || fileType.isBinary());
                if (file instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document, file);
                } else {
                    this.myDocuments.put(file, document);
                    document.putUserData(FILE_KEY, file);
                }
                if (!(file instanceof LightVirtualFile) && !(file.getFileSystem() instanceof DummyFileSystem)) {
                    document.addDocumentListener((DocumentListener)new DocumentAdapter(){

                        public void documentChanged(DocumentEvent e) {
                            Document document = e.getDocument();
                            FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
                            Runnable currentCommand = CommandProcessor.getInstance().getCurrentCommand();
                            Project project = currentCommand == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
                            String lineSeparator = CodeStyleFacade.getInstance((Project)project).getLineSeparator();
                            document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
                            if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                                FileDocumentManagerImpl.this.saveAllDocumentsLater();
                            }
                        }
                    });
                }
            }
            this.myMultiCaster.fileContentLoaded(file, (Document)document);
        }
        return document;
    }

    public static boolean areTooManyDocumentsInTheQueue(Collection<Document> documents) {
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= 0xA00000) continue;
            return true;
        }
        return false;
    }

    private static Document createDocument(CharSequence text, VirtualFile file) {
        boolean acceptSlashR = file instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text, (char)'\r') >= 0;
        return ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text, acceptSlashR, false);
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getCachedDocument"));
        }
        Document hard = (Document)file.getUserData(HARD_REF_TO_DOCUMENT_KEY);
        return hard != null ? hard : this.myDocuments.get(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "registerDocument"));
        }
        Object object = lock;
        synchronized (object) {
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
            document.putUserData(FILE_KEY, (Object)virtualFile);
        }
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getFile"));
        }
        return (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.fireUnsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Document[] unsavedDocuments;
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                for (Document document : unsavedDocuments = FileDocumentManagerImpl.this.getUnsavedDocuments()) {
                    Project project;
                    VirtualFile file = FileDocumentManagerImpl.this.getFile(document);
                    if (file == null || (project = ProjectUtil.guessProjectForFile((VirtualFile)file)) == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(document)) continue;
                    FileDocumentManagerImpl.this.saveDocument(document);
                }
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocument"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "saveDocumentAsIs"));
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        String trailer = editorSettings.getStripTrailingSpaces();
        boolean ensureEOLonEOF = editorSettings.isEnsureNewLineAtEOF();
        editorSettings.setStripTrailingSpaces("None");
        editorSettings.setEnsureNewLineAtEOF(false);
        try {
            this.saveDocument(document);
        }
        finally {
            editorSettings.setStripTrailingSpaces(trailer);
            editorSettings.setEnsureNewLineAtEOF(ensureEOLonEOF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocument"));
        }
        VirtualFile file = this.getFile(document);
        if (file == null || file instanceof LightVirtualFile || file.isValid() && !this.isFileModified(file)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file.isValid() && FileDocumentManagerImpl.needsRefresh(file)) {
            file.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            if (vetoer.maySaveDocument(document, isExplicit)) continue;
            throw new SaveVetoException();
        }
        AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(((Object)((Object)this)).getClass());
        try {
            this.doSaveDocumentInWriteAction(document, file);
        }
        finally {
            token.finish();
        }
    }

    private void doSaveDocumentInWriteAction(final @NotNull Document document, final @NotNull VirtualFile file) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "doSaveDocumentInWriteAction"));
        }
        if (!file.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file);
        }
        if (!FileDocumentManagerImpl.isSaveNeeded(document, file)) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file);
            return;
        }
        PomModelImpl.guardPsiModificationsIn(new ThrowableRunnable<IOException>(){

            public void run() throws IOException {
                FileDocumentManagerImpl.this.myMultiCaster.beforeDocumentSaving(document);
                LOG.assertTrue(file.isValid());
                String text = document.getText();
                String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file);
                if (!lineSeparator.equals("\n")) {
                    text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
                }
                Project project = ProjectLocator.getInstance().guessProjectForFile(file);
                LoadTextUtil.write(project, file, (Object)FileDocumentManagerImpl.this, text, document.getModificationStamp());
                FileDocumentManagerImpl.this.myUnsavedDocuments.remove(document);
                LOG.assertTrue(!FileDocumentManagerImpl.this.myUnsavedDocuments.contains(document));
                FileDocumentManagerImpl.this.myTrailingSpacesStripper.clearLineModificationFlags(document);
            }
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "updateModifiedProperty"));
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (FileEditor editor : fileEditorManager.getAllEditors(file)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "removeFromUnsaved"));
        }
        this.myUnsavedDocuments.remove(document);
        this.fireUnsavedDocumentsDropped();
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isSaveNeeded"));
        }
        if (file.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file, false, false);
        return !Comparing.equal((CharSequence)document.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(VirtualFile file) {
        VirtualFileSystem fs = file.getFileSystem();
        return fs instanceof NewVirtualFileSystem && file.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        String lineSeparator = LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        String string = lineSeparator;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file, @Nullable Project project) {
        String lineSeparator;
        String string = lineSeparator = file == null ? null : LoadTextUtil.getDetectedLineSeparator(file);
        if (lineSeparator == null) {
            CodeStyleFacade settingsManager = project == null ? CodeStyleFacade.getInstance() : CodeStyleFacade.getInstance((Project)project);
            lineSeparator = settingsManager.getLineSeparator();
        }
        String string2 = lineSeparator;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getLineSeparator"));
        }
        return string2;
    }

    public boolean requestWriting(@NotNull Document document, Project project) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "requestWriting"));
        }
        VirtualFile file = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project != null && file != null && file.isValid()) {
            return !file.getFileType().isBinary() && ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file});
        }
        if (document.isWritable()) {
            return true;
        }
        document.fireReadOnlyModificationAttempt();
        return false;
    }

    public void reloadFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFiles"));
        }
        for (VirtualFile file : files) {
            Document doc;
            if (!file.exists() || (doc = this.getCachedDocument(file)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    @NotNull
    public Document[] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            if (Document.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
            }
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list = new ArrayList<Document>(this.myUnsavedDocuments);
        Document[] documentArray = list.toArray(new Document[list.size()]);
        if (documentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getUnsavedDocuments"));
        }
        return documentArray;
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isDocumentUnsaved"));
        }
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModified(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isFileModified"));
        }
        Document doc = this.getCachedDocument(file);
        return doc != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file.getModificationStamp();
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Document document;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "propertyChanged"));
        }
        final VirtualFile file = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            final Document document2 = this.getCachedDocument(file);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction(){

                    @Override
                    public void run() {
                        document2.setReadOnly(!file.isWritable());
                    }
                });
            }
        } else if ("name".equals(event.getPropertyName()) && (document = this.getCachedDocument(file)) != null && FileDocumentManagerImpl.isBinaryWithoutDecompiler(file)) {
            this.unbindFileFromDocument(file, document);
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "unbindFileFromDocument"));
        }
        this.myDocuments.remove(file);
        file.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithDecompiler"));
        }
        FileType ft = file.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "isBinaryWithoutDecompiler"));
        }
        FileType fileType = file.getFileType();
        return fileType.isBinary() && BinaryFileTypeDecompilers.INSTANCE.forFileType(fileType) == null;
    }

    public void contentsChanged(@NotNull VirtualFileEvent event) {
        long oldFileStamp;
        long documentStamp;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "contentsChanged"));
        }
        if (event.isFromSave()) {
            return;
        }
        VirtualFile file = event.getFile();
        Document document = this.getCachedDocument(file);
        if (document == null) {
            this.myMultiCaster.fileWithNoDocumentChanged(file);
            return;
        }
        if (FileDocumentManagerImpl.isBinaryWithDecompiler(file)) {
            this.myMultiCaster.fileWithNoDocumentChanged(file);
        }
        if ((documentStamp = document.getModificationStamp()) != (oldFileStamp = event.getOldModificationStamp())) {
            LOG.info("reload " + file.getName() + " from disk?");
            LOG.info("  documentStamp:" + documentStamp);
            LOG.info("  oldFileStamp:" + oldFileStamp);
            if (file.isValid() && this.askReloadFromDisk(file, document)) {
                this.reloadFromDisk(document);
            }
        } else {
            this.reloadFromDisk(document);
        }
    }

    public void reloadFromDisk(final @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "reloadFromDisk"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file = this.getFile(document);
        assert (file != null);
        if (!this.fireBeforeFileContentReload(file, document)) {
            return;
        }
        if (file.getLength() > (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
            this.unbindFileFromDocument(file, document);
            this.myUnsavedDocuments.remove(document);
            this.myMultiCaster.fileWithNoDocumentChanged(file);
            return;
        }
        final Project project = ProjectLocator.getInstance().guessProjectForFile(file);
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document, project){

                    @Override
                    public void run() {
                        boolean wasWritable = document.isWritable();
                        DocumentEx documentEx = (DocumentEx)document;
                        documentEx.setReadOnly(false);
                        LoadTextUtil.setCharsetWasDetectedFromBytes(file, null);
                        file.setBOM(null);
                        documentEx.replaceText(LoadTextUtil.loadText(file), file.getModificationStamp());
                        documentEx.setReadOnly(!wasWritable);
                    }
                });
            }
        }, UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        this.myUnsavedDocuments.remove(document);
        this.myMultiCaster.fileContentReloaded(file, document);
    }

    public void setAskReloadFromDisk(@NotNull Disposable disposable, @NotNull PairProcessor<VirtualFile, Document> newProcessor) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        if (newProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newProcessor", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "setAskReloadFromDisk"));
        }
        final PairProcessor<VirtualFile, Document> old = this.askReloadFromDisk;
        this.askReloadFromDisk = newProcessor;
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                FileDocumentManagerImpl.this.askReloadFromDisk = old;
            }
        });
    }

    private boolean askReloadFromDisk(VirtualFile file, Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isDocumentUnsaved(document)) {
            return true;
        }
        return this.askReloadFromDisk.process((Object)file, (Object)document);
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCreated"));
        }
    }

    public void fileDeleted(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileDeleted"));
        }
        Document doc = this.getCachedDocument(event.getFile());
        if (doc != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileMoved"));
        }
    }

    public void fileCopied(@NotNull VirtualFileCopyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fileCopied"));
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforePropertyChange"));
        }
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeContentsChange"));
        }
        VirtualFile virtualFile = event.getFile();
        if (virtualFile.getFileType() == UnknownFileType.INSTANCE && virtualFile.getLength() == 0L) {
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "recomputeFileTypeIfNecessary"));
        }
        if (virtualFile.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile.getFileType();
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileDeletion"));
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "beforeFileMovement"));
        }
    }

    public void projectOpened(Project project) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canCloseProject(Project project) {
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myOnClose = true;
            try {
                this.saveAllDocuments();
            }
            finally {
                this.myOnClose = false;
            }
        }
        return this.myUnsavedDocuments.isEmpty();
    }

    public void projectClosed(Project project) {
    }

    public void projectClosing(Project project) {
    }

    private void fireUnsavedDocumentsDropped() {
        this.myMultiCaster.unsavedDocumentsDropped();
    }

    private boolean fireBeforeFileContentReload(VirtualFile file, @NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "fireBeforeFileContentReload"));
        }
        for (FileDocumentSynchronizationVetoer vetoer : (FileDocumentSynchronizationVetoer[])Extensions.getExtensions((ExtensionPointName)FileDocumentSynchronizationVetoer.EP_NAME)) {
            try {
                if (vetoer.mayReloadFileContent(file, document)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file, document);
        return true;
    }

    @NotNull
    private static FileDocumentManagerListener[] getListeners() {
        FileDocumentManagerListener[] fileDocumentManagerListenerArray = (FileDocumentManagerListener[])FileDocumentManagerListener.EP_NAME.getExtensions();
        if (fileDocumentManagerListenerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "getListeners"));
        }
        return fileDocumentManagerListenerArray;
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (failures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "failures", "com/intellij/openapi/fileEditor/impl/FileDocumentManagerImpl", "handleErrorsOnSave"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException;
            IOException iOException = ioException = failures.isEmpty() ? null : failures.values().iterator().next();
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (IOException exception : failures.values()) {
            LOG.warn((Throwable)exception);
        }
        final String text = StringUtil.join(failures.values(), (Function)new Function<IOException, String>(){

            public String fun(IOException e) {
                return e.getMessage();
            }
        }, (String)"\n");
        DialogWrapper dialog = new DialogWrapper(null){
            {
                super(x0);
                this.init();
                this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            protected JComponent createCenterPanel() {
                JPanel panel = new JPanel(new BorderLayout(0, 5));
                panel.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                return panel;
            }
        };
        dialog.show();
        if (dialog.isOK()) {
            for (Document document : failures.keySet()) {
                this.reloadFromDisk(document);
            }
        }
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }
}

