/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public final class IdeMouseEventDispatcher {
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private final ArrayList<AnAction> myActions = new ArrayList(1);
    private final Map<Container, BlockState> myRootPane2BlockedId = new HashMap();
    private int myLastHorScrolledComponentHash = 0;
    private static final List<Integer> SWING_EVENTS_PRIORITY = Arrays.asList(501, 504, 505, 503, 506, 507, 502, 500);

    private void fillActionsList(Component component, MouseShortcut mouseShortcut, boolean isModalContext) {
        KeymapManager keymapManager;
        this.myActions.clear();
        if (component instanceof JComponent) {
            for (AnAction action : ActionUtil.getActions((JComponent)((JComponent)component))) {
                for (Shortcut shortcut : action.getShortcutSet().getShortcuts()) {
                    if (!mouseShortcut.equals((Object)shortcut) || this.myActions.contains(action)) continue;
                    this.myActions.add(action);
                }
            }
            if (!this.myActions.isEmpty()) {
                return;
            }
        }
        if (KeymapManagerImpl.ourKeymapManagerInitialized && (keymapManager = KeymapManager.getInstance()) != null) {
            Keymap keymap = keymapManager.getActiveKeymap();
            String[] actionIds = keymap.getActionIds(mouseShortcut);
            ActionManager actionManager = ActionManager.getInstance();
            for (String actionId : actionIds) {
                AnAction action = actionManager.getAction(actionId);
                if (action == null || isModalContext && !action.isEnabledInModalContext() || this.myActions.contains(action)) continue;
                this.myActions.add(action);
            }
        }
    }

    public boolean dispatchMouseEvent(MouseEvent e) {
        boolean done;
        BlockState blockState;
        JRootPane root;
        boolean ignore;
        Component c;
        block20: {
            block19: {
                Component at;
                IdeFocusManager focusManager;
                c = e.getComponent();
                if (e.getID() == 501 && c instanceof IdeFrame && !c.hasFocus() && (focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl && (at = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY())) != null && at.isFocusable()) {
                    ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation((IdeFrame)c, at);
                }
                if (SystemInfo.isXWindow && e.isPopupTrigger() && e.getButton() != 3) {
                    IdeMouseEventDispatcher.resetPopupTrigger(e);
                }
                ignore = false;
                if (e.getID() != 501 && e.getID() != 502 && e.getID() != 500) {
                    ignore = true;
                }
                IdeMouseEventDispatcher.patchClickCount(e);
                if (e.isConsumed() || e.isPopupTrigger() || (e.getButton() <= 3 ? e.getID() != 502 : e.getID() != 501)) break block19;
                if (e.getClickCount() >= 1 && e.getButton() != 0) break block20;
            }
            ignore = true;
        }
        if ((root = IdeMouseEventDispatcher.findRoot(e)) != null && (blockState = this.myRootPane2BlockedId.get(root)) != null) {
            if (SWING_EVENTS_PRIORITY.indexOf(blockState.currentEventId) < SWING_EVENTS_PRIORITY.indexOf(e.getID())) {
                blockState.currentEventId = e.getID();
                if (blockState.blockMode == IdeEventQueue.BlockMode.COMPLETE) {
                    return true;
                }
                ignore = true;
            } else {
                this.myRootPane2BlockedId.remove(root);
            }
        }
        if (c == null) {
            throw new IllegalStateException("component cannot be null");
        }
        if ((c = SwingUtilities.getDeepestComponentAt(c, e.getX(), e.getY())) instanceof IdeGlassPaneImpl) {
            c = ((IdeGlassPaneImpl)c).getTargetComponentFor(e);
        }
        if (c == null) {
            return false;
        }
        if (IdeMouseEventDispatcher.isHorizontalScrolling(c, e) && (done = this.doHorizontalScrolling(c, (MouseWheelEvent)e))) {
            return true;
        }
        if (ignore) {
            return false;
        }
        if (!KeymapManagerImpl.ourKeymapManagerInitialized) {
            return false;
        }
        MouseShortcut shortcut = new MouseShortcut(e.getButton(), e.getModifiersEx(), e.getClickCount());
        this.fillActionsList(c, shortcut, IdeKeyEventDispatcher.isModalContext(c));
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (actionManager != null) {
            AnAction[] actions;
            for (AnAction action : actions = this.myActions.toArray(new AnAction[this.myActions.size()])) {
                DataContext dataContext = DataManager.getInstance().getDataContext(c);
                Presentation presentation = this.myPresentationFactory.getPresentation(action);
                AnActionEvent actionEvent = new AnActionEvent((InputEvent)e, dataContext, "MainMenu", presentation, ActionManager.getInstance(), e.getModifiers());
                action.beforeActionPerformedUpdate(actionEvent);
                if (!presentation.isEnabled()) continue;
                actionManager.fireBeforeActionPerformed(action, dataContext, actionEvent);
                Component context = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
                if (context != null && !context.isShowing()) continue;
                action.actionPerformed(actionEvent);
                e.consume();
            }
            if (actions.length > 0 && e.isConsumed()) {
                return true;
            }
        }
        return e.getButton() > 3;
    }

    private static void resetPopupTrigger(MouseEvent e) {
        ReflectionUtil.setField(MouseEvent.class, (Object)e, Boolean.TYPE, (String)"popupTrigger", (Object)false);
    }

    public static boolean patchClickCount(MouseEvent e) {
        if (e.getClickCount() != 1 && e.getButton() > 3) {
            ReflectionUtil.setField(MouseEvent.class, (Object)e, Integer.TYPE, (String)"clickCount", (Object)1);
        }
        return false;
    }

    private boolean doHorizontalScrolling(Component c, MouseWheelEvent me) {
        JScrollBar scrollBar = IdeMouseEventDispatcher.findHorizontalScrollBar(c);
        if (scrollBar != null) {
            if (scrollBar.hashCode() != this.myLastHorScrolledComponentHash) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("ui.horizontal.scrolling");
                this.myLastHorScrolledComponentHash = scrollBar.hashCode();
            }
            scrollBar.setValue(scrollBar.getValue() + IdeMouseEventDispatcher.getScrollAmount(c, me, scrollBar));
            return true;
        }
        return false;
    }

    public void resetHorScrollingTracker() {
        this.myLastHorScrolledComponentHash = 0;
    }

    private static int getScrollAmount(Component c, MouseWheelEvent me, JScrollBar scrollBar) {
        int scrollBarWidth = scrollBar.getWidth();
        int ratio = Registry.is((String)"ide.smart.horizontal.scrolling") && scrollBarWidth > 0 ? Math.max((int)Math.pow(c.getWidth() / scrollBarWidth, 2.0), 10) : 10;
        return me.getUnitsToScroll() * scrollBar.getUnitIncrement() * ratio;
    }

    private static boolean isHorizontalScrolling(Component c, MouseEvent e) {
        if (c != null && e instanceof MouseWheelEvent && (!SystemInfo.isMac || IdeMouseEventDispatcher.isDiagramViewComponent(c.getParent()))) {
            MouseWheelEvent mwe = (MouseWheelEvent)e;
            return mwe.isShiftDown() && mwe.getScrollType() == 0 && IdeMouseEventDispatcher.findHorizontalScrollBar(c) != null;
        }
        return false;
    }

    @Nullable
    private static JScrollBar findHorizontalScrollBar(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JScrollPane) {
            return ((JScrollPane)c).getHorizontalScrollBar();
        }
        if (IdeMouseEventDispatcher.isDiagramViewComponent(c)) {
            JComponent view = (JComponent)c;
            for (int i = 0; i < view.getComponentCount(); ++i) {
                JScrollBar scrollBar;
                if (!(view.getComponent(i) instanceof JScrollBar) || (scrollBar = (JScrollBar)view.getComponent(i)).getOrientation() != 0) continue;
                return scrollBar;
            }
        }
        return IdeMouseEventDispatcher.findHorizontalScrollBar(c.getParent());
    }

    private static boolean isDiagramViewComponent(Component c) {
        return c != null && "y.view.Graph2DView".equals(c.getClass().getName());
    }

    public void blockNextEvents(MouseEvent e, IdeEventQueue.BlockMode blockMode) {
        JRootPane root = IdeMouseEventDispatcher.findRoot(e);
        if (root == null) {
            return;
        }
        this.myRootPane2BlockedId.put(root, new BlockState(e.getID(), blockMode));
    }

    @Nullable
    private static JRootPane findRoot(MouseEvent e) {
        Component parent = UIUtil.findUltimateParent((Component)e.getComponent());
        JRootPane root = null;
        if (parent instanceof JWindow) {
            root = ((JWindow)parent).getRootPane();
        } else if (parent instanceof JDialog) {
            root = ((JDialog)parent).getRootPane();
        } else if (parent instanceof JFrame) {
            root = ((JFrame)parent).getRootPane();
        }
        return root;
    }

    private static class BlockState {
        private int currentEventId;
        private final IdeEventQueue.BlockMode blockMode;

        private BlockState(int id, IdeEventQueue.BlockMode mode) {
            this.currentEventId = id;
            this.blockMode = mode;
        }
    }
}

