/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.newEditor.OptionsEditorColleague;
import com.intellij.openapi.options.newEditor.SettingsFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.speedSearch.ElementFilter;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.ui.treeStructure.filtered.FilteringTreeBuilder;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionsTree
extends JPanel
implements Disposable,
OptionsEditorColleague {
    private final SettingsFilter myFilter;
    final SimpleTree myTree;
    List<ConfigurableGroup> myGroups;
    FilteringTreeBuilder myBuilder;
    Root myRoot;
    Map<Configurable, EditorNode> myConfigurable2Node = new HashMap<Configurable, EditorNode>();
    MergingUpdateQueue mySelection;
    private final Renderer myRenderer;
    private Configurable myQueuedConfigurable;
    private static final EditorNode[] EMPTY_EN_ARRAY = new EditorNode[0];

    public OptionsTree(SettingsFilter filter, ConfigurableGroup ... groups) {
        this.myFilter = filter;
        this.myGroups = Arrays.asList(groups);
        this.myRoot = new Root();
        SimpleTreeStructure structure = new SimpleTreeStructure(){

            public Object getRootElement() {
                return OptionsTree.this.myRoot;
            }
        };
        this.myTree = new MyTree();
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setBorder((Border)new EmptyBorder(0, 1, 0, 0));
        this.myTree.setRowHeight(-1);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myRenderer = new Renderer();
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)this.myRenderer));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        this.myBuilder = new MyBuilder(structure);
        this.myBuilder.setFilteringMerge(300, null);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.setLayout(new BorderLayout());
        this.myTree.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OptionsTree.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                OptionsTree.this.myBuilder.revalidateTree();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                OptionsTree.this.myBuilder.revalidateTree();
            }
        });
        this.add((Component)new StickySeparator(this.myTree), "Center");
        this.mySelection = new MergingUpdateQueue("OptionsTree", 150, false, (JComponent)this, (Disposable)this, (JComponent)this).setRestartTimerOnAdd(true);
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path == null) {
                    OptionsTree.this.queueSelection(null);
                } else {
                    Base base = OptionsTree.this.extractNode(path.getLastPathComponent());
                    OptionsTree.this.queueSelection(base != null ? base.getConfigurable() : null);
                }
            }
        });
    }

    ActionCallback select(@Nullable Configurable configurable) {
        return this.queueSelection(configurable);
    }

    public void selectFirst() {
        for (ConfigurableGroup eachGroup : this.myGroups) {
            Configurable[] kids = eachGroup.getConfigurables();
            if (kids.length <= 0) continue;
            this.queueSelection(kids[0]);
            return;
        }
    }

    ActionCallback queueSelection(final Configurable configurable) {
        if (this.myBuilder.isSelectionBeingAdjusted()) {
            return new ActionCallback.Rejected();
        }
        final ActionCallback callback = new ActionCallback();
        this.myQueuedConfigurable = configurable;
        Update update = new Update(this){

            public void run() {
                if (configurable != OptionsTree.this.myQueuedConfigurable) {
                    return;
                }
                if (configurable == null) {
                    OptionsTree.this.myTree.getSelectionModel().clearSelection();
                    ((OptionsTree)OptionsTree.this).myFilter.myContext.fireSelected(null, OptionsTree.this);
                } else {
                    OptionsTree.this.myBuilder.getReady((Object)this).doWhenDone(new Runnable(){

                        @Override
                        public void run() {
                            if (configurable != OptionsTree.this.myQueuedConfigurable) {
                                return;
                            }
                            EditorNode editorNode = OptionsTree.this.myConfigurable2Node.get(configurable);
                            FilteringTreeStructure.FilteringNode editorUiNode = OptionsTree.this.myBuilder.getVisibleNodeFor((Object)editorNode);
                            if (editorUiNode == null) {
                                return;
                            }
                            if (!OptionsTree.this.myBuilder.getSelectedElements().contains(editorUiNode)) {
                                OptionsTree.this.myBuilder.select((Object)editorUiNode, new Runnable(){

                                    @Override
                                    public void run() {
                                        OptionsTree.this.fireSelected(configurable, callback);
                                    }
                                });
                            } else {
                                OptionsTree.this.myBuilder.scrollSelectionToVisible(new Runnable(){

                                    @Override
                                    public void run() {
                                        OptionsTree.this.fireSelected(configurable, callback);
                                    }
                                }, false);
                            }
                        }
                    });
                }
            }

            public void setRejected() {
                super.setRejected();
                callback.setRejected();
            }
        };
        this.mySelection.queue(update);
        return callback;
    }

    private void fireSelected(Configurable configurable, ActionCallback callback) {
        this.myFilter.myContext.fireSelected(configurable, this).doWhenProcessed(callback.createSetDoneRunnable());
    }

    public JTree getTree() {
        return this.myTree;
    }

    public List<Configurable> getPathToRoot(Configurable configurable) {
        ArrayList<Configurable> path = new ArrayList<Configurable>();
        EditorNode eachNode = this.myConfigurable2Node.get(configurable);
        if (eachNode == null) {
            return path;
        }
        while (eachNode != null) {
            path.add(eachNode.getConfigurable());
            SimpleNode parent = eachNode.getParent();
            if (!(parent instanceof EditorNode)) break;
            eachNode = (EditorNode)parent;
        }
        return path;
    }

    public SimpleNode findNodeFor(Configurable toSelect) {
        return (SimpleNode)this.myConfigurable2Node.get(toSelect);
    }

    @Nullable
    public <T extends Configurable> T findConfigurable(Class<T> configurableClass) {
        for (Configurable configurable : this.myConfigurable2Node.keySet()) {
            if (!configurableClass.isInstance(configurable)) continue;
            return (T)((Configurable)configurableClass.cast(configurable));
        }
        return null;
    }

    @Nullable
    public SearchableConfigurable findConfigurableById(@NotNull String configurableId) {
        if (configurableId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableId", "com/intellij/openapi/options/newEditor/OptionsTree", "findConfigurableById"));
        }
        for (Configurable configurable : this.myConfigurable2Node.keySet()) {
            SearchableConfigurable searchableConfigurable;
            if (!(configurable instanceof SearchableConfigurable) || !configurableId.equals((searchableConfigurable = (SearchableConfigurable)configurable).getId())) continue;
            return searchableConfigurable;
        }
        return null;
    }

    @Nullable
    private Base extractNode(Object object) {
        DefaultMutableTreeNode uiNode;
        Object o;
        if (object instanceof DefaultMutableTreeNode && (o = (uiNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof FilteringTreeStructure.FilteringNode) {
            return (Base)((Object)((FilteringTreeStructure.FilteringNode)o).getDelegate());
        }
        return null;
    }

    private static boolean isInvisibleNode(Configurable child) {
        return child instanceof SearchableConfigurable.Parent && !((SearchableConfigurable.Parent)child).isVisible();
    }

    private static List<EditorNode> sort(List<EditorNode> c) {
        ArrayList<EditorNode> cc = new ArrayList<EditorNode>(c);
        Collections.sort(cc, new Comparator<EditorNode>(){

            @Override
            public int compare(EditorNode o1, EditorNode o2) {
                return OptionsTree.getConfigurableDisplayName(o1.getConfigurable()).compareToIgnoreCase(OptionsTree.getConfigurableDisplayName(o2.getConfigurable()));
            }
        });
        return cc;
    }

    private static String getConfigurableDisplayName(Configurable c) {
        String name = c.getDisplayName();
        return name != null ? name : "{ Unnamed Page:" + c.getClass().getSimpleName() + " }";
    }

    private List<EditorNode> buildChildren(Configurable configurable, SimpleNode parent, ConfigurableGroup group) {
        if (configurable instanceof Configurable.Composite) {
            Configurable[] kids = ((Configurable.Composite)configurable).getConfigurables();
            ArrayList<EditorNode> result = new ArrayList<EditorNode>(kids.length);
            for (Configurable child : kids) {
                result.add(new EditorNode(parent, child, group));
                this.myFilter.myContext.registerKid(configurable, child);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void dispose() {
        this.myQueuedConfigurable = null;
    }

    @Override
    public ActionCallback onSelected(Configurable configurable, Configurable oldConfigurable) {
        return this.queueSelection(configurable);
    }

    @Override
    public ActionCallback onModifiedAdded(Configurable colleague) {
        this.myTree.repaint();
        return new ActionCallback.Done();
    }

    @Override
    public ActionCallback onModifiedRemoved(Configurable configurable) {
        this.myTree.repaint();
        return new ActionCallback.Done();
    }

    @Override
    public ActionCallback onErrorsChanged() {
        return new ActionCallback.Done();
    }

    public void processTextEvent(KeyEvent e) {
        this.myTree.processKeyEvent(e);
    }

    Project getConfigurableProject(Configurable configurable) {
        if (configurable instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            return wrapper.getExtensionPoint().getProject();
        }
        return OptionsTree.getConfigurableProject((SimpleNode)this.myConfigurable2Node.get(configurable));
    }

    private static Project getConfigurableProject(SimpleNode node) {
        EditorNode editor;
        Configurable configurable;
        if (node == null) {
            return null;
        }
        if (node instanceof EditorNode && (configurable = (editor = (EditorNode)node).getConfigurable()) instanceof ConfigurableWrapper) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
            return wrapper.getExtensionPoint().getProject();
        }
        return OptionsTree.getConfigurableProject(node.getParent());
    }

    private static final class StickySeparator
    extends JComponent {
        private final SimpleTree myTree;
        private final JScrollPane myScroller;
        private final GroupSeparator mySeparator;

        public StickySeparator(SimpleTree tree) {
            this.myTree = tree;
            this.myScroller = ScrollPaneFactory.createScrollPane((Component)this.myTree);
            this.myScroller.setVerticalScrollBarPolicy(22);
            this.mySeparator = new GroupSeparator();
            this.add(this.myScroller);
        }

        @Override
        public void doLayout() {
            this.myScroller.setBounds(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            ConfigurableGroup group;
            super.paint(g);
            if (Registry.is((String)"ide.new.settings.dialog") && (group = this.getGroup(10 + this.mySeparator.getFont().getSize())) != null && group == this.getGroup(-10)) {
                this.mySeparator.configure(group, false);
                Rectangle bounds = this.myScroller.getViewport().getBounds();
                int height = this.mySeparator.getPreferredSize().height;
                if (bounds.height > height) {
                    bounds.height = height;
                }
                g.setColor(this.myTree.getBackground());
                if (g instanceof Graphics2D) {
                    int h = bounds.height / 3;
                    int y = bounds.y + bounds.height - h;
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height - h);
                    ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)y, (Color)g.getColor(), (float)0.0f, (float)(y + h), (Color)ColorUtil.toAlpha((Color)g.getColor(), (int)0)));
                    g.fillRect(bounds.x, y, bounds.width, h);
                } else {
                    g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                this.mySeparator.setSize(bounds.width - 1, bounds.height);
                this.mySeparator.paint(g.create(bounds.x + 1, bounds.y, bounds.width - 1, bounds.height));
            }
        }

        private ConfigurableGroup getGroup(int offset) {
            TreePath path = this.myTree.getClosestPathForLocation(-this.myTree.getX(), -this.myTree.getY() + offset);
            SimpleNode node = this.myTree.getNodeFor(path);
            if (node instanceof FilteringTreeStructure.FilteringNode) {
                Object delegate = ((FilteringTreeStructure.FilteringNode)node).getDelegate();
                while (delegate instanceof EditorNode) {
                    EditorNode editor = (EditorNode)((Object)delegate);
                    ConfigurableGroup group = editor.getGroup();
                    if (group != null) {
                        return group;
                    }
                    delegate = editor.getParent();
                }
            }
            return null;
        }
    }

    private static final class GroupSeparator
    extends JLabel {
        public static final int SPACE = 10;

        public GroupSeparator() {
            this.setFont(UIUtil.getLabelFont());
            this.setFont(this.getFont().deriveFont(1));
        }

        public void configure(ConfigurableGroup group, boolean isSpaceNeeded) {
            if (group == null) {
                this.setVisible(false);
            } else {
                this.setVisible(true);
                int bottom = UIUtil.isUnderNativeMacLookAndFeel() ? 1 : 3;
                int top = isSpaceNeeded ? bottom + 10 : bottom;
                this.setBorder(BorderFactory.createEmptyBorder(top, 3, bottom, 3));
                this.setText(group.getDisplayName());
            }
        }
    }

    private class MyBuilder
    extends FilteringTreeBuilder {
        List<Object> myToExpandOnResetFilter;
        boolean myRefilteringNow;
        boolean myWasHoldingFilter;

        public MyBuilder(SimpleTreeStructure structure) {
            super((Tree)OptionsTree.this.myTree, (ElementFilter)OptionsTree.this.myFilter, (AbstractTreeStructure)structure, (Comparator)new WeightBasedComparator(false));
            OptionsTree.this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                    MyBuilder.this.invalidateExpansions();
                }
            });
        }

        private void invalidateExpansions() {
            if (!this.myRefilteringNow) {
                this.myToExpandOnResetFilter = null;
            }
        }

        protected boolean isSelectable(Object nodeObject) {
            return nodeObject instanceof EditorNode;
        }

        public boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
            return ((OptionsTree)OptionsTree.this).myFilter.myContext.isHoldingFilter();
        }

        public boolean isToEnsureSelectionOnFocusGained() {
            return false;
        }

        protected ActionCallback refilterNow(Object preferredSelection, boolean adjustSelection) {
            final ArrayList<Object> toRestore = new ArrayList<Object>();
            if (((OptionsTree)OptionsTree.this).myFilter.myContext.isHoldingFilter() && !this.myWasHoldingFilter && this.myToExpandOnResetFilter == null) {
                this.myToExpandOnResetFilter = OptionsTree.this.myBuilder.getUi().getExpandedElements();
            } else if (!((OptionsTree)OptionsTree.this).myFilter.myContext.isHoldingFilter() && this.myWasHoldingFilter && this.myToExpandOnResetFilter != null) {
                toRestore.addAll(this.myToExpandOnResetFilter);
                this.myToExpandOnResetFilter = null;
            }
            this.myWasHoldingFilter = ((OptionsTree)OptionsTree.this).myFilter.myContext.isHoldingFilter();
            ActionCallback result = super.refilterNow(preferredSelection, adjustSelection);
            this.myRefilteringNow = true;
            return result.doWhenDone(new Runnable(){

                @Override
                public void run() {
                    MyBuilder.this.myRefilteringNow = false;
                    if (!((OptionsTree)OptionsTree.this).myFilter.myContext.isHoldingFilter() && MyBuilder.this.getSelectedElements().isEmpty()) {
                        MyBuilder.this.restoreExpandedState(toRestore);
                    }
                }
            });
        }

        private void restoreExpandedState(List<Object> toRestore) {
            TreePath[] selected = OptionsTree.this.myTree.getSelectionPaths();
            if (selected == null) {
                selected = new TreePath[]{};
            }
            ArrayList<TreePath> toCollapse = new ArrayList<TreePath>();
            for (int eachRow = 0; eachRow < OptionsTree.this.myTree.getRowCount(); ++eachRow) {
                Object eachElement;
                TreePath eachVisiblePath;
                if (!OptionsTree.this.myTree.isExpanded(eachRow) || (eachVisiblePath = OptionsTree.this.myTree.getPathForRow(eachRow)) == null || toRestore.contains(eachElement = OptionsTree.this.myBuilder.getElementFor(eachVisiblePath.getLastPathComponent()))) continue;
                for (TreePath eachSelected : selected) {
                    if (eachVisiblePath.isDescendant(eachSelected)) continue;
                    toCollapse.add(eachVisiblePath);
                }
            }
            for (TreePath each : toCollapse) {
                OptionsTree.this.myTree.collapsePath(each);
            }
        }
    }

    private class MyTree
    extends SimpleTree {
        private MyTree() {
            this.getInputMap().clear();
            this.setOpaque(true);
        }

        public final String getToolTipText(MouseEvent event) {
            if (event != null) {
                String text;
                JLabel label;
                Point point = event.getPoint();
                Component component = this.getDeepestRendererComponentAt(point.x, point.y);
                if (component instanceof JLabel && (label = (JLabel)component).getIcon() != null && (text = label.getToolTipText()) != null) {
                    return text;
                }
            }
            return super.getToolTipText(event);
        }

        protected boolean paintNodes() {
            return false;
        }

        protected boolean highlightSingleNode() {
            return false;
        }

        public void setUI(TreeUI ui) {
            Object actualUI = ui;
            if (!(ui instanceof MyTreeUi)) {
                actualUI = new MyTreeUi();
            }
            super.setUI(actualUI);
        }

        protected boolean isCustomUI() {
            return true;
        }

        protected void configureUiHelper(TreeUIHelper helper) {
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public void processKeyEvent(KeyEvent e) {
            TreePath path = OptionsTree.this.myTree.getSelectionPath();
            if (path != null) {
                if (e.getKeyCode() == 37) {
                    if (this.isExpanded(path)) {
                        this.collapsePath(path);
                        return;
                    }
                } else if (e.getKeyCode() == 39 && this.isCollapsed(path)) {
                    this.expandPath(path);
                    return;
                }
            }
            super.processKeyEvent(e);
        }

        protected void processMouseEvent(MouseEvent e) {
            Rectangle bounds;
            TreePath path;
            boolean toggleLater;
            MyTreeUi ui = (MyTreeUi)((Object)OptionsTree.this.myTree.getUI());
            boolean toggleNow = e.getID() == 502 && UIUtil.isActionClick((MouseEvent)e, (int)502) && !ui.isToggleEvent(e);
            boolean bl = toggleLater = e.getID() == 501;
            if ((toggleNow || toggleLater) && (path = this.getPathForLocation(e.getX(), e.getY())) != null && (bounds = this.getPathBounds(path)) != null && path.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                boolean selected = this.isPathSelected(path);
                boolean expanded = this.isExpanded(path);
                Component comp = OptionsTree.this.myRenderer.getTreeCellRendererComponent((JTree)((Object)this), node, selected, expanded, node.isLeaf(), this.getRowForPath(path), this.isFocusOwner());
                comp.setBounds(bounds);
                comp.validate();
                Point point = new Point(e.getX() - bounds.x, e.getY() - bounds.y);
                if (OptionsTree.this.myRenderer.isUnderHandle(point)) {
                    if (toggleNow) {
                        ui.toggleExpandState(path);
                        e.consume();
                        return;
                    }
                    if (toggleLater) {
                        e.consume();
                        return;
                    }
                }
            }
            super.processMouseEvent(e);
        }

        private class MyTreeUi
        extends WideSelectionTreeUI {
            private MyTreeUi() {
            }

            public void toggleExpandState(TreePath path) {
                super.toggleExpandState(path);
            }

            public boolean isToggleEvent(MouseEvent event) {
                return super.isToggleEvent(event);
            }

            protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
                return false;
            }

            protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            }

            protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
            }

            public void paint(Graphics g, JComponent c) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                super.paint(g, c);
            }
        }
    }

    class EditorNode
    extends Base {
        Configurable myConfigurable;
        ConfigurableGroup myGroup;

        EditorNode(SimpleNode parent, @Nullable Configurable configurable, ConfigurableGroup group) {
            super(parent);
            this.myConfigurable = configurable;
            this.myGroup = group;
            OptionsTree.this.myConfigurable2Node.put(configurable, this);
            this.addPlainText(OptionsTree.getConfigurableDisplayName(configurable));
        }

        protected EditorNode[] buildChildren() {
            List list = OptionsTree.this.buildChildren(this.myConfigurable, (SimpleNode)this, null);
            return list.isEmpty() ? EMPTY_EN_ARRAY : list.toArray(new EditorNode[list.size()]);
        }

        public boolean isAlwaysLeaf() {
            return !(this.myConfigurable instanceof Configurable.Composite);
        }

        public boolean isContentHighlighted() {
            return this.getParent() == OptionsTree.this.myRoot;
        }

        @Override
        Configurable getConfigurable() {
            return this.myConfigurable;
        }

        public int getWeight() {
            if (this.getParent() == OptionsTree.this.myRoot) {
                return Integer.MAX_VALUE - OptionsTree.this.myGroups.indexOf(this.myGroup);
            }
            return Integer.MIN_VALUE;
        }

        public ConfigurableGroup getGroup() {
            return this.myGroup;
        }

        @Override
        String getText() {
            return OptionsTree.getConfigurableDisplayName(this.myConfigurable).replace("\n", " ");
        }

        @Override
        boolean isModified() {
            return ((OptionsTree)OptionsTree.this).myFilter.myContext.getModified().contains(this.myConfigurable);
        }

        @Override
        boolean isError() {
            return ((OptionsTree)OptionsTree.this).myFilter.myContext.getErrors().containsKey(this.myConfigurable);
        }
    }

    class Root
    extends Base {
        Root() {
            super(null);
        }

        protected SimpleNode[] buildChildren() {
            ArrayList<EditorNode> result = new ArrayList<EditorNode>();
            for (ConfigurableGroup eachGroup : OptionsTree.this.myGroups) {
                result.addAll(this.buildGroup(eachGroup));
            }
            return result.isEmpty() ? NO_CHILDREN : result.toArray(new SimpleNode[result.size()]);
        }

        private List<EditorNode> buildGroup(ConfigurableGroup eachGroup) {
            ArrayList<EditorNode> result = new ArrayList<EditorNode>();
            Configurable[] kids = eachGroup.getConfigurables();
            if (kids.length > 0) {
                for (Configurable eachKid : kids) {
                    if (OptionsTree.isInvisibleNode(eachKid)) continue;
                    result.add(new EditorNode((SimpleNode)this, eachKid, eachGroup));
                }
            }
            return OptionsTree.sort(result);
        }
    }

    static abstract class Base
    extends CachingSimpleNode {
        protected Base(SimpleNode aParent) {
            super(aParent);
        }

        String getText() {
            return null;
        }

        boolean isModified() {
            return false;
        }

        boolean isError() {
            return false;
        }

        Configurable getConfigurable() {
            return null;
        }
    }

    class Renderer
    extends GroupedElementsRenderer.Tree {
        private GroupSeparator mySeparator;
        private JLabel myProjectIcon;
        private JLabel myHandle;

        Renderer() {
        }

        protected void layout() {
            this.myRendererComponent.setOpaqueActive(false);
            this.mySeparator = new GroupSeparator();
            this.myRendererComponent.add((Component)(Registry.is((String)"ide.new.settings.dialog") ? this.mySeparator : this.mySeparatorComponent), (Object)"North");
            NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myHandle = new JLabel("", 0);
            if (!SystemInfo.isMac) {
                this.myHandle.setBorder(new EmptyBorder(0, 2, 0, 2));
            }
            this.myHandle.setOpaque(false);
            content.add((Component)this.myHandle, (Object)"West");
            content.add((Component)this.myComponent, (Object)"Center");
            this.myProjectIcon = new JLabel(" ", 2);
            this.myProjectIcon.setOpaque(true);
            content.add((Component)this.myProjectIcon, (Object)"East");
            this.myRendererComponent.add((Component)content, (Object)"Center");
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            SimpleNode parent;
            JComponent result;
            Color fg = UIUtil.getTreeTextForeground();
            this.mySeparator.configure(null, false);
            Base base = OptionsTree.this.extractNode(value);
            if (base instanceof EditorNode) {
                TreePath path;
                EditorNode editor = (EditorNode)base;
                ConfigurableGroup group = null;
                if (editor.getParent() == OptionsTree.this.myRoot) {
                    DefaultMutableTreeNode prevValue = ((DefaultMutableTreeNode)value).getPreviousSibling();
                    if (prevValue == null || prevValue instanceof LoadingNode) {
                        group = editor.getGroup();
                        this.mySeparator.configure(group, false);
                    } else {
                        EditorNode prevEditor;
                        Base prevBase = OptionsTree.this.extractNode(prevValue);
                        if (prevBase instanceof EditorNode && (prevEditor = (EditorNode)prevBase).getGroup() != editor.getGroup()) {
                            group = editor.getGroup();
                            this.mySeparator.configure(group, true);
                        }
                    }
                }
                if ((path = tree.getPathForRow(row)) == null && value instanceof DefaultMutableTreeNode) {
                    path = new TreePath(((DefaultMutableTreeNode)value).getPath());
                }
                boolean toStretch = tree.isVisible() && path != null;
                int forcedWidth = 2000;
                if (toStretch) {
                    Rectangle visibleRect = tree.getVisibleRect();
                    int nestingLevel = tree.isRootVisible() ? path.getPathCount() - 1 : path.getPathCount() - 2;
                    int left = UIUtil.getTreeLeftChildIndent();
                    int right = UIUtil.getTreeRightChildIndent();
                    Insets treeInsets = tree.getInsets();
                    int indent = (left + right) * nestingLevel + (treeInsets != null ? treeInsets.left + treeInsets.right : 0);
                    forcedWidth = visibleRect.width > 0 ? visibleRect.width - indent : forcedWidth;
                }
                result = this.configureComponent(base.getText(), base.getText(), null, null, row == -1 || selected, group != null, group != null ? group.getDisplayName() : null, forcedWidth - 4);
                if (base.isError()) {
                    fg = JBColor.red;
                } else if (base.isModified()) {
                    fg = JBColor.blue;
                }
            } else {
                result = this.configureComponent(value.toString(), null, null, null, selected, false, null, -1);
            }
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                TreePath nodePath = new TreePath(node.getPath());
                this.myHandle.setIcon(((SimpleTree)tree).getHandleIcon(node, nodePath));
            } else {
                this.myHandle.setIcon(null);
            }
            this.myTextLabel.setForeground(selected ? UIUtil.getTreeSelectionForeground() : fg);
            this.myTextLabel.setOpaque(selected);
            if (Registry.is((String)"ide.new.settings.dialog")) {
                this.myTextLabel.setBorder(new EmptyBorder(1, 2, 1, 0));
            }
            Project project = null;
            if (base != null && Registry.is((String)"ide.new.settings.dialog") && (parent = base.getParent()) == OptionsTree.this.myRoot) {
                project = OptionsTree.getConfigurableProject((SimpleNode)base);
            }
            if (project != null) {
                this.myProjectIcon.setBackground(selected ? this.getSelectionBackground() : this.getBackground());
                this.myProjectIcon.setIcon(selected ? AllIcons.General.ProjectConfigurableSelected : AllIcons.General.ProjectConfigurable);
                this.myProjectIcon.setVisible(true);
                this.myProjectIcon.setToolTipText(OptionsBundle.message((String)(project.isDefault() ? "configurable.default.project.tooltip" : "configurable.current.project.tooltip"), (Object[])new Object[0]));
            } else {
                this.myProjectIcon.setVisible(false);
            }
            if (Registry.is((String)"ide.new.settings.dialog")) {
                result.setBackground(selected ? UIUtil.getTreeSelectionBackground() : UIUtil.getSidePanelColor());
            }
            return result;
        }

        protected JComponent createItemComponent() {
            this.myTextLabel = new ErrorLabel();
            return this.myTextLabel;
        }

        public boolean isUnderHandle(Point point) {
            Point handlePoint = SwingUtilities.convertPoint((Component)this.myRendererComponent, point, this.myHandle);
            Rectangle bounds = this.myHandle.getBounds();
            return bounds.x < handlePoint.x && bounds.getMaxX() >= (double)handlePoint.x;
        }
    }
}

