/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.ProjectManagerComponent");
    private static final boolean ourScheduleCacheUpdateInDumbMode = SystemProperties.getBooleanProperty((String)"idea.schedule.cache.update.in.dumb.mode", (boolean)true);
    private boolean myPointerChangesDetected = false;
    private int myInsideRefresh = 0;
    private final BatchUpdateListener myHandler;
    private final MessageBusConnection myConnection;
    protected final List<CacheUpdater> myRootsChangeUpdaters = new ArrayList<CacheUpdater>();
    protected final List<CacheUpdater> myRefreshCacheUpdaters = new ArrayList<CacheUpdater>();
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch = new THashSet();
    private final boolean myDoLogCachesUpdate;

    public ProjectRootManagerComponent(Project project, StartupManager startupManager) {
        super(project);
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1", "beforeFileTypesChanged"));
                }
                ProjectRootManagerComponent.this.beforeRootsChange(true);
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1", "fileTypesChanged"));
                }
                ProjectRootManagerComponent.this.rootsChanged(true);
            }
        });
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                ProjectRootManagerComponent.this.doUpdateOnRefresh();
            }
        }, (Disposable)project);
        startupManager.registerStartupActivity(new Runnable(){

            @Override
            public void run() {
                ProjectRootManagerComponent.this.myStartupActivityPerformed = true;
            }
        });
        this.myHandler = new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        };
        this.myConnection.subscribe(VirtualFilePointerListener.TOPIC, (Object)new MyVirtualFilePointerListener());
        this.myDoLogCachesUpdate = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    public void registerRootsChangeUpdater(CacheUpdater updater) {
        this.myRootsChangeUpdaters.add(updater);
    }

    public void unregisterRootsChangeUpdater(CacheUpdater updater) {
        boolean removed = this.myRootsChangeUpdaters.remove(updater);
        LOG.assertTrue(removed);
    }

    public void registerRefreshUpdater(CacheUpdater updater) {
        this.myRefreshCacheUpdaters.add(updater);
    }

    public void unregisterRefreshUpdater(CacheUpdater updater) {
        boolean removed = this.myRefreshCacheUpdaters.remove(updater);
        LOG.assertTrue(removed);
    }

    @Override
    public void initComponent() {
        super.initComponent();
        this.myConnection.subscribe(BatchUpdateListener.TOPIC, (Object)this.myHandler);
    }

    @Override
    public void projectOpened() {
        super.projectOpened();
        this.addRootsToWatch();
        AppListener applicationListener = new AppListener();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)applicationListener, (Disposable)this.myProject);
    }

    @Override
    public void projectClosed() {
        super.projectClosed();
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @Override
    protected void addRootsToWatch() {
        Pair<Set<String>, Set<String>> roots = this.getAllRoots(false);
        if (roots == null) {
            return;
        }
        this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)roots.first, (Collection)roots.second);
    }

    private void beforeRootsChange(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(fileTypes).beforeRootsChanged();
    }

    private void rootsChanged(boolean fileTypes) {
        this.getBatchSession(fileTypes).rootsChanged();
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (!this.myStartupActivityPerformed || this.myProject.isDisposed())) {
            return;
        }
        if (this.myProject.isDefault()) {
            return;
        }
        if (this.myDoLogCachesUpdate) {
            LOG.info("refresh");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task != null) {
            dumbService.queueTask(task);
        }
        if (this.myRefreshCacheUpdaters.size() == 0) {
            return;
        }
        if (ourScheduleCacheUpdateInDumbMode) {
            dumbService.queueCacheUpdateInDumbMode(this.myRefreshCacheUpdaters);
        } else {
            dumbService.queueCacheUpdate(this.myRefreshCacheUpdaters);
        }
    }

    private boolean affectsRoots(VirtualFilePointer[] pointers) {
        Pair<Set<String>, Set<String>> roots = this.getAllRoots(true);
        if (roots == null) {
            return false;
        }
        for (VirtualFilePointer pointer : pointers) {
            String path = ProjectRootManagerComponent.url2path(pointer.getUrl());
            if (!((Set)roots.first).contains(path) && !((Set)roots.second).contains(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireRootsChangedEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    private static String url2path(String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return path;
        }
        return path.substring(0, separatorIndex);
    }

    @Nullable
    private Pair<Set<String>, Set<String>> getAllRoots(boolean includeSourceRoots) {
        Module[] modules;
        if (this.myProject.isDefault()) {
            return null;
        }
        HashSet recursive = new HashSet();
        HashSet flat = new HashSet();
        String projectFilePath = this.myProject.getProjectFilePath();
        File projectDirFile = new File(projectFilePath).getParentFile();
        if (projectDirFile != null && projectDirFile.getName().equals(".idea")) {
            recursive.add(projectDirFile.getAbsolutePath());
        } else {
            flat.add(projectFilePath);
            VirtualFile workspaceFile = this.myProject.getWorkspaceFile();
            if (workspaceFile != null) {
                flat.add(workspaceFile.getPath());
            }
        }
        for (WatchedRootsProvider extension : (WatchedRootsProvider[])Extensions.getExtensions((ExtensionPointName)WatchedRootsProvider.EP_NAME, (AreaInstance)this.myProject)) {
            recursive.addAll(extension.getRootsToWatch());
        }
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            ProjectRootManagerComponent.addRootsToTrack(moduleRootManager.getContentRootUrls(), (Collection<String>)recursive, (Collection<String>)flat);
            if (includeSourceRoots) {
                ProjectRootManagerComponent.addRootsToTrack(moduleRootManager.getSourceRootUrls(), (Collection<String>)recursive, (Collection<String>)flat);
            }
            flat.add(module.getModuleFilePath());
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                        ProjectRootManagerComponent.addRootsToTrack(library.getUrls(orderRootType), (Collection<String>)recursive, (Collection<String>)flat);
                    }
                    continue;
                }
                if (!(entry instanceof JdkOrderEntry)) continue;
                for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
                    ProjectRootManagerComponent.addRootsToTrack(((JdkOrderEntry)entry).getRootUrls(orderRootType), (Collection<String>)recursive, (Collection<String>)flat);
                }
            }
        }
        return Pair.create((Object)recursive, (Object)flat);
    }

    @Override
    protected void doSynchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        if (this.myDoLogCachesUpdate) {
            LOG.info(new Throwable("sync roots"));
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        dumbService.queueTask(new UnindexedFilesUpdater(this.myProject, false));
        if (this.myRootsChangeUpdaters.isEmpty()) {
            return;
        }
        if (ourScheduleCacheUpdateInDumbMode) {
            dumbService.queueCacheUpdateInDumbMode(this.myRootsChangeUpdaters);
        } else {
            dumbService.queueCacheUpdate(this.myRootsChangeUpdaters);
        }
    }

    private static void addRootsToTrack(String[] urls, Collection<String> recursive, Collection<String> flat) {
        for (String url : urls) {
            if (url == null) continue;
            String protocol = VirtualFileManager.extractProtocol((String)url);
            if (protocol == null || "file".equals(protocol)) {
                recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            flat.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache.getInstance(this.myProject).clear();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        super.clearScopesCachesForModules();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleEx)module).clearScopesCache();
        }
    }

    private class MyVirtualFilePointerListener
    implements VirtualFilePointerListener {
        private MyVirtualFilePointerListener() {
        }

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$MyVirtualFilePointerListener", "beforeValidityChanged"));
            }
            if (!ProjectRootManagerComponent.this.myProject.isDisposed()) {
                if (ProjectRootManagerComponent.this.myInsideRefresh == 0) {
                    if (ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                        ProjectRootManagerComponent.this.beforeRootsChange(false);
                        if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                            LOG.info(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                        }
                    }
                } else if (!ProjectRootManagerComponent.this.myPointerChangesDetected && ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                    ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                    ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                    if (ProjectRootManagerComponent.this.myDoLogCachesUpdate) {
                        LOG.info(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                    }
                }
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointers", "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$MyVirtualFilePointerListener", "validityChanged"));
            }
            if (!ProjectRootManagerComponent.this.myProject.isDisposed()) {
                if (ProjectRootManagerComponent.this.myInsideRefresh > 0) {
                    ProjectRootManagerComponent.this.clearScopesCaches();
                } else if (ProjectRootManagerComponent.this.affectsRoots(pointers)) {
                    ProjectRootManagerComponent.this.rootsChanged(false);
                }
            }
        }
    }

    private class AppListener
    extends ApplicationAdapter {
        private AppListener() {
        }

        public void beforeWriteActionStart(Object action) {
            ProjectRootManagerComponent.this.myInsideRefresh++;
        }

        public void writeActionFinished(Object action) {
            if (--ProjectRootManagerComponent.this.myInsideRefresh == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                ProjectRootManagerComponent.this.doSynchronizeRoots();
                ProjectRootManagerComponent.this.addRootsToWatch();
            }
        }
    }
}

