/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesContainerFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory");
    private static final Library[] EMPTY_LIBRARIES_ARRAY = new Library[0];

    private LibrariesContainerFactory() {
    }

    @NotNull
    public static LibrariesContainer createContainer(@Nullable Project project) {
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(project, null, null);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, null);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        Module module = rootModel.getModule();
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, rootModel);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        return librariesContainerImpl;
    }

    public static LibrariesContainer createContainer(StructureConfigurableContext context) {
        return new StructureConfigurableLibrariesContainer(context);
    }

    public static Library createLibrary(@Nullable LibrariesContainer container1, @NotNull LibrariesContainer container2, @NotNull @NonNls NewLibraryEditor editor, @NotNull LibrariesContainer.LibraryLevel level) {
        if (container2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container2", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createLibrary"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createLibrary"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createLibrary"));
        }
        if (container1 != null && container1.canCreateLibrary(level)) {
            return container1.createLibrary(editor, level);
        }
        return container2.createLibrary(editor, level);
    }

    @NotNull
    private static Library createLibraryInTable(@NotNull NewLibraryEditor editor, LibraryTable table) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createLibraryInTable"));
        }
        LibraryTableBase.ModifiableModelEx modifiableModel = (LibraryTableBase.ModifiableModelEx)table.getModifiableModel();
        String name = StringUtil.isEmpty((String)editor.getName()) ? null : LibrariesContainerFactory.getUniqueLibraryName(editor.getName(), modifiableModel);
        LibraryType<?> type = editor.getType();
        Library library = modifiableModel.createLibrary(name, (PersistentLibraryKind)(type == null ? null : type.getKind()));
        LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        editor.applyTo(model);
        model.commit();
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createLibraryInTable"));
        }
        return library2;
    }

    private static String getUniqueLibraryName(String baseName, final LibraryTable.ModifiableModel model) {
        return UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", (String)" (", (String)")", (Condition)new Condition<String>(){

            public boolean value(String s) {
                return model.getLibraryByName(s) == null;
            }
        });
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        LibrariesContainer container;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        if (modulesProvider instanceof ModulesConfigurator) {
            ModulesConfigurator configurator = (ModulesConfigurator)modulesProvider;
            container = LibrariesContainerFactory.createContainer(configurator.getContext());
        } else {
            container = LibrariesContainerFactory.createContainer(context.getProject());
        }
        LibrariesContainer librariesContainer = container;
        if (librariesContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory", "createContainer"));
        }
        return librariesContainer;
    }

    private static class StructureConfigurableLibrariesContainer
    extends LibrariesContainerBase {
        private final StructureConfigurableContext myContext;

        public StructureConfigurableLibrariesContainer(StructureConfigurableContext context) {
            this.myContext = context;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            if (libraryEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryEditor", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "createLibrary"));
            }
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "createLibrary"));
            }
            LibraryTableModifiableModelProvider provider = this.getProvider(level);
            if (provider == null) {
                LOG.error("cannot create module library in this context");
            }
            LibraryTableBase.ModifiableModelEx model = (LibraryTableBase.ModifiableModelEx)provider.getModifiableModel();
            LibraryType<?> type = libraryEditor.getType();
            Library library = model.createLibrary(LibrariesContainerFactory.getUniqueLibraryName(libraryEditor.getName(), model), (PersistentLibraryKind)(type == null ? null : type.getKind()));
            ExistingLibraryEditor createdLibraryEditor = ((LibrariesModifiableModel)model).getLibraryEditor(library);
            createdLibraryEditor.setProperties(libraryEditor.getProperties());
            libraryEditor.applyTo(createdLibraryEditor);
            return library;
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryEditor"));
            }
            LibraryTable table = library.getTable();
            if (table == null) {
                return null;
            }
            LibraryTable.ModifiableModel model = this.myContext.getModifiableLibraryTable(table);
            if (model instanceof LibrariesModifiableModel) {
                return ((LibrariesModifiableModel)model).getLibraryEditor(library);
            }
            return null;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myContext.getProject();
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraries"));
            }
            LibraryTableModifiableModelProvider provider = this.getProvider(libraryLevel);
            Library[] libraryArray = provider != null ? provider.getModifiableModel().getLibraries() : EMPTY_LIBRARIES_ARRAY;
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraries"));
            }
            return libraryArray;
        }

        @Nullable
        private LibraryTableModifiableModelProvider getProvider(LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT) {
                return this.myContext.getProjectLibrariesProvider();
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return this.myContext.getGlobalLibrariesProvider();
            }
            return null;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "canCreateLibrary"));
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || level == LibrariesContainer.LibraryLevel.PROJECT;
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryFiles"));
            }
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryFiles"));
            }
            LibrariesModifiableModel projectLibrariesModel = this.myContext.getProjectLibrariesProvider().getModifiableModel();
            if (projectLibrariesModel.hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = projectLibrariesModel.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryFiles"));
                }
                return virtualFileArray;
            }
            LibrariesModifiableModel globalLibraries = this.myContext.getGlobalLibrariesProvider().getModifiableModel();
            if (globalLibraries.hasLibraryEditor(library)) {
                ExistingLibraryEditor libraryEditor = globalLibraries.getLibraryEditor(library);
                VirtualFile[] virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryFiles"));
                }
                return virtualFileArray;
            }
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer", "getLibraryFiles"));
            }
            return virtualFileArray;
        }
    }

    private static class LibrariesContainerImpl
    extends LibrariesContainerBase {
        @Nullable
        private final Project myProject;
        @Nullable
        private final Module myModule;
        @Nullable
        private final ModifiableRootModel myRootModel;

        private LibrariesContainerImpl(@Nullable Project project, @Nullable Module module, @Nullable ModifiableRootModel rootModel) {
            this.myProject = project;
            this.myModule = module;
            this.myRootModel = rootModel;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraries"));
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.myModule != null) {
                Library[] libraryArray = this.getModuleLibraries();
                if (libraryArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraries"));
                }
                return libraryArray;
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                Library[] libraryArray = registrar.getLibraryTable().getLibraries();
                if (libraryArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraries"));
                }
                return libraryArray;
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                Library[] libraryArray = registrar.getLibraryTable(this.myProject).getLibraries();
                if (libraryArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraries"));
                }
                return libraryArray;
            }
            Library[] libraryArray = EMPTY_LIBRARIES_ARRAY;
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraries"));
            }
            return libraryArray;
        }

        private Library[] getModuleLibraries() {
            if (this.myRootModel != null) {
                return this.myRootModel.getModuleLibraryTable().getLibraries();
            }
            OrderEntry[] orderEntries = ModuleRootManager.getInstance((Module)this.myModule).getOrderEntries();
            ArrayList<Library> libraries = new ArrayList<Library>();
            for (OrderEntry orderEntry : orderEntries) {
                LibraryOrderEntry entry;
                if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
                libraries.add(entry.getLibrary());
            }
            return libraries.toArray(new Library[libraries.size()]);
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraryFiles"));
            }
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraryFiles"));
            }
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraryFiles"));
            }
            return virtualFileArray;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "canCreateLibrary"));
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE) {
                return this.myRootModel != null;
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || this.myProject != null;
        }

        @Override
        public Library createLibrary(@NotNull NewLibraryEditor libraryEditor, @NotNull LibrariesContainer.LibraryLevel level) {
            LibraryTable table;
            if (libraryEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryEditor", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "createLibrary"));
            }
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "createLibrary"));
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE && this.myRootModel != null) {
                return LibrariesContainerFactory.createLibraryInTable(libraryEditor, this.myRootModel.getModuleLibraryTable());
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (level == LibrariesContainer.LibraryLevel.GLOBAL) {
                table = registrar.getLibraryTable();
            } else if (level == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                table = registrar.getLibraryTable(this.myProject);
            } else {
                return null;
            }
            return LibrariesContainerFactory.createLibraryInTable(libraryEditor, table);
        }

        @Override
        public ExistingLibraryEditor getLibraryEditor(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl", "getLibraryEditor"));
            }
            return null;
        }
    }

    private static abstract class LibrariesContainerBase
    implements LibrariesContainer {
        private UniqueNameGenerator myNameGenerator;

        private LibrariesContainerBase() {
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name, @NotNull LibrariesContainer.LibraryLevel level, @NotNull VirtualFile[] classRoots, @NotNull VirtualFile[] sourceRoots) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            if (classRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classRoots", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            if (sourceRoots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoots", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name);
            for (VirtualFile classRoot : classRoots) {
                editor.addRoot(classRoot, OrderRootType.CLASSES);
            }
            for (VirtualFile sourceRoot : sourceRoots) {
                editor.addRoot(sourceRoot, OrderRootType.SOURCES);
            }
            return this.createLibrary(editor, level);
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name, @NotNull LibrariesContainer.LibraryLevel level, @NotNull Collection<? extends OrderRoot> roots) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            if (level == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "createLibrary"));
            }
            NewLibraryEditor editor = new NewLibraryEditor();
            editor.setName(name);
            editor.addRoots(roots);
            return this.createLibrary(editor, level);
        }

        @Override
        @NotNull
        public Library[] getAllLibraries() {
            Object[] moduleLibraries;
            Object[] libraries = this.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL);
            Object[] projectLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.PROJECT);
            if (projectLibraries.length > 0) {
                libraries = (Library[])ArrayUtil.mergeArrays((Object[])libraries, (Object[])projectLibraries);
            }
            if ((moduleLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.MODULE)).length > 0) {
                libraries = (Library[])ArrayUtil.mergeArrays((Object[])libraries, (Object[])moduleLibraries);
            }
            if (libraries == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "getAllLibraries"));
            }
            return libraries;
        }

        @Override
        @NotNull
        public List<LibrariesContainer.LibraryLevel> getAvailableLevels() {
            ArrayList<LibrariesContainer.LibraryLevel> levels = new ArrayList<LibrariesContainer.LibraryLevel>();
            for (LibrariesContainer.LibraryLevel level : LibrariesContainer.LibraryLevel.values()) {
                if (!this.canCreateLibrary(level)) continue;
                levels.add(level);
            }
            ArrayList<LibrariesContainer.LibraryLevel> arrayList = levels;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "getAvailableLevels"));
            }
            return arrayList;
        }

        @Override
        @NotNull
        public String suggestUniqueLibraryName(@NotNull String baseName) {
            if (baseName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "suggestUniqueLibraryName"));
            }
            if (this.myNameGenerator == null) {
                this.myNameGenerator = new UniqueNameGenerator(Arrays.asList(this.getAllLibraries()), (Function)new Function<Library, String>(){

                    public String fun(Library o) {
                        return o.getName();
                    }
                });
            }
            String string = this.myNameGenerator.generateUniqueName(baseName, "", "", " (", ")");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase", "suggestUniqueLibraryName"));
            }
            return string;
        }
    }
}

