/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.RepositoryChangesBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkHtmlRenderer;
import com.intellij.openapi.vcs.history.CopyRevisionNumberAction;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeListImpl;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListViewerDialog
extends DialogWrapper
implements DataProvider {
    private Project myProject;
    private CommittedChangeList myChangeList;
    private RepositoryChangesBrowser myChangesBrowser;
    private JEditorPane myCommitMessageArea;
    private final boolean myInAir;
    private Change[] myChanges;
    private NotNullFunction<Change, Change> myConvertor;
    private JScrollPane commitMessageScroll;
    private VirtualFile myToSelect;

    public ChangeListViewerDialog(Project project, CommittedChangeList changeList) {
        super(project, true);
        this.myInAir = false;
        this.initCommitMessageArea(project, changeList);
        this.initDialog(project, changeList);
    }

    public ChangeListViewerDialog(Project project, CommittedChangeList changeList, VirtualFile toSelect) {
        super(project, true);
        this.myInAir = false;
        this.myToSelect = toSelect;
        this.initCommitMessageArea(project, changeList);
        this.initDialog(project, changeList);
    }

    public ChangeListViewerDialog(Component parent, Project project, Collection<Change> changes, boolean inAir) {
        super(parent, true);
        this.myInAir = inAir;
        this.initDialog(project, (CommittedChangeList)new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes));
    }

    public ChangeListViewerDialog(Project project, Collection<Change> changes, boolean inAir) {
        super(project, true);
        this.myInAir = inAir;
        this.initDialog(project, (CommittedChangeList)new CommittedChangeListImpl("", "", "", -1L, new Date(0L), changes));
    }

    private void initDialog(Project project, CommittedChangeList changeList) {
        this.myProject = project;
        this.myChangeList = changeList;
        Collection changes = this.myChangeList.getChanges();
        this.myChanges = changes.toArray(new Change[changes.size()]);
        this.setTitle(VcsBundle.message((String)"dialog.title.changes.browser", (Object[])new Object[0]));
        this.setCancelButtonText(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]));
        this.setModal(false);
        this.init();
    }

    private void initCommitMessageArea(Project project, CommittedChangeList changeList) {
        this.myCommitMessageArea = new JEditorPane("text/html", "");
        this.myCommitMessageArea.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.myCommitMessageArea.setEditable(false);
        String text = IssueLinkHtmlRenderer.formatTextIntoHtml(project, changeList.getComment().trim());
        this.myCommitMessageArea.setBackground(UIUtil.getComboBoxDisabledBackground());
        this.myCommitMessageArea.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.commitMessageScroll = ScrollPaneFactory.createScrollPane((Component)this.myCommitMessageArea);
        this.myCommitMessageArea.setText(text);
        this.myCommitMessageArea.setCaretPosition(0);
    }

    protected String getDimensionServiceKey() {
        return "VCS.ChangeListViewerDialog";
    }

    public Object getData(@NonNls String dataId) {
        if (VcsDataKeys.CHANGES.is(dataId)) {
            return this.myChanges;
        }
        if (VcsDataKeys.VCS_REVISION_NUMBER.is(dataId) && this.myChangeList instanceof VcsRevisionNumberAware) {
            return ((VcsRevisionNumberAware)this.myChangeList).getRevisionNumber();
        }
        return null;
    }

    public void setConvertor(NotNullFunction<Change, Change> convertor) {
        this.myConvertor = convertor;
    }

    public JComponent createCenterPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        Splitter splitter = new Splitter(true, 0.8f);
        this.myChangesBrowser = new RepositoryChangesBrowser(this.myProject, Collections.singletonList(this.myChangeList), new ArrayList(this.myChangeList.getChanges()), (ChangeList)this.myChangeList, this.myToSelect){

            @Override
            protected void buildToolBar(DefaultActionGroup toolBarGroup) {
                super.buildToolBar(toolBarGroup);
                toolBarGroup.add((AnAction)new CopyRevisionNumberAction());
            }

            @Override
            public Object getData(@NonNls String dataId) {
                Object data = super.getData(dataId);
                if (data != null) {
                    return data;
                }
                return ChangeListViewerDialog.this.getData(dataId);
            }

            @Override
            protected void showDiffForChanges(Change[] changesArray, int indexInSelection) {
                if (ChangeListViewerDialog.this.myInAir && ChangeListViewerDialog.this.myConvertor != null) {
                    Change[] convertedChanges = new Change[changesArray.length];
                    for (int i = 0; i < changesArray.length; ++i) {
                        Change change = changesArray[i];
                        convertedChanges[i] = (Change)ChangeListViewerDialog.this.myConvertor.fun((Object)change);
                    }
                    super.showDiffForChanges(convertedChanges, indexInSelection);
                } else {
                    super.showDiffForChanges(changesArray, indexInSelection);
                }
            }
        };
        this.myChangesBrowser.setUseCase(this.myInAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
        splitter.setFirstComponent((JComponent)this.myChangesBrowser);
        if (this.myCommitMessageArea != null) {
            JPanel commitPanel = new JPanel(new BorderLayout());
            TitledSeparator separator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myCommitMessageArea);
            commitPanel.add((Component)separator, "North");
            commitPanel.add((Component)this.commitMessageScroll, "Center");
            splitter.setSecondComponent((JComponent)commitPanel);
        }
        mainPanel.add((Component)splitter, "Center");
        String description = this.getDescription();
        if (description != null) {
            JPanel descPanel = new JPanel();
            descPanel.add(new JLabel(XmlStringUtil.wrapInHtml((CharSequence)description)));
            descPanel.setBorder(BorderFactory.createEtchedBorder());
            mainPanel.add((Component)descPanel, "North");
        }
        return mainPanel;
    }

    protected void dispose() {
        this.myChangesBrowser.dispose();
        super.dispose();
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/ChangeListViewerDialog", "createActions"));
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myChangesBrowser.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getDescription() {
        return null;
    }
}

