/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.core.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.TreeAspectEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.CommitToPsiFileAction;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.text.BlockSupportImpl;
import com.intellij.psi.impl.source.text.DiffLog;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.text.BlockSupport;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelImpl
extends UserDataHolderBase
implements PomModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.pom.core.impl.PomModelImpl");
    private final Project myProject;
    private final Map<Class<? extends PomModelAspect>, PomModelAspect> myAspects = new HashMap<Class<? extends PomModelAspect>, PomModelAspect>();
    private final Map<PomModelAspect, List<PomModelAspect>> myIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Map<PomModelAspect, List<PomModelAspect>> myInvertedIncidence = new HashMap<PomModelAspect, List<PomModelAspect>>();
    private final Collection<PomModelListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Stack<Pair<PomModelAspect, PomTransaction>> myBlockedAspects = new Stack();
    private static volatile boolean allowPsiModification = true;

    public PomModelImpl(Project project) {
        this.myProject = project;
    }

    public <T extends PomModelAspect> T getModelAspect(@NotNull Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "getModelAspect"));
        }
        return (T)this.myAspects.get(aClass);
    }

    public void registerAspect(@NotNull Class<? extends PomModelAspect> aClass, @NotNull PomModelAspect aspect, @NotNull Set<PomModelAspect> dependencies) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (aspect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aspect", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/intellij/pom/core/impl/PomModelImpl", "registerAspect"));
        }
        this.myAspects.put(aClass, aspect);
        Iterator<PomModelAspect> iterator = dependencies.iterator();
        ArrayList<PomModelAspect> deps = new ArrayList<PomModelAspect>();
        while (iterator.hasNext()) {
            PomModelAspect depend = iterator.next();
            deps.addAll(this.getAllDependencies(depend));
        }
        deps.add(aspect);
        for (PomModelAspect pomModelAspect : deps) {
            List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(pomModelAspect);
            if (pomModelAspects != null) {
                pomModelAspects.add(aspect);
                continue;
            }
            this.myInvertedIncidence.put(pomModelAspect, new ArrayList<PomModelAspect>(Collections.singletonList(aspect)));
        }
        this.myIncidence.put(aspect, deps);
    }

    private List<PomModelAspect> getAllDependencies(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    private List<PomModelAspect> getAllDependants(PomModelAspect aspect) {
        List<PomModelAspect> pomModelAspects = this.myInvertedIncidence.get(aspect);
        return pomModelAspects != null ? pomModelAspects : Collections.emptyList();
    }

    public void addModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.myListeners.add(listener);
    }

    public void addModelListener(final @NotNull PomModelListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/pom/core/impl/PomModelImpl", "addModelListener"));
        }
        this.addModelListener(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                PomModelImpl.this.removeModelListener(listener);
            }
        });
    }

    public void removeModelListener(@NotNull PomModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/pom/core/impl/PomModelImpl", "removeModelListener"));
        }
        this.myListeners.remove(listener);
    }

    /*
     * Exception decompiling
     */
    public void runTransaction(@NotNull PomTransaction transaction) throws IncorrectOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK], 21[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Pair<PomModelAspect, PomTransaction> getBlockingTransaction(PomModelAspect aspect, PomTransaction transaction) {
        List<PomModelAspect> allDependants = this.getAllDependants(aspect);
        for (PomModelAspect pomModelAspect : allDependants) {
            ListIterator blocksIterator = this.myBlockedAspects.listIterator(this.myBlockedAspects.size());
            while (blocksIterator.hasPrevious()) {
                Pair pair = (Pair)blocksIterator.previous();
                if (pomModelAspect != pair.getFirst() || !PsiTreeUtil.isAncestor((PsiElement)((PomTransaction)pair.getSecond()).getChangeScope(), (PsiElement)transaction.getChangeScope(), (boolean)false) || PomModelImpl.getContainingFileByTree(((PomTransaction)pair.getSecond()).getChangeScope()) == null) continue;
                return pair;
            }
        }
        return null;
    }

    private void commitTransaction(PomTransaction transaction) {
        Document document;
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(transaction.getChangeScope());
        Document document2 = document = containingFileByTree != null ? manager.getCachedDocument(containingFileByTree) : null;
        if (document != null) {
            int oldLength = containingFileByTree.getTextLength();
            boolean success = synchronizer.commitTransaction(document);
            if (success) {
                BlockSupportImpl.sendAfterChildrenChangedEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), containingFileByTree, oldLength, true);
            }
        }
        if (containingFileByTree != null) {
            boolean isFromCommit;
            boolean bl = isFromCommit = ApplicationManager.getApplication().isDispatchThread() && ApplicationManager.getApplication().hasWriteAction(CommitToPsiFileAction.class);
            if (!isFromCommit && !synchronizer.isIgnorePsiEvents()) {
                this.reparseParallelTrees(containingFileByTree);
            }
        }
        if (progressIndicator != null) {
            progressIndicator.finishNonCancelableSection();
        }
    }

    private void reparseParallelTrees(PsiFile changedFile) {
        List allFiles = changedFile.getViewProvider().getAllFiles();
        if (allFiles.size() <= 1) {
            return;
        }
        CharSequence newText = changedFile.getNode().getChars();
        for (PsiFile file : allFiles) {
            FileElement fileElement;
            if (file == changedFile || (fileElement = ((PsiFileImpl)file).getTreeElement()) == null) continue;
            this.reparseFile(file, fileElement, newText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseFile(final PsiFile file, FileElement treeElement, CharSequence newText) {
        PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject)).getSynchronizer();
        TextRange changedPsiRange = DocumentCommitProcessor.getChangedPsiRange(file, treeElement, newText);
        if (changedPsiRange == null) {
            return;
        }
        final DiffLog log = BlockSupport.getInstance(this.myProject).reparseRange(file, changedPsiRange, newText, (ProgressIndicator)new EmptyProgressIndicator());
        synchronizer.setIgnorePsiEvents(true);
        try {
            CodeStyleManager.getInstance((Project)file.getProject()).performActionWithFormatterDisabled(new Runnable(){

                @Override
                public void run() {
                    PomModelImpl.this.runTransaction((PomTransaction)new PomTransactionBase((PsiElement)file, PomModelImpl.this.getModelAspect(TreeAspect.class)){

                        @Nullable
                        public PomModelEvent runInner() throws IncorrectOperationException {
                            return new TreeAspectEvent(PomModelImpl.this, log.performActualPsiChange(file));
                        }
                    });
                }
            });
        }
        finally {
            synchronizer.setIgnorePsiEvents(false);
        }
    }

    private void startTransaction(@NotNull PomTransaction transaction) {
        Document document;
        if (transaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/pom/core/impl/PomModelImpl", "startTransaction"));
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.startNonCancelableSection();
        }
        PsiDocumentManagerBase manager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance((Project)this.myProject);
        PsiToDocumentSynchronizer synchronizer = manager.getSynchronizer();
        PsiElement changeScope = transaction.getChangeScope();
        LOG.assertTrue(changeScope != null);
        PsiFile containingFileByTree = PomModelImpl.getContainingFileByTree(changeScope);
        if (changeScope.isPhysical() && synchronizer.toProcessPsiEvent() && this.isDocumentUncommitted(containingFileByTree)) {
            throw new IllegalStateException("Attempt to modify PSI for non-committed Document!");
        }
        BlockSupportImpl.sendBeforeChildrenChangeEvent((PsiManagerImpl)PsiManager.getInstance((Project)this.myProject), changeScope, true);
        Document document2 = document = containingFileByTree == null ? null : manager.getCachedDocument(containingFileByTree);
        if (document != null) {
            synchronizer.startTransaction(this.myProject, document, changeScope);
        }
    }

    private boolean isDocumentUncommitted(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document cachedDocument = manager.getCachedDocument(file);
        return cachedDocument != null && manager.isUncommited(cachedDocument);
    }

    @Nullable
    private static PsiFile getContainingFileByTree(@NotNull PsiElement changeScope) {
        PsiFile psiFile;
        if (changeScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeScope", "com/intellij/pom/core/impl/PomModelImpl", "getContainingFileByTree"));
        }
        ASTNode node = changeScope.getNode();
        if (node == null) {
            psiFile = changeScope.getContainingFile();
        } else {
            FileElement fileElement = TreeUtil.getFileElement((TreeElement)node);
            if (fileElement == null) {
                return null;
            }
            psiFile = (PsiFile)fileElement.getPsi();
        }
        return psiFile.getNode() != null ? psiFile : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void guardPsiModificationsIn(@NotNull ThrowableRunnable<T> runnable) throws T {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/pom/core/impl/PomModelImpl", "guardPsiModificationsIn"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean old = allowPsiModification;
        try {
            allowPsiModification = false;
            runnable.run();
        }
        finally {
            allowPsiModification = old;
        }
    }
}

