/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemberOrderService {
    @Nullable
    public PsiElement getAnchor(@NotNull PsiElement member, @NotNull CommonCodeStyleSettings settings, @NotNull PsiElement context) {
        PsiElement element;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/codeStyle/arrangement/MemberOrderService", "getAnchor"));
        }
        Language language = context.getLanguage();
        Rearranger rearranger = (Rearranger)Rearranger.EXTENSION.forLanguage(language);
        if (rearranger == null) {
            return null;
        }
        ArrangementSettings arrangementSettings = settings.getArrangementSettings();
        if (arrangementSettings == null && rearranger instanceof ArrangementStandardSettingsAware) {
            arrangementSettings = ((ArrangementStandardSettingsAware)rearranger).getDefaultSettings();
        }
        if (arrangementSettings == null) {
            return null;
        }
        Pair pair = rearranger.parseWithNew(context, null, Collections.singleton(context.getTextRange()), member, arrangementSettings);
        if (pair == null || ((List)pair.second).isEmpty()) {
            return null;
        }
        ArrangementEntry memberEntry = (ArrangementEntry)pair.first;
        List entries = (List)pair.second;
        ArrangementEntry parentEntry = (ArrangementEntry)entries.get(0);
        List nonArranged = parentEntry.getChildren();
        ArrayList<ArrangementEntry> entriesWithNew = new ArrayList<ArrangementEntry>(nonArranged);
        entriesWithNew.add(memberEntry);
        List rulesByPriority = arrangementSettings.getRulesSortedByPriority();
        List arranged = ArrangementEngine.arrange(entriesWithNew, arrangementSettings.getSections(), rulesByPriority, null);
        int i = arranged.indexOf(memberEntry);
        if (i <= 0) {
            return context;
        }
        ArrangementEntry anchorEntry = null;
        if (i >= arranged.size() - 1) {
            anchorEntry = (ArrangementEntry)nonArranged.get(nonArranged.size() - 1);
        } else {
            ArrangementEntry entry;
            HashSet entriesBelow = new HashSet();
            entriesBelow.addAll(arranged.subList(i + 1, arranged.size()));
            Iterator i$ = nonArranged.iterator();
            while (i$.hasNext() && !entriesBelow.contains(entry = (ArrangementEntry)i$.next())) {
                anchorEntry = entry;
            }
        }
        if (anchorEntry == null) {
            return context;
        }
        int offset = anchorEntry.getEndOffset() - 1 - context.getTextRange().getStartOffset();
        for (PsiElement e = element = context.findElementAt(offset); e != null && e.getTextRange().getStartOffset() >= anchorEntry.getStartOffset(); e = e.getParent()) {
            element = e;
        }
        return element;
    }
}

