/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.autodetect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.autodetect.IndentOptionsDetector;
import com.intellij.psi.codeStyle.autodetect.IndentUsageInfo;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatistics;
import com.intellij.psi.codeStyle.autodetect.IndentUsageStatisticsImpl;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfo;
import com.intellij.psi.codeStyle.autodetect.LineIndentInfoBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IndentOptionsDetectorImpl
implements IndentOptionsDetector {
    private static Logger LOG = Logger.getInstance((String)"#com.intellij.psi.codeStyle.CommonCodeStyleSettings.IndentOptionsDetector");
    private static final double RATE_THRESHOLD = 0.8;
    private static final int MAX_INDENT_TO_DETECT = 8;
    private final PsiFile myFile;
    private final Project myProject;
    private final Document myDocument;

    public IndentOptionsDetectorImpl(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "<init>"));
        }
        this.myFile = file;
        this.myProject = file.getProject();
        this.myDocument = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myFile);
    }

    @NotNull
    public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
        CommonCodeStyleSettings.IndentOptions indentOptions = (CommonCodeStyleSettings.IndentOptions)CodeStyleSettingsManager.getSettings((Project)this.myProject).getIndentOptions(this.myFile.getFileType()).clone();
        if (this.myDocument != null) {
            List<LineIndentInfo> linesInfo = new LineIndentInfoBuilder(this.myDocument.getCharsSequence()).build();
            IndentUsageStatisticsImpl stats = new IndentUsageStatisticsImpl(linesInfo);
            this.adjustIndentOptions(indentOptions, stats);
        }
        CommonCodeStyleSettings.IndentOptions indentOptions2 = indentOptions;
        if (indentOptions2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "getIndentOptions"));
        }
        return indentOptions2;
    }

    private void adjustIndentOptions(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @NotNull IndentUsageStatistics stats) {
        int linesWithWhiteSpaceIndent;
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "adjustIndentOptions"));
        }
        if (stats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stats", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "adjustIndentOptions"));
        }
        int linesWithTabs = stats.getTotalLinesWithLeadingTabs();
        if (linesWithTabs > (linesWithWhiteSpaceIndent = stats.getTotalLinesWithLeadingSpaces())) {
            this.setUseTabs(indentOptions, true);
        } else if (linesWithWhiteSpaceIndent > linesWithTabs) {
            this.setUseTabs(indentOptions, false);
            int newIndentSize = IndentOptionsDetectorImpl.getPositiveIndentSize(stats);
            if (newIndentSize > 0 && indentOptions.INDENT_SIZE != newIndentSize) {
                indentOptions.INDENT_SIZE = newIndentSize;
                LOG.info("Detected indent size: " + newIndentSize + " for file " + this.myFile);
            }
        }
    }

    private void setUseTabs(@NotNull CommonCodeStyleSettings.IndentOptions indentOptions, boolean useTabs) {
        if (indentOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indentOptions", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "setUseTabs"));
        }
        if (indentOptions.USE_TAB_CHARACTER != useTabs) {
            indentOptions.USE_TAB_CHARACTER = useTabs;
            LOG.info("Tab usage set to " + useTabs + " for file " + this.myFile);
        }
    }

    private static int getPositiveIndentSize(@NotNull IndentUsageStatistics stats) {
        double usageRate;
        if (stats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stats", "com/intellij/psi/codeStyle/autodetect/IndentOptionsDetectorImpl", "getPositiveIndentSize"));
        }
        int totalIndentSizesDetected = stats.getTotalIndentSizesDetected();
        if (totalIndentSizesDetected == 0) {
            return -1;
        }
        IndentUsageInfo maxUsedIndentInfo = stats.getKMostUsedIndentInfo(0);
        int maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        if (maxUsedIndentSize == 0) {
            if (totalIndentSizesDetected < 2) {
                return -1;
            }
            maxUsedIndentInfo = stats.getKMostUsedIndentInfo(1);
            maxUsedIndentSize = maxUsedIndentInfo.getIndentSize();
        }
        if (maxUsedIndentSize <= 8 && (usageRate = (double)maxUsedIndentInfo.getTimesUsed() / (double)stats.getTotalLinesWithLeadingSpaces()) > 0.8) {
            return maxUsedIndentSize;
        }
        return -1;
    }
}

