/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class InvertBooleanHandler
implements RefactoringActionHandler {
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"invert.boolean.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof PsiMethod) {
            InvertBooleanHandler.invoke((PsiMethod)element, project, editor);
        } else if (element instanceof PsiVariable) {
            InvertBooleanHandler.invoke((PsiVariable)element, project, editor);
        } else {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.variable.name")), (String)REFACTORING_NAME, (String)"refactoring.invertBoolean");
        }
    }

    private static void invoke(PsiVariable var, Project project, Editor editor) {
        PsiMethod method;
        PsiMethod superMethod;
        PsiType returnType = var.getType();
        if (!PsiType.BOOLEAN.equals((Object)returnType)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invert.boolean.wrong.type")), (String)REFACTORING_NAME, (String)"refactoring.invertBoolean");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)var)) {
            return;
        }
        if (var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiMethod && (superMethod = SuperMethodWarningUtil.checkSuperMethod(method = (PsiMethod)((PsiParameter)var).getDeclarationScope(), RefactoringBundle.message((String)"to.refactor"))) != null) {
            var = superMethod.getParameterList().getParameters()[method.getParameterList().getParameterIndex((PsiParameter)var)];
        }
        new InvertBooleanDialog((PsiNamedElement)var).show();
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/invertBoolean/InvertBooleanHandler", "invoke"));
        }
        if (elements.length == 1) {
            if (elements[0] instanceof PsiMethod) {
                InvertBooleanHandler.invoke((PsiMethod)elements[0], project, null);
            } else if (elements[0] instanceof PsiVariable) {
                InvertBooleanHandler.invoke((PsiVariable)elements[0], project, null);
            }
        }
    }

    private static void invoke(PsiMethod method, Project project, Editor editor) {
        PsiType returnType = method.getReturnType();
        if (!PsiType.BOOLEAN.equals((Object)returnType)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invert.boolean.wrong.type")), (String)REFACTORING_NAME, (String)"refactoring.invertBoolean");
            return;
        }
        PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
        if (superMethod != null) {
            method = superMethod;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        new InvertBooleanDialog((PsiNamedElement)method).show();
    }
}

