/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.ui;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.refactoring.RefactoringBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;

public class YesNoPreviewUsagesDialog
extends DialogWrapper {
    private JCheckBox myCbPreviewResults;
    private final boolean myToPreviewUsages;
    private final String myMessage;
    private final String myHelpID;

    public YesNoPreviewUsagesDialog(String title, String message, boolean previewUsages, String helpID, Project project) {
        super(project, false);
        this.myHelpID = helpID;
        this.setTitle(title);
        this.myMessage = message;
        this.myToPreviewUsages = previewUsages;
        this.setOKButtonText(RefactoringBundle.message((String)"yes.button"));
        this.setCancelButtonText(RefactoringBundle.message((String)"no.button"));
        this.setButtonsAlignment(0);
        this.init();
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel(this.myMessage);
        label.setUI((LabelUI)new MultiLineLabelUI());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "Center");
        Icon icon = Messages.getQuestionIcon();
        if (icon != null) {
            label.setIcon(icon);
            label.setIconTextGap(7);
        }
        return panel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public boolean isPreviewUsages() {
        return this.myCbPreviewResults.isSelected();
    }

    protected JComponent createSouthPanel() {
        this.myCbPreviewResults = new JCheckBox();
        this.myCbPreviewResults.setSelected(this.myToPreviewUsages);
        this.myCbPreviewResults.setText(RefactoringBundle.message((String)"preview.usages.to.be.changed"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.createSouthPanel(), "Center");
        panel.add((Component)this.myCbPreviewResults, "West");
        return panel;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myHelpID != null) {
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/YesNoPreviewUsagesDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/ui/YesNoPreviewUsagesDialog", "createActions"));
        }
        return actionArray;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }
}

