/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import java.util.HashMap;
import javax.swing.JOptionPane;

class MatchConstraintsSink
implements MatchResultSink {
    private final MatchResultSink delegate;
    private MatchingProcess process;
    private final boolean distinct;
    private final boolean caseSensitive;
    private int matchCount;
    private final int maxMatches;
    private final HashMap<Object, MatchResult> matches = new HashMap();

    MatchConstraintsSink(MatchResultSink _delegate, int _maxMatches, boolean distinct, boolean _caseSensitive) {
        this.delegate = _delegate;
        this.maxMatches = _maxMatches;
        this.distinct = distinct;
        this.caseSensitive = _caseSensitive;
    }

    @Override
    public void newMatch(MatchResult result) {
        if (this.distinct) {
            String matchImage = result.getMatchImage();
            if (!this.caseSensitive) {
                matchImage = matchImage.toLowerCase();
            }
            if (this.matches.get(matchImage) != null) {
                return;
            }
            this.matches.put(matchImage, result);
        } else {
            PsiElement match = result.getMatch();
            if (this.matches.containsKey(match)) {
                return;
            }
            this.matches.put(match, result);
        }
        this.delegate.newMatch(result);
        ++this.matchCount;
        if (this.matchCount == this.maxMatches) {
            JOptionPane.showMessageDialog(null, SSRBundle.message("search.produced.too.many.results.message", new Object[0]));
            this.process.stop();
        }
    }

    @Override
    public void processFile(PsiFile element) {
        this.delegate.processFile(element);
    }

    @Override
    public void setMatchingProcess(MatchingProcess matchingProcess) {
        this.process = matchingProcess;
        this.delegate.setMatchingProcess(this.process);
    }

    @Override
    public void matchingFinished() {
        this.matchCount = 0;
        this.matches.clear();
        this.delegate.matchingFinished();
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return this.delegate.getProgressIndicator();
    }
}

