/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchConstraintsSink;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatcherImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.structuralsearch.impl.matcher.MatcherImpl");
    private final Project project;
    private final MatchContext matchContext;
    private boolean isTesting;
    private final GlobalMatchingVisitor visitor = new GlobalMatchingVisitor();
    private ProgressIndicator progress;
    private final TaskScheduler scheduler = new TaskScheduler();
    private int totalFilesToScan;
    private int scannedFilesCount;
    private static java.lang.ref.SoftReference<LastMatchData> lastMatchData;

    public MatcherImpl(Project project, MatchOptions matchOptions) {
        this.project = project;
        this.matchContext = new MatchContext();
        this.matchContext.setMatcher(this.visitor);
        if (matchOptions != null) {
            this.matchContext.setOptions(matchOptions);
            this.cacheCompiledPattern(matchOptions, PatternCompiler.compilePattern(project, matchOptions));
        }
    }

    protected MatcherImpl(Project project) {
        this(project, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validate(Project project, MatchOptions options) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Class<MatcherImpl> clazz = MatcherImpl.class;
        synchronized (MatcherImpl.class) {
            LastMatchData data = new LastMatchData();
            data.lastPattern = PatternCompiler.compilePattern(project, options);
            data.lastOptions = options;
            lastMatchData = new java.lang.ref.SoftReference<LastMatchData>(data);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(options.getFileType());
            profile.checkSearchPattern(project, options);
            return;
        }
    }

    public static boolean checkIfShouldAttemptToMatch(MatchContext context, NodeIterator matchedNodes) {
        CompiledPattern pattern = context.getPattern();
        NodeIterator patternNodes = pattern.getNodes();
        try {
            while (true) {
                PsiElement patternNode;
                if ((patternNode = patternNodes.current()) == null) {
                    boolean bl = true;
                    return bl;
                }
                PsiElement matchedNode = matchedNodes.current();
                if (matchedNode == null) {
                    boolean bl = false;
                    return bl;
                }
                MatchingHandler matchingHandler = pattern.getHandler(patternNode);
                if (matchingHandler == null || !matchingHandler.canMatch(patternNode, matchedNode)) {
                    boolean bl = false;
                    return bl;
                }
                matchedNodes.advance();
                patternNodes.advance();
            }
        }
        finally {
            patternNodes.reset();
            matchedNodes.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMatchesInElement(MatchContext context, Configuration configuration, NodeIterator matchedNodes, PairProcessor<MatchResult, Configuration> processor) {
        try {
            this.configureOptions(context, configuration, matchedNodes.current(), processor);
            context.setShouldRecursivelyMatch(false);
            this.visitor.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
        }
    }

    public void clearContext() {
        this.matchContext.clear();
    }

    private void configureOptions(MatchContext context, final Configuration configuration, PsiElement psiFile, final PairProcessor<MatchResult, Configuration> processor) {
        if (psiFile == null) {
            return;
        }
        LocalSearchScope scope = new LocalSearchScope(psiFile);
        this.matchContext.clear();
        this.matchContext.setMatcher(this.visitor);
        MatchOptions options = context.getOptions();
        this.matchContext.setOptions(options);
        this.matchContext.setPattern(context.getPattern());
        this.matchContext.setShouldRecursivelyMatch(context.shouldRecursivelyMatch());
        this.visitor.setMatchContext(this.matchContext);
        this.matchContext.setSink(new MatchConstraintsSink(new MatchResultSink(){

            @Override
            public void newMatch(MatchResult result) {
                processor.process((Object)result, (Object)configuration);
            }

            @Override
            public void processFile(PsiFile element) {
            }

            @Override
            public void setMatchingProcess(MatchingProcess matchingProcess) {
            }

            @Override
            public void matchingFinished() {
            }

            @Override
            public ProgressIndicator getProgressIndicator() {
                return null;
            }
        }, options.getMaxMatchesCount(), options.isDistinct(), options.isCaseSensitiveMatch()));
        options.setScope((SearchScope)scope);
    }

    public CompiledOptions precompileOptions(List<Configuration> configurations) {
        final ArrayList<Pair<MatchContext, Configuration>> contexts = new ArrayList<Pair<MatchContext, Configuration>>();
        for (final Configuration configuration : configurations) {
            final MatchContext matchContext = new MatchContext();
            matchContext.setMatcher(this.visitor);
            final MatchOptions matchOptions = configuration.getMatchOptions();
            matchContext.setOptions(matchOptions);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        CompiledPattern compiledPattern = PatternCompiler.compilePattern(MatcherImpl.this.project, matchOptions);
                        matchContext.setPattern(compiledPattern);
                        contexts.add(Pair.create((Object)matchContext, (Object)configuration));
                    }
                    catch (UnsupportedPatternException ignored) {
                    }
                    catch (MalformedPatternException malformedPatternException) {
                        // empty catch block
                    }
                }
            });
        }
        return new CompiledOptions(contexts);
    }

    Project getProject() {
        return this.project;
    }

    protected void findMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        if (compiledPattern == null) {
            return;
        }
        this.matchContext.getSink().setMatchingProcess(this.scheduler);
        this.scheduler.init();
        this.progress = this.matchContext.getSink().getProgressIndicator();
        if (this.isTesting) {
            PsiElement[] elements = ((LocalSearchScope)options.getScope()).getScope();
            PsiElement parent = elements[0].getParent();
            if (elements.length > 0 && this.matchContext.getPattern().getStrategy().continueMatching(parent != null ? parent : elements[0])) {
                this.visitor.matchContext(new SsrFilteringNodeIterator(new ArrayBackedNodeIterator(elements)));
            } else {
                for (PsiElement element : elements) {
                    this.match(element);
                }
            }
            this.matchContext.getSink().matchingFinished();
            return;
        }
        if (!this.findMatches(options, compiledPattern)) {
            return;
        }
        if (this.scheduler.getTaskQueueEndAction() == null) {
            this.scheduler.setTaskQueueEndAction(new Runnable(){

                @Override
                public void run() {
                    MatcherImpl.this.matchContext.getSink().matchingFinished();
                }
            });
        }
        this.scheduler.executeNext();
    }

    private boolean findMatches(MatchOptions options, CompiledPattern compiledPattern) {
        boolean ourOptimizedScope;
        LanguageFileType languageFileType = (LanguageFileType)options.getFileType();
        final StructuralSearchProfile profile = StructuralSearchUtil.getProfileByLanguage(languageFileType.getLanguage());
        assert (profile != null);
        PsiElement node = compiledPattern.getNodes().current();
        final Language ourPatternLanguage = node != null ? profile.getLanguage(node) : ((LanguageFileType)options.getFileType()).getLanguage();
        final Language ourPatternLanguage2 = ourPatternLanguage == StdLanguages.XML ? StdLanguages.XHTML : null;
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl = ourOptimizedScope = searchScope != null;
        if (!ourOptimizedScope) {
            searchScope = options.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            final GlobalSearchScope scope = (GlobalSearchScope)searchScope;
            final ContentIterator ci = new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    if (!fileOrDir.isDirectory() && scope.contains(fileOrDir) && fileOrDir.getFileType() != FileTypes.UNKNOWN) {
                        ++MatcherImpl.this.totalFilesToScan;
                        MatcherImpl.this.scheduler.addOneTask(new MatchOneVirtualFile(fileOrDir, profile, ourPatternLanguage, ourPatternLanguage2));
                    }
                    return true;
                }
            };
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    FileBasedIndex.getInstance().iterateIndexableFiles(ci, MatcherImpl.this.project, MatcherImpl.this.progress);
                }
            });
            this.progress.setText2("");
        } else {
            PsiElement[] elementsToScan = ((LocalSearchScope)searchScope).getScope();
            this.totalFilesToScan = elementsToScan.length;
            for (int i = 0; i < elementsToScan.length; ++i) {
                PsiFile file;
                PsiElement psiElement = elementsToScan[i];
                if (psiElement == null) continue;
                Language language = psiElement.getLanguage();
                PsiFile psiFile = file = psiElement instanceof PsiFile ? (PsiFile)psiElement : psiElement.getContainingFile();
                if (profile.isMyFile(file, language, ourPatternLanguage, ourPatternLanguage2)) {
                    this.scheduler.addOneTask(new MatchOnePsiFile(psiElement));
                }
                if (!ourOptimizedScope) continue;
                elementsToScan[i] = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompiledPattern prepareMatching(MatchResultSink sink, final MatchOptions options) {
        CompiledPattern savedPattern = null;
        if (this.matchContext.getOptions() == options && this.matchContext.getPattern() != null && this.matchContext.getOptions().hashCode() == this.matchContext.getPattern().getOptionsHashStamp()) {
            savedPattern = this.matchContext.getPattern();
        }
        this.matchContext.clear();
        this.matchContext.setSink(new MatchConstraintsSink(sink, options.getMaxMatchesCount(), options.isDistinct(), options.isCaseSensitiveMatch()));
        this.matchContext.setOptions(options);
        this.matchContext.setMatcher(this.visitor);
        this.visitor.setMatchContext(this.matchContext);
        CompiledPattern compiledPattern = savedPattern;
        if (compiledPattern == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                LastMatchData data = (LastMatchData)SoftReference.dereference(lastMatchData);
                if (data != null && options == data.lastOptions) {
                    compiledPattern = data.lastPattern;
                }
                lastMatchData = null;
            }
            if (compiledPattern == null) {
                compiledPattern = (CompiledPattern)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompiledPattern>(){

                    public CompiledPattern compute() {
                        return PatternCompiler.compilePattern(MatcherImpl.this.project, options);
                    }
                });
            }
        }
        this.cacheCompiledPattern(options, compiledPattern);
        return compiledPattern;
    }

    private void cacheCompiledPattern(MatchOptions options, CompiledPattern compiledPattern) {
        this.matchContext.setPattern(compiledPattern);
        compiledPattern.setOptionsHashStamp(options.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testFindMatches(MatchResultSink sink, MatchOptions options) throws MalformedPatternException, UnsupportedPatternException {
        this.isTesting = true;
        try {
            this.findMatches(sink, options);
        }
        finally {
            this.isTesting = false;
        }
    }

    protected List<MatchResult> testFindMatches(String source, String pattern, MatchOptions options, boolean filePattern, FileType sourceFileType, String sourceExtension, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        try {
            PsiElement[] elements = MatcherImplUtil.createSourceTreeFromText(source, filePattern ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceExtension, this.project, physicalSourceFile);
            options.setSearchPattern(pattern);
            options.setScope((SearchScope)new LocalSearchScope(elements));
            this.testFindMatches(sink, options);
        }
        catch (IncorrectOperationException e) {
            MalformedPatternException exception = new MalformedPatternException();
            exception.initCause(e);
            throw exception;
        }
        return sink.getMatches();
    }

    protected List<MatchResult> testFindMatches(String source, String pattern, MatchOptions options, boolean filePattern) {
        return this.testFindMatches(source, pattern, options, filePattern, options.getFileType(), null, false);
    }

    public void match(PsiElement element) {
        MatchingStrategy strategy = this.matchContext.getPattern().getStrategy();
        if (strategy.continueMatching(element)) {
            this.visitor.matchContext(new ArrayBackedNodeIterator(new PsiElement[]{element}));
            return;
        }
        for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
            this.match(el);
        }
        if (element instanceof PsiLanguageInjectionHost) {
            InjectedLanguageUtil.enumerate(element, new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                    if (injectedPsi == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$7", "visit"));
                    }
                    if (places == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/structuralsearch/impl/matcher/MatcherImpl$7", "visit"));
                    }
                    MatcherImpl.this.match((PsiElement)injectedPsi);
                }
            });
        }
    }

    @Nullable
    protected MatchResult isMatchedByDownUp(PsiElement element, MatchOptions options) {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        CompiledPattern compiledPattern = this.prepareMatching(sink, options);
        if (compiledPattern == null) {
            assert (false);
            return null;
        }
        PsiElement targetNode = compiledPattern.getTargetNode();
        PsiElement elementToStartMatching = null;
        if (targetNode == null) {
            targetNode = compiledPattern.getNodes().current();
            if (targetNode != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                while (element.getClass() != targetNode.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    return null;
                }
                elementToStartMatching = element;
            }
        } else {
            targetNode = StructuralSearchUtil.getProfileByPsiElement(element).extendMatchedByDownUp(targetNode);
            MatchingHandler handler = null;
            while (element.getClass() == targetNode.getClass() || compiledPattern.isTypedVar(targetNode) && compiledPattern.getHandler(targetNode).canMatch(targetNode, element)) {
                handler = compiledPattern.getHandler(targetNode);
                handler.setPinnedElement(element);
                elementToStartMatching = element;
                if (handler instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                targetNode = targetNode.getParent();
                if (!options.isLooseMatching()) continue;
                element = StructuralSearchUtil.getProfileByPsiElement(element).updateCurrentNode(element);
                targetNode = StructuralSearchUtil.getProfileByPsiElement(element).updateCurrentNode(targetNode);
            }
            if (!(handler instanceof TopLevelMatchingHandler)) {
                return null;
            }
        }
        assert (targetNode != null) : "Could not match down up when no target node";
        this.match(elementToStartMatching);
        this.matchContext.getSink().matchingFinished();
        int matchCount = sink.getMatches().size();
        assert (matchCount <= 1);
        return matchCount > 0 ? sink.getMatches().get(0) : null;
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile myFileOrDir;
        private final StructuralSearchProfile myProfile;
        private final Language myOurPatternLanguage;
        private final Language myOurPatternLanguage2;

        public MatchOneVirtualFile(VirtualFile fileOrDir, StructuralSearchProfile profile, Language ourPatternLanguage, Language ourPatternLanguage2) {
            this.myFileOrDir = fileOrDir;
            this.myProfile = profile;
            this.myOurPatternLanguage = ourPatternLanguage;
            this.myOurPatternLanguage2 = ourPatternLanguage2;
        }

        @Override
        @Nullable
        protected List<PsiElement> getPsiElementsToProcess() {
            return (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<PsiElement>>(){

                public List<PsiElement> compute() {
                    PsiFile file = PsiManager.getInstance((Project)MatcherImpl.this.project).findFile(MatchOneVirtualFile.this.myFileOrDir);
                    if (file == null) {
                        return null;
                    }
                    FileViewProvider viewProvider = file.getViewProvider();
                    SmartList elementsToProcess = new SmartList();
                    for (Language lang : viewProvider.getLanguages()) {
                        if (!MatchOneVirtualFile.this.myProfile.isMyFile(file, lang, MatchOneVirtualFile.this.myOurPatternLanguage, MatchOneVirtualFile.this.myOurPatternLanguage2)) continue;
                        elementsToProcess.add(viewProvider.getPsi(lang));
                    }
                    return elementsToProcess;
                }
            });
        }
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            List<PsiElement> files = this.getPsiElementsToProcess();
            if (MatcherImpl.this.progress != null) {
                MatcherImpl.this.progress.setFraction((double)MatcherImpl.this.scannedFilesCount / (double)MatcherImpl.this.totalFilesToScan);
            }
            ++MatcherImpl.this.scannedFilesCount;
            if (files == null || files.size() == 0) {
                return;
            }
            final PsiFile psiFile = files.get(0).getContainingFile();
            if (psiFile != null) {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                if (MatcherImpl.this.project.isDisposed()) {
                                    return;
                                }
                                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)MatcherImpl.this.project);
                                Document document = manager.getDocument(psiFile);
                                if (document != null) {
                                    manager.commitDocument(document);
                                }
                            }
                        });
                    }
                };
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    action.run();
                } else {
                    ApplicationManager.getApplication().invokeAndWait(action, ModalityState.defaultModalityState());
                }
            }
            if (MatcherImpl.this.project.isDisposed()) {
                return;
            }
            for (PsiElement file : files) {
                if (file instanceof PsiFile) {
                    MatcherImpl.this.matchContext.getSink().processFile((PsiFile)file);
                }
                final PsiElement finalFile = file;
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        PsiElement file = finalFile;
                        if (!file.isValid()) {
                            return;
                        }
                        file = StructuralSearchUtil.getProfileByLanguage(file.getLanguage()).extendMatchOnePsiFile(file);
                        MatcherImpl.this.match(file);
                    }
                });
            }
        }

        @Nullable
        protected abstract List<PsiElement> getPsiElementsToProcess();
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement file;

        MatchOnePsiFile(PsiElement file) {
            this.file = file;
        }

        @Override
        @Nullable
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement file = this.file;
            this.file = null;
            return new SmartList((Object)file);
        }
    }

    class TaskScheduler
    implements MatchingProcess {
        private LinkedList<Runnable> tasks = new LinkedList();
        private boolean ended;
        private Runnable taskQueueEndAction;
        private boolean suspended;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.ended = true;
        }

        @Override
        public void pause() {
            this.suspended = true;
        }

        @Override
        public void resume() {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
            this.executeNext();
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public boolean isEnded() {
            return this.ended;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.taskQueueEndAction = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.taskQueueEndAction;
        }

        void addOneTask(Runnable runnable) {
            this.tasks.add(runnable);
        }

        private void executeNext() {
            while (!this.suspended && !this.ended) {
                if (this.tasks.isEmpty()) {
                    this.ended = true;
                    break;
                }
                Runnable task = this.tasks.removeFirst();
                try {
                    task.run();
                }
                catch (ProcessCanceledException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (StructuralSearchException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (Throwable th) {
                    LOG.error(th);
                }
            }
            if (this.ended) {
                this.clearSchedule();
            }
        }

        private void init() {
            this.ended = false;
            this.suspended = false;
            PsiManager.getInstance((Project)MatcherImpl.this.project).startBatchFilesProcessingMode();
        }

        private void clearSchedule() {
            if (this.tasks != null) {
                this.taskQueueEndAction.run();
                if (!MatcherImpl.this.project.isDisposed()) {
                    PsiManager.getInstance((Project)MatcherImpl.this.project).finishBatchFilesProcessingMode();
                }
                this.tasks = null;
            }
        }
    }

    public static class CompiledOptions {
        public final List<Pair<MatchContext, Configuration>> matchContexts;

        public CompiledOptions(List<Pair<MatchContext, Configuration>> matchContexts) {
            this.matchContexts = matchContexts;
        }

        public List<Pair<MatchContext, Configuration>> getMatchContexts() {
            return this.matchContexts;
        }
    }

    static class LastMatchData {
        CompiledPattern lastPattern;
        MatchOptions lastOptions;

        LastMatchData() {
        }
    }
}

