/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.fixtures.LightPlatformCodeInsightFixtureTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class FileEditorManagerTestCase
extends LightPlatformCodeInsightFixtureTestCase {
    protected FileEditorManagerImpl myManager;
    private FileEditorManager myOldManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myManager = new FileEditorManagerImpl(this.getProject(), DockManager.getInstance((Project)this.getProject()), EditorHistoryManager.getInstance(this.getProject()));
        this.myOldManager = ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, this.myManager);
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
    }

    @Override
    protected void tearDown() throws Exception {
        ((ComponentManagerImpl)this.getProject()).registerComponentInstance(FileEditorManager.class, this.myOldManager);
        this.myManager.closeAllFiles();
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        super.tearDown();
    }

    @Override
    protected boolean isWriteActionRequired() {
        return false;
    }

    protected VirtualFile getFile(String path) {
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file);
        return file;
    }

    protected void openFiles(String s) throws IOException, JDOMException, InterruptedException, ExecutionException {
        Document document = JDOMUtil.loadDocument((CharSequence)s);
        Element rootElement = document.getRootElement();
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        this.myManager.readExternal(rootElement);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        FileEditorManagerTestCase.this.myManager.getMainSplitters().openFiles();
                    }
                });
            }
        });
        while (true) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }
}

