/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ErrorLabel;
import com.intellij.ui.GroupedElementsRenderer;
import com.intellij.ui.components.panels.OpaquePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class GroupedItemsListRenderer
extends GroupedElementsRenderer.List
implements ListCellRenderer {
    protected ListItemDescriptor myDescriptor;
    protected JLabel myNextStepLabel;

    public JLabel getNextStepLabel() {
        return this.myNextStepLabel;
    }

    public GroupedItemsListRenderer(ListItemDescriptor descriptor) {
        this.myDescriptor = descriptor;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String caption = this.myDescriptor.getCaptionAboveOf(value);
        boolean hasSeparator = this.myDescriptor.hasSeparatorAboveOf(value);
        if (index == 0 && StringUtil.isEmptyOrSpaces((String)caption)) {
            hasSeparator = false;
        }
        Icon icon = this.myDescriptor.getIconFor(value);
        JComponent result = this.configureComponent(this.myDescriptor.getTextFor(value), this.myDescriptor.getTooltipFor(value), icon, icon, isSelected, hasSeparator, caption, -1);
        this.customizeComponent(list, value, isSelected);
        return result;
    }

    protected JComponent createItemComponent() {
        this.myTextLabel = new ErrorLabel();
        this.myTextLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.myTextLabel.setOpaque(true);
        return this.layoutComponent(this.myTextLabel);
    }

    protected final JComponent layoutComponent(JComponent middleItemComponent) {
        OpaquePanel result = new OpaquePanel((LayoutManager)(Registry.is((String)"ide.new.project.settings") ? new BorderLayout(0, 0) : new BorderLayout(4, 4)), Color.white);
        this.myNextStepLabel = new JLabel();
        this.myNextStepLabel.setOpaque(true);
        result.add((Component)middleItemComponent, "Center");
        result.add((Component)this.myNextStepLabel, "East");
        result.setBorder(this.getDefaultItemComponentBorder());
        return result;
    }

    protected void customizeComponent(JList list, Object value, boolean isSelected) {
    }
}

