/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.OrphanGuardian;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntStack;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IJSwingUtilities
extends JBSwingUtilities {
    private static final Consumer<JComponent> UI_TREE_UPDATER = new Consumer<JComponent>(){

        public void consume(JComponent component) {
            IJSwingUtilities.updateComponentTreeUI0(component);
        }
    };

    public static void invoke(Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
        }
    }

    public static boolean hasFocus(Component component) {
        Component focusOwner = IJSwingUtilities.findFocusOwner(component);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean hasFocus2(Component component) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        Window activeWindow = null;
        if (windowManager != null) {
            activeWindow = windowManager.getMostRecentFocusedWindow();
        }
        if (activeWindow == null) {
            return false;
        }
        Component focusedComponent = windowManager.getFocusedComponent(activeWindow);
        if (focusedComponent == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusedComponent, component);
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static Iterator<Component> getParents(final Component component) {
        return new Iterator<Component>(){
            private Component myCurrent;
            {
                this.myCurrent = component;
            }

            @Override
            public boolean hasNext() {
                return this.myCurrent != null && this.myCurrent.getParent() != null;
            }

            @Override
            public Component next() {
                this.myCurrent = this.myCurrent.getParent();
                return this.myCurrent;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator<Component> getChildren(final Container component) {
        return new Iterator<Component>(){
            private Container myCurrentParent;
            private final TIntStack myState;
            private int myCurrentIndex;
            {
                this.myCurrentParent = component;
                this.myState = new TIntStack();
                this.myCurrentIndex = 0;
            }

            @Override
            public boolean hasNext() {
                return this.hasNextChild();
            }

            @Override
            public Component next() {
                Container container;
                Component next = this.myCurrentParent.getComponent(this.myCurrentIndex);
                ++this.myCurrentIndex;
                if (next instanceof Container && (container = (Container)next).getComponentCount() > 0) {
                    this.myState.push(this.myCurrentIndex);
                    this.myCurrentIndex = 0;
                    this.myCurrentParent = container;
                }
                while (!this.hasNextChild() && this.myState.size() != 0) {
                    this.myCurrentIndex = this.myState.pop();
                    this.myCurrentParent = this.myCurrentParent.getParent();
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean hasNextChild() {
                return this.myCurrentParent.getComponentCount() > this.myCurrentIndex;
            }
        };
    }

    @Nullable
    public static <T extends Component> T findParentOfType(Component focusOwner, Class<T> aClass) {
        return (T)((Component)ContainerUtil.find(IJSwingUtilities.getParents(focusOwner), (Condition)FilteringIterator.instanceOf(aClass)));
    }

    @Nullable
    public static Component findParentByInterface(Component focusOwner, Class aClass) {
        return (Component)ContainerUtil.find(IJSwingUtilities.getParents(focusOwner), (Condition)FilteringIterator.instanceOf((Class)aClass));
    }

    public static void adjustComponentsOnMac(@Nullable JComponent component) {
        IJSwingUtilities.adjustComponentsOnMac(null, component);
    }

    public static void adjustComponentsOnMac(@Nullable JLabel label, @Nullable JComponent component) {
        if (component == null) {
            return;
        }
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            return;
        }
        if (component instanceof JComboBox) {
            UIUtil.addInsets((JComponent)component, (Insets)new Insets(0, -2, 0, 0));
            if (label != null) {
                UIUtil.addInsets((JComponent)label, (Insets)new Insets(0, 2, 0, 0));
            }
        }
        if (component instanceof JCheckBox) {
            UIUtil.addInsets((JComponent)component, (Insets)new Insets(0, -5, 0, 0));
        }
        if ((component instanceof JTextField || component instanceof EditorTextField) && label != null) {
            UIUtil.addInsets((JComponent)label, (Insets)new Insets(0, 3, 0, 0));
        }
    }

    public static HyperlinkEvent createHyperlinkEvent(@Nullable String href, @NotNull Object source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IJSwingUtilities", "createHyperlinkEvent"));
        }
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new HyperlinkEvent(source, HyperlinkEvent.EventType.ACTIVATED, url, href);
    }

    public static void updateComponentTreeUI(Component c) {
        IJSwingUtilities.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    private static void updateComponentTreeUI0(Component c) {
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (Component aChildren : children) {
                IJSwingUtilities.updateComponentTreeUI0(aChildren);
            }
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            OrphanGuardian orphans = (OrphanGuardian)jc.getClientProperty(OrphanGuardian.CLIENT_PROPERTY_KEY);
            if (orphans != null) {
                orphans.iterateOrphans(UI_TREE_UPDATER);
            }
            jc.updateUI();
            JPopupMenu jpm = jc.getComponentPopupMenu();
            if (jpm != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                IJSwingUtilities.updateComponentTreeUI(jpm);
            }
        }
    }

    public static void moveMousePointerOn(Component component) {
        if (component != null && component.isShowing()) {
            UISettings settings;
            UISettings uISettings = settings = ApplicationManager.getApplication() == null ? null : UISettings.getInstance();
            if (settings != null && settings.MOVE_MOUSE_ON_DEFAULT_BUTTON) {
                Point point = component.getLocationOnScreen();
                int dx = component.getWidth() / 2;
                int dy = component.getHeight() / 2;
                try {
                    new Robot().mouseMove(point.x + dx, point.y + dy);
                }
                catch (AWTException ignored) {
                    // empty catch block
                }
            }
        }
    }
}

