/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.indexing.DebugAssertions;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.ValueContainerImpl;
import gnu.trove.TIntObjectHashMap;

class FileId2ValueMapping<Value> {
    private TIntObjectHashMap<Value> id2ValueMap = new TIntObjectHashMap();
    private ValueContainerImpl<Value> valueContainer;

    FileId2ValueMapping(ValueContainerImpl<Value> _valueContainer) {
        this.valueContainer = _valueContainer;
        ValueContainer.ValueIterator<Value> valueIterator = _valueContainer.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            ValueContainer.IntIterator intIterator = valueIterator.getInputIdsIterator();
            while (intIterator.hasNext()) {
                this.associateFileIdToValue(intIterator.next(), value);
            }
        }
    }

    void associateFileIdToValue(int fileId, Value value) {
        Object previousValue = this.id2ValueMap.put(fileId, value);
        if (previousValue != null) {
            this.valueContainer.removeValue(fileId, previousValue);
        }
    }

    boolean removeFileId(int inputId) {
        Object mapped = this.id2ValueMap.remove(inputId);
        if (mapped != null) {
            this.valueContainer.removeValue(inputId, mapped);
        }
        if (DebugAssertions.EXTRA_SANITY_CHECKS) {
            ValueContainer.ValueIterator<Value> valueIterator = this.valueContainer.getValueIterator();
            while (valueIterator.hasNext()) {
                valueIterator.next();
                DebugAssertions.assertTrue(!valueIterator.getValueAssociationPredicate().contains(inputId));
            }
        }
        return mapped != null;
    }
}

