/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogHashMap
implements Disposable {
    private static final File LOG_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-log");
    private static final Logger LOG = Logger.getInstance(VcsLogHashMap.class);
    private final PersistentEnumerator<Hash> myPersistentEnumerator;

    VcsLogHashMap(@NotNull Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsLogHashMap", "<init>"));
        }
        final File myMapFile = new File(LOG_CACHE_APP_DIR, project.getName() + "." + project.getLocationHash());
        Disposer.register((Disposable)project, (Disposable)this);
        this.myPersistentEnumerator = (PersistentEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentEnumerator<Hash>, IOException>(){

            public PersistentEnumerator<Hash> compute() throws IOException {
                return new PersistentEnumerator(myMapFile, (KeyDescriptor)new MyHashKeyDescriptor(), 4096);
            }
        }, (File)myMapFile);
    }

    @Nullable
    private Hash doGetHash(int index) throws IOException {
        return (Hash)this.myPersistentEnumerator.valueOf(index);
    }

    private int getOrPut(@NotNull Hash hash) throws IOException {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMap", "getOrPut"));
        }
        return this.myPersistentEnumerator.enumerate((Object)hash);
    }

    public int getCommitIndex(@NotNull Hash hash) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMap", "getCommitIndex"));
        }
        try {
            return this.getOrPut(hash);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Hash getHash(int commitIndex) {
        Hash hash;
        try {
            Hash hash2 = this.doGetHash(commitIndex);
            if (hash2 == null) {
                throw new RuntimeException("Unknown commit index: " + commitIndex);
            }
            hash = hash2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMap", "getHash"));
        }
        return hash;
    }

    @Nullable
    public Hash findHashByString(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/VcsLogHashMap", "findHashByString"));
        }
        final String pHash = string.toLowerCase();
        try {
            return this.findHash(new Condition<Hash>(){

                public boolean value(@NotNull Hash hash) {
                    if (hash == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/VcsLogHashMap$2", "value"));
                    }
                    return hash.toString().toLowerCase().startsWith(pHash);
                }
            });
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public NotNullFunction<Hash, Integer> asIndexGetter() {
        NotNullFunction<Hash, Integer> notNullFunction = new NotNullFunction<Hash, Integer>(){

            @NotNull
            public Integer fun(Hash hash) {
                Integer n = VcsLogHashMap.this.getCommitIndex(hash);
                if (n == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMap$3", "fun"));
                }
                return n;
            }
        };
        if (notNullFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMap", "asIndexGetter"));
        }
        return notNullFunction;
    }

    @NotNull
    public NotNullFunction<Integer, Hash> asHashGetter() {
        NotNullFunction<Integer, Hash> notNullFunction = new NotNullFunction<Integer, Hash>(){

            @NotNull
            public Hash fun(Integer commitIndex) {
                Hash hash = VcsLogHashMap.this.getHash(commitIndex);
                if (hash == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMap$4", "fun"));
                }
                return hash;
            }
        };
        if (notNullFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsLogHashMap", "asHashGetter"));
        }
        return notNullFunction;
    }

    public void flush() {
        this.myPersistentEnumerator.force();
    }

    public void dispose() {
        try {
            this.myPersistentEnumerator.close();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    Hash findHash(final @NotNull Condition<Hash> condition) throws IOException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/VcsLogHashMap", "findHash"));
        }
        final Ref hashRef = Ref.create();
        this.myPersistentEnumerator.iterateData((Processor)new CommonProcessors.FindProcessor<Hash>(){

            protected boolean accept(Hash hash) {
                boolean matches = condition.value((Object)hash);
                if (matches) {
                    hashRef.set((Object)hash);
                }
                return matches;
            }
        });
        return (Hash)hashRef.get();
    }

    private static class MyHashKeyDescriptor
    implements KeyDescriptor<Hash> {
        private MyHashKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, Hash value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsLogHashMap$MyHashKeyDescriptor", "save"));
            }
            out.writeUTF(value.asString());
        }

        public Hash read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsLogHashMap$MyHashKeyDescriptor", "read"));
            }
            return HashImpl.build(in.readUTF());
        }

        public int getHashCode(Hash value) {
            return value.hashCode();
        }

        public boolean isEqual(Hash val1, Hash val2) {
            return val1.equals(val2);
        }
    }
}

