/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsUserRegistryImpl
implements Disposable,
VcsUserRegistry {
    private static final File USER_CACHE_APP_DIR = new File(PathManager.getSystemPath(), "vcs-users");
    private static final Logger LOG = Logger.getInstance(VcsUserRegistryImpl.class);
    private static final PersistentEnumeratorBase.DataFilter ACCEPT_ALL_DATA_FILTER = new PersistentEnumeratorBase.DataFilter(){

        public boolean accept(int id) {
            return true;
        }
    };
    @Nullable
    private final PersistentEnumerator<VcsUser> myPersistentEnumerator;

    VcsUserRegistryImpl(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "<init>"));
        }
        File mapFile = new File(USER_CACHE_APP_DIR, project.getName() + "." + project.getLocationHash());
        Disposer.register((Disposable)project, (Disposable)this);
        this.myPersistentEnumerator = VcsUserRegistryImpl.initEnumerator(mapFile);
    }

    @Nullable
    private static PersistentEnumerator<VcsUser> initEnumerator(final @NotNull File mapFile) {
        if (mapFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapFile", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "initEnumerator"));
        }
        try {
            return (PersistentEnumerator)IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<PersistentEnumerator<VcsUser>, IOException>(){

                public PersistentEnumerator<VcsUser> compute() throws IOException {
                    return new PersistentEnumerator(mapFile, (KeyDescriptor)new MyDescriptor(), 4096);
                }
            }, (File)mapFile);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public void addUser(@NotNull VcsUser user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "addUser"));
        }
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.enumerate((Object)user);
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void addUsers(@NotNull Collection<VcsUser> users) {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "users", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "addUsers"));
        }
        for (VcsUser user : users) {
            this.addUser(user);
        }
    }

    @NotNull
    public Set<VcsUser> getUsers() {
        HashSet hashSet;
        try {
            Set users = this.myPersistentEnumerator != null ? this.myPersistentEnumerator.getAllDataObjects(ACCEPT_ALL_DATA_FILTER) : Collections.emptySet();
            hashSet = ContainerUtil.newHashSet(users);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            Set<VcsUser> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "getUsers"));
            }
            return set;
        }
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/VcsUserRegistryImpl", "getUsers"));
        }
        return hashSet;
    }

    public void flush() {
        if (this.myPersistentEnumerator != null) {
            this.myPersistentEnumerator.force();
        }
    }

    public void dispose() {
        try {
            if (this.myPersistentEnumerator != null) {
                this.myPersistentEnumerator.close();
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static class MyDescriptor
    implements KeyDescriptor<VcsUser> {
        private MyDescriptor() {
        }

        public void save(@NotNull DataOutput out, VcsUser value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/vcs/log/data/VcsUserRegistryImpl$MyDescriptor", "save"));
            }
            IOUtil.writeUTF((DataOutput)out, (String)value.getName());
            IOUtil.writeUTF((DataOutput)out, (String)value.getEmail());
        }

        public VcsUser read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/vcs/log/data/VcsUserRegistryImpl$MyDescriptor", "read"));
            }
            String name = IOUtil.readUTF((DataInput)in);
            String email = IOUtil.readUTF((DataInput)in);
            return new VcsUserImpl(name, email);
        }

        public int getHashCode(VcsUser value) {
            return value.hashCode();
        }

        public boolean isEqual(VcsUser val1, VcsUser val2) {
            return val1.equals(val2);
        }
    }
}

