/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableScrollingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.graph.actions.GraphMouseAction;
import com.intellij.vcs.log.printer.idea.ColorGenerator;
import com.intellij.vcs.log.printer.idea.GraphCellPainter;
import com.intellij.vcs.log.printer.idea.PositionUtil;
import com.intellij.vcs.log.printer.idea.SimpleGraphCellPainter;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.GraphCommitCellRender;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogGraphTable
extends JBTable
implements TypeSafeDataProvider,
CopyProvider {
    private static final int ROOT_INDICATOR_WIDTH = 5;
    private static final int MAX_DEFAULT_AUTHOR_COLUMN_WIDTH = 200;
    private static final int MAX_ROWS_TO_CALC_WIDTH = 1000;
    private static final int MAX_ROWS_TO_CALC_OFFSET = 100;
    @NotNull
    private final VcsLogUiImpl myUI;
    private final VcsLogDataHolder myLogDataHolder;
    private final GraphCommitCellRender myGraphCommitCellRender;
    private boolean myColumnsSizeInitialized;
    private final AtomicInteger myRepaintFreezedCounter;
    @NotNull
    private final Collection<VcsLogHighlighter> myHighlighters;
    private final GraphCellPainter myGraphCellPainter;
    @NotNull
    private VisiblePack myDataPack;

    public VcsLogGraphTable(@NotNull VcsLogUiImpl UI2, @NotNull VcsLogDataHolder logDataHolder, @NotNull VisiblePack initialDataPack) {
        if (UI2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "UI", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        if (initialDataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialDataPack", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "<init>"));
        }
        this.myColumnsSizeInitialized = false;
        this.myRepaintFreezedCounter = new AtomicInteger();
        this.myHighlighters = ContainerUtil.newArrayList();
        this.myGraphCellPainter = new SimpleGraphCellPainter(new ColorGenerator(){

            @Override
            public Color getColor(int colorId) {
                return com.intellij.vcs.log.graph.ColorGenerator.getColor(colorId);
            }
        });
        this.myUI = UI2;
        this.myLogDataHolder = logDataHolder;
        this.myDataPack = initialDataPack;
        this.myGraphCommitCellRender = new GraphCommitCellRender(this.myUI.getColorManager(), logDataHolder, this.myGraphCellPainter, this.myDataPack.getVisibleGraph(), this);
        this.setDefaultRenderer(VirtualFile.class, new RootCellRenderer(this.myUI, this.myLogDataHolder.isMultiRoot()));
        this.setDefaultRenderer(GraphCommitCell.class, (TableCellRenderer)((Object)this.myGraphCommitCellRender));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new StringCellRenderer()));
        this.setRowHeight(22);
        this.setShowHorizontalLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"Vcs.Log.ContextMenu", (String)"Vcs.Log.ContextMenu");
        TableScrollingUtil.installActions((JTable)((Object)this), (boolean)false);
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "setModel"));
        }
        super.setModel(model);
        if (!this.myColumnsSizeInitialized && model.getRowCount() > 0) {
            this.myColumnsSizeInitialized = true;
            this.setColumnPreferredSize();
            this.setAutoCreateColumnsFromModel(false);
        }
    }

    private void setColumnPreferredSize() {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            if (i == 0) {
                int rootWidth = this.myUI.getColorManager().isMultipleRoots() ? 5 : 0;
                column.setMinWidth(rootWidth);
                column.setMaxWidth(rootWidth);
                column.setPreferredWidth(rootWidth);
                continue;
            }
            if (i == 1) {
                column.setPreferredWidth(Short.MAX_VALUE);
                continue;
            }
            if (i == 2) {
                int maxRowsToCheck = Math.min(1000, this.getRowCount() - 100);
                if (maxRowsToCheck < 0) {
                    maxRowsToCheck = this.getRowCount();
                }
                int contentWidth = this.calcMaxContentColumnWidth(i, maxRowsToCheck);
                column.setMinWidth(Math.min(contentWidth, 200));
                column.setWidth(column.getMinWidth());
                continue;
            }
            if (i != 3) continue;
            Font tableFont = UIManager.getFont("Table.font");
            column.setMinWidth(this.getFontMetrics(tableFont).stringWidth("mm" + DateFormatUtil.formatDateTime((Date)new Date())));
            column.setWidth(column.getMinWidth());
        }
    }

    private int calcMaxContentColumnWidth(int columnIndex, int maxRowsToCheck) {
        int maxWidth = 0;
        for (int row = 0; row < maxRowsToCheck; ++row) {
            TableCellRenderer renderer = this.getCellRenderer(row, columnIndex);
            Component comp = this.prepareRenderer(renderer, row, columnIndex);
            maxWidth = Math.max(comp.getPreferredSize().width, maxWidth);
        }
        return maxWidth + 10;
    }

    public String getToolTipText(@NotNull MouseEvent event) {
        Object at;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "getToolTipText"));
        }
        int row = this.rowAtPoint(event.getPoint());
        int column = this.columnAtPoint(event.getPoint());
        if (column < 0 || row < 0) {
            return null;
        }
        if (column == 0 && (at = this.getValueAt(row, column)) instanceof VirtualFile) {
            return ((VirtualFile)at).getPresentableUrl();
        }
        return null;
    }

    public void jumpToRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex <= this.getRowCount() - 1) {
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
            this.setRowSelectionInterval(rowIndex, rowIndex);
            this.scrollRectToVisible(this.getCellRect(rowIndex, 0, false));
        }
    }

    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "paintComponent"));
        }
        if (this.myRepaintFreezedCounter.get() > 0) {
            return;
        }
        super.paintComponent(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithoutRepaint(@NotNull Runnable action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "executeWithoutRepaint"));
        }
        this.myRepaintFreezedCounter.incrementAndGet();
        try {
            action.run();
        }
        finally {
            this.myRepaintFreezedCounter.decrementAndGet();
        }
    }

    @Nullable
    public List<Change> getSelectedChanges() {
        TableModel model = this.getModel();
        if (!(model instanceof GraphTableModel)) {
            return null;
        }
        List<Change> changes = ((GraphTableModel)model).getSelectedChanges(this.sortSelectedRows());
        return changes == null ? null : CommittedChangesTreeBrowser.zipChanges(changes);
    }

    @NotNull
    private List<Integer> sortSelectedRows() {
        ArrayList rows = ContainerUtil.newArrayList();
        for (int row : this.getSelectedRows()) {
            rows.add(row);
        }
        Collections.sort(rows, Collections.reverseOrder());
        ArrayList arrayList = rows;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "sortSelectedRows"));
        }
        return arrayList;
    }

    public void calcData(DataKey key, DataSink sink) {
        if (PlatformDataKeys.COPY_PROVIDER == key) {
            sink.put(key, (Object)this);
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "performCopy"));
        }
        ArrayList hashes = ContainerUtil.newArrayList();
        for (int row : this.getSelectedRows()) {
            Hash hash = ((GraphTableModel)this.getModel()).getHashAtRow(row);
            if (hash == null) continue;
            hashes.add(hash.asString());
        }
        if (!hashes.isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join((Collection)hashes, (String)"\n")));
        }
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "isCopyEnabled"));
        }
        return this.getSelectedRowCount() > 0;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "isCopyVisible"));
        }
        return true;
    }

    public void updateDataPack(@NotNull VisiblePack dataPack) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "updateDataPack"));
        }
        this.myDataPack = dataPack;
        this.myGraphCommitCellRender.updateVisibleGraph(dataPack.getVisibleGraph());
    }

    public void addHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "addHighlighter"));
        }
        this.myHighlighters.add(highlighter);
    }

    public void removeHighlighter(@NotNull VcsLogHighlighter highlighter) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "removeHighlighter"));
        }
        this.myHighlighters.remove(highlighter);
    }

    public void removeAllHighlighters() {
        this.myHighlighters.clear();
    }

    public void applyHighlighters(@NotNull Component rendererComponent, int row, boolean selected) {
        if (rendererComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rendererComponent", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "applyHighlighters"));
        }
        boolean fgUpdated = false;
        for (VcsLogHighlighter highlighter : this.myHighlighters) {
            Color color = highlighter.getForeground(((Integer)this.myDataPack.getVisibleGraph().getRowInfo(row).getCommit()).intValue(), selected);
            if (color == null) continue;
            rendererComponent.setForeground(color);
            fgUpdated = true;
        }
        if (!fgUpdated) {
            rendererComponent.setForeground(UIUtil.getTableForeground((boolean)selected));
        }
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        if (clickPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clickPoint", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "calcPoint4Graph"));
        }
        Point point = new Point(clickPoint.x - this.getXOffset(), PositionUtil.getYInsideRow(clickPoint));
        if (point == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable", "calcPoint4Graph"));
        }
        return point;
    }

    private int getXOffset() {
        TableColumn rootColumn = this.getColumnModel().getColumn(0);
        return this.myLogDataHolder.isMultiRoot() ? rootColumn.getWidth() : 0;
    }

    private class StringCellRenderer
    extends ColoredTableCellRenderer {
        private StringCellRenderer() {
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return;
            }
            this.append(value.toString());
            VcsLogGraphTable.this.applyHighlighters((Component)((Object)this), row, selected);
            this.setBorder(null);
        }
    }

    private static class RootCellRenderer
    extends JPanel
    implements TableCellRenderer {
        @NotNull
        private final VcsLogUiImpl myUi;
        @NotNull
        private Color myColor;

        RootCellRenderer(@NotNull VcsLogUiImpl ui, boolean multiRoot) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$RootCellRenderer", "<init>"));
            }
            this.myColor = UIUtil.getTableBackground();
            this.myUi = ui;
            int rootWidth = multiRoot ? 5 : 0;
            this.setPreferredSize(new Dimension(rootWidth, -1));
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.myColor);
            g.fillRect(0, 0, 4, 22);
            UIUtil.drawLine((Graphics2D)((Graphics2D)g), (int)4, (int)0, (int)4, (int)22, null, (Color)this.myUi.getColorManager().getRootIndicatorBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myColor = value instanceof VirtualFile ? this.myUi.getColorManager().getRootColor((VirtualFile)value) : UIUtil.getTableBackground((boolean)isSelected);
            return this;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private final TableLinkMouseListener myLinkListener = new TableLinkMouseListener();

        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            if (e.getClickCount() == 1) {
                this.performAction(e, GraphMouseAction.Type.CLICK);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this.isAboveLink(e)) {
                VcsLogGraphTable.this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.performAction(e, GraphMouseAction.Type.OVER);
            }
        }

        private void performAction(@NotNull MouseEvent e, @NotNull GraphMouseAction.Type actionType) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyMouseAdapter", "performAction"));
            }
            if (actionType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionType", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyMouseAdapter", "performAction"));
            }
            int row = PositionUtil.getRowIndex(e.getPoint());
            if (row > VcsLogGraphTable.this.getRowCount() - 1) {
                return;
            }
            Point point = VcsLogGraphTable.this.calcPoint4Graph(e.getPoint());
            Collection printElements = VcsLogGraphTable.this.myDataPack.getVisibleGraph().getRowInfo(row).getPrintElements();
            PrintElement printElement = VcsLogGraphTable.this.myGraphCellPainter.mouseOver(printElements, point.x, point.y);
            GraphAnswer answer = VcsLogGraphTable.this.myDataPack.getVisibleGraph().getActionController().performMouseAction((GraphMouseAction)new MyGraphMouseAction(printElement, actionType));
            VcsLogGraphTable.this.myUI.handleAnswer((GraphAnswer<Integer>)answer, actionType == GraphMouseAction.Type.CLICK && printElement != null);
        }

        private boolean isAboveLink(MouseEvent e) {
            return this.myLinkListener.getTagAt(e) != null;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        private class MyGraphMouseAction
        implements GraphMouseAction {
            private final PrintElement myPrintElement;
            private final GraphMouseAction.Type myActionType;

            public MyGraphMouseAction(PrintElement printElement, GraphMouseAction.Type actionType) {
                this.myPrintElement = printElement;
                this.myActionType = actionType;
            }

            @Nullable
            public PrintElement getAffectedElement() {
                return this.myPrintElement;
            }

            @NotNull
            public GraphMouseAction.Type getType() {
                GraphMouseAction.Type type = this.myActionType;
                if (type == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/VcsLogGraphTable$MyMouseAdapter$MyGraphMouseAction", "getType"));
                }
                return type;
            }
        }
    }
}

