/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryContainer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DebuggerTreeWithHistoryPopup<D>
extends DebuggerTreeWithHistoryContainer<D> {
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "DebuggerActiveHint";
    private JBPopup myPopup;
    private final Editor myEditor;
    private final Point myPoint;

    private DebuggerTreeWithHistoryPopup(@NotNull D initialItem, @NotNull DebuggerTreeCreator<D> creator, @NotNull Editor editor, @NotNull Point point, @NotNull Project project) {
        if (initialItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialItem", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "<init>"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "<init>"));
        }
        super(initialItem, creator, project);
        this.myEditor = editor;
        this.myPoint = point;
    }

    public static <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D initialItem, @NotNull Editor editor, @NotNull Point point, @NotNull Project project) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "showTreePopup"));
        }
        if (initialItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialItem", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "showTreePopup"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "showTreePopup"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "showTreePopup"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/common/DebuggerTreeWithHistoryPopup", "showTreePopup"));
        }
        new DebuggerTreeWithHistoryPopup<D>(initialItem, creator, editor, point, project).updateTree(initialItem);
    }

    private TreeModelListener createTreeListener(final Tree tree) {
        return new TreeModelAdapter(){

            public void treeStructureChanged(TreeModelEvent e) {
                DebuggerTreeWithHistoryPopup.this.resize(e.getTreePath(), (JTree)tree);
            }
        };
    }

    @Override
    protected void updateContainer(final Tree tree, String title) {
        if (this.myPopup != null) {
            this.myPopup.cancel();
        }
        tree.getModel().addTreeModelListener(this.createTreeListener(tree));
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this.createMainPanel(tree), (JComponent)tree).setRequestFocus(true).setTitle(title).setResizable(true).setMovable(true).setDimensionServiceKey(this.myProject, DIMENSION_SERVICE_KEY, false).setMayBeParent(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Window parent = SwingUtilities.getWindowAncestor((Component)tree);
                if (parent != null) {
                    for (Window child : parent.getOwnedWindows()) {
                        if (!child.isShowing()) continue;
                        return false;
                    }
                }
                return true;
            }
        }).createPopup();
        if (tree instanceof Disposable) {
            Disposer.register((Disposable)this.myPopup, (Disposable)((Disposable)tree));
        }
        if (this.myEditor.getComponent().getRootPane() == null) {
            this.myPopup.cancel();
            return;
        }
        this.myPopup.show(new RelativePoint((Component)this.myEditor.getContentComponent(), this.myPoint));
        this.updateInitialBounds(tree);
    }

    private void resize(TreePath path, JTree tree) {
        if (this.myPopup == null || !this.myPopup.isVisible()) {
            return;
        }
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        if (popupWindow == null) {
            return;
        }
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds == null) {
            return;
        }
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(Math.max(size.width, bounds.width) + 20, windowBounds.width), Math.max(tree.getRowCount() * bounds.height + 55, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }

    private void updateInitialBounds(Tree tree) {
        Window popupWindow = SwingUtilities.windowForComponent(this.myPopup.getContent());
        Dimension size = tree.getPreferredSize();
        Point location = popupWindow.getLocation();
        Rectangle windowBounds = popupWindow.getBounds();
        Rectangle targetBounds = new Rectangle(location.x, location.y, Math.max(size.width + 250, windowBounds.width), Math.max(size.height, windowBounds.height));
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)targetBounds);
        popupWindow.setBounds(targetBounds);
        popupWindow.validate();
        popupWindow.repaint();
    }
}

