/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class ValueLookupManager
implements EditorMouseMotionListener {
    public static final Key<Boolean> DISABLE_VALUE_LOOKUP = Key.create((String)"DISABLE_VALUE_LOOKUP");
    private final Project myProject;
    private final Alarm myAlarm;
    private AbstractValueHint myRequest = null;
    private final DebuggerSupport[] mySupports;
    private boolean myListening;

    public ValueLookupManager(Project project) {
        this.myProject = project;
        this.mySupports = DebuggerSupport.getDebuggerSupports();
        this.myAlarm = new Alarm((Disposable)project);
    }

    public void startListening() {
        if (!this.myListening) {
            this.myListening = true;
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    public void mouseMoved(EditorMouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA || DISABLE_VALUE_LOOKUP.get((UserDataHolder)editor) == Boolean.TRUE) {
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (this.myRequest != null && !this.myRequest.isKeepHint(editor, point)) {
            this.hideHint();
        }
        for (DebuggerSupport support : this.mySupports) {
            QuickEvaluateHandler handler = support.getQuickEvaluateHandler();
            if (!handler.isEnabled(this.myProject)) continue;
            this.requestHint(handler, editor, point, AbstractValueHint.getType(e));
            break;
        }
    }

    private void requestHint(final QuickEvaluateHandler handler, final Editor editor, final Point point, final ValueHintType type) {
        this.myAlarm.cancelAllRequests();
        if (type == ValueHintType.MOUSE_OVER_HINT) {
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ValueLookupManager.this.showHint(handler, editor, point, type);
                }
            }, handler.getValueLookupDelay(this.myProject));
        } else {
            this.showHint(handler, editor, point, type);
        }
    }

    public void hideHint() {
        if (this.myRequest != null) {
            this.myRequest.hideHint();
            this.myRequest = null;
        }
    }

    public void showHint(@NotNull QuickEvaluateHandler handler, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        this.myAlarm.cancelAllRequests();
        if (editor.isDisposed() || !handler.canShowHint(this.myProject)) {
            return;
        }
        final AbstractValueHint request = handler.createValueHint(this.myProject, editor, point, type);
        if (request != null) {
            if (this.myRequest != null && this.myRequest.equals(request)) {
                return;
            }
            if (!request.canShowHint()) {
                return;
            }
            if (this.myRequest != null && this.myRequest.isInsideHint(editor, point)) {
                return;
            }
            this.hideHint();
            this.myRequest = request;
            this.myRequest.invokeHint(new Runnable(){

                @Override
                public void run() {
                    if (ValueLookupManager.this.myRequest != null && ValueLookupManager.this.myRequest == request) {
                        ValueLookupManager.this.myRequest = null;
                    }
                }
            });
        }
    }

    public static ValueLookupManager getInstance(Project project) {
        return (ValueLookupManager)ServiceManager.getService((Project)project, ValueLookupManager.class);
    }
}

